<%@ include file="/sdk/oemTop.jspf" %>

<!-- ================  Window View Page =================== -->

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<db:script src="/database/utils.js"/>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>

  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <%-- HTML Form --%>
      <db:form name="winViewForm" destinationBinding="defaultDest@servletRequest" copyParams="target,type,oname">
        <uix:formValue name="pageName" value="/database/instance/scheduler/windowView"/>
        <uix:formValue name="windowName" valueBinding="objectName@defaultBean@servletRequest" />
        <uix:formValue name="event"/>

        <uix:pageLayout titleBinding="header@defaultBean@servletRequest">
          <%@ include file="/database/global.jspf" %>
          <jsp:include page="windowViewData.jsp" />
          <uix:ref refID="windowViewData" />

          <%-- Create/Edit Buttons --%>
            <uix:pageButtons>
              <uix:pageButtonBar>
                <jsp:include page="/database/schema/pageButtonViewInclude.jsp" />
                  <uix:ref refID="pageButtonViewInclude" />
              </uix:pageButtonBar>
            </uix:pageButtons>
          </uix:pageLayout>
        </db:form>
        <%-- END: HTML Form --%>
    </uix:body>
  </uix:document>
</uix:renderingContext>
<%-- END: Content --%>  
