<!-- ================  Windows Page =================== -->

<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <uix:pageLayout>
        <%@ include file="/database/global.jspf" %>

        <db:form name="windowsForm" destinationBinding="defaultDest@servletRequest" copyParams="target,type">
          <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest"
                             msgBundleBinding="defaultMsgBundle"
                             titleTextKey="titleText" mainTextKey="mainText"/>
        <uix:header textBinding="WINDOWS@ResourceBundle@servletRequest" >                             
          <uix:tableLayout width="100%">
            <uix:rowLayout>
              <uix:stackLayout>
                
                  <uix:tableLayout width="100%">
                    <uix:rowLayout>
                      <uix:cellFormat>
                        <uix:rowLayout>
                          <uix:styledText styleClass="OraInstructionText"
                               textBinding="WINDOW_TEXT@ResourceBundle@servletRequest" />
                        </uix:rowLayout>
                      </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:rowLayout hAlign="right">
                      <uix:cellFormat>
                        <uix:rowLayout>
                          <uix:submitButton textBinding="CREATE@DBObjectMsgBundle@servletRequest"
                          	name="event" value="create"/>
                        </uix:rowLayout>
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:tableLayout>

              </uix:stackLayout>
            </uix:rowLayout>
          </uix:tableLayout>
          <uix:tableLayout width="100%">
            <uix:rowLayout>
              <oem:table name="twoDUIDataSource" beanKey="dataSourceBean"
                   formSubmitted="true"
                   dataSourceProp="twoDUIDataSource" width="100%"
                   alternateTextBinding="NO_WINDOW@ResourceBundle@servletRequest"
                   blockSize="25" partialRenderMode="self" copyParams="target,type"
                   summaryBinding="WINDOWS@ResourceBundle@servletRequest">
                <uix:tableSelection>
                  <oem:singleSelection selectedIndexBinding="selectedIndex@defaultBean@servletRequest"
                          shortDescBinding="WINDOWS@ResourceBundle@servletRequest">
                    <uix:submitButton textBinding="VIEW_BUTTON@DBObjectMsgBundle@servletRequest"
                                 name="event" value="view"/>
                    <uix:submitButton textBinding="EDIT@DBObjectMsgBundle@servletRequest"
                                 name="event" value="edit"/>
                    <uix:submitButton textBinding="DELETE@DBObjectMsgBundle@servletRequest"
                                 name="event" value="delete"/>
                    <uix:choice  name="actionChoice"
                                 selectedValueBinding="selectedAction@defaultBean@servletRequest"
                                 shortDescBinding="COLUMN_HEADER">
                      <uix:option textBinding="CREATE_LIKE@DBObjectMsgBundle@servletRequest"
	                         value="createLike"/>
                      <uix:option textBinding="OPEN@ResourceBundle@servletRequest"
	                         value="open"/>
                      <uix:option textBinding="CLOSE@ResourceBundle@servletRequest"
 	                         value="close"/>
                    </uix:choice>
                    <uix:submitButton textBinding="GO@DBObjectMsgBundle@servletRequest"
                                      name="event" value="changeAction" />
                  </oem:singleSelection>
                </uix:tableSelection>
              </oem:table>
            </uix:rowLayout>
           </uix:tableLayout>
	  <%--
	   <uix:tableLayout>
             <uix:rowLayout>
               <uix:spacer height="10"/>
             </uix:rowLayout>
             <uix:rowLayout>
               <uix:cellFormat>
                 <uix:styledText styleClass="OraInstructionText"
                                 textBinding="RELATED_LINK@DBMsgBundle@servletRequest"/>
                 <uix:spacer width="5"/>
                 <uix:link textBinding="JOBS@ResourceBundle@servletRequest"
 		                 destinationBinding="jobsURL@@servletRequest"/>
               </uix:cellFormat>
             </uix:rowLayout>
           </uix:tableLayout>
	  --%>
       <oem:relatedLinks />
            </uix:header>
         </db:form>
       </uix:pageLayout>
     </uix:body>
   </uix:document>
</uix:renderingContext> 
