<%@ include file="/sdk/oemTop.jspf" %>

<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="TopConsumersMsgBundle"                   
          class="oracle.sysman.db.rsc.inst.TopConsumersMsg"/>

<oem:setURLEncoder id="renderingContext"/>  
  <uix:document>    
    <%@ include file="/oemTitle.jspf" %>      
    
    <uix:body>      
      <uix:form name="enableSQLTraceForm" destinationBinding="defaultDest@servletRequest">        
       <uix:formValue name="pageName" value="/database/instance/searchsess/enableSQLTrace" /> 
	      
        <uix:pageLayout titleBinding="pageHeader@servletRequest">
            <!-- for breadcrumbs support; plus standard label, links, tabs, etc -->          
            <%@ include file="/database/global.jspf" %>
            
            <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest"
                msgBundleBinding="ResourceBundle"  titleTextKey="titleText" mainTextKey="mainText"/>
<uix:header iconBinding="confirmationIcon@servletRequest" textBinding="ENABLE_SQL_TRACE@TopConsumersMsgBundle" >
    <uix:tableLayout width="100%">
    <uix:rowLayout>
    </uix:rowLayout>
    <uix:rowLayout>
        <uix:table name="searchSessionsUIDataSource"
		width="100%"
		tableDataBinding="displaySearchSessionsTable@searchSessionsBean@servletRequest"
		summaryBinding="RESULT_LABEL@DBMsgBundle@servletRequest"
		formSubmitted="true"
		showAll="yes"
		alternateTextBinding = "NO_SESSIONS@DBMsgBundle@servletRequest"
             id="sessionsTabsearchSessionsUIDataSource">
	     
	     <uix:column>
	     <uix:columnHeader>
	     <uix:styledText textBinding="TS_SID@DBMsgBundle@servletRequest"/> 
	     </uix:columnHeader>
	     <uix:styledText styleClass="OraText" textBinding="tabCol0"/>
	     </uix:column>
	     
	     <uix:column>
	     <uix:columnHeader>
	     <uix:styledText textBinding="TS_DBUSER@DBMsgBundle@servletRequest"/> 
	     </uix:columnHeader>
	     <uix:styledText styleClass="OraText" textBinding="tabCol1"/>
	     </uix:column>
	     
	     <uix:column>
	     <uix:columnHeader>
	     <uix:styledText textBinding="TS_PROGRAM@DBMsgBundle@servletRequest"/> 
	     </uix:columnHeader>
	     <uix:styledText styleClass="OraText" textBinding="tabCol2"/>
	     </uix:column>
	     
	     <uix:column>
	     <uix:columnHeader>
	     <uix:styledText textBinding="SERVICE@DBMsgBundle@servletRequest"/> 
	     </uix:columnHeader>
	     <uix:styledText styleClass="OraText" textBinding="tabCol3"/>
	     </uix:column>
	     
	     <uix:column>
	     <uix:columnHeader>
	     <uix:styledText textBinding="MODULE@DBMsgBundle@servletRequest"/> 
	     </uix:columnHeader>
	     <uix:styledText styleClass="OraText" textBinding="tabCol4"/>
	     </uix:column>
	     
	     <uix:column>
	     <uix:columnHeader>
	     <uix:styledText textBinding="ACTION@DBMsgBundle@servletRequest"/> 
	     </uix:columnHeader>
	     <uix:styledText styleClass="OraText" textBinding="tabCol5"/>
	     </uix:column>
	     
	     <uix:column>
	     <uix:columnHeader>
	     <uix:styledText textBinding="CLIENT@DBMsgBundle@servletRequest"/> 
	     </uix:columnHeader>
	     <uix:styledText styleClass="OraText" textBinding="tabCol6"/>
	     </uix:column>
	     
	     <uix:column>
	     <uix:columnHeader>
	     <uix:styledText textBinding="TS_MACHINE@DBMsgBundle@servletRequest"/> 
	     </uix:columnHeader>
	     <uix:styledText styleClass="OraText" textBinding="tabCol7"/>
	     </uix:column>
	     
	     <uix:column>
	     <uix:columnHeader>
	     <uix:styledText textBinding="TS_OSUSER@DBMsgBundle@servletRequest"/> 
	     </uix:columnHeader>
	     <uix:styledText styleClass="OraText" textBinding="tabCol8"/>
	     </uix:column>
	     
	</uix:table>
    </uix:rowLayout>
    <uix:rowLayout>
            <uix:tableLayout cellSpacing="5">
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">                      
                  <uix:messagePrompt promptBinding="TRACE_WITH_WAIT@TopConsumersMsgBundle" />               
                </uix:cellFormat>                    
                <uix:cellFormat hAlign="left">                      
                  <uix:radioButton textBinding="SP_YES@DBMsgBundle@servletRequest"                         
                            name="waits"                                                             
                            value="TRUE"
			    selectedValue="TRUE"/>                    
                  <uix:radioButton textBinding="SP_NO@DBMsgBundle@servletRequest"                         
                            name="waits"                                                             
                            value="FALSE" />                    
                </uix:cellFormat>                  
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:messagePrompt promptBinding="TRACE_WITH_BIND@TopConsumersMsgBundle" />
                </uix:cellFormat>
                <uix:cellFormat hAlign="left">                     
                  <uix:radioButton textBinding="SP_YES@DBMsgBundle@servletRequest"
                            name="binds"
                            value="TRUE"/>
                  <uix:radioButton textBinding="SP_NO@DBMsgBundle@servletRequest"
                            name="binds"
                            value="FALSE"
			    selectedValue="FALSE" />
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
    </uix:rowLayout>
    </uix:tableLayout>
    </uix:header>
          
            <uix:pageButtons>            
              <uix:pageButtonBar>              
                <uix:submitButton textBinding="SP_NO@DBMsgBundle@servletRequest" 
                        name="event" value="cancelEnableSQLTrace"/>
                <uix:submitButton textBinding="SP_YES@DBMsgBundle@servletRequest"                      
                    name="event" value="doEnableSQLTrace"/>             
              </uix:pageButtonBar>          
            </uix:pageButtons>        
          </uix:pageLayout>        
        </uix:form>                  
    </uix:body>  
  </uix:document>
</uix:renderingContext> 
