<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="TopConsumersMsgBundle"                   
          class="oracle.sysman.db.rsc.inst.TopConsumersMsg"/>
   
 <oem:setURLEncoder id="renderingContext"/>     
      
  <uix:document>
    <%@ include file="/enablePPR.jspf" %> 
    <%@ include file="/oemTitle.jspf" %>


    <uix:body>
    <uix:pageLayout>
    <%@ include file="/database/global.jspf" %>
    
    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
    <oem:messageBox messageType="info" 
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>

    <db:form name="foo" method="POST" destination="/console/database/instance/searchSessions"
      copyParams="target,type">

    <uix:formValue name="event" value="doLoad" />  
    <uix:formValue name="pageName" value="/database/instance/searchsess/searchsess" />  

    <uix:header textBinding="header@searchSessionsBean@servletRequest">

    <%@ include file="/database/instances.jspf" %>

   
    <uix:header textBinding="SEARCH@DBMsgBundle@servletRequest" >
   
    <uix:tableLayout width="100%" cellSpacing="2">

        <uix:stackLayout>

        <uix:radioButton name="useFilters" value="TRUE"
           selectedBinding="useFilters@searchSessionsBean@servletRequest"
           textBinding="SEARCH_SESS_FILTERS@DBMsgBundle@servletRequest"/>

          <uix:tableLayout>

            <uix:rowLayout>
              <uix:spacer width="30" />
              <uix:cellFormat hAlign="right" wrappingDisabled="true">
                  <uix:styledText styleClass="OraPromptText"
                    labeledNodeId="FilterLabel"
                    textBinding="FILTER@DBMsgBundle@servletRequest"/>
              </uix:cellFormat>
              <uix:spacer width="8"/>
              <uix:cellFormat hAlign="left" wrappingDisabled="true">
                <uix:choice name="searchCriteria" 
                id="FilterLabel"
                selectedValueBinding="searchCriteria@searchSessionsBean@servletRequest" >
                
                  <uix:option textBinding="TS_SID@DBMsgBundle@servletRequest"
                    value="TS_SID" />
                  <uix:option textBinding="TS_DBUSER@DBMsgBundle@servletRequest"
                    value="TS_DBUSER" />
                  <uix:option textBinding="TS_PROGRAM@DBMsgBundle@servletRequest"
                    value="TS_PROGRAM" />
                  <uix:option textBinding="SERVICE@DBMsgBundle@servletRequest"
                    value="SERVICE"
                    renderedBinding="10gOrHigher@searchSessionsBean@servletRequest" />
                  <uix:option textBinding="MODULE@DBMsgBundle@servletRequest"
                    value="MODULE" />
                  <uix:option textBinding="ACTION@DBMsgBundle@servletRequest"
                    value="ACTION" />
                  <uix:option textBinding="CLIENT@DBMsgBundle@servletRequest"
                    value="CLIENT" />
                  <uix:option textBinding="TS_MACHINE@DBMsgBundle@servletRequest"
                    value="TS_MACHINE" />
                  <uix:option textBinding="TS_OSUSER@DBMsgBundle@servletRequest"
                    value="TS_OSUSER" />
                
                </uix:choice>
              
              </uix:cellFormat>
              
              <uix:spacer width="8"/>
              
              <uix:textInput name="searchString" columns="30" 
                shortDescBinding="FILTER@DBMsgBundle@servletRequest"
                textBinding="searchString@searchSessionsBean@servletRequest" />
                
              <uix:spacer width="8"/>  
                
              <uix:submitButton name="event" value="search" 
                textBinding="GO@DBMsgBundle@servletRequest" />
              
            </uix:rowLayout>
            
          </uix:tableLayout>
          
          <uix:rowLayout>
            <uix:spacer width="30" />
            <uix:styledText textBinding="SEARCH_SESS_INSTR@DBMsgBundle@servletRequest"
               styleClass="OraInlineInfoText"  />
          </uix:rowLayout>
          
         <uix:rowLayout>
           <uix:radioButton name="useFilters" value="FALSE"
             selectedBinding="notUseFilters@searchSessionsBean@servletRequest"
             textBinding="SEARCH_SESS_WHERE_CLAUSE@DBMsgBundle@servletRequest" />
          
           <uix:spacer width="50" />
           
           <uix:link textBinding="DISPLAY_COL@DBMsgBundle@servletRequest" 
                destinationBinding="viewSessionLink@servletRequest" />
           
        </uix:rowLayout>
          
          
          <uix:rowLayout>
            <uix:spacer width="30" />
             <uix:textInput columns="60" rows="5" name="searchWhereClause"
                shortDescBinding="SEARCH_SESS_WHERE_CLAUSE@DBMsgBundle@servletRequest"
                textBinding="searchWhereClause@searchSessionsBean@servletRequest" />
                
            <uix:spacer width="8"/>
            
              
              <uix:cellFormat vAlign="bottom" >
               <uix:submitButton name="event" value="search" 
                  textBinding="GO@DBMsgBundle@servletRequest" />
              </uix:cellFormat>
                    
            
          </uix:rowLayout>
          
          <uix:rowLayout>
            <uix:spacer width="30" />          
             <uix:styledText textBinding="whereClauseExampleMsg@searchSessionsBean@servletRequest"
               styleClass="OraInlineInfoText"  />
           </uix:rowLayout>
          
        </uix:stackLayout>

      </uix:tableLayout>
      </uix:header>
      <uix:header textBinding="RESULT_LABEL@DBMsgBundle@servletRequest">

      
        <oem:table name="searchSessionsUIDataSource"
             id="sessionsTable"
             alternateTextBinding="NO_SESSIONS@DBMsgBundle@servletRequest" 
             width="100%"
             blockSize="25"
             summaryBinding="RESULT_LABEL@DBMsgBundle@servletRequest"
             dataSourceProp="searchSessionsUIDataSource"
             beanKey="searchSessionsBean"
             formSubmitted="true" >
	     
                <uix:tableSelection>
                        <uix:multipleSelection selected="selected"
                          shortDescBinding="SELECT@ResourceBundle@servletRequest">
<uix:flowLayout>
 <uix:styledText styleClass="OraPromptText" textBinding="SESS_USER_TYPE@TopConsumersMsgBundle"/>
  <uix:spacer width="5"/>
 <uix:choice name="userType" onChange="submitForm('foo', true, {'event':'changeUserType'})" selectedValueBinding="userType@searchSessionsBean@servletRequest">
	<uix:option textBinding="DB_USER_TYPE@TopConsumersMsgBundle" value="DB"/>
        <uix:option textBinding="SYS_SESS_USER_TYPE@TopConsumersMsgBundle" value="System"/>
 </uix:choice>
</uix:flowLayout>
                          <uix:submitButton textBinding="KILL_SESSION@DBMsgBundle@servletRequest"
                                name="event" value="loadKillSession"/>
                          <uix:submitButton textBinding="DISABLE_SQL_TRACE@TopConsumersMsgBundle"
                                name="event" value="disableSQLTrace"/>
                          <uix:submitButton textBinding="ENABLE_SQL_TRACE@TopConsumersMsgBundle"
                                name="event" value="loadEnableSQLTrace"/>               
			</uix:multipleSelection>
		</uix:tableSelection>
	     
        </oem:table>
      

      </uix:header>
      </uix:header>
      
      <uix:spacer height="15" />

      <%@ include file="/database/instance/monitoringLinks.jspf" %>

    </db:form>    
    </uix:pageLayout>
    </uix:body>

  </uix:document>
</uix:renderingContext>

