<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<uix:bundle name="sqlMsg"
            class="oracle.sysman.db.rsc.inst.SQLMsg"/>

  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="CONFIRMATION@uixDBObjectBundle@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
      
          
      <db:form name="foo" method="POST" destinationBinding="dest@servletRequest"
        copyParams="target,type,tabNum">  

        <uix:pageLayout messageType="confirmation">

<%-- Warning/Error display --%>
<oem:messageBox messageType="info"
                errorTableBinding="info@servletRequest"
                titleTextKey="titleText" mainTextKey="mainText"/>
<oem:messageBox messageType="error"
                errorTableBinding="errors@servletRequest"
                titleTextKey="titleText" mainTextKey="mainText"/>

            <%@ include file="/database/globalPopup.jspf" %>

         <uix:stackLayout>
           <uix:rowLayout>
             <uix:styledText styleClass="OraDataText"
                             textBinding="msgText@msgTable@servletRequest"/>
           </uix:rowLayout>
              <uix:tableLayout width="100%" cellSpacing="2">
               <uix:rowLayout width="100%">
                   <uix:styledText styleClass="OraDataText"
                                  textBinding="message@errorBean@servletRequest"/>
               </uix:rowLayout>
               <uix:header textBinding="LOAD_STS_LOAD_OPTIONS@sqlMsg">
               <uix:rowLayout>
               <uix:checkBox name="addNewSql" 
                      textBinding="LOAD_STS_ADD_NEW_SQL@sqlMsg"  
                      checkedBinding="addNewSql@searchSource@servletRequest"/>
               </uix:rowLayout>
               <uix:rowLayout>
               <uix:checkBox name="updateExistingSql" 
                      textBinding="LOAD_STS_UPDATE_EXIST_SQL@sqlMsg"  
                      checkedBinding="updateExistingSql@searchSource@servletRequest"/>
               </uix:rowLayout>
               </uix:header>
               </uix:tableLayout>
         </uix:stackLayout>   

          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:submitButton name="event"
                      textBinding="NO@uixDBObjectBundle@servletRequest" 
                      value="reLoad"/>
              <uix:submitButton name="event"
                      textBinding="YES@uixDBObjectBundle@servletRequest" 
                      value="doSaveAllToSTS"/>
            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>

        </db:form>

      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>



