<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<db:script src="/database/LOV.js"/>

<script>
function launchTimePickerPage(url, winName) 
{
  timePickerWin = openWindow(window, url, winName, {width:1000, height:600}, true, 'dialog', '');
  timePickerWin.focus();
}
</script>
<uix:renderingContext id="renderingContext"> 
<uix:bundle name="DBMsg"
	    class="oracle.sysman.db.rsc.inst.DBMsg"/>  
<uix:bundle name="SQLMsg" 
	    class="oracle.sysman.db.rsc.inst.SQLMsg"/>
 <oem:setURLEncoder id="renderingContext"/>     
        
  <uix:document> 
    <%@ include file="/enablePPR.jspf" %>  
    <%@ include file="/oemTitle.jspf" %> 

    <uix:body> 
    <uix:pageLayout> 
    <%@ include file="/database/global.jspf" %>
    
    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@searchSQLsBean@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>

    <uix:switcher childNameBinding="confirmRendered@servletRequest">
    <uix:case name="true">
    <uix:messageBox automatic="false" textBinding="confirmTitle@servletRequest"
                    messageBinding="confirmMessage@servletRequest"
                    messageTypeBinding="confirmMessageType@servletRequest">
       <uix:link textBinding="fullSaveToSTSName@searchSQLsBean@servletRequest"
                 destinationBinding="stsLink@servletRequest"/>
    </uix:messageBox>
    </uix:case>
    </uix:switcher>
    <db:form name="foo" method="POST" destinationBinding="dest@servletRequest"
      copyParams="target,type,tabNum">  
  
    <uix:formValue name="event" value="doLoad" />

    <uix:header textBinding="header@searchSQLsBean@servletRequest">
    <%@ include file="../refreshTime.jspf" %>
    <uix:stackLayout>
      <uix:rowLayout>
        <uix:cellFormat width="53%" vAlign="top">
          <%@ include file="/database/instance/searchSource.jspf" %> 
        </uix:cellFormat>
        <uix:cellFormat width="2%">
        </uix:cellFormat>
        <uix:cellFormat width="45%" vAlign="top" hAlign="center">
        <uix:contentContainer textBinding="SAVE_TO_STS@SQLMsg" width="100%">
          <uix:stackLayout>
            <uix:separator>
              <uix:spacer width="10" height="7"/>
            </uix:separator>
            <uix:styledText textBinding="SAVE_TO_STS_DESC@SQLMsg" styleClass="OraInstructionText"/>
            <uix:radioButton name="saveType"
                             value="saveToExistingSTS"
                             selectedValueBinding="saveType@searchSQLsBean@servletRequest" 
                             onClick="submitForm('foo', true, {event:'switchToSaveToExistingSTS'})"
                             textBinding="SAVE_TO_EXISTING_STS@SQLMsg"/>
            <uix:rowLayout>
            <uix:spacer width="30"/>
            <uix:messageLovField promptBinding="NAME@SQLMsg" name="saveToExistingSTSName" searchDescBinding="SQL_TUNING_SET_NAME@SQLMsg"
	id="saveToExistingSTSName" textBinding="saveToExistingSTSName@searchSQLsBean@servletRequest" 
	onClick="startLov('saveToExistingSTSName', 'ListSTS')"
        disabledBinding="disableSaveToExistingSTSNameField@searchSQLsBean@servletRequest"/>
            </uix:rowLayout>
            <uix:radioButton name="saveType"
                             value="saveToNewSTS"
                             selectedValueBinding="saveType@searchSQLsBean@servletRequest" 
                             onClick="submitForm('foo', true, {event:'switchToSaveToNewSTS'})"
                             textBinding="SAVE_TO_NEW_STS@SQLMsg"/>
            <uix:rowLayout>
            <uix:spacer width="30"/>
            <uix:messageTextInput promptBinding="NAME@SQLMsg" name="saveToNewSTSName"
	id="saveToNewSTSName" textBinding="saveToNewSTSName@searchSQLsBean@servletRequest" 
        disabledBinding="disableSaveToNewSTSNameField@searchSQLsBean@servletRequest"/>
            </uix:rowLayout>
            <uix:rowLayout hAlign="right">
              <uix:submitButton name="event" value="saveAllToSTS" textBinding="SAVE_TO_STS_BTN@SQLMsg"/>
            </uix:rowLayout>                         
          </uix:stackLayout>
        </uix:contentContainer>
        </uix:cellFormat>
      </uix:rowLayout>
    </uix:stackLayout>
    <%@ include file="/database/instance/filterConditions.jspf" %>
    <uix:flowLayout>
    <uix:spacer width="30"/>
    <uix:submitButton name="event" value="search" textBinding="SEARCH_BTN@SQLMsg"/>
    <uix:spacer width="10"/>
    <uix:submitButton name="event" value="showSql" textBinding="SHOW_SQL_BTN@SQLMsg"/>
    </uix:flowLayout>

    <uix:separator/>
    <uix:header textBinding="resultHeader@searchSQLsBean@servletRequest" >
    <uix:switcher childNameBinding="tabNum@servletRequest">
    <uix:case name="1">
    <%@ include file="awrResults.jspf" %>
    </uix:case>				  
    <uix:case name="2">
    <%@ include file="baselineResults.jspf" %> 
    </uix:case>					  
    <uix:case name="3">
    <%@ include file="stsResults.jspf" %> 
    </uix:case>				  
    <uix:default>
    <%@ include file="ccResults.jspf" %> 
    </uix:default>
    </uix:switcher>
    </uix:header>

    </uix:header>

    </db:form>    
    </uix:pageLayout> 
    </uix:body>

  </uix:document>
</uix:renderingContext>

