<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>

      <uix:metaContainer>
        <uix:head titleBinding="SEARCH_SEL_SNAPSHOT_TITLE@DBMsgBundle@servletRequest"/>
        <db:script src="/database/utils.js"/>
        <db:script src="/cabo/jsLibs/TableProxy.js"/>
      </uix:metaContainer>
      
      <head>
       
        <script>
          function lovSelect(lovField)
          {
            var proxy = new TableProxy('selectSnapshotUIDataSource');
            var selectedIndex = proxy.getSelectedRow();
            if (selectedIndex >= 0)
            {
              var selectedElement = proxy.getFormElement('Hidden', selectedIndex);
              lovField.value = selectedElement.value;
              window.close();
            }
          }
        </script>
        </head>
   

    <uix:body>
      <uix:pageLayout>
        <uix:form name="selectSnapshotForm" destinationBinding="controllerDestination@servletRequest">
        <uix:formValue name="pageName" value="/database/instance/selectSnapshotPage"/>

	  <uix:spacer height="10"/>
          <uix:header textBinding="SEARCH_SEL_SNAPSHOT_TITLE@DBMsgBundle@servletRequest">


<%-- cancel and select button --%>
	<uix:rowLayout hAlign="right">
	  <uix:tableLayout cellSpacing="5">
	    <uix:rowLayout hAlign="right">
                <uix:button textBinding="CANCEL@DBMsgBundle@servletRequest" 
                            destination="javascript:self.close()"/>
                <uix:spacer width="5"/>
	        <uix:button textBinding="SELECT@DBMsgBundle@servletRequest" 
                      destinationBinding="selectSnapshotDestination@httpSession" />
	    </uix:rowLayout>
          </uix:tableLayout>
	</uix:rowLayout>
<%-- end cancel and select button --%>

	<uix:tableLayout>
<%-- searching criteria section
	<uix:rowLayout>
	<uix:stackLayout>
	  <uix:header textBinding="SEARCH@DBMsgBundle@servletRequest">
	  <uix:styledText textBinding="SELECT_SNAPSHOT_INTRO@DBMsgBundle@servletRequest"/>
          <uix:tableLayout cellSpacing="5">		
	    <uix:rowLayout>
		  <uix:cellFormat hAlign="right">
		  <uix:messagePrompt promptBinding="SNAPSHOT_TIME@DBMsgBundle@servletRequest"/>
		  </uix:cellFormat>
                  <uix:cellFormat hAlign="left">
		  <uix:textInput name="date"
				textBinding="date@defaultBean@servletRequest"/>
		  </uix:cellFormat>
		  <uix:cellFormat>
		  <uix:messagePrompt prompt="  "/>
		  </uix:cellFormat>
		  <uix:cellFormat hAlign="left">
		  <uix:submitButton textBinding="GO@DBMsgBundle@servletRequest"
				  name="event" value="searchSnapshots"/>
                  </uix:cellFormat>
	    </uix:rowLayout>		
	    </uix:tableLayout>
	    </uix:header>
	</uix:stackLayout>
	</uix:rowLayout>  --%>
<%-- end searching criteria section --%>

<%-- search result section --%>
	<uix:rowLayout>
              <uix:cellFormat>
              <uix:stackLayout>
                <uix:header textBinding="RESULT_LABEL@DBMsgBundle@servletRequest">
	        <oem:table width="100%" 
                           name="selectSnapshotUIDataSource"
                           dataSourceProp="snapshotTwoDDataSource"
                           beanKey="selectSnapshotUIDataSourceBean"
                           destinationBinding="controllerDestination@servletRequest"
                           formSubmitted="true"
                           blockSize="10"
	    	           alternateTextBinding="NO_ROWS_FOUND@DBMsgBundle@servletRequest">
	        <uix:tableSelection>
	        <uix:singleSelection selectedIndex="0">
	        </uix:singleSelection>
	        </uix:tableSelection>
                </oem:table>
	        </uix:header>
              </uix:stackLayout>
              </uix:cellFormat>
	</uix:rowLayout>
<%-- end search result section --%>

        </uix:tableLayout>	
          </uix:header>

          <uix:contentFooter>
            <uix:contents>
              <uix:pageButtonBar>
                <uix:button textBinding="CANCEL@DBMsgBundle@servletRequest" 
                            destination="javascript:self.close()"/>
	        <uix:button textBinding="SELECT@DBMsgBundle@servletRequest" 
                            destinationBinding="selectSnapshotDestination@httpSession" />
              </uix:pageButtonBar>
            </uix:contents>
          </uix:contentFooter>

        </uix:form>	
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>
