<%@ include file="/sdk/oemTop.jspf" %>
<!-- ================  Database Active SQL Page =================== --> 

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <uix:pageLayout>
        <%@ include file="/database/global.jspf" %>

        <oem:messageBox messageType="warning"
                              errorTableBinding="intervalWarning@servletRequest"
                  mainTextKey="mainText"/>

        <oem:messageBox messageType="error"
                              errorTableBinding="intervalError@servletRequest"
                              mainTextKey="mainText"/>

          <oem:messageBox messageType="error"
                          errorTableBinding="errors@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>

	   <oem:messageBox messageType="error"
                          errorTableBinding="errorsSqlTuning@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>
	  <oem:messageBox messageType="info"
                          errorTableBinding="infoSqlTuning@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>

        <db:form name="tsForm" destination="/console/database/instance/activeSqls"
                  copyParams="target,type,source,lastUpdatedTime,sids">
          <uix:header textBinding="header@activeSqlsBean@servletRequest" >
            <uix:tableLayout width="100%">
              <uix:rowLayout hAlign="right">
                <uix:cellFormat>
                  <uix:switcher childNameBinding="showTime@activeSqlsBean@servletRequest">
                    <uix:case name="true">
                      <uix:rowLayout>
                        <uix:styledText styleClass="OraTipText"
                              textBinding="DATA_RETRIEVED@ResourceBundle@servletRequest"/>
                        <uix:spacer width="10"/>
                        <uix:styledText styleClass="OraTipLabel"
                              textBinding="lastUpdatedTime@activeSqlsBean@servletRequest"/>
                      </uix:rowLayout>
                    </uix:case>
                  </uix:switcher>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
 
            <uix:spacer height="5"/>
            <uix:styledText styleClass="OraInstructionText" 
                            textBinding="ACTIVE_SQL_DESC@ResourceBundle@servletRequest" />

              <uix:switcher childNameBinding="SWRF@activeSqlsBean@servletRequest">
                <uix:case name="false">

            <uix:tableLayout  width="100%">
              <uix:rowLayout hAlign="right"  width="100%">            
                <uix:cellFormat vAlign="center">                  
                  <uix:spacer width="10"/>                  
                  <uix:submitButton textBinding="TOP_SQL_ASSESS@ResourceBundle@servletRequest"
                                name="event"                                    
                                value="sqlAssessment" />                

                </uix:cellFormat>              
              </uix:rowLayout>          
            </uix:tableLayout>      
                </uix:case>
              </uix:switcher>

            <uix:tableLayout  width="100%">
              <uix:rowLayout>            
                  <uix:spacer height="5"/>                  
              </uix:rowLayout>          
              <uix:rowLayout>            
                <uix:stackLayout>                
<%--
                  <uix:switcher childNameBinding="node@activeSqlsBean@servletRequest"> 
                    <uix:case name="okNode">                    
--%>
              <uix:switcher childNameBinding="SWRF@activeSqlsBean@servletRequest">
                <uix:case name="true">
                      <oem:table name="twoDUIDataSource" 
                                 summaryBinding="header@activeSqlsBean@servletRequest" 
                                 blockSize="25"
                                 beanKey="dataSourceBean"
                                 destination="/console/database/instance/activeSqls" 
                                 formSubmitted="true" 
                                 dataSourceProp="twoDUIDataSource" 
                                 alternateTextBinding="noData@activeSqlsBean@servletRequest"
                                 width="100%">                    
                          <uix:tableSelection>
                           <uix:multipleSelection
                             selectedBinding="selected"
                             shortDescBinding="SELECT@ResourceBundle@servletRequest"
                             selectionBinding="selection@activeSqlsBean@servletRequest"
                             >
                           <uix:pageButtonBar>
                             <uix:submitButton
                               textBinding="RUN_TUNING_ADVISOR@ResourceBundle@servletRequest"
                               name="event"
                               value="sqlTuning"
                             />
                            </uix:pageButtonBar>
                            </uix:multipleSelection>

                          </uix:tableSelection>
                      </oem:table>                  

                </uix:case>
                <uix:case name="false">
                    <oem:table name="twoDUIDataSource"
                                 summaryBinding="header@activeSqlsBean@servletRequest" 
                                 blockSize="25"
                                 beanKey="dataSourceBean"
                                 destination="/console/database/instance/activeSqls"
                                 formSubmitted="true"
                                 dataSourceProp="twoDUIDataSource"
                                 alternateTextBinding="noData@activeSqlsBean@servletRequest"
                                 width="100%">
                      </oem:table>                  

                </uix:case>
            </uix:switcher>
                </uix:stackLayout>            
              </uix:rowLayout>        

              <uix:rowLayout>        
                <uix:stackLayout>            
                  <uix:header textBinding="RELATED_LINKS@ResourceBundle@servletRequest">
                    <uix:link textBinding="ACTIVITY_DETAILS@ResourceBundle@servletRequest"
                              destinationBinding="topSqlUrl@servletRequest"/>
                  </uix:header>
                </uix:stackLayout>            
              </uix:rowLayout>        
            </uix:tableLayout>      
          </uix:header>            
        </db:form>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>

