<%@ include file="/sdk/oemTop.jspf" %>
<!-- ================  Session Details General Page =================== -->

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:styleSheet/> 


  <script>

    function scroll_timechart(direction)
    {
    if (direction == 'prev'){
    document.foo.direction.value = '1';
    }
    else{
    document.foo.direction.value = '2';
    }
    submitForm('foo', true, {'event':'scrollChart'});
    }

    function my_goto_band(selIdx, startMS, endMS)
    {
    submitForm('foo', true, {'event':'moveSlider','leftEdge':startMS,'rightEdge':endMS,'selectedBand':selIdx});
    }  
    
    function sliderOffLeft(param)
    {
    location.href = param;
    }
    
  </script>

  <uix:renderingContext id="renderingContext">
    <%-- check to see if auto-refresh needs to be set --%> 
    <uix:switcher childNameBinding="autoRefresh@servletRequest">
      <uix:case name="true">
	<uix:rawText rendered="true">  
	  <meta http-equiv="Cache-Control" content="max-age=0" >
	    <meta http-equiv="Refresh" content="15" >
            </uix:rawText> 
          </uix:case>  
        </uix:switcher>
	<uix:bundle name="DBMsg"
	    class="oracle.sysman.db.rsc.inst.DBMsg"/>
	<oem:setURLEncoder id="renderingContext"/> 
	<uix:document>
	  <%@ include file="/oemTitle.jspf" %>    

	  <uix:body>
	    <db:form name="foo" destinationBinding="destURL@servletRequest"
		     copyParams="target,type,serialNum,SID,refreshChoice,leftEdge, rightEdge" >
	      <uix:formValue name="SID" valueBinding="SID@sessionDetailsBean@servletRequest"/>
	      <uix:formValue name="serialNum" valueBinding="sessSerial@sessionDetailsBean@servletRequest"/>
	      <uix:formValue name="pageNum" value="2"/>
	      <uix:formValue name="leftEdge" valueBinding="leftEdge@servletRequest"/>
	      <uix:formValue name="rightEdge" valueBinding="rightEdge@servletRequest"/>
	      <uix:formValue name="direction" value=""/>
	      <uix:formValue name="selectedBand" value=""/>


	      
	      <uix:pageLayout>
		<%@ include file="/database/global.jspf" %>
	         <oem:messageBox messageType="info" 
          	        errorTableBinding="info@servletRequest"
               	  	titleTextKey="titleText" mainTextKey="mainText"/>

	        <oem:messageBox messageType="warning"
			errorTableBinding="warning@servletRequest"
			mainTextKey="exceptionText"/>
		<oem:messageBox messageType="error"
				errorTableBinding="errors@servletRequest"
				titleTextKey="titleText" mainTextKey="mainText"/>
	        
	        <oem:messageBox messageType="warning"
			errorTableBinding="intervalWarning@servletRequest"
			mainTextKey="exceptionText"/>
	  <oem:messageBox messageType="error"
			errorTableBinding="intervalError@servletRequest"
			mainTextKey="exceptionText"/>
		<uix:header textBinding="header@sessionDetailsBean@servletRequest"> 
		  <uix:rowLayout>
        	    <uix:spacer height="5"/>
	          </uix:rowLayout>



	       <uix:flowLayout>
          <uix:tableLayout width="100%">
             <uix:rowLayout>

               <uix:cellFormat hAlign="left" >
                <uix:rowLayout>
                    <uix:styledText styleClass="OraTipText" 
                      textBinding="COLL_FROM_TARGET@SDKBundle@servletRequest"/>
                    <uix:spacer width="5" />  
                    <uix:styledText styleClass="OraTipLabel" 
                      textBinding="refreshTime@servletRequest"/>
                    <uix:spacer width="10" />
                </uix:rowLayout>
              </uix:cellFormat>
                
              <uix:cellFormat hAlign="right" >
                <uix:flowLayout>
  
                    <uix:styledText styleClass="OraFieldText" 
                      textBinding="VIEW_DATA@DBMsgBundle@servletRequest" 
                      labeledNodeId="viewById" />
 			  <uix:choice name="refreshChoice" id="viewById"
				      onChange="submitForm('foo', true, {'event':'updateRefreshChoice'})"
				      selectedValueBinding="refreshChoiceSelected@servletRequest">
			    <uix:option textBinding="REAL_TIME_AUTO_15_SEC@DBMsgBundle@servletRequest"
					value="RT_15"/>
			    <uix:option textBinding="REAL_TIME_MANUAL@DBMsgBundle@servletRequest"
					value="RT_MAN"/>
			    <uix:option textBinding="HISTORICAL@DBMsgBundle@servletRequest"
					value="HIST_CUST" />       
			  </uix:choice>  
 
  
                      <uix:button textBinding="REFRESH@SDKBundle@servletRequest"
                        destinationBinding="refreshDest@servletRequest" />
  
                 </uix:flowLayout>
                </uix:cellFormat>
       
  
              </uix:rowLayout>
	
         </uix:tableLayout>
      </uix:flowLayout>
	 <uix:tableLayout width="100%">	  
	 

            <uix:rowLayout>
              <uix:spacer height="5"/>
            </uix:rowLayout>

              	    <uix:rowLayout hAlign="right" renderedBinding="isNotDisconnected@servletRequest">
                      <uix:include node="/database/instance/session/button.jsp"/>
                    </uix:rowLayout>

            <uix:rowLayout>
              <uix:spacer height="5"/>
            </uix:rowLayout>

		  </uix:tableLayout>
		  
		      <uix:subTabLayout>

			<uix:subTabs>
<uix:switcher childNameBinding="hasResult@sessionDetailsBean@servletRequest">
		    <uix:case name="true">
		      <uix:switcher childNameBinding="historical@sessionActivityBean@servletRequest">
			<uix:case name="false">
			  <uix:subTabBar selectedIndex="1">
			    <uix:link textBinding="GENERAL@ResourceBundle@servletRequest"
				      destinationBinding="generalDest@servletRequest"/>
			    <uix:link textBinding="ACTIVITY@ResourceBundle@servletRequest"
				      destinationBinding="activityDest@servletRequest"/>
			    <uix:link textBinding="ALL_SESS_LINK@ResourceBundle@servletRequest"
				      destinationBinding="allStatDest@servletRequest"/>
			    <uix:link textBinding="OPEN_CURSORS@ResourceBundle@servletRequest"
				      destinationBinding="openCursorDest@servletRequest"/>
			    <uix:link textBinding="BLOCKING_TREE@ResourceBundle@servletRequest"
				      destinationBinding="locksDest@servletRequest"/>
                            <uix:link textBinding="WAIT_EVENT_HDR@ResourceBundle@servletRequest"
                                      destinationBinding="waitEventDest@servletRequest"/>
          <uix:link textBinding="PARALLEL_SQL@ResourceBundle@servletRequest"
                destinationBinding="parallelSqlDest@servletRequest"/>
    <uix:switcher childNameBinding="disableMonitor@sessionDetailsBean@servletRequest">
        <uix:case name="true">
           <uix:link textBinding="SQL_MONITORING@ResourceBundle@servletRequest"
                destinationBinding="sqlMonitorDest@servletRequest"
                shortDescBinding="NO_MONITOR_INFO@ResourceBundle@servletRequest"
                disabled="true"
                renderedBinding="renderMonitorTab@sessionDetailsBean@servletRequest"/>
        </uix:case>
        <uix:default>
           <uix:link textBinding="SQL_MONITORING@ResourceBundle@servletRequest"
                destinationBinding="sqlMonitorDest@servletRequest"
                renderedBinding="renderMonitorTab@sessionDetailsBean@servletRequest"/>
        </uix:default>
     </uix:switcher>
			  </uix:subTabBar>
			</uix:case>
		      </uix:switcher>
</uix:case>
	</uix:switcher>
			</uix:subTabs>

			<uix:switcher childNameBinding="useSVG@sessionActivityBean@servletRequest">
			  <uix:case name="true">
			    <uix:tableLayout renderedBinding="showChart@sessionActivityBean@servletRequest">
			      <uix:rowLayout hAlign="left">
				<uix:messagePrompt promptBinding="WAIT_DETAIL_SELECTOR_TIP@DBMsgBundle@servletRequest" />
			      </uix:rowLayout>
			    </uix:tableLayout>
			  </uix:case>
			  <uix:case name="false">
			    <uix:tableLayout renderedBinding="showChart@sessionActivityBean@servletRequest">
			      <uix:rowLayout hAlign="left">
				<uix:messagePrompt promptBinding="WAIT_DETAIL_GIF_TIP@DBMsgBundle@servletRequest" />
			      </uix:rowLayout>
			    </uix:tableLayout> 
			  </uix:case>
			</uix:switcher>
                        

   <uix:switcher childNameBinding="showChart@sessionActivityBean@servletRequest">
   <uix:case name="true">
       <uix:switcher childNameBinding="useSVG@sessionActivityBean@servletRequest">
       <uix:case name="true">
              <db:flexRegion
                  swfName="/database/flex/sessionDetails.swf"
                  dataSrcKeyBinding="flexKey@servletRequest"
                  windowWidth="100%"
                  windowHeight="250"
                  idBase="flexSessDetailsChart" />
       </uix:case>   
       <uix:case name="false" >
       
                  <oem:chart 
                    chartType="timeSeriesChart"
                    width="900"
                    height="175"
                    timeGranularity="SECOND" 
                    orientation="vertical"
                    fill="cumulative"  
                    yAxisLabelBinding="PCT_ACTIVITY@DBMsgBundle@servletRequest"
                    legendPosition="east"
                    legendVisible="true"
                    titleBinding="ACTIVE_SESSIONS@DBMsgBundle@servletRequest"
                    titleVisible="false"
                    seriesColorsAutomatic="true"
                    format="svg"
                    svgUpdateFrequencyBinding="svgUpdateRate@servletRequest"
                    xAxisMinBinding="beginDate@waitAreaChart@sessionActivityBean@servletRequest"
                    xAxisMaxBinding="endDate@waitAreaChart@sessionActivityBean@servletRequest"
                    axisMin="0"
                    axisMaxBinding="actualMaxValue@waitAreaChart@sessionActivityBean@servletRequest"
                    svgHighlightLegend="true"
                    svgTimebandTipBinding="WAIT_DETAIL_SELECTOR_TIP@DBMsgBundle@servletRequest"
                    colorPaletteBinding="waitColorsTable@activityDetailsChart@sessionActivityBean@servletRequest"
                    >
                    <uix:contents>
                      <oem:timeSelector
                        xAxisMinBinding="beginDate@waitAreaChart@sessionActivityBean@servletRequest"
                        xAxisMaxBinding="endDate@waitAreaChart@sessionActivityBean@servletRequest"
                        intervalTimeSecBinding="intervalTimeSec@servletRequest"
                        height="20"
                        selectedMaxDateBinding="selectedMaxDate@activityDetailsChart@sessionActivityBean@servletRequest"
                        selectedMinDateBinding="selectedMinDate@activityDetailsChart@sessionActivityBean@servletRequest"
                        numBandsSelectedBinding="numBandsSelected@servletRequest"
                        selectionDest="my_goto_band"
                        selectionDestType="JavaScript"
                        selectionAltTextBinding="SELECT_PERIOD_RANGE@DBMsgBundle@servletRequest" 
                        position="south"
                        dynamicTimeSelector="true"
                        xAxisScrollDest="scroll_timechart"
                        xAxisScrollDestType="JavaScript"
                        xAxisScrollPrevBinding="scrollButtonsAvailable@activityDetailsChart@sessionActivityBean@servletRequest"
                        xAxisScrollPrevAltTextBinding="GO_BACKWARD@DBMsgBundle@servletRequest" 
                        xAxisScrollNextBinding="scrollButtonsAvailable@activityDetailsChart@sessionActivityBean@servletRequest"
                        xAxisScrollNextAltTextBinding="GO_FORWARD@DBMsgBundle@servletRequest" 
                        selectionIndicator="shading"
                        dynamicTimeSelectorColorBinding="sliderColor@waitAreaChart@sessionActivityBean@servletRequest"
                        dynamicTimeSelectorEdgeColorBinding="sliderEdgeColor@waitAreaChart@sessionActivityBean@servletRequest"
                        >
                      </oem:timeSelector> 
                      <oem:boundChartDataSource 
                        dataClass="oracle.sysman.db.adm.inst.SessionDetailsController"
                        dataMethod="updateChartData" />
                      <oem:chartColumn                                   
                        isKey="true" 
                        displayLabel=""
                        sourceIndex="0" />
                      <oem:chartColumn
                        isTimeColumn="true"
                        displayLabel="Time"
                        sourceIndex="1"  />
                      <oem:chartColumn                                   
                        displayLabel=""
                        sourceIndex="2" />
                    </uix:contents>
                  </oem:chart>

            </uix:case>
            </uix:switcher>
            </uix:case>
            <uix:case name="false">
             <uix:rowLayout>
                <uix:text textBinding="5001@ChartMsgBundle@servletRequest"/>
              </uix:rowLayout> 
            </uix:case>
            </uix:switcher>


		


			 <uix:switcher childNameBinding="showDetails@servletRequest">
          <uix:case name="true">


	<uix:stackLayout>
	<uix:tableLayout  width="100%">
	<uix:rowLayout hAlign="left" > 

	 <uix:switcher childNameBinding="historical@sessionActivityBean@servletRequest">
	<uix:case name="false"> 
		    <uix:switcher childNameBinding="showRawDetails@sessionActivityBean@servletRequest"> 
	

		<uix:case name="true"> 
		  <uix:flowLayout>
		    <uix:checkBox name="pin" 
				  checkedBinding="pinned@sessionActivityBean@servletRequest"
				  textBinding="ANCHOR_SHADED_BOX_LABEL@DBMsgBundle@servletRequest"/>
		    <uix:submitButton textBinding="GO@DBMsgBundle@servletRequest" name="event" valueBinding="pinEvent@sessionActivityBean@servletRequest"/> 
		  </uix:flowLayout> 
	 </uix:case>
	</uix:switcher>
	 </uix:case>
	</uix:switcher>
	</uix:rowLayout>
	</uix:tableLayout> 
            <uix:header size="1"
                textBinding="detailIntervalHeader@sessionActivityBean@servletRequest"
                renderedBinding="showChart@sessionActivityBean@servletRequest">
    
       <uix:tableLayout width="100%" >
	
          <uix:rowLayout vAlign="top" >
          <uix:stackLayout>
          
              <uix:flowLayout>

                <uix:styledText styleClass="OraPromptText"
                    textBinding="SPOT_SQL_DETAIL_TEXT@DBMsgBundle@servletRequest"/>
                <uix:spacer width="8"/>
                <uix:styledText styleClass="OraDataText"
                  textBinding="detailStartTime@sessionActivityBean@servletRequest"/>

              <uix:spacer width="20" />
	         <uix:switcher childNameBinding="historical@sessionActivityBean@servletRequest">
	         <uix:case name="false"> 
			<uix:flowLayout> 
              	          <uix:styledText styleClass="OraFieldText" 
					  labeledNodeId="detailViewOption"
					  textBinding="VIEW@DBMsgBundle@servletRequest" />
			  <uix:choice name="detailViewOption" id="detailViewOption"
				      onChange="submitForm('foo', true, {'event':'changedDetailViewOption'})"
				      selectedValueBinding="detailViewOption@servletRequest">
			    <uix:option textBinding="SHOW_AGGREGATED_DATA_BUTTON@DBMsgBundle@servletRequest"
					value="showAggregatedData"/>
			    <uix:option textBinding="SHOW_RAW_DATA_BUTTON@DBMsgBundle@servletRequest"
					value="showRawData"/>
			  </uix:choice>  

                          <uix:spacer width="20" />

	 	        </uix:flowLayout>

	 </uix:case>
	</uix:switcher>



          <uix:button textBinding="ASH_REPORT@DBMsgBundle@servletRequest"
                      renderedBinding="showAshReportLink@servletRequest"
                      destinationBinding="ashReportLink@servletRequest" />


	</uix:flowLayout>
               <uix:spacer height="4" />
	      <uix:switcher childNameBinding="showRawDetails@sessionActivityBean@servletRequest"> 
		<uix:case name="false">
		  <uix:stackLayout>
                  <%@ include file="activityAggregateDetails.jspf" %>
		  <uix:spacer height="4" />
		  </uix:stackLayout>
	      </uix:case>
		<uix:case name="true"> 
                  <%@ include file="activityRawDetails.jspf" %>
	      </uix:case>	
	      </uix:switcher>  
              </uix:stackLayout>

		 </uix:rowLayout> 
             
             </uix:tableLayout>  

            </uix:header>
	    </uix:stackLayout>
            </uix:case>
            </uix:switcher> 
		      </uix:subTabLayout>
		</uix:header>

		<uix:contentFooter>
	<uix:switcher childNameBinding="hasResult@sessionDetailsBean@servletRequest">
		    <uix:case name="true">
		  <uix:include node="/database/instance/session/button.jsp"/>
	</uix:case>
	</uix:switcher>
		</uix:contentFooter>

	      </uix:pageLayout>
	    </db:form>
	  </uix:body>
	</uix:document>
      </uix:renderingContext>

