<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/>
    <uix:document>
        <%@ include file="/oemTitle.jspf" %>

        <uix:body>
            <uix:pageLayout>
                <%@ include file="/database/global.jspf" %> 
    
                <db:form name="foo" method="post" destinationBinding="destURI@servletRequest" copyParams="target,type">

                    <uix:contents>
      <oem:messageBox messageType="info" errorTableBinding="info@servletRequest"
                             msgBundleBinding="ResourceBundle"
                             titleTextKey="titleText" mainTextKey="mainText"/>
      <oem:messageBox messageType="error"
         errorTableBinding="errors@servletRequest"
         titleTextKey="titleText" mainTextKey="mainText"/>

                        <uix:header textBinding="header@blockingSessionsBean@servletRequest" >

              <%@ include file="../refreshTime.jspf" %>
    <%@ include file="/database/instances.jspf" %>

                            <uix:tableLayout width="100%">
                                <uix:switcher childNameBinding="hasDeadlock@blockingSessionsBean@servletRequest">
                                    <uix:case name="true">
                                        <uix:rowLayout hAlign="left">
                                            <uix:messagePrompt prompt="A deadlock has been detected in the blocked sessions." />
                                        </uix:rowLayout>
                                    </uix:case>
                                </uix:switcher>
                            </uix:tableLayout>

                            <uix:hGrid id="blockSess"
				summaryBinding="header@blockingSessionsBean@servletRequest"
                                width="100%"
                                alternateTextBinding="NO_BLOCKING_SESSIONS@DBMsgBundle@servletRequest"
                                destinationBinding="destURI@servletRequest"
                                columnHeaderDataBinding="columnHeaderData@blockingSessionsBean@servletRequest"
                                columnFormatsBinding="columnFormatData@blockingSessionsBean@servletRequest"
                                treeDataBinding="treeData@blockingSessionsBean@servletRequest"
                                formSubmitted="true"
                                proxyBinding="proxy@servletRequest">
                  
                                <uix:nodeStamp>
                                    <uix:column>
                                        <uix:columnHeader>
                                            <uix:styledText
                                                textBinding="LOCK_USERNAME@DBMsgBundle@servletRequest"/>
                                        </uix:columnHeader>
                                    <uix:rowLayout>
                                      <uix:image sourceBinding="iconText" />
                                      <uix:spacer width="5" />
                                      <uix:styledText textBinding="userName"
                                                      styleClass="OraFieldText" />
                                    </uix:rowLayout>
                                  </uix:column>
                                </uix:nodeStamp>

                                <uix:columnHeaderStamp>
                                    <uix:text textBinding="text"/>
                                </uix:columnHeaderStamp>

                                <uix:tableSelection>
                                    <uix:singleSelection selectedIndex="1"
					shortDescBinding="SELECT@ResourceBundle@servletRequest"
                                        disabledBinding="disabled">
                                        <uix:rowLayout>
                                            <uix:submitButton
                                                textBinding="VIEW_SESSION@DBMsgBundle@servletRequest"
                                                name="event" value="viewSessionDetail"/>
                                            <uix:submitButton
                                                textBinding="KILL_SESSION@DBMsgBundle@servletRequest"
                                                name="event" value="killSession"/>
                                            <%--
                                            <uix:submitButton
                                                textBinding="VIEW_SQL_STMT@DBMsgBundle@servletRequest"
                                                name="event" value="viewSQLDetail"/>
                                            --%>
                                        </uix:rowLayout>
                                    </uix:singleSelection>
                                </uix:tableSelection>

                                <uix:styledText textBinding="numBlocked"/>
                                <uix:styledText textBinding="sessId"
                                    destinationBinding="sessDetailURL"/>
                                <uix:styledText textBinding="serialNum"/>
                                <uix:styledText textBinding="sqlHashValue"
                                    destinationBinding="sqlDetailURL"/>
                                <uix:styledText textBinding="waitClass"/>
                                <uix:styledText textBinding="waitEvent"
                                    destinationBinding="waitHistogramURL"/>
                                <uix:styledText textBinding="p1"
                                    destinationBinding="p1URL"/>
                                <uix:styledText textBinding="p2"
                                     destinationBinding="p2URL"/>
                                <uix:styledText textBinding="p3"
                                     destinationBinding="p3URL"/>
                                <uix:styledText textBinding="secondsInWait"/>
                                <uix:formValue name="uniqueID" valueBinding="uid" />
                            </uix:hGrid>
                    </uix:header>

        	     <uix:spacer height="20"/>

                     <%@ include file="/database/instance/monitoringLinks.jspf" %>

                    </uix:contents>
                </db:form>
            </uix:pageLayout>
        </uix:body>
    </uix:document>
</uix:renderingContext>
