<%@ include file="/sdk/oemTop.jspf" %>
<!-- ================  Session Details Blocking Tree tab =================== -->

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>

      <uix:form name="sessBlockingSessionsForm" method="get" destinationBinding="defaultDest@servletRequest">

        <uix:formValue name="target" valueBinding="targetName@sessionDetailsBean@servletRequest"/>
        <uix:formValue name="type" valueBinding="targetType@sessionDetailsBean@servletRequest"/>
        <uix:formValue name="SID" valueBinding="SID@sessionDetailsBean@servletRequest"/>
        <uix:formValue name="pageNum" value="5"/>
        <uix:pageLayout>

    	  <%@ include file="/database/global.jspf" %>

          <oem:messageBox messageType="info" errorTableBinding="info@servletRequest"
                msgBundleBinding="ResourceBundle"
                titleTextKey="titleText" mainTextKey="mainText"/>
      	  <oem:messageBox messageType="error"
         	errorTableBinding="errors@servletRequest"
         	titleTextKey="titleText" mainTextKey="mainText"/>

          <uix:switcher childNameBinding="refreshChoice@servletRequest">
            <uix:case name="RT_15">
              <uix:rawText>
                <meta http-equiv="Refresh" content="15" >
              </uix:rawText>
            </uix:case>
          </uix:switcher>
          <uix:messageBox automatic="true" />

          <uix:header textBinding="header@sessionDetailsBean@servletRequest" >

	    <uix:flowLayout>
	      <uix:tableLayout width="100%">
		<uix:rowLayout>

		  <uix:cellFormat hAlign="left" >
		    <uix:rowLayout>
		      <uix:styledText styleClass="OraTipText" 
				      textBinding="COLL_FROM_TARGET@SDKBundle@servletRequest"/>
		      <uix:spacer width="5" />  
		      <uix:styledText styleClass="OraTipLabel" 
				      textBinding="refreshTime@servletRequest"/>
		      <uix:spacer width="10" />
		    </uix:rowLayout>
		  </uix:cellFormat>

		  <uix:cellFormat hAlign="right" > 
		    <uix:flowLayout>

		      <uix:styledText styleClass="OraFieldText" 
				      textBinding="VIEW_DATA@DBMsgBundle@servletRequest" 
				      labeledNodeId="view_choice" />
		      <uix:choice name="refreshChoice" id="view_choice"
				  onChange="submitForm('sessBlockingSessionsForm', true, {'event':'changeRefreshChoice'})"
				  selectedValueBinding="refreshChoiceSelected@servletRequest">
			<uix:option textBinding="REAL_TIME_AUTO_15_SEC@DBMsgBundle@servletRequest"
				    value="RT_15"/>
			<uix:option textBinding="REAL_TIME_MANUAL@DBMsgBundle@servletRequest"
				    value="RT_MAN"/>
			<uix:option textBinding="HISTORICAL@DBMsgBundle@servletRequest"
				    value="HIST_CUST" />       
		      </uix:choice>  


		      <uix:button textBinding="REFRESH@SDKBundle@servletRequest"
				  destinationBinding="refreshDest@servletRequest" />

		    </uix:flowLayout>
		  </uix:cellFormat>


		</uix:rowLayout>

	      </uix:tableLayout>
	    </uix:flowLayout>
	    <uix:tableLayout width="100%">	  
	    

            <uix:rowLayout>
              <uix:spacer height="5"/>
            </uix:rowLayout>

	    <uix:rowLayout hAlign="right">
	      <uix:include node="/database/instance/session/button.jsp"/>
	    </uix:rowLayout>

            <uix:rowLayout>
              <uix:spacer height="5"/>
            </uix:rowLayout>

	  </uix:tableLayout>

      	    <uix:subTabLayout>
              <uix:subTabs>
                <uix:switcher childNameBinding="showActivity@sessionDetailsBean@servletRequest">
                  <uix:case name="true">
                    <uix:subTabBar selectedIndex="4">
                    <%@ include file="tab10g.jspf" %>
                    </uix:subTabBar>
                  </uix:case>
                  <uix:case name="false">
                    <uix:subTabBar selectedIndex="3">
                    <%@ include file="tabPre10g.jspf" %>
                    </uix:subTabBar>
                  </uix:case>
                </uix:switcher>
              </uix:subTabs>

              <uix:styledText styleClass="OraInstructionText"
                           textBinding="BLOCKING_SESS_TXT@ResourceBundle@servletRequest"/>

              <uix:hGrid id="blockingSessions"
			   summaryBinding="BLOCKING_TREE@ResourceBundle@servletRequest"
                           width="100%"
                           alternateTextBinding="NO_BLOCKING_SESSIONS@ResourceBundle@servletRequest"
                           destinationBinding="defalutDest@servletRequest"
                           columnHeaderDataBinding="columnHeaderData@blockingSessionsBean@servletRequest"
			   columnFormatsBinding="columnFormatData@blockingSessionsBean@servletRequest"
                           treeDataBinding="treeData@blockingSessionsBean@servletRequest"
                           proxyBinding="proxy@servletRequest">
                <uix:nodeStamp>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:styledText textBinding="LOCK_USERNAME@ResourceBundle@servletRequest"/>
                    </uix:columnHeader>
                    <uix:rowLayout>
                      <uix:image sourceBinding="iconText" />
                      <uix:spacer width="5" />
                      <uix:styledText textBinding="userName"
                        styleClass="OraFieldText" />
                    </uix:rowLayout>
                  </uix:column>
                </uix:nodeStamp>

                <uix:columnHeaderStamp>
                  <uix:text textBinding="text"/>
                </uix:columnHeaderStamp>

                <uix:styledText textBinding="numBlocked"/>
                <uix:styledText textBinding="sessId"
                	destinationBinding="sessDetailURL"/>
                <uix:styledText textBinding="serialNum"/>
                <uix:styledText textBinding="sqlHashValue"
                        destinationBinding="sqlDetailURL"/>
                <uix:styledText textBinding="waitClass"/>
                <uix:styledText textBinding="waitEvent"
                        destinationBinding="waitHistogramURL"/>
                <uix:styledText textBinding="p1"
                        destinationBinding="p1URL"/>
                <uix:styledText textBinding="p2"
                        destinationBinding="p2URL"/>
                <uix:styledText textBinding="p3"
                        destinationBinding="p3URL"/>
                <uix:styledText textBinding="secondsInWait"/>
              </uix:hGrid>

      	    </uix:subTabLayout>
          </uix:header>

      	  <uix:contentFooter>
	    <uix:include node="/database/instance/session/button.jsp"/>
      	  </uix:contentFooter>

        </uix:pageLayout>
      </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
