<%@ include file="/sdk/oemTop.jspf" %>

<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>  
  <uix:document>    
    <%@ include file="/oemTitle.jspf" %>      
    
    <uix:body>      
      <uix:form name="enableSQLTraceForm" destinationBinding="defaultDest@servletRequest">        
        
    <uix:formValue name="target" valueBinding="target@servletRequest"/>
    <uix:formValue name="type" valueBinding="type@servletRequest"/>
    <uix:formValue name="sid" valueBinding="sid@servletRequest"/>
    <uix:formValue name="selectedSerial" valueBinding="selectedSerial@servletRequest"/>
    <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>

	<uix:formValue name="refreshChoice" valueBinding="refreshChoice@servletRequest"/>        
	      
        <uix:pageLayout titleBinding="pageHeader@servletRequest">
            <!-- for breadcrumbs support; plus standard label, links, tabs, etc -->          
            <%@ include file="/database/global.jspf" %>
            
            <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest"
                msgBundleBinding="ResourceBundle"  titleTextKey="titleText" mainTextKey="mainText"/>

            <uix:tableLayout cellSpacing="5">
       	      <uix:rowLayout>
                <uix:cellFormat hAlign="right">
            	  <uix:messagePrompt promptBinding="TS_SID@ResourceBundle@servletRequest" />
          	</uix:cellFormat>
          	<uix:cellFormat hAlign="left">
            	  <uix:styledText styleClass="OraDataText" textBinding="sid@servletRequest"/>
          	</uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:messagePrompt promptBinding="SERIAL@ResourceBundle@servletRequest" />
                </uix:cellFormat>
                <uix:cellFormat hAlign="left">
                  <uix:styledText styleClass="OraDataText" textBinding="selectedSerial@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">                      
                  <uix:messagePrompt promptBinding="TRACE_WITH_WAIT@TopConsumersMsgBundle@servletRequest" />               
                </uix:cellFormat>                    
                <uix:cellFormat hAlign="left">                      
                  <uix:radioButton textBinding="YES@uixDBObjectBundle@servletRequest"                         
                            name="waits"                                                             
                            value="TRUE"
			    selectedValue="TRUE"/>                    
                  <uix:radioButton textBinding="NO@uixDBObjectBundle@servletRequest"                         
                            name="waits"                                                             
                            value="FALSE" />                    
                </uix:cellFormat>                  
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:messagePrompt promptBinding="TRACE_WITH_BIND@TopConsumersMsgBundle@servletRequest" />
                </uix:cellFormat>
                <uix:cellFormat hAlign="left">                     
                  <uix:radioButton textBinding="YES@uixDBObjectBundle@servletRequest"
                            name="binds"
                            value="TRUE"/>
                  <uix:radioButton textBinding="NO@uixDBObjectBundle@servletRequest"
                            name="binds"
                            value="FALSE"
			    selectedValue="FALSE" />
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
          
            <uix:pageButtons>            
              <uix:pageButtonBar>              
                <uix:button textBinding="CANCEL@uixDBObjectBundle@servletRequest"      
                        destinationBinding="cancelURL@servletRequest"/>
                <uix:submitButton textBinding="OK@uixDBObjectBundle@servletRequest"                      
                    name="event" value="doEnableSQLTrace"/>             
              </uix:pageButtonBar>          
            </uix:pageButtons>        
          </uix:pageLayout>        
        </uix:form>                  
    </uix:body>  
  </uix:document>
</uix:renderingContext> 
