<%@ include file="/sdk/oemTop.jspf" %>

<!-- ================  Session Details General Page =================== -->

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <uix:form name="genForm" destinationBinding="defaultDest@servletRequest">
    	<uix:formValue name="target" valueBinding="targetName@sessionDetailsBean@servletRequest"/>
    	<uix:formValue name="type" valueBinding="targetType@sessionDetailsBean@servletRequest"/>
    	<uix:formValue name="SID" valueBinding="SID@sessionDetailsBean@servletRequest"/>
	<uix:formValue name="serialNum" valueBinding="sessSerial@sessionDetailsBean@servletRequest"/>
    	<uix:formValue name="pageNum" value="1"/>

        <uix:switcher childNameBinding="hasResult@sessionDetailsBean@servletRequest">
          <uix:case name="true">

        <uix:pageLayout>
    	  <uix:switcher childNameBinding="refreshChoice@servletRequest">
            <uix:case name="RT_15">
              <uix:rawText>
          	<meta http-equiv="Refresh" content="15" >
              </uix:rawText>
            </uix:case>
          </uix:switcher>

      	  <%@ include file="/database/global.jspf" %>

          <oem:messageBox messageType="info" errorTableBinding="info@servletRequest"
              msgBundleBinding="ResourceBundle"
              titleTextKey="titleText" mainTextKey="mainText"/>
      	  <oem:messageBox messageType="error"
	      errorTableBinding="errors@servletRequest"
              titleTextKey="titleText" mainTextKey="mainText"/>

      	  <uix:header textBinding="header@sessionDetailsBean@servletRequest">

	    <uix:flowLayout>
	      <uix:tableLayout width="100%">
		<uix:rowLayout>

		  <uix:cellFormat hAlign="left" >
		    <uix:rowLayout>
		      <uix:styledText styleClass="OraTipText" 
				      textBinding="COLL_FROM_TARGET@SDKBundle@servletRequest"/>
		      <uix:spacer width="5" />  
		      <uix:styledText styleClass="OraTipLabel" 
				      textBinding="refreshTime@servletRequest"/>
		      <uix:spacer width="10" />
		    </uix:rowLayout>
		  </uix:cellFormat>

		  <uix:cellFormat hAlign="right" > 
		    <uix:flowLayout>

		      <uix:styledText styleClass="OraFieldText" 
				      textBinding="VIEW_DATA@DBMsgBundle@servletRequest" 
				      labeledNodeId="view_choice" />
		      <uix:choice name="refreshChoice" id="view_choice"
				  onChange="submitForm('genForm', true, {'event':'changeRefreshChoice'})"
				  selectedValueBinding="refreshChoiceSelected@servletRequest">
			<uix:option textBinding="REAL_TIME_AUTO_15_SEC@DBMsgBundle@servletRequest"
				    value="RT_15"/>
			<uix:option textBinding="REAL_TIME_MANUAL@DBMsgBundle@servletRequest"
				    value="RT_MAN"/>
			<uix:option textBinding="HISTORICAL@DBMsgBundle@servletRequest"
				    value="HIST_CUST" />       
		      </uix:choice>  


		      <uix:button textBinding="REFRESH@SDKBundle@servletRequest"
				  destinationBinding="refreshDest@servletRequest" />

		    </uix:flowLayout>
		  </uix:cellFormat>


		</uix:rowLayout>

	      </uix:tableLayout>
	    </uix:flowLayout>
	    <uix:tableLayout width="100%">	  
	    
	    
	    <uix:rowLayout>
	      <uix:spacer height="5"/>
	    </uix:rowLayout>

	    <uix:rowLayout hAlign="right">
	      <uix:include node="/database/instance/session/button.jsp"/>
	    </uix:rowLayout>

            <uix:rowLayout>
              <uix:spacer height="5"/>
            </uix:rowLayout>

	  </uix:tableLayout>
      	    <uix:subTabLayout>
              <uix:subTabs>
		<uix:switcher childNameBinding="showActivity@sessionDetailsBean@servletRequest">
		  <uix:case name="true">
          	    <uix:subTabBar selectedIndex="0">
		    <%@ include file="tab10g.jspf" %>
          	    </uix:subTabBar>
		  </uix:case>
                  <uix:case name="false">
                    <uix:subTabBar selectedIndex="0">
                    <%@ include file="tabPre10g.jspf" %>
                    </uix:subTabBar>
                  </uix:case>
		</uix:switcher>
              </uix:subTabs>

              <uix:tableLayout width="100%">
          	<uix:rowLayout>
            	  <uix:cellFormat vAlign="top" width="33%">
		    <uix:include node="/database/instance/session/server.jsp"/>
		  </uix:cellFormat>
		  <uix:cellFormat vAlign="top" width="33%">
                    <uix:include node="/database/instance/session/client.jsp"/>
                  </uix:cellFormat>
                  <uix:cellFormat vAlign="top" width="33%">
                    <uix:include node="/database/instance/session/application.jsp"/>
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout vAlign="top">
		  <uix:cellFormat renderedBinding="version10iOrHigher@sessionDetailsBean@servletRequest" width="33%">
                    <uix:include node="/database/instance/session/contention.jsp"/>
                  </uix:cellFormat>
                  <uix:cellFormat renderedBinding="version10iOrHigher@sessionDetailsBean@servletRequest" width="33%">
                    <uix:include node="/database/instance/session/wait.jsp"/>
                  </uix:cellFormat>
                  <uix:cellFormat width="33%">
                    <uix:include node="/database/instance/session/advanced.jsp"/>
                  </uix:cellFormat>
                </uix:rowLayout>
		<uix:rowLayout renderedBinding="resumableInfo@sessionDetailsBean@servletRequest">
                  <uix:cellFormat width="33%">
                    <uix:include node="/database/instance/session/resumable.jsp"/>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>
      	    </uix:subTabLayout>
      	  </uix:header>

      	  <uix:contentFooter>
	    <uix:include node="/database/instance/session/button.jsp"/>
          </uix:contentFooter>

        </uix:pageLayout>

          </uix:case>
          <uix:case name="false">
            <uix:pageLayout>
              <%@ include file="/database/global.jspf" %>

              <uix:header textBinding="header@sessionDetailsBean@servletRequest">
                <uix:tableLayout width="100%">
                  <%@ include file="refreshTime.jspf" %>
                </uix:tableLayout>
                <uix:styledText textBinding="SESSION_EXPIRED@ResourceBundle@servletRequest" styleClass="OraInstructionText"/>
	      </uix:header>
            </uix:pageLayout>
          </uix:case>
        </uix:switcher>

      </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

