<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<script>

function clickedNode(nodeId, targetName, targetType) {

  document.location = 'hangDrilldown?event=doLoad&target='+ targetName + '&type=oracle_database&clickid=' + nodeId;
  return false;	
}

</script>


<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/>

     <uix:bundle name="dbMsg"
         class="oracle.sysman.db.rsc.inst.DBMsg"/>

    <uix:document>

        <uix:metaContainer>
        <uix:head titleBinding="_emSDK_PageTitle@servletRequest">
        <uix:switcher childNameBinding="manualSelected@servletRequest">
           <uix:case name="false">
            <uix:rawText>
              <meta http-equiv="Refresh" content="<%=request.getAttribute("refreshChoiceValue") %>">
            </uix:rawText> 
          </uix:case> 
        </uix:switcher>
        </uix:head>
        </uix:metaContainer>             


        <uix:body>
            <uix:pageLayout>
                <%@ include file="/database/global.jspf" %>                  

                <uix:form name="foo" method="get" destinationBinding="destURI@servletRequest">
                    <uix:formValue name="target"
                        valueBinding="targetName@hangAnalyzeBean@servletRequest"/>
	            <uix:formValue name="type"
                        valueBinding="targetType@hangAnalyzeBean@servletRequest"/>
		    <uix:formValue name="event"/>

                    <uix:contents>
		      <oem:messageBox messageType="info" errorTableBinding="info@servletRequest"
                             msgBundleBinding="ResourceBundle"
                             titleTextKey="titleText" mainTextKey="mainText"/>
		      <oem:messageBox messageType="error"
		         errorTableBinding="errors@servletRequest"
		         titleTextKey="titleText" mainTextKey="mainText"/>

	<uix:tableLayout width="100%">
          <uix:rowLayout hAlign="right">

	     <uix:cellFormat hAlign="right">
                <uix:rowLayout>
                  <uix:styledText styleClass="OraFieldText" 
                    textBinding="VIEW_DATA@DBMsgBundle@servletRequest" 
                    labeledNodeId="ViewLabel" />

                  <uix:choice name="refreshChoice" id="ViewLabel"
                      onChange="submitForm('foo', true, {'event':'doLoad'})"
                       selectedValueBinding="refreshChoiceSelected@servletRequest">
                    <uix:option textBinding="REAL_TIME_AUTO_15_SEC@DBMsgBundle@servletRequest"
                      value="RT_15"/>
                    <uix:option textBinding="REAL_TIME_1_MIN@DBMsgBundle@servletRequest"
                      value="RT_60"/> 
                    <uix:option textBinding="REAL_TIME_MANUAL@DBMsgBundle@servletRequest"
                      value="RT_MAN"/>
                   </uix:choice>          
              </uix:rowLayout>
            </uix:cellFormat>

           </uix:rowLayout>
         </uix:tableLayout>

        <uix:flowLayout renderedBinding="renderAnalysisArea@hangAnalyzeBean@servletRequest" >
          <uix:flowLayout >
                <uix:contents childDataBinding="analysisAreaList@hangAnalyzeBean@servletRequest">
                  <uix:radioButton name="analysisArea"
                     textBinding="text"
                     valueBinding="val"
                     onClickBinding="onclick"
                     selectedBinding="selected"/>
                </uix:contents>

               </uix:flowLayout>
          </uix:flowLayout>



                        <uix:header textBinding="header@hangAnalyzeBean@servletRequest" >

			<uix:tableLayout width="100%">
			<uix:rowLayout hAlign="right">
			 <uix:cellFormat width="70%" hAlign="left">
                         <uix:styledText styleClass="OraPromptText" textBinding="introductionText@hangAnalyzeBean@servletRequest" />
                         </uix:cellFormat>

                                    <uix:cellFormat>
                                        <uix:rowLayout>
                                            <uix:styledText styleClass="OraTipText"
                                                textBinding="PAGE_REFRESHED@DBMsgBundle@servletRequest"/>
                                            <uix:spacer width="5" />
                                            <uix:styledText styleClass="OraTipLabel"
                                                textBinding="retrievalTime@hangAnalyzeBean@servletRequest"/>
                                            <uix:image sourceBinding="refreshImage@servletRequest"
                                                destinationBinding="refreshDest@servletRequest" />
                                        </uix:rowLayout>
                                    </uix:cellFormat>
                                     
            </uix:rowLayout>  
           </uix:tableLayout>

			<%--
			 *
			 *   This is where new additions starts
			 * 
			--%>

			<jsp:useBean
			    id="hangAnalyzeBean"
			    scope="request"
			    type="oracle.sysman.emo.perf.bean.sesn.HangAnalyze"/>

<%--		         <uix:header text="Summary"> --%>
 
 			 <uix:tableLayout width="100%" cellSpacing="0">

			 <uix:rowLayout>

			 <uix:cellFormat>
                         <uix:styledText styleClass="OraPromptText" textBinding="sessionLegendText@hangAnalyzeBean@servletRequest" />
                         </uix:cellFormat>
	      		 <uix:cellFormat hAlign="right">
		         <uix:messagePrompt labeledNodeId="zoomFactor" promptBinding="HANG_ANALYZE_ZOOM_FACTOR@dbMsg"/>
		         <uix:choice name="zoomFactor" 
			  id="zoomFactor"
		       	  selectedValueBinding="zoomFactor@hangAnalyzeBean@servletRequest"
   	                  onChange="submitForm('foo', true, {'event':'zoom'})">
		         <uix:contents>
			       <uix:option value="40" textBinding="HANG_ANALYZE_40@dbMsg"/>
			       <uix:option value="60" textBinding="HANG_ANALYZE_60@dbMsg"/>
			       <uix:option value="80" textBinding="HANG_ANALYZE_80@dbMsg"/>
			       <uix:option value="100" textBinding="HANG_ANALYZE_100@dbMsg"/>
			       <uix:option value="120" textBinding="HANG_ANALYZE_120@dbMsg"/>
			       <uix:option value="140" textBinding="HANG_ANALYZE_140@dbMsg"/>
			       <uix:option value="160" textBinding="HANG_ANALYZE_160@dbMsg"/>
		         </uix:contents>
 		         </uix:choice>
			 </uix:cellFormat>			

			 </uix:rowLayout>
	
			 <uix:rowLayout>

  	      		 <uix:cellFormat hAlign="center">
			 <uix:labeledFieldLayout columns="2">

			    <uix:styledText styleClass="OraPromptText"
		                    textBinding="HANG_ANALYZE_TOTAL_SESSIONS@dbMsg"/>
			    <uix:styledText styleClass="OraDataText"
		                    textBinding="totalSessions@hangAnalyzeBean@servletRequest"/>

			    <uix:styledText styleClass="OraPromptText" 
                                    textBinding="HANG_ANALYZE_BLOCKED_SESSIONS@dbMsg"/>
			    <uix:styledText styleClass="OraDataText" 
		                    textBinding="blocked@hangAnalyzeBean@servletRequest"/>

			    <uix:styledText styleClass="OraPromptText" 
                                    textBinding="HANG_ANALYZE_WAITING_SESSIONS@dbMsg"/>
			    <uix:styledText styleClass="OraDataText" 
		                    textBinding="totalWaitingSessions@hangAnalyzeBean@servletRequest"/>

			    <uix:styledText styleClass="OraPromptText" 
                                    textBinding="HANG_ANALYZE_ROOT_BLOCKERS@dbMsg"/>
			    <uix:styledText styleClass="OraDataText" 
		                    textBinding="blockers@hangAnalyzeBean@servletRequest"/>

		        </uix:labeledFieldLayout>
			</uix:cellFormat>

			<uix:cellFormat hAlign="right">
                        <uix:rawText textBinding="navigationGraphURL@hangAnalyzeBean@servletRequest"/>
                        <uix:rawText textBinding="navigationImageMapCode@hangAnalyzeBean@servletRequest"/>
			</uix:cellFormat>

			</uix:rowLayout>

			</uix:tableLayout>

<%--		        </uix:header> --%>

<%--                    <uix:header text="Hang Trees">  --%>
	
		        <uix:tableLayout hAlign="center" cellSpacing="8">

                        <uix:rowLayout hAlign="center"><uix:cellFormat>
                         <uix:styledText styleClass="OraDataText"
                           textBinding="emptyString@hangAnalyzeBean@servletRequest"/>
                        </uix:cellFormat></uix:rowLayout>

		        <uix:rowLayout hAlign="center">
		        <uix:cellFormat>
                        <uix:rawText textBinding="topologyGraphURL@hangAnalyzeBean@servletRequest"/>
                        <uix:rawText textBinding="topologyImageMapCode@hangAnalyzeBean@servletRequest"/>
		        </uix:cellFormat>
  		        </uix:rowLayout>

			</uix:tableLayout>


<%--			</uix:header> --%>

			<%--
			 *
			 *   This is where new additions ends
			 * 
			--%>

			


                        </uix:header>

                      <uix:spacer height="15" />

                      <%@ include file="/database/instance/monitoringLinks.jspf" %>

                    </uix:contents>
                </uix:form>

              <%-- add related links conditionally --%>
              <uix:tableLayout renderedBinding="showRelatedLinks@servletRequest">
                <oem:relatedLinks/>
              </uix:tableLayout>
            </uix:pageLayout>
        </uix:body>
    </uix:document>
</uix:renderingContext>
