<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<script>
function disableCredentials(disabled)
{
  document.hangAnalyzeCredentialsForm.sysdbaUserName.disabled = disabled;
  document.hangAnalyzeCredentialsForm.sysdbaPassword.disabled = disabled;
}
</script>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="metadataMsgs" class="oracle.sysman.db.rsc.oracle_databaseMsg"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="_emSDK_PageTitle@servletRequest"/>
    </uix:metaContainer>

    <uix:body onLoad="document.forms[0].setAttribute('autocomplete','OFF');">

      <db:form name="hangAnalyzeCredentialsForm"
               destinationBinding="destinationURL@servletRequest"
               method="post"
               copyParams="target,type">

        <uix:pageLayout titleBinding="HANG_ANALYZE_HEADER@DBMsgBundle@servletRequest">

          <%@ include file="/database/global.jspf" %>

          <oem:messageBox messageTypeBinding="messageType@servletRequest"
                          errorTableBinding="msgBox@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>

          <uix:header textBinding="CREDS_DATABASE_DBCREDS_SYSDBA@metadataMsgs">
            <uix:stackLayout>
              <uix:spacer width="1" height="5"/>
              <uix:styledText textBinding="SYSDBA_ACCESS_REQUIRED@DBMsgBundle@servletRequest"
                              styleClass="OraPromptText"/>
              <uix:spacer width="1" height="10"/>
              <uix:radioButton textBinding="CHOOSE_SYSDBA_CREDENTIALS@DBMsgBundle@servletRequest"
                               name="explicit"
                               value="true"
                               selected="true"
                               onClick="disableCredentials(false)"/>

              <uix:spacer width="1" height="5"/>
              <uix:labeledFieldLayout labelWidth="10%">
                <uix:messagePrompt required="yes"
                                   labeledNodeId="sysdbaUserName"
                                   promptBinding="LOGON_USERNAME@DBMsgBundle@servletRequest"/>
                <uix:textInput name="sysdbaUserName"
                               id="sysdbaUserName" noAutoComplete="true"
                               textBinding="sysdbaUserName@servletRequest"
                               columns="30"/>
                <uix:messagePrompt required="yes"
                                   labeledNodeId="sysdbaPassword"
                                   promptBinding="LOGON_PASSWORD@DBMsgBundle@servletRequest"/>
                <uix:textInput name="sysdbaPassword"
                               secret="true"
                               noAutoComplete="true"
                               id="sysdbaPassword"
                               textBinding="sysdbaPassword@servletRequest"
                               columns="30"/>
              </uix:labeledFieldLayout>
              <uix:spacer width="1" height="5"/>

              <uix:radioButton textBinding="CHOOSE_OS_AUTHENTICATION@DBMsgBundle@servletRequest"
                               name="explicit"
                               value="false"
                               onClick="disableCredentials(true)"/>
              <uix:spacer width="1" height="10"/>
            </uix:stackLayout>
          </uix:header>

          <uix:pageButtons>
            <uix:pageButtonBar>

              <uix:button textBinding="CANCEL@DBMsgBundle@servletRequest"
                          destinationBinding="cancelDestination@servletRequest"/>
              <uix:submitButton textBinding="CONTINUE@DBMsgBundle@servletRequest"
                                formName="hangAnalyzeCredentialsForm"
                                name="event"
                                value="sysdbaLogin"/>

            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>

      </db:form>

    </uix:body>

  </uix:document>
</uix:renderingContext>

