<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>


<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/>

     <uix:bundle name="dbMsg"
         class="oracle.sysman.db.rsc.inst.DBMsg"/>

    <uix:document>
        <%@ include file="/oemTitle.jspf" %>

        <uix:body>
            <uix:pageLayout>
                <%@ include file="/database/global.jspf" %> 

                <uix:form name="foo" method="get" destinationBinding="destURI@servletRequest">
                    <uix:formValue name="target"
                        valueBinding="targetName@hangDrilldownBean@servletRequest"/>
	            <uix:formValue name="type"
                        valueBinding="targetType@hangDrilldownBean@servletRequest"/>
		    <uix:formValue name="event"/>

                    <uix:contents>
		      <oem:messageBox messageType="info" errorTableBinding="info@servletRequest"
                             msgBundleBinding="ResourceBundle"
                             titleTextKey="titleText" mainTextKey="mainText"/>
		      <oem:messageBox messageType="error"
		         errorTableBinding="errors@servletRequest"
		         titleTextKey="titleText" mainTextKey="mainText"/>


                        <uix:header textBinding="header@hangDrilldownBean@servletRequest" >

			<jsp:useBean
			    id="hangDrilldownBean"
			    scope="request"
			    type="oracle.sysman.emo.perf.bean.sesn.HangDrilldownBean"/>

			 <uix:labeledFieldLayout columns="2">

			    <uix:styledText styleClass="OraPromptText"
		                    textBinding="HANG_DRILL1@dbMsg"/>
			    <uix:styledText styleClass="OraDataText"
                                    textBinding="sidOnInstNum@hangDrilldownBean@servletRequest"/>

			    <uix:styledText styleClass="OraPromptText" 
                                    textBinding="HANG_DRILL2@dbMsg"/>
			    <uix:styledText styleClass="OraDataText" 
		                    textBinding="session@hangDrilldownBean@servletRequest"/>

			    <uix:styledText styleClass="OraPromptText" 
                                    textBinding="HANG_DRILL3@dbMsg"/>
			    <uix:styledText styleClass="OraDataText" 
                                    textBinding="blockerSidOnInstNum@hangDrilldownBean@servletRequest"/>

			    <uix:styledText styleClass="OraPromptText" 
                                    textBinding="HANG_DRILL4@dbMsg"/>
			    <uix:styledText styleClass="OraDataText" 
		                    textBinding="serialNo@hangDrilldownBean@servletRequest"/>

			    <uix:styledText styleClass="OraPromptText" 
                                    textBinding="HANG_DRILL5@dbMsg"/>
			    <uix:styledText styleClass="OraDataText" 
		                    textBinding="sqlAddress@hangDrilldownBean@servletRequest"/>

			    <uix:styledText styleClass="OraPromptText" 
                                    textBinding="HANG_DRILL6@dbMsg"/>
			    <uix:styledText styleClass="OraDataText" 
		                    textBinding="sqlHash@hangDrilldownBean@servletRequest"/>

			    <uix:styledText styleClass="OraPromptText" 
                                    textBinding="HANG_DRILL7@dbMsg"/>
			    <uix:styledText styleClass="OraDataText" 
		                    textBinding="fileNum@hangDrilldownBean@servletRequest"/>

			    <uix:styledText styleClass="OraPromptText" 
                                    textBinding="HANG_DRILL8@dbMsg"/>
			    <uix:styledText styleClass="OraDataText" 
		                    textBinding="eventName@hangDrilldownBean@servletRequest"/>

			    <uix:styledText styleClass="OraPromptText" 
                                    textBinding="HANG_DRILL9@dbMsg"/>
			    <uix:styledText styleClass="OraDataText" 
		                    textBinding="userID@hangDrilldownBean@servletRequest"/>

			    <uix:styledText styleClass="OraPromptText" 
                                    textBinding="HANG_DRILL10@dbMsg"/>
			    <uix:styledText styleClass="OraDataText" 
		                    textBinding="program@hangDrilldownBean@servletRequest"/>

                            <uix:styledText styleClass="OraPromptText"
                                    textBinding="HANG_DRILL11@dbMsg"/>
                            <uix:styledText styleClass="OraDataText"
                                    textBinding="pid@hangDrilldownBean@servletRequest"/>

		        </uix:labeledFieldLayout>
     
                        <uix:rowLayout hAlign="center" renderedBinding="renderSessPageLink@hangDrilldownBean@servletRequest">
                        <uix:link styleClass="OraPromptText"
                                  textBinding="HANG_DRILL12@DBMsgBundle@servletRequest"
                                  destinationBinding="sessPageLink@servletRequest" />
			</uix:rowLayout>


                        </uix:header>

                    </uix:contents>
                </uix:form>
            </uix:pageLayout>
        </uix:body>
    </uix:document>
</uix:renderingContext>
