<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="_emSDK_PageTitle@servletRequest">
        <uix:rawText>
          <meta http-equiv="Cache-Control" content="max-age=0">
        </uix:rawText> 
      </uix:head>
    </uix:metaContainer>

    <uix:body>

      <db:form name="emergencyTracesForm"
               copyParams="target,type">

        <uix:pageLayout titleBinding="LASTWILLOPS_TITLE@DBMsgBundle@servletRequest">

          <%@ include file="/database/global.jspf" %>

          <oem:messageBox messageType="error" 
                          errorTableBinding="errors@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="info" 
                          errorTableBinding="info@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>

          <uix:tableLayout width="80%" cellSpacing="5">
           <uix:rowLayout>
            <uix:styledText textBinding="LASTWILLOPS_DESC@DBMsgBundle@servletRequest"
                            styleClass="OraPromptText"/>
           </uix:rowLayout>
           <uix:rowLayout>
            <uix:styledText textBinding="LASTWILLOPS_INSTR_GETTRACES@DBMsgBundle@servletRequest"
                            styleClass="OraPromptText"/>
           </uix:rowLayout>
           <uix:rowLayout hAlign="right">
            <uix:submitButton textBinding="LASTWILLOPS_ACTION_GETTRACES@DBMsgBundle@servletRequest"
                              formName="emergencyTracesForm"
                              name="event"
                              value="generateTraces"/>
           </uix:rowLayout>
           <uix:separator/>
          </uix:tableLayout>
           
            <uix:switcher childNameBinding="hasEmergencyTraces@lastWillOpsBean@servletRequest">
              <uix:case name="true">
                <uix:stackLayout>
                  <uix:styledText textBinding="LASTWILLOPS_LOCATION_GETTRACES@DBMsgBundle@servletRequest"
                                  styleClass="OraPromptText"/>
                  <uix:spacer width="1" height="5"/>
                  <uix:styledList listStyle="none">
                   <uix:contents childDataBinding="emergencyTraces@lastWillOpsBean@servletRequest">
                    <uix:styledItem>
                     <uix:contents>
                      <uix:styledText textBinding="traceFile"
                                      styleClass="OraDataText"/>
                     </uix:contents>
                    </uix:styledItem>
                   </uix:contents>
                  </uix:styledList>
                </uix:stackLayout>
              </uix:case>
              <uix:default>
                <uix:tip>
                  <uix:styledText textBinding="LASTWILLOPS_TIP@DBMsgBundle@servletRequest"/>
                </uix:tip>
              </uix:default>
            </uix:switcher>

        </uix:pageLayout>

      </db:form>

    </uix:body>

  </uix:document>
</uix:renderingContext>

