<%@ include file="/sdk/oemTop.jspf" %>
<!-- ================  Database Top Session Open Cursor Page =================== -->

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <uix:form name="openCurForm" destinationBinding="defaultDest@servletRequest">
        <uix:formValue name="target" valueBinding="targetName@sessionDetailsBean@servletRequest"/>
        <uix:formValue name="type" valueBinding="targetType@sessionDetailsBean@servletRequest"/>
        <uix:formValue name="SID" valueBinding="SID@sessionDetailsBean@servletRequest"/>
        <uix:formValue name="pageNum" value="4"/>

        <uix:pageLayout>
      	  <%@ include file="/database/global.jspf" %>

          <oem:messageBox messageType="info" errorTableBinding="info@servletRequest"
                msgBundleBinding="ResourceBundle"
                titleTextKey="titleText" mainTextKey="mainText"/>
      	  <oem:messageBox messageType="error"
         	errorTableBinding="errors@servletRequest"
         	titleTextKey="titleText" mainTextKey="mainText"/>

          <uix:switcher childNameBinding="refreshChoice@servletRequest">
            <uix:case name="RT_15">
              <uix:rawText>
                <meta http-equiv="Refresh" content="15" >
              </uix:rawText>
            </uix:case>
          </uix:switcher>

          <uix:header textBinding="header@sessionDetailsBean@servletRequest"/>
	    
	    <uix:flowLayout>
	      <uix:tableLayout width="100%">
		<uix:rowLayout>

		  <uix:cellFormat hAlign="left" >
		    <uix:rowLayout>
		      <uix:styledText styleClass="OraTipText" 
				      textBinding="COLL_FROM_TARGET@SDKBundle@servletRequest"/>
		      <uix:spacer width="5" />  
		      <uix:styledText styleClass="OraTipLabel" 
				      textBinding="refreshTime@servletRequest"/>
		      <uix:spacer width="10" />
		    </uix:rowLayout>
		  </uix:cellFormat>

		  <uix:cellFormat hAlign="right" > 
		    <uix:flowLayout>

		      <uix:styledText styleClass="OraFieldText" 
				      textBinding="VIEW_DATA@DBMsgBundle@servletRequest" 
				      labeledNodeId="view_choice" />
		      <uix:choice name="refreshChoice" id="view_choice"
				  onChange="submitForm('openCurForm', true, {'event':'changeRefreshChoice'})"
				  selectedValueBinding="refreshChoiceSelected@servletRequest">
			<uix:option textBinding="REAL_TIME_AUTO_15_SEC@DBMsgBundle@servletRequest"
				    value="RT_15"/>
			<uix:option textBinding="REAL_TIME_MANUAL@DBMsgBundle@servletRequest"
				    value="RT_MAN"/>
			<uix:option textBinding="HISTORICAL@DBMsgBundle@servletRequest"
				    value="HIST_CUST" />       
		      </uix:choice>  


		      <uix:button textBinding="REFRESH@SDKBundle@servletRequest"
				  destinationBinding="refreshDest@servletRequest" />

		    </uix:flowLayout>
		  </uix:cellFormat>


		</uix:rowLayout>

	      </uix:tableLayout>
	    </uix:flowLayout>
	    <uix:tableLayout width="100%">	  
	    

            <uix:rowLayout>
              <uix:spacer height="5"/>
            </uix:rowLayout>

	    <uix:rowLayout hAlign="right">
	      <uix:include node="/database/instance/session/button.jsp"/>
	    </uix:rowLayout>

            <uix:rowLayout>
              <uix:spacer height="5"/>
            </uix:rowLayout>

	  </uix:tableLayout> 

      	    <uix:subTabLayout>
              <uix:subTabs>
                <uix:switcher childNameBinding="showActivity@sessionDetailsBean@servletRequest">
                  <uix:case name="true">
                    <uix:subTabBar selectedIndex="3">
                    <%@ include file="tab10g.jspf" %>
                    </uix:subTabBar>
                  </uix:case>
                  <uix:case name="false">
                    <uix:subTabBar selectedIndex="2">
                    <%@ include file="tabPre10g.jspf" %>
                    </uix:subTabBar>
                  </uix:case>
                </uix:switcher>
              </uix:subTabs>

      	      <uix:switcher childNameBinding="openCursorNode@sessionDetailsBean@servletRequest">
        	<uix:case name="okNode">
            	  <uix:tableLayout width="100%">
              	    <uix:rowLayout>
                      <oem:table name="openCursorTable" width="100%"
			    summaryBinding="OPEN_CURSORS@ResourceBundle@servletRequest"
                            formSubmitted="true"
                            destinationBinding="defaultDest@servletRequest"
                            beanKey="sessionDetailsBean"
                            dataSourceProp="openCursorDataSource"
                            alternateTextBinding="NO_OPEN_CURSOR@ResourceBundle@servletRequest"
                            blockSize="25" partialRenderMode="self">
                      </oem:table>
                    </uix:rowLayout>
            	  </uix:tableLayout>
        	</uix:case>
        	<!-- Empty result message -->
        	<uix:case name="emptyNode">
          	  <!-- <html:em> -->
          	  <uix:styledText textBinding="NO_OPEN_CURSOR@ResourceBundle@servletRequest"/>
          	  <!-- </html:em> -->
        	</uix:case>
        	<!-- Error message -->
        	<!--
          	<uix:case name="errNode">
          	  <include baja:node="errMessage" />
          	</uix:case>
        	-->
              </uix:switcher>
      	    </uix:subTabLayout>
      	  

          <uix:contentFooter>
            <uix:include node="/database/instance/session/button.jsp"/>
          </uix:contentFooter>

    	</uix:pageLayout>
      </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

