<%-- ================   Session Details Parallel SQL page  =================

   MODIFIED    (MM/DD/YY)
      ychan     09/28/07 - 
      yfeng     12/08/06 - Fix ADA issues
--%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <uix:form name="custForm" destinationBinding="defaultDest@servletRequest">
        <uix:formValue name="target" valueBinding="targetName@sessionDetailsBean@servletRequest"/>
        <uix:formValue name="type" valueBinding="targetType@sessionDetailsBean@servletRequest"/>
        <uix:formValue name="SID" valueBinding="SID@sessionDetailsBean@servletRequest"/>
        <uix:formValue name="pageNum" value="7"/>

    	<uix:pageLayout>
      	  <%@ include file="/database/global.jspf" %>

          <oem:messageBox messageType="info" errorTableBinding="info@servletRequest"
                msgBundleBinding="ResourceBundle"
                titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error"
         	errorTableBinding="errors@servletRequest"
         	titleTextKey="titleText" mainTextKey="mainText"/>

    	  <uix:switcher childNameBinding="refreshChoice@servletRequest">
      	    <uix:case name="RT_15">
              <uix:rawText>
          	<meta http-equiv="Refresh" content="15" >
              </uix:rawText>
      	    </uix:case>
    	  </uix:switcher>

          <uix:header textBinding="header@sessionDetailsBean@servletRequest">
 	    	    <uix:flowLayout>
		      <uix:tableLayout width="100%">
			<uix:rowLayout>

			  <uix:cellFormat hAlign="left" >
			    <uix:rowLayout>
			      <uix:styledText styleClass="OraTipText" 
					      textBinding="COLL_FROM_TARGET@SDKBundle@servletRequest"/>
			      <uix:spacer width="5" />  
			      <uix:styledText styleClass="OraTipLabel" 
					      textBinding="refreshTime@servletRequest"/>
			      <uix:spacer width="10" />
			    </uix:rowLayout>
			  </uix:cellFormat>

			  <uix:cellFormat hAlign="right" > 
			    <uix:flowLayout>

			      <uix:styledText styleClass="OraFieldText" 
					      textBinding="VIEW_DATA@DBMsgBundle@servletRequest" 
					      labeledNodeId="view_choice" />
			      <uix:choice name="refreshChoice" id="view_choice"
					  onChange="submitForm('custForm', true, {'event':'changeRefreshChoice'})"
					  selectedValueBinding="refreshChoiceSelected@servletRequest">
				<uix:option textBinding="REAL_TIME_AUTO_15_SEC@DBMsgBundle@servletRequest"
					    value="RT_15"/>
				<uix:option textBinding="REAL_TIME_MANUAL@DBMsgBundle@servletRequest"
					    value="RT_MAN"/>
				<uix:option textBinding="HISTORICAL@DBMsgBundle@servletRequest"
					    value="HIST_CUST" />       
			      </uix:choice>  


			      <uix:button textBinding="REFRESH@SDKBundle@servletRequest"
					  destinationBinding="refreshDest@servletRequest" />

			    </uix:flowLayout>
			  </uix:cellFormat>


			</uix:rowLayout>

		      </uix:tableLayout>
		    </uix:flowLayout>
	    <uix:tableLayout width="100%">	  
	    

            <uix:rowLayout>
              <uix:spacer height="5"/>
            </uix:rowLayout>

	    <uix:rowLayout hAlign="right">
	      <uix:include node="/database/instance/session/button.jsp"/>
	    </uix:rowLayout>

            <uix:rowLayout>
              <uix:spacer height="5"/>
            </uix:rowLayout>

	  </uix:tableLayout> 

      	    <uix:subTabLayout>
              <uix:subTabs>
                <uix:switcher childNameBinding="showActivity@sessionDetailsBean@servletRequest">
                  <uix:case name="true">
                    <uix:subTabBar selectedIndex="6">
                    <%@ include file="tab10g.jspf" %>
                    </uix:subTabBar>
                  </uix:case>
                  <uix:case name="false">
                    <uix:subTabBar selectedIndex="5">
                    <%@ include file="tabPre10g.jspf" %>
                    </uix:subTabBar>
                  </uix:case>
                </uix:switcher>
              </uix:subTabs>


          <uix:switcher childNameBinding="node@parallelSql@sessionDetailsBean@servletRequest">
            <uix:case name="emptyNode">
    <uix:stackLayout>
        <uix:spacer height="5"/>
          <uix:styledText textBinding="NO_DATA_AVAILABLE@ResourceBundle@servletRequest"  
                          styleClass="OraInstructionText"/>
    </uix:stackLayout>
            </uix:case>
            <uix:case name="okNode">
              <uix:stackLayout>  
  <uix:header textBinding="QUERY_COORDINATOR@ResourceBundle@servletRequest">
    <uix:stackLayout>
                  
      <uix:labeledFieldLayout columns="2">
        <uix:contents>
          <uix:messagePrompt promptBinding="LOCK_SID@ResourceBundle@servletRequest" />
          <uix:link textBinding="qcSessionId@parallelSql@sessionDetailsBean@servletRequest"
                  destinationBinding="qcUrl@parallelSql@sessionDetailsBean@servletRequest"
                  disabledBinding="isQcSession@parallelSql@sessionDetailsBean@servletRequest"/>

        <uix:messagePrompt promptBinding="DFO_TREE_PARALLELIZED@ResourceBundle@servletRequest" />
        <uix:styledText styleClass="OraDataText" 
                        textBinding="qcDfoTreeParallized@parallelSql@sessionDetailsBean@servletRequest"/>

        <uix:messagePrompt promptBinding="PX_LOCAL_MES_SNT@ResourceBundle@servletRequest" />
        <uix:styledText styleClass="OraDataText" 
                        textBinding="qcPXLocalMsgSnt@parallelSql@sessionDetailsBean@servletRequest"/>

        <uix:messagePrompt promptBinding="PX_LOCAL_MES_RCV@ResourceBundle@servletRequest" />
        <uix:styledText styleClass="OraDataText" 
                        textBinding="qcPXLocalMsgRcv@parallelSql@sessionDetailsBean@servletRequest"/>

        <uix:messagePrompt promptBinding="PX_REMOTE_MES_SNT@ResourceBundle@servletRequest" />
        <uix:styledText styleClass="OraDataText" 
                        textBinding="qcPXRemoteMsgSnt@parallelSql@sessionDetailsBean@servletRequest"/>

        <uix:messagePrompt promptBinding="PX_REMOTE_MES_RCV@ResourceBundle@servletRequest" />
        <uix:styledText styleClass="OraDataText" 
                        textBinding="qcPXRemoteMsgRcv@parallelSql@sessionDetailsBean@servletRequest"/>


        </uix:contents>
      </uix:labeledFieldLayout>
    </uix:stackLayout>   
  </uix:header>
  
  <uix:header textBinding="PARALLEL_EXEC_SERVERS@ResourceBundle@servletRequest">
    <uix:stackLayout>
    
      <uix:flowLayout>
        <uix:rowLayout>
          <uix:styledText textBinding="PARA_EXEC_SERVER_DESC@ResourceBundle@servletRequest"  
                          styleClass="OraInstructionText"/>
        </uix:rowLayout>
        <uix:spacer height="5"/>

              <uix:tableLayout width="100%">
          	<uix:rowLayout>
                  <oem:table name="parallelSql" width="100%"
			    summaryBinding="WAIT_EVENT_HDR@ResourceBundle@servletRequest"
                            formSubmitted="true"
                            destinationBinding="defaultDest@servletRequest"
                            beanKey="sessionDetailsBean"
                            dataSourceProp="parallelSql"
                            alternateTextBinding="NO_DATA_AVAILABLE@ResourceBundle@servletRequest"
                            partialRenderMode="self">
                  </oem:table>
                </uix:rowLayout>
              </uix:tableLayout>
              
              
      </uix:flowLayout>
      
    </uix:stackLayout>   
  </uix:header>
      </uix:stackLayout>
              </uix:case>
          </uix:switcher>
  
  
      	    </uix:subTabLayout>
      	  </uix:header>

      	  <uix:contentFooter>
	    <uix:include node="/database/instance/session/button.jsp"/>
      	  </uix:contentFooter>
    	</uix:pageLayout>
      </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>


