<%@ include file="/sdk/oemTop.jspf" %>
<!-- ================  Database Top Sessions Details Page =================== -->

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext>  
  <uix:document>    
    <uix:metaContainer>      
      <uix:head titleBinding="SESS_DET_TITLE@ResourceBundle@servletRequest"/>    
      <uix:styleSheet/>
      <meta http-equiv="Refresh" content=<%=request.getAttribute("refreshChoice") %> >
    </uix:metaContainer>           
    
    <uix:form name="customerForm" destinationBinding="defaultDest@servletRequest"> 
    <uix:formValue name="target" valueBinding="targetName@sessionDetailsBean@servletRequest"/>
    <uix:formValue name="type" valueBinding="targetType@sessionDetailsBean@servletRequest"/>
    <uix:pageLayout>      
      <%@ include file="/database/global.jspf" %>
      <uix:header textBinding="header@sessionDetailsBean@servletRequest"> 
        <uix:tableLayout width="100%">
          <uix:rowLayout hAlign="right">
            <uix:cellFormat>
              <uix:rowLayout>
                <uix:styledText styleClass="OraInlineInfoText" 
                              textBinding="DATA_RETRIEVED@ResourceBundle@servletRequest"/>
                <uix:spacer width="10"/>
                <uix:styledText styleClass="OraInlineInfoText" 
                              textBinding="lastUpdatedTime@sessionDetailsBean@servletRequest"/>
                <uix:spacer width="10"/>
                <uix:image sourceBinding="refreshImage@servletRequest"
                              destinationBinding="refreshDest@servletRequest" />
              </uix:rowLayout>
            </uix:cellFormat>
          </uix:rowLayout>
          <uix:switcher childNameBinding="delta@sessionDetailsBean@servletRequest">
            <uix:case name="true">
              <uix:rowLayout hAlign="right">
                <uix:cellFormat>
                  <uix:rowLayout>
                    <uix:styledText styleClass="OraInstructionText"                               
			    labeledNodeId="view_choice"
                            textBinding="VIEW_DATA@ResourceBundle@servletRequest" />              
                    <uix:spacer width="5"/>
                    <uix:choice name="refreshChoice" id="view_choice">
                      <uix:option textBinding="REAL_TIME_AUTO_15_SEC@ResourceBundle@servletRequest"
                        value="15"/>
                      <uix:option textBinding="REAL_TIME_MANUAL@ResourceBundle@servletRequest"
                        value="-1" selectedBinding="manualRefresh@sessionDetailsBean@servletRequest"/>
                    </uix:choice>
                    <uix:submitButton textBinding="GO@ResourceBundle@servletRequest"
                        name="event" value="changeRefreshChoice"/>
                  </uix:rowLayout>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:case>
          </uix:switcher>
          <uix:rowLayout>
            <uix:cellFormat>
        <uix:header textBinding="GENERAL_HDR@ResourceBundle@servletRequest">            
          <uix:tableLayout width="100%">              
            <uix:rowLayout vAlign="top">                
              <uix:tableLayout>                  
                <uix:rowLayout>                    
                  <uix:cellFormat hAlign="right">                      
                    <uix:styledText textBinding="SERIAL@ResourceBundle@servletRequest" styleClass="OraPromptText"/>
                  </uix:cellFormat>                    
                  <uix:spacer width="10"/>                    
                  <uix:styledText textBinding="sessSerial@sessionDetailsBean@servletRequest" 
                                styleClass="OraDataText"/>                  
                </uix:rowLayout>                  
                <uix:rowLayout>                    
                  <uix:cellFormat hAlign="right">                      
                    <uix:styledText textBinding="STATUS@ResourceBundle@servletRequest" styleClass="OraPromptText"/>
                  </uix:cellFormat>                    
                  <uix:spacer width="10"/>                    
                  <uix:styledText textBinding="sessStatus@sessionDetailsBean@servletRequest" 
                                styleClass="OraDataText"/>                  
                </uix:rowLayout>                  
                <uix:rowLayout>                    
                  <uix:cellFormat hAlign="right">                      
                    <uix:styledText textBinding="WAITING_FOR@ResourceBundle@servletRequest" styleClass="OraPromptText"/>
                  </uix:cellFormat>                    
                  <uix:spacer width="10"/>                    
                  <uix:styledText textBinding="sessWait@sessionDetailsBean@servletRequest"
                                styleClass="OraDataText"/>                  
                </uix:rowLayout>                  
                <uix:rowLayout>                    
                  <uix:cellFormat hAlign="right">                      
                    <uix:styledText textBinding="OSPID@ResourceBundle@servletRequest" styleClass="OraPromptText"/>
                  </uix:cellFormat>                    
                  <uix:spacer width="10"/>                    
                  <uix:styledText textBinding="sessDbOsPid@sessionDetailsBean@servletRequest"
                                styleClass="OraDataText"/>                  
                </uix:rowLayout>                  
                <uix:rowLayout>                    
                  <uix:cellFormat hAlign="right">                      
                    <uix:styledText textBinding="DB_USER@ResourceBundle@servletRequest" styleClass="OraPromptText"/>
                  </uix:cellFormat>                    
                  <uix:spacer width="10"/>                    
                  <uix:styledText textBinding="sessUser@sessionDetailsBean@servletRequest"
                                styleClass="OraDataText"/>                  
                </uix:rowLayout>                  
                <uix:rowLayout>                    
                  <uix:cellFormat hAlign="right">                      
                    <uix:styledText textBinding="CONSUMER_GROUP@ResourceBundle@servletRequest" styleClass="OraPromptText"/> 
                  </uix:cellFormat>                    
                  <uix:spacer width="10"/>                    
                  <uix:styledText textBinding="sessConsumerGroup@sessionDetailsBean@servletRequest" 
                                styleClass="OraDataText"/>                  
                </uix:rowLayout>                
              </uix:tableLayout>                                
              <uix:tableLayout>                  
                <uix:rowLayout>                    
                  <uix:cellFormat hAlign="right">                      
                    <uix:styledText textBinding="LOGON@ResourceBundle@servletRequest" styleClass="OraPromptText"/> 
                  </uix:cellFormat>                    
                  <uix:spacer width="10"/>                    
                  <uix:styledText textBinding="sessLogonTime@sessionDetailsBean@servletRequest" 
                                styleClass="OraDataText"/>                  
                </uix:rowLayout>                  
                <uix:rowLayout>                   
                  <uix:cellFormat hAlign="right">                      
                    <uix:styledText textBinding="LAST_ACTIVITY@ResourceBundle@servletRequest" styleClass="OraPromptText"/>
                  </uix:cellFormat>                    
                  <uix:spacer width="10"/>                    
                  <uix:styledText textBinding="sessLastActivity@sessionDetailsBean@servletRequest"
                                styleClass="OraDataText"/>                  
                </uix:rowLayout>                  
                <uix:rowLayout>                    
                  <uix:cellFormat hAlign="right">                      
                    <uix:styledText textBinding="CONN_TYPE@ResourceBundle@servletRequest" styleClass="OraPromptText"/> 
                  </uix:cellFormat>                    
                  <uix:spacer width="10"/>                    
                  <uix:styledText textBinding="sessConnection@sessionDetailsBean@servletRequest" 
                                styleClass="OraDataText"/>                  
                </uix:rowLayout>                
              </uix:tableLayout>              
            </uix:rowLayout>            
          </uix:tableLayout>          
        </uix:header>          
            </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:cellFormat>
        <uix:tableLayout width="100%">            
          <uix:rowLayout>              
            <uix:spacer height="10"/>            
          </uix:rowLayout>            
          <uix:rowLayout vAlign="top">              
            <uix:header textBinding="APPLICATION_HDR@ResourceBundle@servletRequest">                
              <uix:stackLayout>                  
                <uix:tableLayout>                    
                  <uix:rowLayout>                      
                    <uix:cellFormat hAlign="right">                        
                      <uix:styledText textBinding="PROGRAM@ResourceBundle@servletRequest" styleClass="OraPromptText"/>
                    </uix:cellFormat>                      
                    <uix:spacer width="10"/>                      
                    <uix:styledText textBinding="sessProgram@sessionDetailsBean@servletRequest" 
                                styleClass="OraDataText"/>                    
                  </uix:rowLayout>                    
                  <uix:rowLayout>                      
                    <uix:cellFormat hAlign="right">                        
                      <uix:styledText textBinding="MODULE@ResourceBundle@servletRequest" styleClass="OraPromptText"/>
                    </uix:cellFormat>                      
                    <uix:spacer width="10"/>                      
                    <uix:styledText textBinding="sessModule@sessionDetailsBean@servletRequest"
                                styleClass="OraDataText"/>                    
                  </uix:rowLayout>                    
                  <uix:rowLayout>                      
                    <uix:cellFormat hAlign="right">                        
                      <uix:styledText textBinding="COMMAND@ResourceBundle@servletRequest" styleClass="OraPromptText"/>
                    </uix:cellFormat>                      
                    <uix:spacer width="10"/>                      
                    <uix:styledText textBinding="sessCommand@sessionDetailsBean@servletRequest"
                                styleClass="OraDataText"/>                    
                  </uix:rowLayout>                  
                </uix:tableLayout>                  
                <uix:spacer height="1" />                  
                <uix:link textBinding="viewSqlText@sessionDetailsBean@servletRequest" 
                                destinationBinding="viewSqlLink@sessionDetailsBean@servletRequest"/>                
              </uix:stackLayout>              
            </uix:header>              
            <uix:header textBinding="CLIENT_HDR@ResourceBundle@servletRequest">                
              <uix:tableLayout>                  
                <uix:rowLayout>                    
                  <uix:cellFormat hAlign="right">                      
                    <uix:styledText textBinding="CLIENT_PID@ResourceBundle@servletRequest" styleClass="OraPromptText"/>
                  </uix:cellFormat>                    
                  <uix:spacer width="10"/>                    
                  <uix:styledText textBinding="sessClientPid@sessionDetailsBean@servletRequest"
                                styleClass="OraDataText"/>                  
                </uix:rowLayout>                  
                <uix:rowLayout>                    
                  <uix:cellFormat hAlign="right">                      
                    <uix:styledText textBinding="OS_USERNAME@ResourceBundle@servletRequest" styleClass="OraPromptText"/>
                  </uix:cellFormat>                    
                  <uix:spacer width="10"/>                    
                  <uix:styledText textBinding="sessOsUser@sessionDetailsBean@servletRequest"
                                styleClass="OraDataText"/>                  
                </uix:rowLayout>
                <uix:rowLayout>                    
                  <uix:cellFormat hAlign="right">                      
                    <uix:styledText textBinding="TERMINAL@ResourceBundle@servletRequest" styleClass="OraPromptText"/> 
                  </uix:cellFormat>                    
                  <uix:spacer width="10"/>                    
                  <uix:styledText textBinding="sessTerminal@sessionDetailsBean@servletRequest"
                                styleClass="OraDataText"/>                  
                </uix:rowLayout>                  
                <uix:rowLayout>                    
                  <uix:cellFormat hAlign="right">                      
                    <uix:styledText textBinding="HOST@ResourceBundle@servletRequest" styleClass="OraPromptText"/>
                  </uix:cellFormat>                    
                  <uix:spacer width="10"/>                    
                  <uix:styledText textBinding="sessMachine@sessionDetailsBean@servletRequest"
                                styleClass="OraDataText"/>                  
                </uix:rowLayout>                
              </uix:tableLayout>              
            </uix:header>            
          </uix:rowLayout>            
          <uix:rowLayout>              
            <uix:spacer height="10"/>            
          </uix:rowLayout>            
          <uix:rowLayout vAlign="top">              
            <uix:header textBinding="CONSUMPTION_HDR@ResourceBundle@servletRequest">                
              <uix:tableLayout>                  
                <uix:rowLayout>                    
                  <uix:spacer height="10"/>                  
                </uix:rowLayout>                  
                <uix:rowLayout>                    
                  <uix:styledText textBinding="CPU_HDR@ResourceBundle@servletRequest" styleClass="OraTipText"/>
                </uix:rowLayout>                  
                <uix:rowLayout>                    
                  <uix:spacer width="1" />                    
                  <uix:cellFormat hAlign="right">                      
                    <uix:styledText textBinding="CPU_TIME@ResourceBundle@servletRequest" styleClass="OraPromptText"/>
                  </uix:cellFormat>                    
                  <uix:spacer width="10"/>                    
                  <uix:styledText textBinding="sessCpu@sessionDetailsBean@servletRequest" styleClass="OraDataText"/>
                </uix:rowLayout>                  
                <uix:rowLayout>                    
                  <uix:spacer width="1" />                    
                  <uix:cellFormat hAlign="right">                      
                    <uix:styledText textBinding="PARSE_CPU@ResourceBundle@servletRequest" styleClass="OraPromptText"/>
                  </uix:cellFormat>                    
                  <uix:spacer width="10"/>                    
                  <uix:styledText textBinding="sessParseCpu@sessionDetailsBean@servletRequest" styleClass="OraDataText"/>
                </uix:rowLayout>                  
                <uix:rowLayout>                    
                  <uix:spacer height="10"/>                  
                </uix:rowLayout>                  
                <uix:rowLayout>                    
                  <uix:styledText textBinding="MEMORY_HDR@ResourceBundle@servletRequest" styleClass="OraTipText"/>
                </uix:rowLayout>                  
                <uix:rowLayout>                    
                  <uix:spacer width="1" />                    
                  <uix:cellFormat hAlign="right">                      
                    <uix:styledText textBinding="UGA@ResourceBundle@servletRequest" styleClass="OraPromptText"/>
                  </uix:cellFormat>                    
                  <uix:spacer width="10"/>                    
                  <uix:styledText textBinding="sessUga@sessionDetailsBean@servletRequest" styleClass="OraDataText"/>
                </uix:rowLayout>                  
                <uix:rowLayout>                    
                  <uix:spacer width="1" />                    
                  <uix:cellFormat hAlign="right">                      
                    <uix:styledText textBinding="PGA@ResourceBundle@servletRequest" styleClass="OraPromptText"/>
                  </uix:cellFormat>                    
                  <uix:spacer width="10"/>                    
                  <uix:styledText textBinding="sessPga@sessionDetailsBean@servletRequest" styleClass="OraDataText"/>
                </uix:rowLayout>                  
                <uix:rowLayout>                    
                  <uix:spacer height="10"/>                  
                </uix:rowLayout>                  
                <uix:rowLayout>                    
                  <uix:styledText textBinding="IO_HDR@ResourceBundle@servletRequest" styleClass="OraTipText"/>
                </uix:rowLayout>                  
                <uix:rowLayout>                    
                  <uix:spacer width="1" />                    
                  <uix:cellFormat hAlign="right">                      
                    <uix:styledText textBinding="PHYS_READS@ResourceBundle@servletRequest" styleClass="OraPromptText"/>
                  </uix:cellFormat>                    
                  <uix:spacer width="10"/>                    
                  <uix:styledText textBinding="sessPhysReads@sessionDetailsBean@servletRequest" styleClass="OraDataText"/>
                </uix:rowLayout>                  
                <uix:rowLayout>                    
                  <uix:spacer width="1" />                    
                  <uix:cellFormat hAlign="right">                      
                    <uix:styledText textBinding="PHYS_WRITES@ResourceBundle@servletRequest" styleClass="OraPromptText"/>
                  </uix:cellFormat>                    
                  <uix:spacer width="10"/>                    
                  <uix:styledText textBinding="sessPhysWrites@sessionDetailsBean@servletRequest" styleClass="OraDataText"/>
                </uix:rowLayout>                
              </uix:tableLayout>                
              <uix:tableLayout>                  
                <uix:rowLayout>                    
                  <uix:spacer height="20"/>                  
                </uix:rowLayout>                  
                <uix:rowLayout>                    
                  <uix:link textBinding="ALL_SESS_LINK@ResourceBundle@servletRequest" 
                                destinationBinding="allSessLink@sessionDetailsBean@servletRequest"/>                  
                </uix:rowLayout>                
              </uix:tableLayout>              
            </uix:header>                            
            <uix:stackLayout>                
              <uix:tableLayout hAlign="left">                  
                <uix:rowLayout hAlign="center"> 
                <%--
                  <oem:chart titleBinding="RES_CONTENTION_HDR@ResourceBundle@servletRequest" 
                                chartType="barChart"                               
                                width="350"                               
                                height="185"                               
                                orientation="horizontal"                               
                                noDataMessageBinding="NO_WAIT_EVENTS@ResourceBundle@servletRequest">
                    <oem:rtChartDataSource targetBinding="targetName@sessionDetailsBean@servletRequest" 
                                targetType="oracle_database"                                             
                                credentialsBinding="targetCredentials@sessionDetailsBean@servletRequest"
                                metricId="SESSION_WAITS"                                             
                                metricContextBinding="sid@sessionDetailsBean@servletRequest"/>                      
                    <oem:chartColumn displayLabelBinding="WAIT_EVENT@ResourceBundle@servletRequest" 
                                columnName="sesswaitEvent"                                       
                                isKey="true"/>                      
                    <oem:chartColumn displayLabelBinding="WAIT_MS@ResourceBundle@servletRequest" 
                                columnName="sesswaitTime"                                       
                                itemColor="blue"/>                    
                  </oem:chart>                  
                    --%>
                  <oem:chart titleBinding="RES_CONTENTION_HDR@ResourceBundle@servletRequest"
                                chartType="barChart"
                                width="350" 
                                height="185"
                                orientation="horizontal"
                                noDataMessageBinding="NO_WAIT_EVENTS@ResourceBundle@servletRequest">
                    <oem:boundChartDataSource chartDataSourceBinding="sessionWaitDataSource@sessionDetailsBean@servletRequest"/>
                    <oem:chartColumn isKey="true" displayLabelBinding="WAIT_EVENT@ResourceBundle@servletRequest" 
                                sourceIndex="0" />
                    <oem:chartColumn displayLabelBinding="WAIT_MS@ResourceBundle@servletRequest"
                                itemColor="blue"
                                sourceIndex="1"/>
                  </oem:chart>
                </uix:rowLayout>                
              </uix:tableLayout>              
            </uix:stackLayout>            
          </uix:rowLayout>          
        </uix:tableLayout>
            </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:cellFormat>
        <uix:tableLayout width="100%">            
          <uix:rowLayout>              
            <uix:cellFormat hAlign="right">                
              <uix:button textBinding="KILL_SESSION@ResourceBundle@servletRequest"
                                destinationBinding="killSession@sessionDetailsBean@servletRequest"/>                
              <uix:spacer width="10"/>              
            </uix:cellFormat>            
          </uix:rowLayout>          
        </uix:tableLayout>
            </uix:cellFormat>
          </uix:rowLayout>
        </uix:tableLayout>
      </uix:header>      
    </uix:pageLayout>  
      </uix:form>    
  </uix:document>
</uix:renderingContext> 

