<%@ include file="/sdk/oemTop.jspf" %>
<!-- ================  Database Top Session Statistics Page =================== -->

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>

      <uix:form name="statsForm" destinationBinding="defaultDest@servletRequest">
        <uix:formValue name="target" valueBinding="targetName@sessionDetailsBean@servletRequest"/>
        <uix:formValue name="type" valueBinding="targetType@sessionDetailsBean@servletRequest"/>
        <uix:formValue name="SID" valueBinding="SID@sessionDetailsBean@servletRequest"/>
        <uix:formValue name="serialNum" valueBinding="sessSerial@sessionDetailsBean@servletRequest"/>
        <uix:formValue name="pageNum" value="3"/>

        <uix:pageLayout>
          <%@ include file="/database/global.jspf" %>

	  <oem:messageBox messageType="info" errorTableBinding="info@servletRequest"
              	msgBundleBinding="ResourceBundle"
              	titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error"
          	errorTableBinding="errors@servletRequest"
         	titleTextKey="titleText" mainTextKey="mainText"/>

    	  <uix:switcher childNameBinding="refreshChoice@servletRequest">
      	    <uix:case name="RT_15">
              <uix:rawText>
          	<meta http-equiv="Refresh" content="15" >
              </uix:rawText>
      	    </uix:case>
    	  </uix:switcher>
          <uix:messageBox automatic="true" />

          <uix:header textBinding="header@sessionDetailsBean@servletRequest"/>
 

	    <uix:flowLayout>
	      <uix:tableLayout width="100%">
		<uix:rowLayout>

		  <uix:cellFormat hAlign="left" >
		    <uix:switcher childNameBinding="statisticsNode@sessionDetailsBean@servletRequest">
		      <uix:case name="okNode">
               	        <uix:rowLayout>
			  <uix:styledText styleClass="OraTipText"
					  textBinding="fromText@servletRequest"/>
			  <uix:spacer width="5" />
			  <uix:styledText styleClass="OraTipLabel"
					  textBinding="fromDate@servletRequest"/>
			  <uix:spacer width="5" />
			  <uix:styledText styleClass="OraTipText"
					  textBinding="toText@servletRequest"/>
			  <uix:spacer width="5" />
			  <uix:styledText styleClass="OraTipLabel"
					  textBinding="toDate@servletRequest"/>
			</uix:rowLayout>
		      </uix:case>
		    </uix:switcher>
		  </uix:cellFormat>

		  <uix:cellFormat hAlign="right" > 
		    <uix:flowLayout>

		      <uix:styledText styleClass="OraFieldText" 
				      textBinding="VIEW_DATA@DBMsgBundle@servletRequest" 
				      labeledNodeId="view_choice" />
		      <uix:choice name="refreshChoice" id="view_choice"
				  onChange="submitForm('statsForm', true, {'event':'changeRefreshChoice'})"
				  selectedValueBinding="refreshChoiceSelected@servletRequest">
			<uix:option textBinding="REAL_TIME_AUTO_15_SEC@DBMsgBundle@servletRequest"
				    value="RT_15"/>
			<uix:option textBinding="REAL_TIME_MANUAL@DBMsgBundle@servletRequest"
				    value="RT_MAN"/>
			<uix:option textBinding="HISTORICAL@DBMsgBundle@servletRequest"
				    value="HIST_CUST" />       
		      </uix:choice>  


		      <uix:button textBinding="REFRESH@SDKBundle@servletRequest"
				  destinationBinding="refreshDest@servletRequest" />

		    </uix:flowLayout>
		  </uix:cellFormat>


		</uix:rowLayout>

	      </uix:tableLayout>
	    </uix:flowLayout>
	    <uix:tableLayout width="100%">	  
	    

            <uix:rowLayout>
              <uix:spacer height="5"/>
            </uix:rowLayout>

	    <uix:rowLayout hAlign="right">
	      <uix:include node="/database/instance/session/button.jsp"/>
	    </uix:rowLayout>

            <uix:rowLayout>
              <uix:spacer height="5"/>
            </uix:rowLayout>

	  </uix:tableLayout> 

      	    <uix:subTabLayout>
              <uix:subTabs>
                <uix:switcher childNameBinding="showActivity@sessionDetailsBean@servletRequest">
                  <uix:case name="true">
                    <uix:subTabBar selectedIndex="2">
                    <%@ include file="tab10g.jspf" %>
                    </uix:subTabBar>
                  </uix:case>
                  <uix:case name="false">
                    <uix:subTabBar selectedIndex="1">
                    <%@ include file="tabPre10g.jspf" %>
                    </uix:subTabBar>
                  </uix:case>
                </uix:switcher>
              </uix:subTabs>

      	      <uix:switcher childNameBinding="statisticsNode@sessionDetailsBean@servletRequest">
        	<uix:case name="okNode">
            	  <uix:tableLayout width="100%">
              	    <uix:rowLayout>
                      <oem:table name="statTable" width="100%"
			    summaryBinding="ALL_SESS_LINK@ResourceBundle@servletRequest"
                            formSubmitted="true"
                            destinationBinding="defaultDest@servletRequest"
                            beanKey="sessionDetailsBean"
                            dataSourceProp="statistics"
                            alternateTextBinding="NOSTATS@ResourceBundle@servletRequest"
                            blockSize="25" partialRenderMode="self">
                      </oem:table>
                    </uix:rowLayout>
            	  </uix:tableLayout>
        	</uix:case>
        	<!-- Empty result message -->
        	<uix:case name="emptyNode">
          	  <!-- <html:em> -->
          	  <uix:styledText textBinding="NOSTATS@ResourceBundle@servletRequest"/>
          	  <!-- </html:em> -->
        	</uix:case>
        	<!-- Error message -->
        	<!--
          	<uix:case name="errNode">
          	  <include baja:node="errMessage" />
          	</uix:case>
        	-->
      	      </uix:switcher>
      	    </uix:subTabLayout>
	  

      	  <uix:contentFooter>
	    <uix:include node="/database/instance/session/button.jsp"/>
          </uix:contentFooter>

    	</uix:pageLayout>
      </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

