<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext" >
<uix:bundle name="dbMsg"
	    class="oracle.sysman.db.rsc.inst.DBMsg"/>

<oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/setRefreshRate.jspf" %>

    <uix:body>
      <db:form name="processForm" method="POST" destinationBinding="controllerDest@processBean@servletRequest"
        copyParams="target,type,processId" >
      <uix:formValue name="pageName" value="/database/instance/simpleProcessPage.jsp"/>

     <uix:pageLayout titleBinding="title@processBean@servletRequest" >
     <%@ include file="/database/global.jspf" %>

      <uix:styledText textBinding="instructionText@processBean@servletRequest"
        styleClass="OraInstructionTextStrong" />
      <uix:spacer height="5" />
      <uix:styledText styleClass="OraInstructionText" 
        textBinding="additionalInstr@processBean@servletRequest" />
      <uix:spacer height="10" /> 

        <uix:switcher childNameBinding="onlyOneStep@processBean@servletRequest">
        <uix:case name="true">

          <uix:processing
              id="processingIcon"
              timeInterval="<%=processingPageInterval%>">
            <uix:tableLayout cellSpacing="1">
              <uix:contents childDataBinding="allStepsData@processBean@servletRequest">
                <uix:styledText styleClass="OraFieldText" textBinding="text" /> 
              </uix:contents>
            </uix:tableLayout>
          </uix:processing>

        </uix:case>
        <uix:case name="false">
          
          <uix:processing
              id="processingIcon"
              percentCompleteBinding="percentCompleteData@processBean@servletRequest"
              timeInterval="<%=processingPageInterval%>">

              <uix:tableLayout cellSpacing="1">
                <uix:contents childDataBinding="allStepsData@processBean@servletRequest">
                  <uix:rowLayout>
                      <uix:cellFormat>
                          <uix:image source="/em/images/processCheck.gif" 
                            renderedBinding="renderedDone"/>       
                          <uix:image source="/em/images/currentStep.gif" 
                            renderedBinding="current"/>       
                      </uix:cellFormat>
                      <uix:spacer width="3" />
                      <uix:cellFormat vAlign="bottom">
                        <uix:styledText styleClass="OraFieldText" textBinding="text" /> 
                      </uix:cellFormat>
                  </uix:rowLayout>
                </uix:contents>
              </uix:tableLayout>
          </uix:processing>
        </uix:case>
        </uix:switcher>


       <uix:pageButtons>
        <uix:pageButtonBar>
           <uix:button textBinding="CANCEL@dbMsg"
              destinationBinding="cancelURL@processBean@servletRequest" /> 
        </uix:pageButtonBar>
        </uix:pageButtons>

     </uix:pageLayout>

     </db:form>
    
    </uix:body>
  </uix:document> 
</uix:renderingContext>
