<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>


  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
    <db:form name="foo" method="POST" destination="/console/database/instance/customizePerfPage"
      copyParams="target,type,refreshChoice">

    <uix:pageLayout titleBinding="header@customizeBean@servletRequest">
    <%@ include file="/database/global.jspf" %>

    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
    <oem:messageBox messageType="info" 
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
    

   <uix:messagePrompt promptBinding="PERF_PAGE_CUST_INSTR@DBMsgBundle@servletRequest" />


    <uix:header textBinding="DETAILED_CHART_SETTINGS@DBMsgBundle@servletRequest" >

         <uix:stackLayout>
         <uix:tableLayout>
        <uix:rowLayout>
          <uix:cellFormat hAlign="right" wrappingDisabled="true">
              <uix:styledText styleClass="OraPromptText"
                textBinding="DEFAULT_TAB_SELECTION@DBMsgBundle@servletRequest"/>

          </uix:cellFormat>
          <uix:spacer width="8"/>
          <uix:cellFormat hAlign="left" wrappingDisabled="true">

          <uix:radioButton name="tabSelection" 
              selectedValueBinding="tabSelection@customizeBean@servletRequest"
              textBinding="THROUGHPUT_METRIC@DBMsgBundle@servletRequest"
              value="0"  />
         <uix:radioButton name="tabSelection" 
              selectedValueBinding="tabSelection@customizeBean@servletRequest"
              textBinding="IO@DBMsgBundle@servletRequest"
              value="1"  />
         <uix:radioButton name="tabSelection" 
              selectedValueBinding="tabSelection@customizeBean@servletRequest"
              textBinding="PARALLEL_EXECUTION@DBMsgBundle@servletRequest"
              value="2"  />
         <uix:radioButton name="tabSelection" 
              selectedValueBinding="tabSelection@customizeBean@servletRequest"
              textBinding="SERVICES@DBMsgBundle@servletRequest"
              value="3"  />


          </uix:cellFormat>
        </uix:rowLayout>
        
        <uix:rowLayout>
          <uix:cellFormat hAlign="right" wrappingDisabled="true">
              <uix:styledText styleClass="OraPromptText"
                textBinding="THROUGHPUT_TAB_SELECTION@DBMsgBundle@servletRequest"/>

          </uix:cellFormat>
          <uix:spacer width="8"/>
          <uix:cellFormat hAlign="left" wrappingDisabled="true">

         <uix:radioButton name="throughputTabSelection" 
              selectedValueBinding="throughputTabSelection@customizeBean@servletRequest"
              textBinding="SP_PER_SECOND@DBMsgBundle@servletRequest"
              value="0"  />
         <uix:radioButton name="throughputTabSelection"
              selectedValueBinding="throughputTabSelection@customizeBean@servletRequest"
              textBinding="SP_PER_TRANSACTION@DBMsgBundle@servletRequest"
              value="1"  />


          </uix:cellFormat>
        </uix:rowLayout>
        
        
         <uix:rowLayout>
          <uix:cellFormat hAlign="right" wrappingDisabled="true">
              <uix:styledText styleClass="OraPromptText"
                textBinding="IO_TAB_SELECTION@DBMsgBundle@servletRequest"/>

          </uix:cellFormat>
          <uix:spacer width="8"/>
          <uix:cellFormat hAlign="left" wrappingDisabled="true">

           <uix:radioButton name="IOTabSelection" 
                selectedValueBinding="IOTabSelection@customizeBean@servletRequest"
                textBinding="IO_FUNCTION@DBMsgBundle@servletRequest"
                value="0"  />
           <uix:radioButton name="IOTabSelection"
                selectedValueBinding="IOTabSelection@customizeBean@servletRequest"
                textBinding="IO_TYPE@DBMsgBundle@servletRequest"
                value="1"  />
           <uix:radioButton name="IOTabSelection"
                selectedValueBinding="IOTabSelection@customizeBean@servletRequest"
                textBinding="CONSUMER_GROUP2@DBMsgBundle@servletRequest"
                value="2"  />

          </uix:cellFormat>
        </uix:rowLayout>
        
        
        </uix:tableLayout>
       </uix:stackLayout>
         
        
    </uix:header>
  

  <uix:header textBinding="BASELINE_SELECTION@DBMsgBundle@servletRequest" >
  <uix:messagePrompt promptBinding="BASELINE_SELECTION_INSTR@DBMsgBundle@servletRequest" />

    <uix:tableLayout width="100%" cellSpacing="2"> 
    <uix:rowLayout vAlign="top">


       <uix:stackLayout>
         <uix:radioButton name="baselinePreference" 
              selectedValueBinding="baselinePreference@customizeBean@servletRequest"
              textBinding="DONT_SHOW_BASELINE@DBMsgBundle@servletRequest"
              value="0"  />
         <uix:radioButton name="baselinePreference"
              selectedValueBinding="baselinePreference@customizeBean@servletRequest"
              textBinding="SHOW_BASELINE_99P@DBMsgBundle@servletRequest"
              value="1"  />
         <uix:radioButton name="baselinePreference"
              disabledBinding="baselineListEmpty@customizeBean@servletRequest"
              selectedValueBinding="baselinePreference@customizeBean@servletRequest"
              textBinding="SHOW_MAX_VALUE_LINE@DBMsgBundle@servletRequest"
              value="2"  />

         <uix:rowLayout>
            <uix:spacer width="20" />
            <uix:messagePrompt promptBinding="BASELINE_NAME_11@DBMsgBundle@servletRequest" />
            <uix:spacer width="5" />
            <uix:choice name="baselineSelection"  disabledBinding="baselineListEmpty@customizeBean@servletRequest">
              <uix:contents childDataBinding="baselineList@customizeBean@servletRequest">
                <uix:option textBinding="text" valueBinding="val" 
                     selectedBinding="selected" />
            </uix:contents>
          </uix:choice>  

         </uix:rowLayout>

      </uix:stackLayout>

   </uix:rowLayout>
   </uix:tableLayout>
   </uix:header>




  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
   <uix:flowLayout >
    <uix:submitButton textBinding="CANCEL@DBMsgBundle@servletRequest" 
                      name="event" 
                      value="cancel"/>
    <uix:spacer width="10"/>
    <uix:submitButton textBinding="OK@DBMsgBundle@servletRequest" 
                      name="event" 
                      value="apply"/>
    </uix:flowLayout>
  </uix:pageButtonBar>
  </uix:pageButtons>
   
    </uix:pageLayout>
    </db:form> 
    </uix:body>

  </uix:document>
</uix:renderingContext>

