<%--
  -- Name:        em/database/instance/sitemap/enableSGA.jsp
  -- Description: This jsp is to enable the SGA mode.
  --
  -- Controller:  oracle.sysman.db.adm.inst.SitemapController
  --
  -- Notes:
  --
  -- MODIFIED     (MM/DD/YY)
  --   jsoule     09/11/06 - sync up tabs
  --   hopark     06/01/05 - hopark_4258298_gc
  --   hopark     05/23/05 - fix ADA issue 
  --   hopark     05/07/05 - Created
  --%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>   
    <db:form name="foo" method="get" 
             destination="/console/database/instance/sitemap"
             copyParams="target,type">
    <uix:pageLayout titleBinding="header@defaultBean@servletRequest">
    <%@ include file="/database/global.jspf" %>

    <uix:formValue name="event"/>
    <uix:formValue name="pageNum" />
    <uix:formValue name="mode" valueBinding="mode@servletRequest"/>
    <uix:formValue name="instanceVersion" valueBinding="instanceVersion@servletRequest"/>
     <uix:subTabLayout>
       <uix:subTabs>
         <uix:subTabBar selectedIndex="1">
           <uix:link textBinding="HOME@DBMsgBundle@servletRequest"
                     destinationBinding="sitemapDest@servletRequest"/>
           <uix:link textBinding="PERFORMANCE_HEADER@DBMsgBundle@servletRequest" />    
           <uix:link textBinding="TAB_AVAILABILITY@DBMsgBundle@servletRequest"
                     destinationBinding="tabAvailabilityDest@servletRequest"/>
           <uix:link textBinding="TAB_SERVER@DBMsgBundle@servletRequest"
                     destinationBinding="tabServerDest@servletRequest"/>
           <uix:link textBinding="TAB_SCHEMA@DBMsgBundle@servletRequest"
                     destinationBinding="tabSchemaDest@servletRequest"/>
           <uix:link textBinding="TOPOLOGY@racMsgBundle@servletRequest"
                     destinationBinding="topologyDest@servletRequest" 
                     renderedBinding="RacDbScope@servletRequest" />
           <uix:link textBinding="TAB_DATA_MOVEMENT@DBMsgBundle@servletRequest"
                     destinationBinding="tabDataMovementDest@servletRequest"/>
           <uix:link textBinding="TAB_SOFTWARE_SUPPORT@DBMsgBundle@servletRequest"
                     destinationBinding="tabSoftwareSupportDest@servletRequest"/>
         </uix:subTabBar>
       </uix:subTabs>
        <uix:spacer height="20" />

        <uix:spacer height="10" />
            <uix:contentContainer background="light" 
                textBinding="SITEMAP_LW@@DBMsgBundle@servletRequest" width="100%">
                <uix:rowLayout>
                  <uix:cellFormat columnSpan="7">
                    <uix:styledText textBinding="SGA_DISABLED_INFO1@DBMsgBundle@servletRequest"
                                    styleClass="OraInstructionText"/>
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat columnSpan="7">
                    <uix:styledText textBinding="SGA_DISABLED_INFO2@DBMsgBundle@servletRequest"
                                    styleClass="OraInstructionText"/>
                  </uix:cellFormat>
                </uix:rowLayout>
            </uix:contentContainer>
      <uix:spacer height="10" />
          <uix:tableLayout width="100%">
             <uix:rowLayout >
                 <uix:cellFormat hAlign="right">
                   <uix:button textBinding="SGA_ENABLE@DBMsgBundle@servletRequest" 
                      destinationBinding="SGAEnableURL@servletRequest"/>
                   <uix:spacer width = "5" />
                   <uix:button textBinding="SGA_SWITCHSQL@DBMsgBundle@servletRequest" 
                      destinationBinding="SwitchToSQLURL@servletRequest"/>
                 </uix:cellFormat>
              </uix:rowLayout >
         </uix:tableLayout >
        <uix:spacer height="20" />
    </uix:subTabLayout>

    <oem:relatedLinks />

    <%-- oem:relatedLinks --%>
        </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

