<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/> 

<script>
 function resizeFlexHeight(height)
 {
   document.getElementById('flexPerfChartObjectId').style.height=height;
   document.getElementById('flexPerfChartEmbedId').style.height=height;
 }
</script>



  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>   
                 <oem:messageBox messageTypeBinding="messageType@servletRequest" 
                             errorTableBinding="errors@servletRequest"
                             destTableBinding="msgUrls@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>

    <db:form name="foo" method="get" 
             destination="/console/database/instance/sitemap"
             copyParams="target,type">

    <uix:formValue name="datasource" valueBinding="datasource@servletRequest"/>
    <uix:pageLayout titleBinding="header@defaultBean@servletRequest">
    
    <%@ include file="/sdk/page/pageMsgBox.jspf" %>
        
    <uix:switcher childNameBinding="showWarning@servletRequest">
    <uix:case name="true">
      <uix:messageBox messageType="warning" automatic="false" 
         messageBinding="warningText@servletRequest" >
        <uix:contents childDataBinding="warningData@servletRequest">
          <uix:link textBinding="statName" destinationBinding="statLink" />
        </uix:contents>
      </uix:messageBox>  
    </uix:case>
    </uix:switcher>

    <uix:contextSwitcher>
    <uix:switcher childNameBinding="showSwitchToList@servletRequest">
    <uix:case name="true">
            <uix:rowLayout>
                <uix:cellFormat vAlign="middle" wrappingDisabled="true">
                  <uix:styledText styleClass="OraPromptText" 
                        textBinding="SWITCH_TO@DBMsgBundle@servletRequest"/>  
                 </uix:cellFormat>
                 <uix:cellFormat vAlign="middle" wrappingDisabled="true">
                  <uix:spacer width="1"/>
                  <oem:choice name="newTarget"
                      onChange="submitForm('foo', true, {'event':'switchTo','pageNum':'2'})"
                      optionsBinding="racSwitchToList@servletRequest"
                      selectedValueBinding="targetName@defaultBean@servletRequest"/>
                 </uix:cellFormat>     
              </uix:rowLayout>
    </uix:case>
    </uix:switcher>
    </uix:contextSwitcher>

    <%@ include file="/database/global.jspf" %>

    <uix:formValue name="event"/>
    <uix:formValue name="pageNum" value="2" />
    <uix:formValue name="mode" valueBinding="mode@servletRequest"/>
    <uix:formValue name="instanceVersion" valueBinding="instanceVersion@servletRequest"/>

     <uix:subTabLayout>
        <uix:subTabs>
          <uix:subTabBar selectedIndex="1">
              <uix:link textBinding="HOME@DBMsgBundle@servletRequest"
               destinationBinding="sitemapDest@servletRequest"/>
              <uix:link textBinding="PERFORMANCE_HEADER@DBMsgBundle@servletRequest" />    
<%--
              <uix:link textBinding="ADMINISTRATION@DBMsgBundle@servletRequest"
                destinationBinding="adminDest@servletRequest"/>
              <uix:link textBinding="SOFTWARE_MAINT@DBMsgBundle@servletRequest"
                destinationBinding="softMaintDest@servletRequest"
                renderedBinding="repositoryMode@servletRequest"/>
--%>
              <uix:link textBinding="TAB_AVAILABILITY@DBMsgBundle@servletRequest"
                 destinationBinding="tabAvailabilityDest@servletRequest"/>
              <uix:link textBinding="TAB_SERVER@DBMsgBundle@servletRequest"
                 destinationBinding="tabServerDest@servletRequest"/>
              <uix:link textBinding="TAB_SCHEMA@DBMsgBundle@servletRequest"
                 destinationBinding="tabSchemaDest@servletRequest"/>
              <uix:link textBinding="TOPOLOGY@racMsgBundle@servletRequest"
                 destinationBinding="topologyDest@servletRequest" 
                 renderedBinding="RacDbScope@servletRequest" />
              <uix:link textBinding="TAB_DATA_MOVEMENT@DBMsgBundle@servletRequest"
                 destinationBinding="tabDataMovementDest@servletRequest"/>
              <uix:link textBinding="TAB_SOFTWARE_SUPPORT@DBMsgBundle@servletRequest"
                 destinationBinding="tabSoftwareSupportDest@servletRequest"/>
          </uix:subTabBar>
        </uix:subTabs>

        <uix:spacer height="1" />

        <uix:flowLayout>
          <uix:tableLayout width="100%" renderedBinding="isSGAEnable@servletRequest">
             <uix:rowLayout >
                <uix:cellFormat>
                   <uix:styledText styleClass="OraDataText"
                                   textBinding="SGA_ENABLED@DBMsgBundle@servletRequest" />
                 </uix:cellFormat>
                 <uix:cellFormat hAlign="right">
                   <uix:button textBinding="SGA_DISABLE@DBMsgBundle@servletRequest" 
                      destinationBinding="SGADisableURL@servletRequest"/>
                   <uix:spacer width = "5" />
                   <uix:button textBinding="SGA_SWITCHSQL@DBMsgBundle@servletRequest" 
                      destinationBinding="SwitchToSQLURL@servletRequest"/>
                 </uix:cellFormat>
              </uix:rowLayout >
              <uix:rowLayout >
                 <uix:spacer height="5" />
              </uix:rowLayout >
         </uix:tableLayout >

          <uix:tableLayout width="100%">
      
	 <uix:rowLayout vAlign="center" >
              <uix:cellFormat hAlign="left" renderedBinding="renderBaselineInfo@defaultBean@servletRequest">
                <uix:messagePrompt promptBinding="BSLN_NAME@DBMsgBundle@servletRequest" />
                <uix:spacer width="10" />
                <uix:styledText styleClass="OraDataText"
                                textBinding="baselineDisplayName@defaultBean@servletRequest" />
              </uix:cellFormat>


              <uix:cellFormat hAlign="right" vAlign="center">

                 <uix:button textBinding="SETTINGS_WORD@DBMsgBundle@servletRequest"
                    renderedBinding="renderBaselineInfo@defaultBean@servletRequest"
                    destinationBinding="customizeDest@servletRequest" />

                 <uix:spacer width="20" />

                  <uix:styledText styleClass="OraFieldText" 
                    textBinding="VIEW_DATA@DBMsgBundle@servletRequest" />

                  <uix:choice name="refreshChoice" 
                      onChange="submitForm('foo', true, {'event':'doLoad','pageNum':'2'})"
                       selectedValueBinding="refreshChoiceSelected@servletRequest">
                    <uix:option textBinding="REAL_TIME_AUTO_15_SEC@DBMsgBundle@servletRequest"
                      value="RT_15"/>
                    <uix:option textBinding="REAL_TIME_1_MIN@DBMsgBundle@servletRequest"
                      value="RT_60"/> 
                    <uix:option textBinding="REAL_TIME_MANUAL@DBMsgBundle@servletRequest"
                      value="RT_MAN"/>
                    <uix:option textBinding="HISTORICAL@DBMsgBundle@servletRequest"
                      value="HIST_CUST"
                      renderedBinding="notSgaMode@servletRequest" />  
                  </uix:choice>          

              </uix:cellFormat>
            </uix:rowLayout>
          </uix:tableLayout>

          <uix:switcher childNameBinding="isSGAEnable@servletRequest">
            <uix:case name="true">
              <db:flexRegion
                swfName="/database/flex/perfSGA.swf"
                dataSrcKeyBinding="flexKey@defaultBean@servletRequest"
                optionsBinding="refreshChoiceFlex@servletRequest"
                windowWidth="100%"
                windowHeightBinding="flexWindowHeight11@defaultBean@servletRequest"
                idBase="flexPerfChart" />
            </uix:case>

           <uix:case name="false">
             <uix:switcher childNameBinding="showPerfTabs@defaultBean@servletRequest">
               <uix:case name="true">
                <uix:switcher childNameBinding="showPerf112@defaultBean@servletRequest">
                 <uix:case name="true"> 
                  <db:flexRegion
                   swfName="/database/flex/perf112.swf"
                   dataSrcKeyBinding="flexKey@defaultBean@servletRequest"
                   optionsBinding="refreshChoiceFlex@servletRequest"
                   windowWidth="100%"
                   windowHeightBinding="flexWindowHeight112@defaultBean@servletRequest"
                   idBase="flexPerfChart" />
                </uix:case>
                <uix:case name="false">
                 <db:flexRegion
                   swfName="/database/flex/perf.swf"
                   dataSrcKeyBinding="flexKey@defaultBean@servletRequest"
                   optionsBinding="refreshChoiceFlex@servletRequest"
                   windowWidth="100%"
                   windowHeightBinding="flexWindowHeight11@defaultBean@servletRequest"
                   idBase="flexPerfChart" />
                </uix:case>
                </uix:switcher>
                </uix:case> 
                <uix:case name="false">
                  <db:flexRegion
                    swfName="/database/flex/perfPre11.swf"
                    dataSrcKeyBinding="flexKey@defaultBean@servletRequest"
                    optionsBinding="refreshChoiceFlex@servletRequest"
                    windowWidth="100%"
                    windowHeightBinding="flexWindowHeightPre11@defaultBean@servletRequest"
                    idBase="flexPerfChart" />
                </uix:case>
              </uix:switcher>
            </uix:case>
          </uix:switcher>
          <%@ include file="/database/instance/monitoringLinks.jspf" %>

        </uix:flowLayout>

    </uix:subTabLayout>

    <oem:relatedLinks />
   </uix:pageLayout>
    </db:form>
   </uix:body>
  </uix:document> 
</uix:renderingContext>
