<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 

<script>
 function scroll_timechart(direction)
 {
   if (direction == 'prev'){
     document.foo.direction.value = '1';
   }
   else{
     document.foo.direction.value = '2';
   }
   submitForm('foo', true, {'event':'scrollChart'});
 }

  function my_goto_band(selIdx, startMS, endMS)
  {
    document.foo.selectedBand.value  = selIdx;
    submitForm('foo', true, {'event':'sliderChanged','startLong':startMS,'endLong':endMS});
  }  

 function resizeFlexHeight(height)
 {
   document.getElementById('flexHistPerfChartObjectId').style.height=height;
   document.getElementById('flexHistPerfChartEmbedId').style.height=height;
 }

</script>
  
  <uix:document> 

  <uix:metaContainer>
    <db:script src="/database/utils.js"/> 
  </uix:metaContainer>
    
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
    <db:form name="foo" method="get" destination="/console/database/instance/sitemap"
      copyParams="target,type,startLong,endLong,pageName">
    <uix:pageLayout titleBinding="historicHeader@servletRequest">
    
    <uix:switcher childNameBinding="showWarning@servletRequest">
    <uix:case name="true">
      <uix:messageBox messageType="warning" automatic="false" 
         messageBinding="warningText@servletRequest" >
        <uix:contents childDataBinding="warningData@servletRequest">
          <uix:link textBinding="statName" destinationBinding="statLink" />
        </uix:contents>
      </uix:messageBox>  
    </uix:case>
    </uix:switcher>
    
    
    <%@ include file="/database/global.jspf" %>

    <oem:messageBox messageType="warning"
        errorTableBinding="intervalWarning@servletRequest"
              mainTextKey="exceptionText"/>

    <oem:messageBox messageType="error"
        errorTableBinding="intervalError@servletRequest"
        mainTextKey="exceptionText"/>

    <uix:contextSwitcher>
    <uix:switcher childNameBinding="showSwitchToList@servletRequest">
    <uix:case name="true">
            <uix:rowLayout>
                <uix:cellFormat vAlign="middle" wrappingDisabled="true">
                  <uix:styledText styleClass="OraPromptText" 
                        textBinding="SWITCH_TO@DBMsgBundle@servletRequest"/>  
                 </uix:cellFormat>
                 <uix:cellFormat vAlign="middle" wrappingDisabled="true">
                  <uix:spacer width="1"/>
                  <oem:choice name="newTarget"
                      onChange="submitForm('foo', true, {'event':'switchTo','pageNum':'2'})"
                      optionsBinding="racSwitchToList@servletRequest"
                      selectedValueBinding="targetName@defaultBean@servletRequest"/>
                 </uix:cellFormat>     
              </uix:rowLayout>
    </uix:case>
    </uix:switcher>
    </uix:contextSwitcher>
   
    <uix:formValue name="event"/>
    <uix:formValue name="pageNum" value="2"/>
    <uix:formValue name="pageName" value="/database/instance/sitemap/healthHist"/>
    <uix:formValue name="mode" valueBinding="mode@servletRequest"/>
    <uix:formValue name="instanceVersion" valueBinding="instanceVersion@servletRequest"/>
    <uix:formValue name="direction" value=""/>
    <uix:formValue name="selectedBand" value=""/>
    <uix:formParameter name="startLong"/>
    <uix:formParameter name="endLong"/>

     <uix:subTabLayout>
        <uix:subTabs>
	  <uix:switcher childNameBinding="repositoryMode@servletRequest">
	  <uix:case name="true">
          <uix:subTabBar selectedIndex="1">
              <uix:link textBinding="HOME@DBMsgBundle@servletRequest"
               destinationBinding="sitemapDest@servletRequest" />
              <uix:link textBinding="PERFORMANCE_HEADER@DBMsgBundle@servletRequest" />    
<%--
              <uix:link textBinding="ADMINISTRATION@DBMsgBundle@servletRequest"
                destinationBinding="adminDest@servletRequest" />
              <uix:link textBinding="SOFTWARE_MAINT@DBMsgBundle@servletRequest"
                destinationBinding="softMaintDest@servletRequest" />
--%>
              <uix:link textBinding="TAB_AVAILABILITY@DBMsgBundle@servletRequest"
                 destinationBinding="tabAvailabilityDest@servletRequest"/>
              <uix:link textBinding="TAB_SERVER@DBMsgBundle@servletRequest"
                 destinationBinding="tabServerDest@servletRequest"/>
              <uix:link textBinding="TAB_SCHEMA@DBMsgBundle@servletRequest"
                 destinationBinding="tabSchemaDest@servletRequest"/>
              <uix:link textBinding="TOPOLOGY@racMsgBundle@servletRequest"
                 destinationBinding="topologyDest@servletRequest" 
                 renderedBinding="RacDbScope@servletRequest" />
              <uix:link textBinding="TAB_DATA_MOVEMENT@DBMsgBundle@servletRequest"
                 destinationBinding="tabDataMovementDest@servletRequest"/>
              <uix:link textBinding="TAB_SOFTWARE_SUPPORT@DBMsgBundle@servletRequest"
                 destinationBinding="tabSoftwareSupportDest@servletRequest"/>
          </uix:subTabBar>
	  </uix:case>
	    <uix:case name="false">
          <uix:subTabBar selectedIndex="1">
              <uix:link textBinding="HOME@DBMsgBundle@servletRequest"
               destinationBinding="sitemapDest@servletRequest" />
              <uix:link textBinding="PERFORMANCE_HEADER@DBMsgBundle@servletRequest" />    
              <uix:link textBinding="ADMINISTRATION@DBMsgBundle@servletRequest"
                destinationBinding="adminDest@servletRequest" />
           </uix:subTabBar>
	    </uix:case>
	  </uix:switcher>

        </uix:subTabs>
        
    <uix:spacer height="1" />

   <uix:flowLayout>
    <uix:tableLayout width="100%">

            <uix:rowLayout vAlign="center" >

            <uix:switcher childNameBinding="useSVG@historicBean@servletRequest">
            <uix:case name="true">
              <uix:cellFormat hAlign="left" renderedBinding="version_gte11@historicBean@servletRequest">
                <uix:messagePrompt promptBinding="BSLN_NAME@DBMsgBundle@servletRequest" />
                <uix:spacer width="10" />
                <uix:styledText styleClass="OraDataText"
                                textBinding="baselineDisplayName@historicBean@servletRequest" />
               </uix:cellFormat>
              </uix:case>
              </uix:switcher>


               <uix:cellFormat hAlign="right" vAlign="center">
                    <uix:button textBinding="SETTINGS_WORD@DBMsgBundle@servletRequest"
                            renderedBinding="version_gte11@historicBean@servletRequest"
                            destinationBinding="customizeDest@servletRequest" />
               <uix:spacer width="20" /> 
               <uix:switcher childNameBinding="instDown@historicBean@servletRequest">
        <uix:case name="false">
                    <uix:styledText styleClass="OraFieldText" 
                        textBinding="VIEW_DATA@DBMsgBundle@servletRequest"
                        labeledNodeId="ViewLabel" />
                    <uix:choice name="refreshChoice" id="ViewLabel"
                            onChange="submitForm('foo', true, {'event':'doLoad','pageNum':'2'})">
                        <uix:option textBinding="REAL_TIME_AUTO_15_SEC@DBMsgBundle@servletRequest"
                            value="RT_15"/>
                        <uix:option textBinding="REAL_TIME_1_MIN@DBMsgBundle@servletRequest"
                            value="RT_60"/> 
                        <uix:option textBinding="REAL_TIME_MANUAL@DBMsgBundle@servletRequest"
                            value="RT_MAN"/>
                        <uix:option textBinding="HISTORICAL@DBMsgBundle@servletRequest"
                            value="HIST_CUST" selected="true"/>  
                    </uix:choice>
                      </uix:case>
         </uix:switcher> 
                </uix:cellFormat>
              </uix:rowLayout>
        </uix:tableLayout>        


        <uix:rowLayout  width="100%">
            <uix:switcher childNameBinding="showData@historicBean@servletRequest">
                <uix:case name="true">
                <uix:switcher childNameBinding="useSVG@historicBean@servletRequest">
                <uix:case name="false">
                  <uix:header textBinding="HIST_INTERVAL_SELECTION@DBMsgBundle@servletRequest" >
                    <uix:tableLayout>
                      <uix:rowLayout hAlign="left">
                        <uix:messagePrompt promptBinding="TIME_BAND_24HOUR_INSTR@DBMsgBundle@servletRequest" />
                      </uix:rowLayout>
                    </uix:tableLayout>
                  </uix:header>
                </uix:case>
                </uix:switcher>
                </uix:case>
            </uix:switcher>
        </uix:rowLayout>
    

      <uix:switcher childNameBinding="useSVG@historicBean@servletRequest">
           <uix:case name="false">
            <uix:tableLayout width="100%" 
              renderedBinding="showData@historicBean@servletRequest">
              <uix:rowLayout hAlign="left">
                <oem:chart 
                    chartType="timeSeriesChart"
                    width="850"
                    height="100"
                    timeGranularity="SECOND" 
                    orientation="vertical"
                    seriesColorsAutomatic="true"
                    legendPosition="east" 
                    legendVisible="true"
                    fill="cumulative"
                    yAxisLabelBinding="RC_SESSIONS@DBMsgBundle@servletRequest"
                    titleBinding="RC_SESSIONS@DBMsgBundle@servletRequest"
                    titleVisible="false"
                    xAxisMinBinding="beginDate@waitsBean@servletRequest"
                    xAxisMaxBinding="endDate@waitsBean@servletRequest"
                    yAxisWidth="30"
                    format="svg"
                    svgTimebandTipBinding="WAIT_DETAIL_SELECTOR_TIP@DBMsgBundle@servletRequest"
                    colorPaletteBinding="nonStaticPickerColors@waitsChart@waitsBean@servletRequest"
                    axisMaxBinding="maxValue@waitsBean@servletRequest"
                    svgHighlightLegend="true"
                >
                  <uix:contents>
                    <oem:timeSelector
                      xAxisMinBinding="beginDate@waitsBean@servletRequest"
                      xAxisMaxBinding="endDate@waitsBean@servletRequest"
                      intervalTimeSecBinding="intervalTimeSec@servletRequest"
                      height="20"
                      selectedMaxDateBinding="selectedMaxDate@servletRequest"
                      selectedMinDateBinding="selectedMinDate@servletRequest"
                      numBandsSelectedBinding="numBandsSelected@servletRequest"
                      selectionDest="my_goto_band"
                      selectionDestType="JavaScript"
                      selectionAltTextBinding="SELECT_PERIOD_RANGE@DBMsgBundle@servletRequest" 
                      position="south"
                      dynamicTimeSelector="true"
                      xAxisScrollDest="scroll_timechart"
                      xAxisScrollDestType="JavaScript"
                      xAxisScrollPrev="true"
                      xAxisScrollPrevAltTextBinding="GO_BACKWARD@DBMsgBundle@servletRequest" 
                      xAxisScrollNext="true"
                      xAxisScrollNextAltTextBinding="GO_FORWARD@DBMsgBundle@servletRequest" 
                      selectionIndicator="shading"
                      dynamicTimeSelectorColorBinding="sliderColor@waitsChart@waitsBean@servletRequest"
                      dynamicTimeSelectorEdgeColorBinding="sliderEdgeColor@waitsChart@waitsBean@servletRequest"                      
                    >
                    </oem:timeSelector>
                    <oem:boundChartDataSource 
                      chartDataSourceBinding="chartDataSource@waitsBean@servletRequest"/>               
                    <oem:chartColumn                                   
                        isKey="true" 
                        displayLabel=""
                        sourceIndex="0" />
                    <oem:chartColumn
                        isTimeColumn="true"
                        displayLabel="Time"
                        sourceIndex="1"  />
                    <oem:chartColumn                                   
                        displayLabel=""
                        sourceIndex="2" />
                  </uix:contents>
                </oem:chart>

              </uix:rowLayout>  
           </uix:tableLayout>

        </uix:case>
       </uix:switcher>


    <uix:switcher childNameBinding="showData@historicBean@servletRequest">
      <uix:case name="true">
       <uix:switcher childNameBinding="useSVG@historicBean@servletRequest">
        <uix:case name="false">
      <uix:switcher childNameBinding="intervalLessThan1Day@waitsBean@servletRequest">
        <uix:case name="false">
        <uix:tableLayout width="100%">
          <uix:rowLayout>
            <uix:header size="1"
              textBinding="HIST_24HOUR_DETAIL_HDR@DBMsgBundle@servletRequest"/>
          </uix:rowLayout>
        </uix:tableLayout>
    	 </uix:case>
      </uix:switcher>    
    	 </uix:case>
      </uix:switcher>
     </uix:case>
   </uix:switcher>

      

      <%-- interval picker --%>
 
      <uix:switcher childNameBinding="showData@historicBean@servletRequest">
        <uix:case name="true">
        <uix:switcher childNameBinding="useSVG@historicBean@servletRequest">
          <uix:case name="true">
            <uix:switcher childNameBinding="version_gte11_2@historicBean@servletRequest">
            <uix:case name="true">

              <db:flexRegion
                swfName="/database/flex/perf112Hist.swf"
                dataSrcKeyBinding="flexKey@historicBean@servletRequest"
                windowWidth="100%"
                windowHeightBinding="flexWindowHeight112@historicBean@servletRequest"
                idBase="flexHistPerfChart" />

             </uix:case>
            <uix:case name="false">
            <uix:switcher childNameBinding="version_gte11@historicBean@servletRequest">
            <uix:case name="true">
	   

         <db:flexRegion
                swfName="/database/flex/perfHist.swf"
                dataSrcKeyBinding="flexKey@historicBean@servletRequest"
                windowWidth="100%"
                windowHeightBinding="flexWindowHeight11@historicBean@servletRequest"
                idBase="flexHistPerfChart" />



      </uix:case>
      <uix:case name="false">

        <db:flexRegion
                swfName="/database/flex/perfPre11Hist.swf"
                dataSrcKeyBinding="flexKey@historicBean@servletRequest"
                windowWidth="100%"
                windowHeightBinding="flexWindowHeightPre11@historicBean@servletRequest"
                idBase="flexHistPerfChart" />


          </uix:case>
        </uix:switcher>
         </uix:case>
        </uix:switcher>

          </uix:case>
        </uix:switcher>
	    </uix:case>
	   </uix:switcher>

        <uix:tableLayout>
          <uix:rowLayout hAlign="left"
              renderedBinding="showSVGMsg@servletRequest">
            <uix:link styleClass="OraDataText"
              textBinding="GET_SVG_PLUGIN@DBMsgBundle@servletRequest"
              destinationBinding="svgPluginURL@servletRequest"/>
          </uix:rowLayout>
         </uix:tableLayout>     


       <uix:switcher childNameBinding="showData@historicBean@servletRequest">
        <uix:case name="true">
          <uix:switcher childNameBinding="repositoryMode@servletRequest">
          <uix:case name="true">       

          <uix:header textBinding="HOST@DBMsgBundle@servletRequest"
            renderedBinding="notUseSVG@historicBean@servletRequest">

            <uix:tableLayout width="100%" 
                renderedBinding="notUseSVG@historicBean@servletRequest">
              <uix:rowLayout hAlign="left">
                <oem:chart 
                    chartType="timeSeriesChart"
                    width="800"
                    height="125"
                    timeGranularity="MINUTE" 
                    orientation="vertical"
                    legendPosition="east" 
                    legendVisible="external"
                    fill="none"
                    yAxisLabelBinding="RUNNABLE_PROCESSES@DBMsgBundle@servletRequest"
                    titleBinding="HOST@DBMsgBundle@servletRequest"
                    titleVisible="false"
                    yAxisWidth="30"
                >
                  <uix:contents>
                    <oem:boundChartDataSource 
                      chartDataSourceBinding="historicHostRunqueueChartGIF@historicBean@servletRequest"/>               
                    <oem:chartColumn                                   
                        isKey="true" 
                        displayLabel=""
                        sourceIndex="0" />
                    <oem:chartColumn
                        isTimeColumn="true"
                        displayLabel="Time"
                        sourceIndex="1"  />
                    <oem:chartColumn                                   
                        displayLabel=""
                        sourceIndex="2" />
                  </uix:contents>
                </oem:chart>

              </uix:rowLayout>  
           </uix:tableLayout>
           
          </uix:header> 
          </uix:case>
       </uix:switcher>
        </uix:case>
     </uix:switcher>

       <uix:switcher childNameBinding="showData@historicBean@servletRequest">
        <uix:case name="true">
        <uix:header textBinding="AVERAGE_ACTIVE_SESSIONS@DBMsgBundle@servletRequest"
          renderedBinding="notUseSVG@historicBean@servletRequest"> 

                <oem:chart 
                    chartType="timeSeriesChart"
                    width="800"
                    height="200"
                    timeGranularity="MINUTE" 
                    orientation="vertical"
                    legendPosition="east" 
                    legendVisible="external"
                    fill="cumulative"  
                    yAxisLabelBinding="ACTIVE_SESSIONS@DBMsgBundle@servletRequest"
                    titleBinding="AVERAGE_ACTIVE_SESSIONS@DBMsgBundle@servletRequest"
                    titleVisible="false" 
                    yAxisWidth="30"
                    colorPaletteBinding="waitsColorTable@historicWaitsChart@historicBean@servletRequest"
                >
                  <uix:contents>
                    <oem:boundChartDataSource 
                      chartDataSourceBinding="chartTagDataSource@historicWaitsChart@historicBean@servletRequest"/>               
                    <oem:imageMap imageMapDataSourceBinding="waitsImageDataSource@servletRequest"/>
                    <oem:chartColumn                                   
                        isKey="true" 
                        displayLabel=""
                        sourceIndex="0" />
                    <oem:chartColumn
                        isTimeColumn="true"
                        displayLabel="Time"
                        sourceIndex="1"  />
                    <oem:chartColumn                                   
                        displayLabel=""
                        sourceIndex="2" />
                  </uix:contents>
                </oem:chart>

             
              <uix:rowLayout hAlign="right">
                <uix:link textBinding="ACTIVITY_DETAILS@DBMsgBundle@servletRequest"
                  destinationBinding="rightSideHeaderURL@historicWaitsChart@historicBean@servletRequest" />
              </uix:rowLayout>               
 
            </uix:header>
        </uix:case>
     </uix:switcher>


  <uix:switcher childNameBinding="useSVG@historicBean@servletRequest">
   <uix:case name="false">
   <uix:subTabLayout renderedBinding="showData@historicBean@servletRequest">
      <uix:subTabs>
        <uix:subTabBar 
          selectedIndexBinding="perfTabSelection@servletRequest">
            <uix:contents childDataBinding="tabsList@defaultBean@servletRequest">
              <uix:link renderedBinding="render"
                        textBinding="text"
                        onClickBinding="onClick"/>
            </uix:contents>
        </uix:subTabBar>
      </uix:subTabs>
 


       <uix:header textBinding="IO_CHART_HEADER@DBMsgBundle@servletRequest" renderedBinding="showIOGifChart@historicBean@servletRequest"> 

	  <oem:chart 
	      chartType="timeSeriesChart"
	      width="800"
	      height="100"
	      timeGranularity="MINUTE" 
	      orientation="vertical"
	      legendPosition="east" 
	      legendVisible="external"
	      fill="cumulative"  
	      yAxisLabelBinding="SP_PER_SECOND@DBMsgBundle@servletRequest"
	      titleBinding="IO_CHART_HEADER@DBMsgBundle@servletRequest"
	      titleVisible="false" 
	      yAxisWidth="30"
	      colorPaletteBinding="IOColorsBinding@historicBean@servletRequest"
	  >
	    <uix:contents>
	      <oem:boundChartDataSource 
		chartDataSourceBinding="IOChartGIF@historicBean@servletRequest"/>               
	      <oem:chartColumn                                   
		  isKey="true" 
		  displayLabel=""
		  sourceIndex="0" />
	      <oem:chartColumn
		  isTimeColumn="true"
		  displayLabel="Time"
		  sourceIndex="1"  />
	      <oem:chartColumn                                   
		  displayLabel=""
		  sourceIndex="2" />
	    </uix:contents>
	  </oem:chart>
	</uix:header>



    <uix:switcher childNameBinding="useSVG@historicBean@servletRequest">
     <uix:case name="false">

    <uix:switcher childNameBinding="showThroughputTab@historicBean@servletRequest">
        <uix:case name="true">

         <uix:flowLayout renderedBinding="showThroughputRadios@historicBean@servletRequest">
	      <uix:spacer width="40" height="0"/>
              <uix:messagePrompt promptBinding="THROUGHPUT_RATE@DBMsgBundle@servletRequest" styleClass="OraCopyright"/>
                <uix:flowLayout>
                <uix:contents childDataBinding="rateTypesList@historicBean@servletRequest">
                  <uix:radioButton
                            textBinding="text"
                            valueBinding="val" 
                            onClickBinding="onclick"
                            selectedBinding="selected" 
			    styleClass="OraCopyright"/> 
                </uix:contents> 
               </uix:flowLayout>  
          </uix:flowLayout>
          </uix:case>
        </uix:switcher>
          </uix:case>
        </uix:switcher>

       <uix:switcher childNameBinding="showThroughputTab@historicBean@servletRequest">
        <uix:case name="true">
           <uix:header textBinding="THROUGHPUT@DBMsgBundle@servletRequest"
            renderedBinding="notUseSVG@historicBean@servletRequest">   

            <uix:tableLayout width="100%" 
                renderedBinding="notUseSVG@historicBean@servletRequest">
            <uix:rowLayout hAlign="left"
                renderedBinding="showSysstatChart@historicBean@servletRequest">
                <oem:chart 
                    chartType="timeSeriesChart"
                    width="800"
                    height="100"
                    timeGranularity="MINUTE" 
                    orientation="vertical"
                    legendPosition="east" 
                    legendVisible="external"
                    fill="none"
                    titleBinding="THROUGHPUT@DBMsgBundle@servletRequest"
                    titleVisible="false"
                    yAxisLabelBinding="systatYAxisLabels@historicBean@servletRequest"
                    yAxisWidth="30"
                >
                  <uix:contents>
                    <oem:boundChartDataSource 
                      chartDataSourceBinding="sysstatChartGIF@historicBean@servletRequest"/>    
                    <oem:imageMap imageMapDataSourceBinding="systatImageDataSource@servletRequest"/>
                    <oem:chartColumn                                   
                        isKey="true" 
                        displayLabel=""
                        sourceIndex="0" />
                    <oem:chartColumn
                        isTimeColumn="true"
                        displayLabel="Time"
                        sourceIndex="1"  />
                    <oem:chartColumn                                   
                        displayLabel=""
                        sourceIndex="2" />
                  </uix:contents>
                </oem:chart>
              </uix:rowLayout>  
            </uix:tableLayout>

            <uix:tableLayout width="100%" 
                renderedBinding="notUseSVG@historicBean@servletRequest">
            <uix:rowLayout hAlign="left">
                <oem:chart 
                    chartType="timeSeriesChart"
                    width="800"
                    height="100"
                    timeGranularity="MINUTE" 
                    orientation="vertical"
                    legendPosition="east" 
                    legendVisible="external"
                    fill="none"
                    yAxisLabelBinding="systatYAxisLabels@historicBean@servletRequest"
                    titleBinding="BLOCKS@DBMsgBundle@servletRequest"
                    titleVisible="false"
                    yAxisWidth="30"
                >
                  <uix:contents>
                    <oem:boundChartDataSource 
                      chartDataSourceBinding="sysstatChartBlocksGIF@historicBean@servletRequest"/>
                    <oem:imageMap imageMapDataSourceBinding="systatBlocksImageDataSource@servletRequest"/>  
                    <oem:chartColumn                                   
                        isKey="true" 
                        displayLabel=""
                        sourceIndex="0" />
                    <oem:chartColumn
                        isTimeColumn="true"
                        displayLabel="Time"
                        sourceIndex="1"  />
                    <oem:chartColumn                                   
                        displayLabel=""
                        sourceIndex="2" />
                  </uix:contents>
                </oem:chart>
              </uix:rowLayout>  
            </uix:tableLayout>

            </uix:header> 
            </uix:case>
          </uix:switcher>

    



<uix:tableLayout width="100%" renderedBinding="showIOTab@historicBean@servletRequest">     

<uix:rowLayout hAlign="left" renderedBinding="notUseSVG@historicBean@servletRequest">
    <oem:chart 
        chartType="timeSeriesChart"
        width="800"
        height="100"
        timeGranularity="SECOND"
        orientation="vertical"
        legendPosition="east" 
        legendVisible="external"
        fill="none"
        titleBinding="LATENCY_SINGLE_BLOCK_READS@DBMsgBundle@servletRequest"
        titleVisible="true"         
        yAxisLabelBinding="MS@DBMsgBundle@servletRequest"
        yAxisWidth="50"
    >
      <uix:contents>
        <oem:boundChartDataSource 
          chartDataSourceBinding="IOLatencyGIF@historicBean@servletRequest"/>
       
        <oem:chartColumn                                   
            isKey="true" 
            displayLabel=""
            sourceIndex="0" />
        <oem:chartColumn
            isTimeColumn="true"
            displayLabel="Time"
            sourceIndex="1"  />
        <oem:chartColumn                                   
            displayLabel=""
            sourceIndex="2" />
      </uix:contents>
    </oem:chart>
  </uix:rowLayout>  
  


         <uix:tableLayout renderedBinding="notUseSVG@historicBean@servletRequest">
            <uix:rowLayout hAlign="left">
              <uix:messagePrompt promptBinding="IO_BREAKDOWN@DBMsgBundle@servletRequest" styleClass="OraCopyright"/>
                <uix:flowLayout>
                <uix:contents childDataBinding="IOTypesList@historicBean@servletRequest">
                  <uix:radioButton
                            textBinding="text"
                            valueBinding="val" 
                            onClickBinding="onclick"
                            selectedBinding="selected"
			    styleClass="OraCopyright" /> 
                </uix:contents> 
               </uix:flowLayout>  
            </uix:rowLayout>
          </uix:tableLayout>




  <uix:rowLayout hAlign="left" renderedBinding="notUseSVG@historicBean@servletRequest">
    <oem:chart 
        chartType="timeSeriesChart"
        width="800"
        height="250"
        timeGranularity="SECOND"
        orientation="vertical"
        legendPosition="east" 
        legendVisible="external"
        fill="cumulative"
        titleBinding="IOThroughputChartHeader@defaultBean@servletRequest"
        titleVisible="true" 
        yAxisLabelBinding="MB_PER_SECOND@DBMsgBundle@servletRequest"
        yAxisWidth="50"
        colorPaletteBinding="ioColors@IOThroughputChart@historicBean@servletRequest"
    >
      <uix:contents>
        <oem:boundChartDataSource 
          chartDataSourceBinding="IOThroughputGIF@historicBean@servletRequest"/>
        <oem:imageMap imageMapDataSourceBinding="IOThroughputImageMap@historicBean@servletRequest"/>

        <oem:chartColumn                                   
            isKey="true" 
            displayLabel=""
            sourceIndex="0" />
        <oem:chartColumn
            isTimeColumn="true"
            displayLabel="Time"
            sourceIndex="1"  />
        <oem:chartColumn                                   
            displayLabel=""
            sourceIndex="2" />
      </uix:contents>
    </oem:chart>
  </uix:rowLayout>  
  
<uix:rowLayout hAlign="left" renderedBinding="notUseSVG@historicBean@servletRequest">
    <oem:chart 
        chartType="timeSeriesChart"
        width="800"
        height="250"
        timeGranularity="SECOND"
        orientation="vertical"
        legendPosition="east" 
        legendVisible="external"
        fill="cumulative"
        titleBinding="IORateChartHeader@defaultBean@servletRequest"
        titleVisible="true" 
        yAxisLabelBinding="IO_PER_SECOND@DBMsgBundle@servletRequest"
        yAxisWidth="50"
        colorPaletteBinding="ioColors@IORateChart@historicBean@servletRequest"
    >
      <uix:contents>
        <oem:boundChartDataSource 
          chartDataSourceBinding="IORateGIF@historicBean@servletRequest"/>

        <oem:imageMap imageMapDataSourceBinding="IORateImageMap@historicBean@servletRequest"/>

        <oem:chartColumn                                   
            isKey="true" 
            displayLabel=""
            sourceIndex="0" />
        <oem:chartColumn
            isTimeColumn="true"
            displayLabel="Time"
            sourceIndex="1"  />
        <oem:chartColumn                                   
            displayLabel=""
            sourceIndex="2" />
      </uix:contents>
    </oem:chart>
  </uix:rowLayout>  
  
</uix:tableLayout>


<uix:tableLayout width="100%" renderedBinding="showPQTab@historicBean@servletRequest">
  <uix:rowLayout hAlign="left" renderedBinding="notUseSVG@historicBean@servletRequest">
    <oem:chart 
        chartType="timeSeriesChart"
        width="800"
        height="100"
        timeGranularity="SECOND"
        orientation="vertical"
        legendPosition="east" 
        legendVisible="external"
        fill="cumulative"
        titleBinding="PQ@DBMsgBundle@servletRequest"
        titleVisible="false"         
        yAxisLabelBinding="RC_SESSIONS@DBMsgBundle@servletRequest"
        yAxisWidth="50"
    >
      <uix:contents>
        <oem:boundChartDataSource 
          chartDataSourceBinding="PQSerialParallelGIF@historicBean@servletRequest"/>
        <oem:imageMap imageMapDataSourceBinding="PQSerialParallelImageMap@historicBean@servletRequest"/>
        <oem:chartColumn                                   
            isKey="true" 
            displayLabel=""
            sourceIndex="0" />
        <oem:chartColumn
            isTimeColumn="true"
            displayLabel="Time"
            sourceIndex="1"  />
        <oem:chartColumn                                   
            displayLabel=""
            sourceIndex="2" />
      </uix:contents>
    </oem:chart>
  </uix:rowLayout>  
  
  
  <uix:rowLayout hAlign="left" renderedBinding="notUseSVG@historicBean@servletRequest">
    <oem:chart 
        chartType="timeSeriesChart"
        width="800"
        height="100"
        timeGranularity="SECOND"
        orientation="vertical"
        legendPosition="east" 
        legendVisible="external"
        fill="cumulative"
        titleBinding="PARALLEL_QC@DBMsgBundle@servletRequest"
        titleVisible="false"         
        yAxisLabelBinding="RC_SESSIONS@DBMsgBundle@servletRequest"
        yAxisWidth="50"
    >
      <uix:contents>
        <oem:boundChartDataSource 
          chartDataSourceBinding="PQ_QC_SlaveGIF@historicBean@servletRequest"/>
          <%--
        <oem:imageMap imageMapDataSourceBinding="systatImageDataSource@servletRequest"/>
        --%>
        <oem:chartColumn                                   
            isKey="true" 
            displayLabel=""
            sourceIndex="0" />
        <oem:chartColumn
            isTimeColumn="true"
            displayLabel="Time"
            sourceIndex="1"  />
        <oem:chartColumn                                   
            displayLabel=""
            sourceIndex="2" />
      </uix:contents>
    </oem:chart>
  </uix:rowLayout>  
  
  <uix:rowLayout hAlign="left" renderedBinding="notUseSVG@historicBean@servletRequest">
    <oem:chart 
        chartType="timeSeriesChart"
        width="800"
        height="100"
        timeGranularity="SECOND"
        orientation="vertical"
        legendPosition="east" 
        legendVisible="external"
        fill="cumulative"
        titleBinding="QUERIES_PARALLELIZED@DBMsgBundle@servletRequest"
        titleVisible="false"         
        yAxisLabelBinding="SP_PER_SECOND@DBMsgBundle@servletRequest"
        yAxisWidth="50"
    >
      <uix:contents>
        <oem:boundChartDataSource 
          chartDataSourceBinding="PQ_Ddl_DmlGIF@historicBean@servletRequest"/>
          <%--
        <oem:imageMap imageMapDataSourceBinding="systatImageDataSource@servletRequest"/>
        --%>
        <oem:chartColumn                                   
            isKey="true" 
            displayLabel=""
            sourceIndex="0" />
        <oem:chartColumn
            isTimeColumn="true"
            displayLabel="Time"
            sourceIndex="1"  />
        <oem:chartColumn                                   
            displayLabel=""
            sourceIndex="2" />
      </uix:contents>
    </oem:chart>
  </uix:rowLayout>  
  
  
  <uix:rowLayout hAlign="left" renderedBinding="notUseSVG@historicBean@servletRequest">
    <oem:chart 
        chartType="timeSeriesChart"
        width="800"
        height="100"
        timeGranularity="SECOND"
        orientation="vertical"
        legendPosition="east" 
        legendVisible="external"
        fill="cumulative"
        titleBinding="SERIALIZED@DBMsgBundle@servletRequest"
        titleVisible="false"         
        yAxisLabelBinding="SP_PER_SECOND@DBMsgBundle@servletRequest"
        yAxisWidth="50"
    >
      <uix:contents>
        <oem:boundChartDataSource 
          chartDataSourceBinding="PQDowngradesGIF@historicBean@servletRequest"/>
          <%--
        <oem:imageMap imageMapDataSourceBinding="systatImageDataSource@servletRequest"/>
        --%>
        <oem:chartColumn                                   
            isKey="true" 
            displayLabel=""
            sourceIndex="0" />
        <oem:chartColumn
            isTimeColumn="true"
            displayLabel="Time"
            sourceIndex="1"  />
        <oem:chartColumn                                   
            displayLabel=""
            sourceIndex="2" />
      </uix:contents>
    </oem:chart>
  </uix:rowLayout>  
  
</uix:tableLayout>





<uix:tableLayout width="100%" renderedBinding="showServicesTab@historicBean@servletRequest">

 <uix:rowLayout hAlign="left" renderedBinding="notUseSVG@historicBean@servletRequest">
    <oem:chart 
        chartType="timeSeriesChart"
        width="800"
        height="200"
        timeGranularity="SECOND"
        orientation="vertical"
        legendPosition="east" 
        legendVisible="external"
        fill="cumulative"
        titleBinding="SERVICES@DBMsgBundle@servletRequest"
        titleVisible="false"         
        yAxisLabelBinding="ACTIVE_SESSIONS@DBMsgBundle@servletRequest"
        yAxisWidth="50"
    >
      <uix:contents>
        <oem:boundChartDataSource 
         chartDataSourceBinding="serviceChartGIF@historicBean@servletRequest"/>
        <oem:imageMap imageMapDataSourceBinding="servicesImageMap@historicBean@servletRequest"/>
        <oem:chartColumn                                   
            isKey="true" 
            displayLabel=""
            sourceIndex="0" />
        <oem:chartColumn
            isTimeColumn="true"
            displayLabel="Time"
            sourceIndex="1"  />
        <oem:chartColumn                                   
            displayLabel=""
            sourceIndex="2" />
      </uix:contents>
    </oem:chart>
  </uix:rowLayout>  

</uix:tableLayout>
















   </uix:subTabLayout>
     </uix:case>
     </uix:switcher>
     <uix:switcher childNameBinding="instDown@historicBean@servletRequest">
            <uix:case name="false">
          <%@ include file="/database/instance/monitoringLinks.jspf" %>
     </uix:case>
     </uix:switcher>

 
    </uix:flowLayout>
    </uix:subTabLayout>
        <uix:switcher childNameBinding="relatedLinkExist@servletRequest">
                  <uix:case name="true">
         <oem:relatedLinks />
                  </uix:case>
                </uix:switcher>

    
    <uix:spacer height="5"/>



   </uix:pageLayout>
   </db:form> 
   </uix:body>
  </uix:document> 
</uix:renderingContext> 
 
