<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 

  <uix:document> 

    <uix:metaContainer>
      <uix:head titleBinding="_emSDK_PageTitle@servletRequest">
        <%-- only need refresh if automatic refresh selected and not using SVG --%> 
        <uix:switcher childNameBinding="manualSelected@servletRequest">
          <uix:case name="false">
            <uix:rawText>
              <meta http-equiv="Cache-Control" content="max-age=0">
              <meta http-equiv="Refresh" content="<%=request.getAttribute("refreshChoiceGIF") %>">
            </uix:rawText> 
          </uix:case>  
        </uix:switcher>
      </uix:head>
    </uix:metaContainer>


    <uix:body>   
    <db:form name="foo" method="get" 
             destination="/console/database/instance/sitemap"
             copyParams="target,type">
    <uix:pageLayout titleBinding="header@defaultBean@servletRequest">
    
    <uix:switcher childNameBinding="showWarning@servletRequest">
    <uix:case name="true">
      <uix:messageBox messageType="warning" automatic="false" 
         messageBinding="warningText@servletRequest" >
        <uix:contents childDataBinding="warningData@servletRequest">
          <uix:link textBinding="statName" destinationBinding="statLink" />
        </uix:contents>
      </uix:messageBox>  
    </uix:case>
    </uix:switcher>
    
    <uix:contextSwitcher>
    <uix:switcher childNameBinding="showSwitchToList@servletRequest">
    <uix:case name="true">
            <uix:rowLayout>
                <uix:cellFormat vAlign="middle" wrappingDisabled="true">
                  <uix:styledText styleClass="OraPromptText" 
                        textBinding="SWITCH_TO@DBMsgBundle@servletRequest"/>  
                 </uix:cellFormat>
                 <uix:cellFormat vAlign="middle" wrappingDisabled="true">
                  <uix:spacer width="1"/>
                  <oem:choice name="newTarget"
                      onChange="submitForm('foo', true, {'event':'switchTo','pageNum':'2'})"
                      optionsBinding="racSwitchToList@servletRequest"
                      selectedValueBinding="targetName@defaultBean@servletRequest"/>
                 </uix:cellFormat>     
              </uix:rowLayout>
    </uix:case>
    </uix:switcher>
    </uix:contextSwitcher>
    
    <%@ include file="/database/global.jspf" %>

    <uix:formValue name="event"/>
    <uix:formValue name="datasource" valueBinding="datasource@servletRequest"/>
    <uix:formValue name="pageNum" value="2"/>
    <uix:formValue name="mode" valueBinding="mode@servletRequest"/>
    <uix:formValue name="instanceVersion" valueBinding="instanceVersion@servletRequest"/>
 
  <%--  <%@ include file="/uixPageGlobal.jspf" %>  --%>

     <uix:subTabLayout>
        <uix:subTabs>
          <uix:subTabBar selectedIndex="1">
              <uix:link textBinding="HOME@DBMsgBundle@servletRequest"
               destinationBinding="sitemapDest@servletRequest"/>
              <uix:link textBinding="PERFORMANCE_HEADER@DBMsgBundle@servletRequest" />    
<%--
              <uix:link textBinding="ADMINISTRATION@DBMsgBundle@servletRequest"
                destinationBinding="adminDest@servletRequest"/>
		  <uix:link textBinding="SOFTWARE_MAINT@DBMsgBundle@servletRequest"
                destinationBinding="softMaintDest@servletRequest"
                renderedBinding="repositoryMode@servletRequest"/>
--%>
              <uix:link textBinding="TAB_AVAILABILITY@DBMsgBundle@servletRequest"
                 destinationBinding="tabAvailabilityDest@servletRequest"/>
              <uix:link textBinding="TAB_SERVER@DBMsgBundle@servletRequest"
                 destinationBinding="tabServerDest@servletRequest"/>
              <uix:link textBinding="TAB_SCHEMA@DBMsgBundle@servletRequest"
                 destinationBinding="tabSchemaDest@servletRequest"/>
              <uix:link textBinding="TOPOLOGY@racMsgBundle@servletRequest"
                 destinationBinding="topologyDest@servletRequest" 
                 renderedBinding="RacDbScope@servletRequest" />
              <uix:link textBinding="TAB_DATA_MOVEMENT@DBMsgBundle@servletRequest"
                 destinationBinding="tabDataMovementDest@servletRequest"/>
              <uix:link textBinding="TAB_SOFTWARE_SUPPORT@DBMsgBundle@servletRequest"
                 destinationBinding="tabSoftwareSupportDest@servletRequest"/>
            </uix:subTabBar>
        </uix:subTabs>

        <uix:spacer height="1" />

        <uix:flowLayout>
          <uix:tableLayout width="100%" renderedBinding="isSGAEnable@servletRequest">
             <uix:rowLayout >
                <uix:cellFormat>
                   <uix:styledText styleClass="OraDataText"
                                   textBinding="SGA_ENABLED@DBMsgBundle@servletRequest" />
                 </uix:cellFormat>
                 <uix:cellFormat hAlign="right">
                   <uix:button textBinding="SGA_DISABLE@DBMsgBundle@servletRequest" 
                      destinationBinding="SGADisableURL@servletRequest"/>
                   <uix:spacer width = "5" />
                   <uix:button textBinding="SGA_SWITCHSQL@DBMsgBundle@servletRequest" 
                      destinationBinding="SwitchToSQLURL@servletRequest"/>
                 </uix:cellFormat>
              </uix:rowLayout >
              <uix:rowLayout >
                 <uix:spacer height="5" />
              </uix:rowLayout >
         </uix:tableLayout >


          <uix:tableLayout width="100%" >
            <uix:rowLayout>
              <uix:cellFormat>
                <uix:link styleClass="OraDataText"
                  renderedBinding="showSVGMsg@servletRequest"
                  textBinding="GET_SVG_PLUGIN@DBMsgBundle@servletRequest"
                  destinationBinding="svgPluginURL@servletRequest"/>
              </uix:cellFormat>

              <uix:cellFormat hAlign="right" vAlign="center">

                <uix:button textBinding="SETTINGS_WORD@DBMsgBundle@servletRequest"
                    renderedBinding="renderBaselineInfo@defaultBean@servletRequest"
                    destinationBinding="customizeDest@servletRequest" />

                <uix:spacer width="20" />

                  <uix:styledText styleClass="OraFieldText" 
                    textBinding="VIEW_DATA@DBMsgBundle@servletRequest" 
                    labeledNodeId="ViewLabel" />

                  <uix:choice name="refreshChoice" id="ViewLabel"
                      onChange="submitForm('foo', true, {'event':'doLoad','pageNum':'2'})"
                       selectedValueBinding="refreshChoiceSelected@servletRequest">
                    <uix:option textBinding="REAL_TIME_AUTO_15_SEC@DBMsgBundle@servletRequest"
                      value="RT_15"/>
                    <uix:option textBinding="REAL_TIME_1_MIN@DBMsgBundle@servletRequest"
                      value="RT_60"/> 
                    <uix:option textBinding="REAL_TIME_MANUAL@DBMsgBundle@servletRequest"
                      value="RT_MAN"/>
                    <uix:option textBinding="HISTORICAL@DBMsgBundle@servletRequest"
                      value="HIST_CUST" 
                      renderedBinding="notSgaMode@servletRequest" />  
                  </uix:choice>          

              </uix:cellFormat>
              
            </uix:rowLayout>
          </uix:tableLayout>

      <%-- host section --%>
      <uix:switcher childNameBinding="repositoryMode@servletRequest">
        <uix:case name="true">

        <uix:header textBinding="HOST@DBMsgBundle@servletRequest"> 


        <uix:tableLayout width="100%" 
          renderedBinding="notUseSVG@defaultBean@servletRequest">

          <%@ include file="runqueue.jspf" %>

         </uix:tableLayout>

        </uix:header> 
      </uix:case>
      </uix:switcher>

      <uix:header textBinding="AVERAGE_ACTIVE_SESSIONS@DBMsgBundle@servletRequest"> 
      
      <uix:rowLayout hAlign="right">
        <uix:button textBinding="ADDM_REPORT@DBMsgBundle@servletRequest"
          destinationBinding="runADDMLink@servletRequest" 
          renderedBinding="runADDMSupported@defaultBean@servletRequest" />
        <uix:spacer width="8" />
        <uix:button textBinding="ASH_REPORT@DBMsgBundle@servletRequest"
          destinationBinding="ashReportLink@servletRequest"  
          renderedBinding="instanceVersion_gte10gR2@defaultBean@servletRequest" />       
      </uix:rowLayout>       
      
       <uix:spacer height="25" /> 
      
        <oem:chart 
            chartType="timeSeriesChart"
            width="800"
            height="200"
            timeGranularity="SECOND"
            orientation="vertical"
            fill="cumulative"  
            legendPosition="east"
            legendVisible="external"
            titleBinding="SERVICE_TIME@DBMsgBundle@servletRequest"
            titleVisible="false"    
            colorPaletteBinding="waitsColorTable@waitsChart@defaultBean@servletRequest"
            yAxisWidth="30"
            yAxisNumberFormatBinding="oneDecimalChartFormat@defaultBean@servletRequest"
            axisMaxBinding="waitsChartGIFMaxValue@defaultBean@servletRequest"
        >
          <uix:contents>
            <oem:boundChartDataSource 
              chartDataSourceBinding="waitsChartGIF@defaultBean@servletRequest"/>
            <oem:imageMap imageMapDataSourceBinding="waitsImageDataSource@servletRequest"/>                     
            <oem:chartColumn                                   
                isKey="true" 
                displayLabel=""
                sourceIndex="0" />
            <oem:chartColumn
                isTimeColumn="true"
                displayLabel="Time"
                sourceIndex="1"  />
            <oem:chartColumn                                   
                displayLabel=""
                sourceIndex="2" />
          </uix:contents>
        </oem:chart>
    
      <uix:rowLayout hAlign="right">
        <uix:link textBinding="ACTIVITY_DETAILS@DBMsgBundle@servletRequest"
          destinationBinding="rightSideHeaderURL@waitsChart@defaultBean@servletRequest" />
      </uix:rowLayout>   
        
      </uix:header>

  <uix:spacer height="20" renderedBinding="showPerfTabs@defaultBean@servletRequest"/>

   <uix:subTabLayout>
      <uix:subTabs>
        <uix:subTabBar 
          selectedIndexBinding="perfTabSelection@servletRequest">
            <uix:contents childDataBinding="tabsList@defaultBean@servletRequest">
              <uix:link renderedBinding="render"
                        textBinding="text"
                        onClickBinding="onClick"/>
            </uix:contents>
        </uix:subTabBar>
      </uix:subTabs>

<uix:switcher childNameBinding="showThroughputHeader@defaultBean@servletRequest">
 <uix:case name="true">
        <uix:header textBinding="THROUGHPUT@DBMsgBundle@servletRequest">

            <uix:tableLayout width="100%" renderedBinding="onThroughputTab@defaultBean@servletRequest">
              <uix:rowLayout hAlign="left" renderedBinding="showSysstatChart@defaultBean@servletRequest">
                <oem:chart 
                    chartType="timeSeriesChart"
                    width="800"
                    height="100"
                    timeGranularity="SECOND"
                    orientation="vertical"
                    legendPosition="east" 
                    legendVisible="external"
                    fill="none"
                    titleBinding="THROUGHPUT@DBMsgBundle@servletRequest"
                    titleVisible="false"         
                    yAxisLabelBinding="sysstatChartYAxisLabel@defaultBean@servletRequest"
                    yAxisWidth="30"
                >
                  <uix:contents>
                    <oem:boundChartDataSource 
                      chartDataSourceBinding="sysstatChartGIF@defaultBean@servletRequest"/>
                    <oem:imageMap imageMapDataSourceBinding="systatImageDataSource@servletRequest"/>
                    <oem:chartColumn                                   
                        isKey="true" 
                        displayLabel=""
                        sourceIndex="0" />
                    <oem:chartColumn
                        isTimeColumn="true"
                        displayLabel="Time"
                        sourceIndex="1"  />
                    <oem:chartColumn                                   
                        displayLabel=""
                        sourceIndex="2" />
                  </uix:contents>
                </oem:chart>
              </uix:rowLayout>  
 
              <uix:rowLayout hAlign="left">
                <oem:chart 
                    chartType="timeSeriesChart"
                    width="800"
                    height="100"
                    timeGranularity="SECOND"
                    orientation="vertical"
                    legendPosition="east" 
                    legendVisible="external"
                    fill="none"
                    titleBinding="BLOCKS@DBMsgBundle@servletRequest"
                    titleVisible="false"          
                    yAxisLabelBinding="sysstatBlocksChartYAxisLabel@defaultBean@servletRequest"
                    yAxisWidth="30"
                >
                  <uix:contents>
                    <oem:boundChartDataSource 
                      chartDataSourceBinding="sysstatBlocksChartGIF@defaultBean@servletRequest"/>
                    <oem:imageMap imageMapDataSourceBinding="systatBlocksImageDataSource@servletRequest"/>
                    <oem:chartColumn                                   
                        isKey="true" 
                        displayLabel=""
                        sourceIndex="0" />
                    <oem:chartColumn
                        isTimeColumn="true"
                        displayLabel="Time"
                        sourceIndex="1"  />
                    <oem:chartColumn                                   
                        displayLabel=""
                        sourceIndex="2" />
                  </uix:contents>
                </oem:chart>
              </uix:rowLayout>  
            </uix:tableLayout>

       <uix:tableLayout renderedBinding="onThroughputTab@defaultBean@servletRequest">
            <uix:rowLayout hAlign="left">

              <uix:messagePrompt promptBinding="THROUGHPUT_RATE@DBMsgBundle@servletRequest" styleClass="OraCopyright"/>
                <uix:flowLayout>
                <uix:contents childDataBinding="rateTypesList@defaultBean@servletRequest">
                  <uix:radioButton 
                            textBinding="text"
                            valueBinding="val" 
                            onClickBinding="onclick"
                            selectedBinding="selected"
			    styleClass="OraCopyright" /> 
                </uix:contents> 
               </uix:flowLayout>  
            </uix:rowLayout>
          </uix:tableLayout>
        </uix:header>
                    
 </uix:case>
 <uix:case name="false">
  <uix:stackLayout>
       <uix:tableLayout renderedBinding="onThroughputTab@defaultBean@servletRequest">
            <uix:rowLayout hAlign="left">

              <uix:messagePrompt promptBinding="THROUGHPUT_RATE@DBMsgBundle@servletRequest" styleClass="OraCopyright"/>
                <uix:flowLayout>
                <uix:contents childDataBinding="rateTypesList@defaultBean@servletRequest">
                  <uix:radioButton 
                            textBinding="text"
                            valueBinding="val" 
                            onClickBinding="onclick"
                            selectedBinding="selected"
			    styleClass="OraCopyright" /> 
                </uix:contents> 
               </uix:flowLayout>  
            </uix:rowLayout>
          </uix:tableLayout>
                    
            <uix:tableLayout width="100%" renderedBinding="onThroughputTab@defaultBean@servletRequest">
              <uix:rowLayout hAlign="left" renderedBinding="showSysstatChart@defaultBean@servletRequest">
                <oem:chart 
                    chartType="timeSeriesChart"
                    width="800"
                    height="100"
                    timeGranularity="SECOND"
                    orientation="vertical"
                    legendPosition="east" 
                    legendVisible="external"
                    fill="none"
                    titleBinding="THROUGHPUT@DBMsgBundle@servletRequest"
                    titleVisible="false"         
                    yAxisLabelBinding="sysstatChartYAxisLabel@defaultBean@servletRequest"
                    yAxisWidth="30"
                >
                  <uix:contents>
                    <oem:boundChartDataSource 
                      chartDataSourceBinding="sysstatChartGIF@defaultBean@servletRequest"/>
                    <oem:imageMap imageMapDataSourceBinding="systatImageDataSource@servletRequest"/>
                    <oem:chartColumn                                   
                        isKey="true" 
                        displayLabel=""
                        sourceIndex="0" />
                    <oem:chartColumn
                        isTimeColumn="true"
                        displayLabel="Time"
                        sourceIndex="1"  />
                    <oem:chartColumn                                   
                        displayLabel=""
                        sourceIndex="2" />
                  </uix:contents>
                </oem:chart>
              </uix:rowLayout>  
 
              <uix:rowLayout hAlign="left">
                <oem:chart 
                    chartType="timeSeriesChart"
                    width="800"
                    height="100"
                    timeGranularity="SECOND"
                    orientation="vertical"
                    legendPosition="east" 
                    legendVisible="external"
                    fill="none"
                    titleBinding="BLOCKS@DBMsgBundle@servletRequest"
                    titleVisible="false"          
                    yAxisLabelBinding="sysstatBlocksChartYAxisLabel@defaultBean@servletRequest"
                    yAxisWidth="30"
                >
                  <uix:contents>
                    <oem:boundChartDataSource 
                      chartDataSourceBinding="sysstatBlocksChartGIF@defaultBean@servletRequest"/>
                    <oem:imageMap imageMapDataSourceBinding="systatBlocksImageDataSource@servletRequest"/>
                    <oem:chartColumn                                   
                        isKey="true" 
                        displayLabel=""
                        sourceIndex="0" />
                    <oem:chartColumn
                        isTimeColumn="true"
                        displayLabel="Time"
                        sourceIndex="1"  />
                    <oem:chartColumn                                   
                        displayLabel=""
                        sourceIndex="2" />
                  </uix:contents>
                </oem:chart>
              </uix:rowLayout>  
            </uix:tableLayout>
  </uix:stackLayout>
 </uix:case>
</uix:switcher>

    <uix:include node="/database/instance/sitemap/iogif.jsp" />
    <uix:include node="/database/instance/sitemap/pqgif.jsp" />


<uix:tableLayout renderedBinding="onServicesTab@defaultBean@servletRequest">
  <uix:rowLayout hAlign="left">
    <oem:chart 
        chartType="timeSeriesChart"
        width="800"
        height="200"
        timeGranularity="SECOND"
        orientation="vertical"
        legendPosition="east" 
        legendVisible="external"
        fill="cumulative"
        titleBinding="SERVICES@DBMsgBundle@servletRequest"
        titleVisible="false"         
        yAxisLabelBinding="ACTIVE_SESSIONS@DBMsgBundle@servletRequest"
        yAxisWidth="50"
    >
      <uix:contents>
        <oem:boundChartDataSource 
          chartDataSourceBinding="servicesGIF@defaultBean@servletRequest"/>
         
        <oem:imageMap imageMapDataSourceBinding="servicesImageMap@defaultBean@servletRequest"/>

        <oem:chartColumn                                   
            isKey="true" 
            displayLabel=""
            sourceIndex="0" />
        <oem:chartColumn
            isTimeColumn="true"
            displayLabel="Time"
            sourceIndex="1"  />
        <oem:chartColumn                                   
            displayLabel=""
            sourceIndex="2" />
      </uix:contents>
    </oem:chart>
  </uix:rowLayout>  
</uix:tableLayout>





   </uix:subTabLayout>

          <%@ include file="/database/instance/monitoringLinks.jspf" %>

        </uix:flowLayout>

    </uix:subTabLayout>

    <oem:relatedLinks />

    <%-- oem:relatedLinks --%>

   </uix:pageLayout>
    </db:form>
   </uix:body>
  </uix:document> 
</uix:renderingContext> 
