<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">

 <uix:bundle name="dvMsgs"
              class="oracle.sysman.db.rsc.sec.dv.DVMsg"/>

<oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
    <uix:pageLayout>
    <%@ include file="/database/global.jspf" %>
    <uix:switcher childNameBinding="stateChange@servletRequest">
      <uix:case name="true">
        <oem:messageBox messageTypeBinding="stateChangeMessageType@servletRequest"
	      errorTableBinding="msgBox@servletRequest"
                             destTableBinding="msgUrls@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>
      </uix:case>
    </uix:switcher>
    <uix:switcher childNameBinding="timeout_msg@servletRequest">
      <uix:case name="true">
        <oem:messageBox messageType="info" 
                  errorTableBinding="timeout_msgtable@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>
      </uix:case>
    </uix:switcher>


    <db:form name="foo" method="post" destination="/console/database/instance/instanceProperties"
      copyParams="target,type">
    <uix:formParameter name="event"/>
    
    <uix:header textBinding="viewAllPropertiesHeader@defaultBean@servletRequest">
      <uix:tableLayout width="100%" cellSpacing="5">
      <uix:rowLayout vAlign="top">
      <uix:stackLayout>
      <uix:rowLayout>
      <uix:borderLayout>
      <uix:tableLayout hAlign="left">

        <uix:rowLayout vAlign="bottom">
          <uix:cellFormat hAlign="right" wrappingDisabled="true" vAlign="bottom">
              <uix:styledText styleClass="OraPromptText"
                textBinding="DB_STATUS@DBMsgBundle@servletRequest"/>
          </uix:cellFormat>
          <uix:spacer width="8"/>
          <uix:cellFormat wrappingDisabled="true" vAlign="bottom" >
            <uix:styledText styleClass="OraDataText"
              textBinding="trafficStatusStr@defaultBean@servletRequest"/>
            <uix:spacer width="8"/>        
          </uix:cellFormat>
        </uix:rowLayout>



        <uix:rowLayout>
          <uix:cellFormat hAlign="right" wrappingDisabled="true">
              <uix:styledText styleClass="OraPromptText"
                textBinding="sinceText@defaultBean@servletRequest"/>
          </uix:cellFormat>
          <uix:spacer width="8"/>
          <uix:cellFormat hAlign="left" wrappingDisabled="true">
            <uix:styledText styleClass="OraDataText"
              textBinding="sinceTime@defaultBean@servletRequest"/>
          </uix:cellFormat>
        </uix:rowLayout>


        <uix:rowLayout>
          <uix:cellFormat hAlign="right" wrappingDisabled="true">
            <uix:styledText styleClass="OraPromptText"
              textBinding="AVAILABILITY@@DBMsgBundle@servletRequest"/>
          </uix:cellFormat>
          <uix:spacer width="8"/>
            <uix:rowLayout>
             <oem:license>
              <uix:link textBinding="trafficAvailStr@defaultBean@servletRequest"
                        destinationBinding="availDest@servletRequest"/>
             </oem:license>
            </uix:rowLayout>
        </uix:rowLayout>

        <uix:rowLayout>
          <uix:cellFormat hAlign="right" wrappingDisabled="true">
            <uix:styledText styleClass="OraPromptText"
              text=""/>
          </uix:cellFormat>
          <uix:spacer width="8"/>
            <uix:rowLayout>
              <uix:styledText styleClass="OraInlineInfoText"
                text="(" />
              <uix:styledText styleClass="OraInlineInfoText"
                textBinding="LAST_DAY@SDKBundle@servletRequest" />
              <uix:styledText styleClass="OraInlineInfoText"
                text=")" />
            </uix:rowLayout>
        </uix:rowLayout>

        <uix:rowLayout>
          <uix:cellFormat hAlign="right" wrappingDisabled="true">
              <uix:styledText styleClass="OraPromptText"
                textBinding="INSTANCE_NAME@DBMsgBundle@servletRequest"/>
          </uix:cellFormat>
          <uix:spacer width="8"/>
          <uix:styledText styleClass="OraDataText"
            textBinding="instanceName@defaultBean@servletRequest"/>
        </uix:rowLayout>

        <uix:rowLayout>
          <uix:cellFormat hAlign="right" wrappingDisabled="true">
            <uix:styledText styleClass="OraPromptText"
              textBinding="VERSION@DBMsgBundle@servletRequest"/>
          </uix:cellFormat>
          <uix:spacer width="8"/>
          <uix:styledText styleClass="OraDataText"
            textBinding="instanceVersion@defaultBean@servletRequest"/>
        </uix:rowLayout>

        <uix:rowLayout>
          <uix:cellFormat hAlign="right"
                          wrappingDisabled="true">
            <uix:styledText styleClass="OraPromptText"
                            textBinding="READ_ONLY@DBMsgBundle@servletRequest"/>
          </uix:cellFormat>
          <uix:spacer width="8"/>
          <uix:styledText styleClass="OraDataText"
                          textBinding="readOnly@defaultBean@servletRequest"/>
        </uix:rowLayout>

        <uix:rowLayout>
          <uix:cellFormat hAlign="right" wrappingDisabled="true">
              <uix:styledText styleClass="OraPromptText"
                textBinding="ORACLE_HOME@DBMsgBundle@servletRequest" />
          </uix:cellFormat>
          <uix:spacer width="8"/>
          <uix:flowLayout>
           <oem:license>
            <uix:link destinationBinding="oracleHomeDest@servletRequest"
              textBinding="oracleHome@defaultBean@servletRequest"/>
           </oem:license>
            <uix:spacer width="4"/>
            <uix:image renderedBinding="hasAdvisory@servletRequest" 
              source="/em/images/warning.gif"
              shortDescBinding="PATCHADV_WARNING@hostBundle@servletRequest"/>
          </uix:flowLayout>
        </uix:rowLayout>

        <uix:rowLayout>
          <uix:cellFormat hAlign="right" wrappingDisabled="true">
              <uix:styledText styleClass="OraPromptText"
                textBinding="HOST@DBMsgBundle@servletRequest" />
          </uix:cellFormat>
          <uix:spacer width="8"/>
          <uix:link destinationBinding="hostDest@servletRequest"
            textBinding="hostDetailsLinkLabel@defaultBean@servletRequest"/>
        </uix:rowLayout>

        <uix:rowLayout renderedBinding="showNormal@defaultBean@servletRequest">
          <uix:cellFormat hAlign="right" wrappingDisabled="true">
              <uix:styledText styleClass="OraPromptText"
                textBinding="LISTENER@DBMsgBundle@servletRequest" />
          </uix:cellFormat>
          <uix:spacer width="8"/>
          <uix:switcher childNameBinding="listenerTgtFound@servletRequest">
          <uix:case name="true">	
            <uix:link destinationBinding="listenerDest@servletRequest"
              textBinding="listenerName@defaultBean@servletRequest"/>
           </uix:case>
           <uix:case name="false">
            <uix:styledText styleClass="OraDataText" textBinding="listenerDest@servletRequest" />
           </uix:case>
           </uix:switcher>
        </uix:rowLayout>
                           
        <!--... Oracle Storage Manager: combined 2 renderedbinding into 1 ...-->
        <uix:rowLayout renderedBinding="showOsmUsage@defaultBean@servletRequest">
           <uix:cellFormat hAlign="right" wrappingDisabled="true">
            <uix:styledText styleClass="OraPromptText"
                          textBinding="ASM@DBMsgBundle@servletRequest" />
           </uix:cellFormat>
          <uix:spacer width="8"/>
           <uix:link textBinding="osmTargetName@defaultBean@servletRequest"
               destinationBinding="osmUsageLink@servletRequest" />
        </uix:rowLayout>


		<uix:rowLayout renderedBinding="databaseVaultNotInstalledOrNotConfigured@defaultBean@servletRequest">
		  <uix:cellFormat hAlign="right" wrappingDisabled="true">

		  <uix:styledText styleClass="OraPromptText"
			textBinding="DATABASE_VAULT_STATUS_TEXT@dvMsgs"/>
		  </uix:cellFormat>
		  <uix:spacer width="8"/>
		  <uix:switcher childNameBinding="dvstatus@defaultBean@servletRequest">
		 <uix:case name="-2">
		 <uix:link textBinding="STATUS_NOT_INSTALLED@dvMsgs"
destination="http://www.oracle.com/technology/deploy/security/database-security/database-vault/index.html"
targetFrame="_blank">
</uix:link>
		  </uix:case>
		  <uix:case name="-1">
		 <uix:link textBinding="STATUS_NOT_CONFIGURED@dvMsgs"
destination="http://www.oracle.com/technology/deploy/security/database-security/database-vault/index.html"
targetFrame="_blank">
</uix:link>
		  </uix:case>
 </uix:switcher>
 
      </uix:rowLayout>
      		<uix:rowLayout renderedBinding="databaseVaultNotInstalledOrNotConfigured@defaultBean@servletRequest">
		  <uix:cellFormat hAlign="right" wrappingDisabled="true">
		  <uix:styledText styleClass="OraPromptText"
			text=""/>
		  </uix:cellFormat>
		  <uix:spacer width="8"/>
		  <uix:styledText styleClass="OraInlineInfoText"
                textBinding="NOT_INSTALLED_NOT_CONFIGURED_TIP@dvMsgs" />
	      </uix:rowLayout>

      </uix:tableLayout>
      </uix:borderLayout>
      </uix:rowLayout>
      </uix:stackLayout>
      </uix:rowLayout>
      
      </uix:tableLayout>
     </uix:header>
          
     </db:form>
    </uix:pageLayout>
    </uix:body>


  </uix:document>
</uix:renderingContext>

