<%-- Confirmation page for launching iSQLPlus if security mode (SSL) differs from EM --%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 

<script language="javascript">

function doSubmit()
{
  // Launch correct version of iSQLPlus, based on role selected on previous page
  if (document.confForm.role.value == "NORMAL")
  {
    document.isqlplusForm.submit();
  }
  else if (document.confForm.role.value == "SYSOPER")
  {
    document.isqlplusFormDBAOper.submit();
  }
  else
  {
    document.isqlplusFormDBADba.submit();
  }
}

</script>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="DBMsgs"
              class="oracle.sysman.db.rsc.inst.DBMsg"/>
  <uix:bundle name="DBObjectMsgs"
              class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <oem:setURLEncoder id="renderingContext"/> 

  <uix:document> 

    <uix:metaContainer>
      <uix:head titleBinding="CONFIRMATION@DBObjectMsgs"/>
    </uix:metaContainer>

    <uix:body>
      <uix:pageLayout messageType="confirmation">
          
        <!-- no breadcrumbs for popups; but standard label, links, tabs, etc -->
        <%@ include file="/database/globalPopup.jspf" %>

        <%--  Form used to retrieve role  --%>
        <uix:form name="confForm" 
                  method="post" 
                  destinationBinding="isqlplusURL@defaultBean@servletRequest" >
          <uix:formValue name="role" 
                         valueBinding="isqlplusRole@defaultBean@servletRequest" />
        </uix:form>

        <%--  Normal iSQLPlus user form  --%>
        <uix:form name="isqlplusForm" 
                  method="post" 
                  destinationBinding="isqlplusURL@defaultBean@servletRequest">
          <uix:formValue name="userid" 
                         valueBinding="isqlplusUser@defaultBean@servletRequest" />
        </uix:form>

        <%--  DBA iSQLPlus user form AS SYSOPER --%>
        <uix:form name="isqlplusFormDBAOper" 
                  method="post" 
                  destinationBinding="isqlplusDBAURL@defaultBean@servletRequest">
          <uix:formValue name="userid" 
                         valueBinding="isqlplusUserSysoper@defaultBean@servletRequest" />
        </uix:form>

        <%--  DBA iSQLPlus user form AS SYSDBA --%>
        <uix:form name="isqlplusFormDBADba" 
                  method="post" 
                  destinationBinding="isqlplusDBAURL@defaultBean@servletRequest">
          <uix:formValue name="userid" 
                         valueBinding="isqlplusUserSysdba@defaultBean@servletRequest" />
        </uix:form>

        <uix:spacer height="10"/>

        <uix:switcher childNameBinding="EMSecureMode@defaultBean@servletRequest">
          <uix:case name="false">
            <uix:rowLayout>
              <uix:spacer width="40"/>
              <uix:styledText styleClass="OraDataText" textBinding="ISQLPLUS_SSL@DBMsgs" />  
            </uix:rowLayout>
          </uix:case>
          <uix:default>
            <uix:rowLayout>
              <uix:spacer width="40"/>
              <uix:styledText styleClass="OraDataText" textBinding="ISQLPLUS_NONSSL@DBMsgs" />  
            </uix:rowLayout>
          </uix:default>
        </uix:switcher>

        <uix:spacer height="10"/>

        <uix:rowLayout>
          <uix:spacer width="40"/>
          <uix:styledText styleClass="OraInstructionText" textBinding="ISQLPLUS_MODESWITCH@DBMsgs" /> 
        </uix:rowLayout>

        <uix:spacer height="10"/>

        <uix:rowLayout>
          <uix:spacer width="40"/>
          <uix:styledText styleClass="OraInstructionText" textBinding="ISQLPLUS_EMOMS@DBMsgs" /> 
        </uix:rowLayout>

        <uix:spacer height="10"/>

        <uix:rowLayout>
          <uix:spacer width="40"/>
          <uix:styledText styleClass="OraInstructionText" textBinding="ISQLPLUS_CONTINUE@DBMsgs" /> 
        </uix:rowLayout>


        <uix:pageButtons>
          <uix:pageButtonBar>
            <uix:button textBinding="NO@DBObjectMsgs" 
                        shortDescBinding="NO@DBObjectMsgs"
                        onClick="window.close()" /> 

            <uix:button textBinding="YES@DBObjectMsgs" 
                        shortDescBinding="YES@DBObjectMsgs"
	                onClick="doSubmit()" /> 

          </uix:pageButtonBar>
        </uix:pageButtons>

      </uix:pageLayout>            
    </uix:body>
  </uix:document>
</uix:renderingContext>
