<%-- Intermediate page for launching iSQLPlus --%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 

<script language="javascript">

function doSubmit()
{
   if (document.roleForm.isqlplusRole[0].checked)
   {
     // If EM is running in secure mode (SSL) and iSQLPlus is not (or vice versa), warn user.
     if (document.roleForm.modeDiff.value == "t")
     {
       document.roleForm.submit();
     }
     else
     {
       document.isqlplusForm.submit();
     }
   }
   else if (document.roleForm.isqlplusRole[1].checked)
   {
     // If EM is running in secure mode (SSL) and iSQLPlus DBA is not (or vice versa), warn user.
     if (document.roleForm.DBAModeDiff.value == "t")
     {
       document.roleForm.submit();
     }
     else
     {
       document.isqlplusFormDBAOper.submit();
     }
   }
   else 
   {
     // If EM is running in secure mode (SSL) and iSQLPlus DBA is not (or vice versa), warn user.
     if (document.roleForm.DBAModeDiff.value == "t")
     {
       document.roleForm.submit();
     }
     else
     {
       document.isqlplusFormDBADba.submit();
     }
   }
}
</script>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="DBMsgs"
              class="oracle.sysman.db.rsc.inst.DBMsg"/>
  <oem:setURLEncoder id="renderingContext"/> 

  <uix:document> 

    <uix:metaContainer>
      <uix:switcher childNameBinding="isqlplusConfigured@defaultBean@servletRequest">
        <uix:case name="true">      
          <uix:head titleBinding="ISQLPLUS_CONN@DBMsgs"/>
        </uix:case>
        <uix:case name="false">      
          <uix:head titleBinding="ISQLPLUS_ERR@DBMsgs"/>
        </uix:case>      
      </uix:switcher>
    </uix:metaContainer>

    <uix:body>
      <uix:pageLayout >

        <%-- Include Global Buttons so we get the Help link --%>
        <uix:globalButtons>
          <uix:globalButtonBar>
            <uix:contents childDataBinding="oracle_sysman_emSDK_eml_nav_GlobalButtons@servletRequest">
              <uix:globalButton textBinding="text" destinationBinding="destination" renderedBinding="rendered" targetFrame="_top"/>
            </uix:contents>
          </uix:globalButtonBar>
        </uix:globalButtons>

        <uix:switcher childNameBinding="isqlplusConfigured@defaultBean@servletRequest">
          <uix:case name="true">  
            <uix:header textBinding="ISQLPLUS_CONN@DBMsgs"/>
          </uix:case>      
          <uix:case name="false">  
            <uix:header messageType="error" 
                        textBinding="ISQLPLUS_ERR@DBMsgs"/>
          </uix:case>      
        </uix:switcher>

        <%--  Normal iSQLPlus user form  --%>
        <uix:form name="isqlplusForm" 
                  method="post" 
                  destinationBinding="isqlplusURL@defaultBean@servletRequest">
          <uix:formValue name="userid" 
                         valueBinding="isqlplusUser@defaultBean@servletRequest" />
        </uix:form>


        <%--  DBA iSQLPlus user form AS SYSOPER --%>
        <uix:form name="isqlplusFormDBAOper" 
                  method="post" 
                  destinationBinding="isqlplusDBAURL@defaultBean@servletRequest">
          <uix:formValue name="userid" 
                         valueBinding="isqlplusUserSysoper@defaultBean@servletRequest" />
        </uix:form>

       <%--  DBA iSQLPlus user form AS SYSDBA --%>
        <uix:form name="isqlplusFormDBADba" 
                  method="post" 
                  destinationBinding="isqlplusDBAURL@defaultBean@servletRequest">
          <uix:formValue name="userid" 
                         valueBinding="isqlplusUserSysdba@defaultBean@servletRequest" />
        </uix:form>


        <%-- Form containing only role options  --%>
        <uix:form name="roleForm" 
                  method="post" 
                  destinationBinding="isqlplusConfLink@servletRequest" >
          <uix:formValue name="modeDiff" 
                         valueBinding="isqlplusDiffModeStr@defaultBean@servletRequest" />
          <uix:formValue name="DBAModeDiff" 
                         valueBinding="isqlplusDBADiffModeStr@defaultBean@servletRequest" />


        <%-- Role Choice Radio buttons --%>
        <uix:switcher childNameBinding="isqlplusConfigured@defaultBean@servletRequest">
          <uix:case name="true">  
            <uix:stackLayout>
              <uix:spacer height="10"/>
              <uix:separator>
                <uix:spacer width="3" height="2"/>
              </uix:separator>

              <uix:labeledFieldLayout labelWidth="35%">
                <%-- Normal --%>
                <uix:messagePrompt promptBinding="CONNECT_AS@DBMsgs"/>
                <uix:radioButton textBinding="CONNECT_NORMAL@DBMsgs"
                                 name="isqlplusRole"
                                 value="NORMAL"
                                 selectedValueBinding="isqlplusRole@defaultBean@servletRequest" />

                <%-- SYSOPER --%>
                <uix:messageText message=""/>
                <uix:stackLayout>
                  <uix:radioButton textBinding="CONNECT_SYSOPER@DBMsgs"
                                   name="isqlplusRole"
                                   value="SYSOPER"
                                   selectedValueBinding="isqlplusRole@defaultBean@servletRequest" />

                  <uix:rowLayout>
                    <uix:spacer width="20"/>
                    <uix:styledText textBinding="ISQLPLUS_WEBDBA@DBMsgs"
                                    styleClass="OraInlineInfoText"/>
                  </uix:rowLayout>
                </uix:stackLayout>

                <%-- SYSDBA --%>
                <uix:messageText message=""/>
                <uix:stackLayout>
                  <uix:radioButton textBinding="CONNECT_SYSDBA@DBMsgs"
                                   name="isqlplusRole"
                                   value="SYSDBA" 
                                   selectedValueBinding="isqlplusRole@defaultBean@servletRequest" />
                  <uix:rowLayout>
                    <uix:spacer width="20"/>
                    <uix:styledText textBinding="ISQLPLUS_WEBDBA@DBMsgs"
                                    styleClass="OraInlineInfoText"/>
                  </uix:rowLayout>
                </uix:stackLayout>
              </uix:labeledFieldLayout>
            </uix:stackLayout>
          </uix:case>

          <uix:case name="false">  
            <uix:stackLayout>
              <uix:spacer height="10"/>
              <uix:rowLayout>            
                <uix:styledText styleClass="OraDataText" 
                                textBinding="ISQLPLUS_ERRTEXT1@DBMsgs" />
              </uix:rowLayout>

              <uix:spacer height="10"/>
              <uix:rowLayout>
                <uix:styledText styleClass="OraInstructionText" 
                                textBinding="ISQLPLUS_ERRTEXT2@DBMsgs" />  
              </uix:rowLayout>

              <uix:spacer height="10"/>
              <uix:rowLayout>
                <uix:tip>
                  <uix:styledText styleClass="OraTipText" 
                                  textBinding="ISQLPLUS_ERRTIP@DBMsgs" />  
                </uix:tip>
              </uix:rowLayout>
            </uix:stackLayout>
          </uix:case>      
        </uix:switcher>
        </uix:form>


        <uix:pageButtons>
          <uix:switcher childNameBinding="isqlplusConfigured@defaultBean@servletRequest">
            <uix:case name="true">   
              <uix:pageButtonBar>
                <uix:button textBinding="CANCEL@DBMsgs" 
                            shortDescBinding="CANCEL@DBMsgs"
                            onClick="window.close()" />
                <uix:button textBinding="CONTINUE@DBMsgs" 
                            shortDescBinding="CONTINUE@DBMsgs"
                            onClick="doSubmit()" />
              </uix:pageButtonBar>
            </uix:case>       
            <uix:case name="false">   
              <uix:pageButtonBar>
                <uix:button textBinding="OK@DBMsgs" 
                            shortDescBinding="OK@DBMsgs"
                            onClick="window.close()" /> 
              </uix:pageButtonBar>
            </uix:case> 
          </uix:switcher>
        </uix:pageButtons>

      </uix:pageLayout>
    </uix:body>
  </uix:document> 
</uix:renderingContext> 


