<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 
 

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
<uix:bundle name="HDMMsg"
	    class="oracle.sysman.db.rsc.inst.HDMMsg"/>
<%-- ......... Job rollups .........--%>
<uix:bundle name="JobsResourceBundle"
      class="oracle.sysman.resources.emSDK.job.JobSDKMsg"/>
<%-- ......... CPF .........--%>
<uix:bundle name="mntrResourceBundle"
      class="oracle.sysman.resources.MntrResourceBundle"/>
<%-- ......... Configure .........--%>
<uix:bundle name="commonResourceBundle"
      class="oracle.sysman.resources.CommonResourceBundle"/>

<uix:bundle name="dvMsgs"
              class="oracle.sysman.db.rsc.sec.dv.DVMsg"/>

  <uix:switcher childNameBinding="autoHomeRefresh@servletRequest">
          <uix:case name="true">
            <uix:rawText>
              <meta http-equiv="Refresh"
                    content="<%=request.getAttribute("refreshHomeRate")%>; URL=<%=request.getAttribute("sitemapRefreshUrl") %>" >
            </uix:rawText> 
          </uix:case>  
  </uix:switcher>
  
  <uix:document>

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>

    <db:form name="foo" method="post" destination="/console/database/instance/sitemap"
      copyParams="target,type">
    <uix:pageLayout titleBinding="header@defaultBean@servletRequest">
    <%@ include file="/database/global.jspf" %>
    <uix:switcher childNameBinding="stateChange@servletRequest">
      <uix:case name="true">
        <oem:messageBox messageTypeBinding="stateChangeMessageType@servletRequest"
	      errorTableBinding="msgBox@servletRequest"
                             destTableBinding="msgUrls@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>
      </uix:case>
    </uix:switcher>
    <uix:switcher childNameBinding="timeout_msg@servletRequest">
      <uix:case name="true">
        <oem:messageBox messageType="info" 
                  errorTableBinding="timeout_msgtable@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>
      </uix:case>
    </uix:switcher>

    <uix:switcher childNameBinding="siha_msg@servletRequest">
      <uix:case name="true">
     <oem:messageBox messageTypeBinding="sihaMessageType@servletRequest" 
                     errorTableBinding="sihaMsgBox@servletRequest"
                     destTableBinding="sihaMsgUrls@servletRequest"
                     titleTextKey="titleText" mainTextKey="mainText"/>
      </uix:case>
    </uix:switcher>
    <uix:switcher childNameBinding="isMarkedDelete@servletRequest">
    <uix:case name="true">
    <oem:messageBox messageTypeBinding="messageType@servletRequest"
                             errorTableBinding="msgBox@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>
    </uix:case> 			     
    </uix:switcher>	 	
    <%--                                                          --%>
    <%-- Support pageMsgBox for any apps that return to this page --%>
    <%-- and support it.  This include must be positioned AFTER   --%>
    <%-- any other uix:messages or messageBox tags.               --%>
    <%--                                                          --%>
    <%@ include file="/sdk/page/pageMsgBox.jspf" %>

    <uix:contextSwitcher>
    <uix:switcher childNameBinding="showSwitchToList@servletRequest">
    <uix:case name="true">
            <uix:rowLayout>
                <uix:cellFormat vAlign="middle" wrappingDisabled="true">
                  <uix:styledText styleClass="OraPromptText" 
                        textBinding="SWITCH_TO@DBMsgBundle@servletRequest"/>  
                 </uix:cellFormat>
                 <uix:cellFormat vAlign="middle" wrappingDisabled="true">
                  <uix:spacer width="1"/>
                  <oem:choice name="newTarget"
                      onChange="submitForm('foo', true, {'event':'switchTo','pageNum':'1'})"
                      optionsBinding="racSwitchToList@servletRequest"
                      selectedValueBinding="targetName@defaultBean@servletRequest"/>
                 </uix:cellFormat>     
              </uix:rowLayout>
    </uix:case>
    </uix:switcher>
    </uix:contextSwitcher>

    <uix:formParameter name="event"/>
    <uix:formValue name="pageNum" value="1"/>

     <uix:subTabLayout>
        <uix:subTabs>
          <uix:subTabBar selectedIndex="0">
              <uix:link textBinding="HOME@DBMsgBundle@servletRequest"/>
              <oem:license> 
              <uix:link textBinding="PERFORMANCE_HEADER@DBMsgBundle@servletRequest"
                 destinationBinding="healthDest@servletRequest"/>
              </oem:license>  
<%--
              <uix:link textBinding="ADMINISTRATION@DBMsgBundle@servletRequest"
                 destinationBinding="adminDest@servletRequest"/>
              <uix:link textBinding="SOFTWARE_MAINT@DBMsgBundle@servletRequest"
                 destinationBinding="softMaintDest@servletRequest"/>
--%>
              <uix:link textBinding="TAB_AVAILABILITY@DBMsgBundle@servletRequest"
                 destinationBinding="tabAvailabilityDest@servletRequest"/>
              <uix:link textBinding="TAB_SERVER@DBMsgBundle@servletRequest"
                 destinationBinding="tabServerDest@servletRequest"/>
              <uix:link textBinding="TAB_SCHEMA@DBMsgBundle@servletRequest"
                 destinationBinding="tabSchemaDest@servletRequest"/>
              <uix:link textBinding="TOPOLOGY@racMsgBundle@servletRequest"
                 destinationBinding="topologyDest@servletRequest" 
                 renderedBinding="RacDbScope@servletRequest" />
              <uix:link textBinding="TAB_DATA_MOVEMENT@DBMsgBundle@servletRequest"
                 destinationBinding="tabDataMovementDest@servletRequest"/>
              <uix:link textBinding="TAB_SOFTWARE_SUPPORT@DBMsgBundle@servletRequest"
                 destinationBinding="tabSoftwareSupportDest@servletRequest"/>
          </uix:subTabBar>
        </uix:subTabs>


        <uix:flowLayout>
          <uix:tableLayout width="100%">
            <uix:rowLayout>
                
              <uix:cellFormat hAlign="right" >
                <uix:flowLayout>
                
                    <uix:styledText styleClass="OraTipText" 
                      textBinding="PAGE_REFRESHED_TIME@SDKBundle@servletRequest"/>
                    <uix:spacer width="5" />  
                    <uix:styledText styleClass="OraTipLabel" 
                      textBinding="refreshTime@servletRequest"/>

                    <uix:spacer width="10" />
                    
                    <uix:button textBinding="REFRESH@SDKBundle@servletRequest"
                      destinationBinding="refreshDest@servletRequest" />
  
                    <uix:spacer width="10" />
  
                    <uix:styledText styleClass="OraFieldText" 
                      textBinding="VIEW_DATA@DBMsgBundle@servletRequest" 
                      labeledNodeId="ViewLabel" />
  
                    <uix:choice name="refreshHome" id="ViewLabel"
                        onChange="submitForm('foo', true, {'event':'doLoad','pageNum':'1'})"
                         selectedValueBinding="refreshHomeSelected@servletRequest">
                      <uix:option textBinding="MANUALLY_REFRESH@DBMsgBundle@servletRequest"
                        value="RT_MAN"/>
                      <uix:option textBinding="AUTOMATICALLY_REFRESH@DBMsgBundle@servletRequest"
                        value="RT_15"/>
                      <uix:option textBinding="AUTOMATICALLY_REFRESH_1MIN@DBMsgBundle@servletRequest"
                        value="RT_60"/> 
                    </uix:choice>          
  
  
                 </uix:flowLayout>
                </uix:cellFormat>  
              </uix:rowLayout>
        </uix:tableLayout>
      </uix:flowLayout>

   <uix:stackLayout renderedBinding="targetDown@defaultBean@servletRequest" >
     <uix:spacer height="10" />
     <uix:rowLayout>
       <uix:messagePrompt promptBinding="TARGET_DOWN_TEXT@DBMsgBundle@servletRequest" />
     </uix:rowLayout>
     <uix:spacer height="10" />
   </uix:stackLayout>

     <uix:stackLayout renderedBinding="targetDown@defaultBean@servletRequest">
      <%@ include file="/database/instance/repDown/repDownInclude.jspf" %>

      <uix:switcher childNameBinding="showNormal@defaultBean@servletRequest">
       <uix:case name="false">

        <uix:rowLayout >
         <uix:cellFormat hAlign="right" wrappingDisabled="true">
          <uix:link textBinding="LAST_KNOWN_STATE@SDKBundle@servletRequest"
                    destinationBinding="showLastDest@servletRequest"/>
         </uix:cellFormat>
        </uix:rowLayout>
    
      </uix:case>
     </uix:switcher>
 
     </uix:stackLayout>


        <uix:tableLayout width="100%" cellSpacing="5">

            <uix:rowLayout vAlign="top">

              <uix:cellFormat vAlign="top" width="25%">
                <!-- ...................  General Section .................. -->
                
                  <uix:header textBinding="GENERAL@DBMsgBundle@servletRequest"
                  iconBinding="allClearIcon@servletRequest"
                  renderedBinding="showGeneral@servletRequest">

                       <uix:stackLayout>
                        <uix:rowLayout>
                        
                          <uix:borderLayout>
                            
                        
                        <uix:flowLayout>
                        <uix:tableLayout width="100%">
                          <uix:rowLayout>
                             <uix:cellFormat hAlign="left" >
                            <uix:image sourceBinding="trafficImage@servletRequest" />
                            </uix:cellFormat>
                               <uix:cellFormat hAlign="right" vAlign="top">
                                <oem:license>
                                <uix:button textBinding="changeStateButtonLabel@servletRequest"
                                  destinationBinding="changeStateUrl@servletRequest"/>
                                </oem:license>
                              <uix:spacer width="2" />
                              <oem:license>
                               <uix:button textBinding="END_BLACKOUT@SDKBundle@servletRequest"
                                shortDescBinding="END_BLACKOUT@SDKBundle@servletRequest"
                                destinationBinding="blackoutsLinkDest@servletRequest"
                                rendered="<%=request.getAttribute(\"isStopBlackout\")%>"/>
                              </oem:license>
                              <oem:license>
                              <uix:button textBinding="CREATE_BLACKOUT@SDKBundle@servletRequest"
                                shortDescBinding="CREATE_BLACKOUT@SDKBundle@servletRequest"
                                destinationBinding="blackoutsLinkDest@servletRequest"
                                rendered="<%=request.getAttribute(\"isCreateBlackout\")%>"/>
                              </oem:license>
                            </uix:cellFormat>  
                          </uix:rowLayout>
                          </uix:tableLayout>
                          </uix:flowLayout>
                      

                           
                    <uix:tableLayout hAlign="left">

                         <uix:rowLayout vAlign="bottom">
                              <uix:cellFormat hAlign="right" wrappingDisabled="true" vAlign="bottom">
                                  <uix:styledText styleClass="OraPromptText"
                                    textBinding="DB_STATUS@DBMsgBundle@servletRequest"/>
                              </uix:cellFormat>
                              <uix:spacer width="8"/>
                              <uix:cellFormat wrappingDisabled="true" vAlign="bottom" >
                               <oem:license>
                                <uix:link destinationBinding="availDest@servletRequest"
                                  textBinding="trafficStatusStr@defaultBean@servletRequest"/>
                               </oem:license>
                              </uix:cellFormat>
                            </uix:rowLayout>
                            <uix:rowLayout renderedBinding="targetNotConfig@defaultBean@servletRequest">
                              <uix:cellFormat hAlign="right" wrappingDisabled="true">
                              </uix:cellFormat>
                              <uix:spacer width="8"/>

                              <uix:cellFormat hAlign="left" vAlign="center" wrappingDisabled="true">
                                <uix:styledText styleClass="OraPromptText" 
				textBinding="DB_NOT_CONFIGURRED@DBMsgBundle@servletRequest"/>
                                <uix:spacer width="2"/>
                                <uix:button textBinding="CONFIGURE@commonResourceBundle"
                                  destinationBinding="monConfigLink@servletRequest"/>

                                  </uix:cellFormat>
                            </uix:rowLayout>

                            <uix:rowLayout>
                              <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                  <uix:styledText styleClass="OraPromptText"
                                    textBinding="sinceText@defaultBean@servletRequest"/>
                              </uix:cellFormat>
                              <uix:spacer width="8"/>
                              <uix:cellFormat hAlign="left" wrappingDisabled="true">
                                <uix:styledText styleClass="OraDataText"
                                  textBinding="sinceTime@defaultBean@servletRequest"/>
                              </uix:cellFormat>
                            </uix:rowLayout>

                            <uix:switcher childNameBinding="showNormal@defaultBean@servletRequest">
                             <uix:case name="false">
                              <uix:rowLayout>

                                <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                  <uix:link textBinding="LAST_KNOWN_STATE@SDKBundle@servletRequest"
                                    destinationBinding="showLastDest@servletRequest"/>
                                </uix:cellFormat>
                              </uix:rowLayout>
                             </uix:case>
                            </uix:switcher>



                            <uix:rowLayout renderedBinding="showNormal@defaultBean@servletRequest">

                              <uix:cellFormat hAlign="right" wrappingDisabled="true">

                                  <uix:styledText styleClass="OraPromptText"
                                    textBinding="INSTANCE_NAME@DBMsgBundle@servletRequest"/>

                              </uix:cellFormat>
                              <uix:spacer width="8"/>
                              <uix:styledText styleClass="OraDataText"
                                textBinding="instanceName@defaultBean@servletRequest"/>

                            </uix:rowLayout>





                            <uix:rowLayout renderedBinding="showNormal@defaultBean@servletRequest">

                              <uix:cellFormat hAlign="right" wrappingDisabled="true">

                                  <uix:styledText styleClass="OraPromptText"
                                    textBinding="VERSION@DBMsgBundle@servletRequest"/>

                              </uix:cellFormat>
                              <uix:spacer width="8"/>
                              <uix:styledText styleClass="OraDataText"
                                textBinding="instanceVersion@defaultBean@servletRequest"/>

                            </uix:rowLayout>


                        <jsp:include page="dvStatusIncl.jsp" />
                        <uix:ref refID="dvStatusIncl" />

                         
                            <uix:rowLayout renderedBinding="showNormal@defaultBean@servletRequest">
                              <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                  <uix:styledText styleClass="OraPromptText"
                                    textBinding="HOST@DBMsgBundle@servletRequest" />
                              </uix:cellFormat>
                              <uix:spacer width="8"/>
                              <uix:link destinationBinding="hostDest@servletRequest"
                                textBinding="hostNameForDisplay@defaultBean@servletRequest"/>
                                </uix:rowLayout>

                            <uix:rowLayout renderedBinding="showNormal@defaultBean@servletRequest">
                              <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                  <uix:styledText styleClass="OraPromptText"
                                    textBinding="LISTENER@DBMsgBundle@servletRequest" />
                              </uix:cellFormat>
                              <uix:spacer width="8"/>
			 <uix:switcher childNameBinding="listenerTgtFound@servletRequest">
                           <uix:case name="true">	
                              <uix:link destinationBinding="listenerDest@servletRequest"
                                textBinding="listenerName@defaultBean@servletRequest"/>
			   </uix:case>
			<uix:case name="false">
				<uix:styledText styleClass="OraDataText" textBinding="listenerDest@servletRequest" />
			</uix:case>
			</uix:switcher>
                            </uix:rowLayout>

                      <!-- SAGE -->
         <uix:switcher childNameBinding="DbScope@servletRequest">
         <uix:case name="true">
              <uix:rowLayout renderedBinding="cellTgtFound@servletRequest">
                              <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                  <uix:styledText styleClass="OraPromptText"
                                    textBinding="EXADATA_LIST@DBMsgBundle@servletRequest" />
                              </uix:cellFormat>
                              <uix:spacer width="8"/>
                              <uix:cellFormat hAlign="left">
                              <uix:link destinationBinding="cellTableDest@servletRequest"
                                textBinding="cellCount@defaultBean@servletRequest"/>

                              <uix:spacer  width="5"/>
                              <uix:styledText styleClass="OraDataText" text="( "/>                               
                           <uix:flowLayout renderedBinding="showUpCellCount@defaultBean@servletRequest">
                                <uix:image sourceBinding="upCellIconSource@defaultBean@servletRequest"
                                           shortDescBinding="upStatusShortDesc@defaultBean@servletRequest" />
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="upCellCount@defaultBean@servletRequest"/>
                              </uix:flowLayout>

                              <uix:flowLayout renderedBinding="showDownCellCount@defaultBean@servletRequest">
                                <uix:image sourceBinding="downCellIconSource@defaultBean@servletRequest"
                                           shortDescBinding="downStatusShortDesc@defaultBean@servletRequest" />
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="downCellCount@defaultBean@servletRequest"/>
                                </uix:flowLayout>

                              <uix:flowLayout renderedBinding="showUnreachableCellCount@defaultBean@servletRequest">
                                <uix:image sourceBinding="unreachableCellIconSource@defaultBean@servletRequest"
                                           shortDescBinding="unreachableStatusShortDesc@defaultBean@servletRequest" />
                                <uix:spacer width="3"/>
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="unreachableCellCount@defaultBean@servletRequest"/>
                              </uix:flowLayout>

                              <uix:flowLayout renderedBinding="showErrorCellCount@defaultBean@servletRequest">
                                <uix:image sourceBinding="errorCellIconSource@defaultBean@servletRequest"
                                           shortDescBinding="errorStatusShortDesc@defaultBean@servletRequest" />
                                <uix:spacer width="3"/>
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="errorCellCount@defaultBean@servletRequest"/>
                              </uix:flowLayout>

                              <uix:flowLayout renderedBinding="showBlackoutCellCount@defaultBean@servletRequest">
                                <uix:image sourceBinding="blackoutCellIconSource@defaultBean@servletRequest"
                                           shortDescBinding="blackoutStatusShortDesc@defaultBean@servletRequest" />
                                <uix:spacer width="3"/>
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="blackoutCellCount@defaultBean@servletRequest"/>
                              </uix:flowLayout>

                              
                              <uix:flowLayout renderedBinding="showAgentDownCellCount@defaultBean@servletRequest">
                                <uix:image sourceBinding="agentDownCellIconSource@defaultBean@servletRequest"
                                           shortDescBinding="agentDownStatusShortDesc@defaultBean@servletRequest" />
                                <uix:spacer width="3"/>
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="agentDownCellCount@defaultBean@servletRequest"/>
                              </uix:flowLayout>

                              <uix:flowLayout renderedBinding="showUnknownCellCount@defaultBean@servletRequest">
                                <uix:image sourceBinding="unknownCellIconSource@defaultBean@servletRequest"
                                           shortDescBinding="unknownStatusShortDesc@defaultBean@servletRequest" />
                                <uix:spacer width="3"/>
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="unknownCellCount@defaultBean@servletRequest"/>
                              </uix:flowLayout> 
                              <uix:styledText styleClass="OraDataText" text=" )"/>
                              </uix:cellFormat>
                            </uix:rowLayout>
         </uix:case>
         </uix:switcher>

                      <!--  Reconfigution history Info -->
                          <uix:switcher  childNameBinding="configHistoryExist@servletRequest">
                           <uix:case name="true">
                              <uix:rowLayout>
                                  <uix:cellFormat hAlign="right">
                                    <uix:styledText styleClass="OraPromptText"
                                      textBinding="reconfigHistoryPage@servletRequest"/>
                                  </uix:cellFormat>
                                  <uix:spacer width="8"/>
                                    <uix:rowLayout >
                                      
                                      <uix:link textBinding="configHistoryCount@servletRequest"
                                                destinationBinding="configHistoryPage@servletRequest"/>
                                      
                                    </uix:rowLayout>
                               </uix:rowLayout>
                             </uix:case>  
                          </uix:switcher>    
                         <!-- END Reconfigution history Info --> 
                         
			    <!--... Oracle Storage Manager: combined 2 renderedbinding into 1 ...-->
			    <uix:rowLayout renderedBinding="showOsmUsage@defaultBean@servletRequest">
			       <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                <uix:styledText styleClass="OraPromptText"
                                    	        textBinding="ASM@DBMsgBundle@servletRequest" />
			       </uix:cellFormat>
                                <uix:spacer width="8"/>
                               <uix:link textBinding="osmTargetName@defaultBean@servletRequest"
                                	 destinationBinding="osmUsageLink@servletRequest" />
			    </uix:rowLayout>
          
          
			    <uix:rowLayout renderedBinding="showSvcsImpacted@svcImpBean@servletRequest">         		      
             <uix:cellFormat hAlign="right" wrappingDisabled="true">
              <uix:styledText styleClass="OraPromptText" textBinding="label@svcImpBean@servletRequest" />
			       </uix:cellFormat>
             <uix:spacer width="8"/>
             <uix:link textBinding="value@svcImpBean@servletRequest" destinationBinding="destination@svcImpBean@servletRequest" />
			    </uix:rowLayout>

                  <!--  end of table of General info  -->

                  </uix:tableLayout>

                  </uix:borderLayout>
                 </uix:rowLayout>

                <uix:spacer height="15" />

                  <uix:rowLayout renderedBinding="showNormal@defaultBean@servletRequest"
                  hAlign="center">


                      
                        <db:link copyParams="target,type"
                          textBinding="VIEW_ALL_PROPERTIES@DBMsgBundle@servletRequest"
                          destination="/console/database/instance/instanceProperties?event=doLoad"
                           />
                  </uix:rowLayout>

               </uix:stackLayout>





          </uix:header>
          

        </uix:cellFormat>
                
          <uix:include node="/database/instance/sitemap/sitemapIncl.jsp" />
        </uix:rowLayout>
      </uix:tableLayout>

        <!-- Have a separate table since columns are 4 -->
        <uix:tableLayout width="100%" cellSpacing="5">        
         <uix:include node="/database/instance/sitemap/sitemapInclude.jsp" />
        </uix:tableLayout>

       <uix:hideShowHeader textBinding="ALERTS_HEADER@DBMsgBundle@servletRequest"
        renderedBinding="showNormal@defaultBean@servletRequest"
        id="hideShowAlertsTableHeader" 
        partialRenderMode="self"
        formSubmitted="true"
        disclosedBinding="discloseHideShowAlertsTableHeader@httpSession" >

        <uix:flowLayout>
        <uix:tableLayout width="100%">
        <uix:rowLayout>
        
          <uix:cellFormat hAlign="left">     
          
         <uix:messagePrompt promptBinding="CATEGORY@DBMsgBundle@servletRequest" 
            labeledNodeId="alersFilterID" />
          
          <uix:spacer width="5" />
          
          <uix:choice name="alertsFilter" id="alersFilterID"
            selectedValueBinding="alertsFilter@defaultBean@servletRequest" >
            <uix:contents childDataBinding="alertsFilterList@defaultBean@servletRequest">
              <uix:option textBinding="text" valueBinding="value" />
            </uix:contents>
          </uix:choice>  
          
          <uix:submitButton name="event" value="filterAlerts"
            textBinding="GO@DBMsgBundle@servletRequest" />
          
          <uix:spacer width="15" />
          
               <uix:styledText 
            styleClass="OraPromptText"
            textBinding="ALERT_CRITICAL@DBMsgBundle@servletRequest" />
          <uix:spacer width="5" />
          <uix:switcher childNameBinding="hasAlertCritical@servletRequest">
           <uix:case name="true">
             <uix:image 
               sourceBinding="criticalImage@servletRequest" />
           </uix:case>
           <uix:case name="false">
             <uix:image sourceBinding="nothing@servletRequest"/>
           </uix:case>
         </uix:switcher>        
          <uix:spacer width="5" />
          <uix:styledText 
             styleClass="OraDataText"
             textBinding="alertCriticalCount@servletRequest" />
             
          <uix:spacer width="20" />
          
          <uix:styledText 
             styleClass="OraPromptText"
             textBinding="WARNING@SDKBundle@servletRequest" />
          <uix:spacer width="5" />        
          <uix:switcher childNameBinding="hasAlertWarning@servletRequest">
           <uix:case name="true">
             <uix:image 
               sourceBinding="warningImage@servletRequest" />
           </uix:case>
           <uix:case name="false">
             <uix:image sourceBinding="nothing@servletRequest"/>
           </uix:case>
         </uix:switcher>
         <uix:spacer width="5" /> 
          <uix:styledText 
             styleClass="OraDataText"
             textBinding="alertWarningCount@servletRequest" />                
                 
         
         </uix:cellFormat>
    

      </uix:rowLayout>
      </uix:tableLayout>
      </uix:flowLayout>    
           
          <uix:tableLayout width="100%" >
              <uix:rowLayout vAlign="top">

                <oem:table name="alertsUIDataSource"
                           partialRenderMode="self"
                           id="alertsTable"
                           alternateTextBinding="NO_ALERTS_ALT@SDKBundle@servletRequest"
                           width="100%"
                           summaryBinding="ALERTS@SDKBundle@servletRequest"
                           dataSourceProp="alertsUIDataSource"
                           beanKey="defaultBean"
                           formSubmitted="true"
			   showAll="yes"
                           blockSize="10">
                  </oem:table>

              </uix:rowLayout>
            </uix:tableLayout>
        </uix:hideShowHeader>

      <%-- host alerts header --%>
       <uix:hideShowHeader textBinding="RELATED_ALERTS@SDKBundle@servletRequest"
        id="hideShowRelatedAlertsTableHeader" 
        partialRenderMode="self"
        formSubmitted="true"
        disclosedBinding="discloseHideShowRelatedAlertsTableHeader@httpSession"
        renderedBinding="showNormal@defaultBean@servletRequest">
          <uix:tableLayout width="100%" >
              <uix:rowLayout vAlign="top">

                <oem:table name="relatedAlertsUIDataSource"
                           partialRenderMode="self"
                           id="relatedAlertsTable"
                           width="100%"
                           alternateTextBinding="NO_ALERTS_ALT@SDKBundle@servletRequest"
                           dataSourceProp="relatedAlertsUIDataSource"
                           summaryBinding="RELATED_ALERTS@SDKBundle@servletRequest"
                           beanKey="defaultBean"
                           formSubmitted="true"
			   showAll="yes"
                           blockSize="10">
                  </oem:table>

              </uix:rowLayout>
            </uix:tableLayout>
        </uix:hideShowHeader>

 

       <uix:header textBinding="TASK_DETAIL_HEADER@HDMMsg"  renderedBinding="hdmRunAvailable@servletRequest">
	 <uix:tableLayout>
	   <uix:rowLayout>
	     
	     
	     
	     <uix:cellFormat  wrappingDisabled="true">
	       <uix:styledText styleClass="OraPromptText"
			       textBinding="START_TIME@HDMMsg"/>

	     </uix:cellFormat>
	     <uix:spacer width="4"/>
	     <uix:cellFormat wrappingDisabled="true">
	       <uix:styledText styleClass="OraDataText"
			       textBinding="HDMStartPeriod@defaultBean@servletRequest"/>
	     </uix:cellFormat>
	     <uix:spacer width="20"/>
	     <uix:cellFormat wrappingDisabled="true">
	       <uix:styledText styleClass="OraPromptText"
			       textBinding="DURATION@HDMMsg"/>

	     </uix:cellFormat>
	     <uix:spacer width="4"/>
	     <uix:cellFormat wrappingDisabled="true">
	       <uix:styledText styleClass="OraDataText"
			       textBinding="HDMDuration@defaultBean@servletRequest"/>
	     </uix:cellFormat> 
	     	     <uix:spacer width="20"/>
	     <uix:cellFormat wrappingDisabled="true" renderedBinding="RacInstance@defaultBean@servletRequest">
	       <uix:styledText styleClass="OraPromptText"
			       textBinding="INSTANCE_INFO@HDMMsg"/>

	     </uix:cellFormat>
	     <uix:spacer width="4"/>
	     <uix:cellFormat wrappingDisabled="true" renderedBinding="RacInstance@defaultBean@servletRequest">
	       <uix:styledText styleClass="OraDataText"
			       textBinding="HDMRequestedAnalysis@defaultBean@servletRequest"/>
	     </uix:cellFormat>
	   </uix:rowLayout>
	 </uix:tableLayout>
	 <oem:table name="findingsTableUI"
		    partialRenderMode="self"
                    id="findingsTableUI"
		    width="100%"
		    formSubmitted="true"
                    summaryBinding="TASK_DETAIL_HEADER@HDMMsg"
		    dataSourceProp="findingsTableUI"
		    beanKey="defaultBean" 
		    blockSize="5" alternateTextBinding="NO_FINDING_MESSAGE@HDMMsg" copyParams="target,type,task_id"> 
	 </oem:table> 
       </uix:header>  

              <uix:switcher childNameBinding="showNormal@defaultBean@servletRequest">
            <uix:case name="true">
                <%-- New policies section integration --%>
                <uix:include nodeBinding="policyNode@servletRequest"/>       
            </uix:case>
        </uix:switcher>

        <uix:switcher childNameBinding="showNormal@defaultBean@servletRequest">
            <uix:case name="true">
                <%-- New security section integration --%>
                <%-- uix:include nodeBinding="secNode@servletRequest"/ --%>
            </uix:case>
        </uix:switcher>

       <uix:tableLayout width="100%" cellSpacing="2" 
              renderedBinding="showNormal@defaultBean@servletRequest">
        <uix:rowLayout vAlign="top">

         <!-- Job Activity -->      
         <%@ include file="/sdk/jobs/jobStatusNVPairInclude.jspf" %> 

         <!--  CPF ONLY in DB Console Mode & non-rac instance -->
         <uix:switcher childNameBinding="isDBLevel@servletRequest">
         <uix:case name="true">
           <uix:switcher childNameBinding="enterpriseMode@servletRequest">
              <uix:case name="false">
                    <uix:cellFormat width="40%">
   		    	     <uix:header textBinding="CRITICAL_PATCH@mntrResourceBundle">
		   		         <uix:contents>
				  	         <uix:include nodeBinding="EcmPatch@servletRequest"/>
        				   </uix:contents>
		    	       </uix:header>
                    </uix:cellFormat>
              </uix:case>
           </uix:switcher>
         </uix:case>
         </uix:switcher> 

        </uix:rowLayout>
       </uix:tableLayout>

<%--................. if no related links (target down) at least show SGA mode option.......--%>
      <uix:switcher childNameBinding="showNormal@defaultBean@servletRequest">
        <uix:case name="false">
          <uix:tableLayout >
            <uix:rowLayout vAlign="top">
               <uix:link textBinding="targetDownSGAText@servletRequest"
                   destinationBinding="targetDownSGALink@servletRequest"
                   renderedBinding="showTargetDownSGA@servletRequest" />
            </uix:rowLayout>
            <uix:rowLayout vAlign="top">
               <uix:link textBinding="targetDownSWBText@servletRequest"
                   destinationBinding="targetDownSWBLink@servletRequest"
                   renderedBinding="showTargetDownSWB@servletRequest" />
            </uix:rowLayout>
	    <uix:rowLayout vAlign="top">
               <uix:link textBinding="targetDownPerfText@servletRequest"
                   destinationBinding="targetDownPerfLink@servletRequest" 
			 renderedBinding="instDown@servletRequest" />
            </uix:rowLayout>
          </uix:tableLayout>
        </uix:case>
      </uix:switcher>

      <uix:spacer height="15"/>

      </uix:subTabLayout>
      
    <uix:tableLayout renderedBinding="showNormal@defaultBean@servletRequest">
         <oem:relatedLinks />
    </uix:tableLayout>
    
      <uix:spacer height="5"/>

    </uix:pageLayout>
    </db:form>
    </uix:body>


  </uix:document>
</uix:renderingContext>

