<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>


<uix:cellFormat vAlign="top" width="25%" >
  <uix:header textBinding="HOST_CPU@DBMsgBundle@servletRequest" 
              renderedBinding="showNormal@defaultBean@servletRequest"
              iconBinding="cpuUtilSeverity@servletRequest">
	  <uix:stackLayout>
     <uix:tableLayout>
	      <uix:rowLayout> 
<%-- other cpu usage is only for 10g DB --%>
      	  <uix:switcher childNameBinding="instanceVersion_gte10@defaultBean@servletRequest">
            <uix:case name="true">
      <oem:chart 
        chartType="barChart"
        widthBinding="hostChartWidth@perfChart@servletRequest"
        height="150"
        shadowEffect="3d"
        orientation="vertical"
        stacked="true"
        legendPosition="east"
        legendVisible="external"
        axisMax="100"
        showXAxisLabels="false"
        yAxisSuffix="%"
        barLabelling="false"
        titleBinding="HOST_CPU@DBMsgBundle@servletRequest"
        titleVisible="false"  
        yAxisWidth="30"
        noDataMessageBinding="noDataTimeoutMessage@perfChart@servletRequest"
         >
        <oem:boundChartDataSource chartDataSourceBinding="hostCPUDataSource@perfChart@servletRequest"/>
        <oem:imageMap imageMapDataSourceBinding="hostCPUImageMap@perfChart@servletRequest"/>

        <oem:chartColumn isKey="true"
            displayLabel="Label 1"
            sourceIndex="0" />
        <oem:chartColumn displayLabelBinding="instName@perfChart@servletRequest" 
            itemColorBinding="cpuColor@perfChart@servletRequest"
            sourceIndex="1" />            
        <oem:chartColumn displayLabelBinding="OTHER@DBMsgBundle@servletRequest" 
            itemColorBinding="secondaryCpuColor@perfChart@servletRequest"
            sourceIndex="2" />            
      </oem:chart>
            </uix:case>
            <uix:case name="false">
        
      <oem:chart 
        chartType="barChart"
        widthBinding="hostChartWidth@perfChart@servletRequest"
        height="150"
        shadowEffect="3d"
        orientation="vertical"
        stacked="true"
        legendPosition="east"
        legendVisible="external"
        axisMax="100"
        showXAxisLabels="false"
        yAxisSuffix="%"
        barLabelling="false"
        titleBinding="HOST_CPU@DBMsgBundle@servletRequest"
        titleVisible="false"  
        yAxisWidth="30"
        noDataMessageBinding="noDataTimeoutMessage@perfChart@servletRequest"
         >
        <oem:boundChartDataSource chartDataSourceBinding="hostCPUDataSource@perfChart@servletRequest"/>
        <oem:imageMap imageMapDataSourceBinding="hostCPUImageMap@perfChart@servletRequest"/>

        <oem:chartColumn isKey="true"
            displayLabel="Label 1"
            sourceIndex="0" />
        <oem:chartColumn displayLabelBinding="instName@perfChart@servletRequest" 
            itemColorBinding="cpuColor@perfChart@servletRequest"
            sourceIndex="1" />            
      </oem:chart>
            </uix:case>
          </uix:switcher>
        </uix:rowLayout>
      </uix:tableLayout>
      
      <uix:rowLayout hAlign="center">
        <uix:rowLayout hAlign="center">
          <uix:cellFormat hAlign="right">
               <uix:styledText styleClass="OraPromptText"
                textBinding="LOAD@DBMsgBundle@servletRequest" />
          </uix:cellFormat>
          <uix:spacer width="5"/>
          <uix:image sourceBinding="nothing@servletRequest" />
          <uix:spacer width="5"/>
          <oem:license>
          <uix:link textBinding="runQueue@defaultBean@servletRequest"
                    destinationBinding="runQueueLink@perfChart@servletRequest"
                    shortDescBinding="RUN_QUEUE_TOOLTIP@DBMsgBundle@servletRequest" />
          </oem:license>
        </uix:rowLayout>   
        
        <uix:spacer width="15" />
        
        <uix:rowLayout>
          <uix:cellFormat hAlign="right">
              <uix:styledText styleClass="OraPromptText"
                textBinding="PAGING@DBMsgBundle@servletRequest" />
          </uix:cellFormat>
          <uix:spacer width="5"/>
          <uix:image shortDescBinding="SEVERITY@DBMsgBundle@servletRequest"
                     sourceBinding="pagingSeverity@servletRequest" />
          <uix:spacer width="5"/>
          <oem:license>
          <uix:link textBinding="pageOutRate@defaultBean@servletRequest"
                    destinationBinding="pageOutRateLink@perfChart@servletRequest"
                    shortDescBinding="PAGING_TOOLTIP@DBMsgBundle@servletRequest" />
         </oem:license>
        </uix:rowLayout>
        
      </uix:rowLayout>
      
	  </uix:stackLayout>
	</uix:header> 
  
</uix:cellFormat>



<uix:cellFormat vAlign="top" width="25%" >

  <uix:header textBinding="ACTIVE_SESSIONS@DBMsgBundle@servletRequest" 
              renderedBinding="showNormal@defaultBean@servletRequest"
              iconBinding="allClearIcon@servletRequest">
	  <uix:stackLayout>
     <uix:tableLayout>
	      <uix:rowLayout> 
      <oem:chart 
        chartType="barChart"
        stacked="true" 
        widthBinding="waitsChartWidth@perfChart@servletRequest"
        height="150"
        shadowEffect="3d"
        orientation="vertical"
        legendPosition="east"
        legendVisible="external"
        titleBinding="ACTIVE_SESSIONS@DBMsgBundle@servletRequest"
        titleVisible="false"  
        barLabelling="false"
        showXAxisLabels="false"
        axisMaxBinding="activeSessMaxValue@perfChart@servletRequest"
        yAxisWidth="30"
        yAxisNumberFormatBinding="axisNumberFormat@perfChart@servletRequest"
        noDataMessageBinding="noDataTimeoutMessage@perfChart@servletRequest"
         >
        <oem:boundChartDataSource chartDataSourceBinding="actSessDataSource@perfChart@servletRequest"/>
        <oem:imageMap imageMapDataSourceBinding="actSessImageMap@perfChart@servletRequest"/>
        
        <oem:chartColumn isKey="true"
            displayLabel="Label 1"
            sourceIndex="0" />
        <oem:chartColumn displayLabelBinding="cpuText@perfChart@servletRequest" 
            itemColorBinding="cpuColor@perfChart@servletRequest"           
            sourceIndex="1" />            
        <oem:chartColumn displayLabelBinding="ioText@perfChart@servletRequest" 
            itemColorBinding="userIOColor@perfChart@servletRequest"
            sourceIndex="2" />            
        <oem:chartColumn displayLabelBinding="waitText@perfChart@servletRequest" 
            itemColorBinding="waitColor@perfChart@servletRequest"
            sourceIndex="3" />        
            
      </oem:chart>
        </uix:rowLayout>
      </uix:tableLayout>


      <uix:rowLayout hAlign="center">
        <uix:rowLayout hAlign="center">
          <uix:cellFormat hAlign="right">
               <uix:styledText styleClass="OraPromptText"
                textBinding="CORE_COUNT@DBMsgBundle@servletRequest" />
          </uix:cellFormat>
          <uix:spacer width="10"/>
          <uix:styledText styleClass="OraDataText"
            textBinding="maximumCpu@perfChart@servletRequest"/>
        </uix:rowLayout>   
      </uix:rowLayout>


      
	  </uix:stackLayout>
	</uix:header> 
</uix:cellFormat>

<uix:cellFormat vAlign="top" width="25%" renderedBinding="responseConfigured@defaultBean@servletRequest" >
  <uix:header textBinding="SQL_RESPONSE_TIME@DBMsgBundle@servletRequest"
              renderedBinding="instanceVersion_gte9@defaultBean@servletRequest"
              iconBinding="avgRespFlag@servletRequest">
	  <uix:stackLayout>
     <uix:tableLayout>
	      <uix:rowLayout> 
      <oem:chart 
        chartType="barChart"
        widthBinding="responseChartWidth@perfChart@servletRequest" 
        height="150"
        shadowEffect="3d"
        orientation="vertical"
        legendPosition="east"
        legendVisible="external"
        titleBinding="SQL_RESPONSE_TIME@DBMsgBundle@servletRequest"
        titleVisible="false"  
        barLabelling="false"
        showXAxisLabels="false"
        axisMaxBinding="responseMaxValue@perfChart@servletRequest"
        axisMin="0"
        yAxisWidth="30"
        yAxisSuffixBinding="responseChartYAxisSuffix@perfChart@servletRequest"
	noDataMessageBinding="noResponseDataMessage@perfChart@servletRequest"
         >
        <oem:boundChartDataSource chartDataSourceBinding="responseDataSource@perfChart@servletRequest"/>
        <oem:imageMap imageMapDataSourceBinding="responseImageMap@perfChart@servletRequest"/>
        
        <oem:chartColumn isKey="true"
            displayLabel="Label 1"
            sourceIndex="0" />
        <oem:chartColumn displayLabelBinding="RESPONSE_PERCENT@DBMsgBundle@servletRequest" 
            renderedBinding="showResponseRelativePctOnly@perfChart@servletRequest"
            itemColor="#529FED"            
            sourceIndex="1" />
        <oem:chartColumn displayLabelBinding="LATEST_COLLECTION@DBMsgBundle@servletRequest" 
            renderedBinding="responseVersionGTE10_2_0_1@perfChart@servletRequest"
            itemColor="#E46800"            
            sourceIndex="1" />            
        <oem:chartColumn displayLabelBinding="BASELINE@DBMsgBundle@servletRequest" 
            renderedBinding="responseVersionGTE10_2_0_1@perfChart@servletRequest"
            itemColor="#529FED"
            sourceIndex="2" />



      </oem:chart>
        </uix:rowLayout>
        <uix:rowLayout hAlign="center">
	  <uix:rowLayout hAlign="center">
	    <uix:cellFormat>
              <uix:styledText styleClass="OraPromptText"
               	textBinding="RESPONSE_PERCENT@DBMsgBundle@servletRequest" />
	    </uix:cellFormat>
	    <uix:spacer width="5"/>
            <uix:cellFormat vAlign="top">
        <uix:switcher childNameBinding="SQLRespAvailable@perfChart@servletRequest">
          <uix:case name="true">
  	    <uix:link textBinding="SQLRespPct@perfChart@servletRequest"
                      destinationBinding="aveRespLink@servletRequest"/>
          </uix:case>
          <uix:default>
            <uix:styledText styleClass="OraPromptText"
                            textBinding="SQLRespPct@perfChart@servletRequest"/>
          </uix:default>
        </uix:switcher>
            </uix:cellFormat>
	  </uix:rowLayout>
        </uix:rowLayout> 
	<uix:rowLayout>
	  <uix:spacer height="5"/>
        </uix:rowLayout>
        <uix:rowLayout hAlign="right">
	  <uix:switcher childNameBinding="showResetBaseline@perfChart@servletRequest">
	    <uix:case name="true">
	      <uix:button textBinding="RESET_BASELINE@DBMsgBundle@servletRequest"
	                  destinationBinding="resetSQLBaselineLink@servletRequest"/>
	    </uix:case>
            <uix:case name="false">
              <uix:button textBinding="EDIT_BASELINE@DBMsgBundle@servletRequest"
                          destinationBinding="editSQLBaselineLink@servletRequest"/>
            </uix:case>
	  </uix:switcher>
        </uix:rowLayout>
      </uix:tableLayout>   
          </uix:stackLayout> 
	</uix:header> 
</uix:cellFormat>


