<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:rowLayout>


<uix:cellFormat vAlign="top" width="35%" >
	<%--.................. Configuration Advice .......................--%>
	<uix:header textBinding="DIAGNOSTIC_SUMMARY@DBMsgBundle@servletRequest"
      renderedBinding="showNormal@defaultBean@servletRequest">
	 <uix:stackLayout>
	  <uix:tableLayout>

        <!-- RAC Instance Interconnect  -->
        <uix:rowLayout renderedBinding="showRacInterconnect@defaultBean@servletRequest">
          <uix:cellFormat hAlign="right" wrappingDisabled="true">
            <uix:styledText styleClass="OraPromptText" 
                	        textBinding="RAC_IC_FINDINGS@DBMsgBundle@servletRequest" />
          </uix:cellFormat>
         
          <uix:cellFormat>
          <uix:spacer width="10"/>
          </uix:cellFormat>
          <uix:cellFormat>
          <uix:image 
            sourceBinding="intrconnFlag@servletRequest" 
            renderedBinding="showRacIntrconnStatus@defaultBean@servletRequest"
	    shortDescBinding="racIntrconnSeverityShortDesc@defaultBean@servletRequest" />

          </uix:cellFormat>  
          <uix:cellFormat>
	  	  <uix:spacer width="10"/>
	  	  </uix:cellFormat>
	  
	  	  <uix:cellFormat>
	  	  <uix:switcher childNameBinding="interconnDestAvail@servletRequest">
	  	  <uix:case name="true">
               <uix:link textBinding="racInterconnectAlerts@defaultBean@servletRequest"
            	    destinationBinding="interconnDest@servletRequest" />
          </uix:case>
          <uix:default>      	        
            <uix:styledText styleClass="OraPromptText" 
                	        textBinding="racInterconnectAlerts@defaultBean@servletRequest" />
          </uix:default>
          </uix:switcher>
          </uix:cellFormat>     
        </uix:rowLayout>

       <uix:rowLayout renderedBinding="hdmSupported@servletRequest">
	    <uix:cellFormat hAlign="right">
		  <uix:styledText 
            styleClass="OraPromptText"
            textBinding="ADDM_FINDINGS@DBMsgBundle@servletRequest" />
  		</uix:cellFormat>
        <uix:spacer width="10"/>
        <uix:image 
          sourceBinding="nothing@servletRequest" />
	  	<uix:spacer width="10"/>
       <oem:license>   
        <uix:link 
          textBinding="lastestHDMFindingCount@defaultBean@servletRequest"
          destinationBinding="latestHDMTaskUrl@servletRequest" />
	 </oem:license>
       </uix:rowLayout>    
      <uix:rowLayout renderedBinding="hdmRunAvailable@servletRequest">
        <uix:cellFormat hAlign="right">	     
           <uix:styledText styleClass="OraPromptText"
               textBinding="START_TIME@HDMMsg"/>
         </uix:cellFormat>
         <uix:spacer width="10"/>
         <uix:image sourceBinding="nothing@servletRequest" />
         <uix:spacer width="10"/>
         <uix:cellFormat wrappingDisabled="true">
          <uix:styledText styleClass="OraDataText"
			       textBinding="HDMStartPeriod@defaultBean@servletRequest"/>
        </uix:cellFormat>     
      </uix:rowLayout>

       <%-- Alert Log --%>
       <uix:rowLayout renderedBinding="showNormal@defaultBean@servletRequest">
         <uix:cellFormat hAlign="right" wrappingDisabled="true">
           <uix:styledText styleClass="OraPromptText"
                           textBinding="ALERT_LOG@DBMsgBundle@servletRequest" />
         </uix:cellFormat>
         <uix:spacer width="10"/>
         <uix:image sourceBinding="nothing@servletRequest"/>
         <uix:spacer width="10"/>
         <uix:switcher childNameBinding="alertLogCountIsAvail@defaultBean@servletRequest">
          <uix:case name="true">
           <uix:styledText styleClass="OraDataText"
                           textBinding="alertLogCount@defaultBean@servletRequest" />
          </uix:case>
          <uix:case name="false">
           <oem:license>
           <uix:link textBinding="alertLogCount@defaultBean@servletRequest"
                     destinationBinding="alertLogLink@servletRequest" />
           </oem:license>
          </uix:case>
         </uix:switcher>
       </uix:rowLayout>

        <uix:rowLayout renderedBinding="showSqlReports@defaultBean@servletRequest">
          <uix:cellFormat hAlign="right" wrappingDisabled="true">
              <uix:styledText styleClass="OraPromptText"
                textBinding="PROBLEM_SQL@DBMsgBundle@servletRequest" />
          </uix:cellFormat>
          <uix:spacer width="10"/>
          <uix:image sourceBinding="problemSqlFlag@servletRequest"/>
          <uix:spacer width="10"/>
          <uix:switcher childNameBinding="problemSqlCountIsStr@defaultBean@servletRequest">
            <uix:case name="true">
              <uix:styledText styleClass="OraDataText"
                textBinding="problemSqlCount@defaultBean@servletRequest" />
            </uix:case>
            <uix:case name="false">
              <uix:link textBinding="problemSqlCount@defaultBean@servletRequest"
                        destinationBinding="problemSqlLink@servletRequest" />
            </uix:case>
          </uix:switcher>
        </uix:rowLayout>

        <uix:rowLayout renderedBinding="showSqlReports@defaultBean@servletRequest">
          <uix:cellFormat hAlign="right">
              <uix:styledText styleClass="OraPromptText"
                textBinding="TOP_SQL_REPORT_HEADER@DBMsgBundle@servletRequest" />
          </uix:cellFormat>
          <uix:spacer width="10"/>
          <uix:image sourceBinding="nothing@servletRequest" />
          <uix:spacer width="10"/>
          <uix:switcher childNameBinding="topSqlCountIsStr@defaultBean@servletRequest">
            <uix:case name="true">
              <uix:styledText styleClass="OraDataText"
                 textBinding="topSqlCount@defaultBean@servletRequest" />
              </uix:case>
            <uix:case name="false">
              <uix:link textBinding="topSqlCount@defaultBean@servletRequest"
                 destinationBinding="topSqlLink@servletRequest" />
           </uix:case>
          </uix:switcher>
        </uix:rowLayout>
       
      <uix:rowLayout renderedBinding="instanceVersion_gte11@defaultBean@servletRequest">
        <uix:cellFormat hAlign="right">
           <uix:styledText styleClass="OraPromptText"
               textBinding="ACTIVE_INCIDENTS@DBMsgBundle@servletRequest"/>
         </uix:cellFormat>
         <uix:spacer width="10"/>
         <uix:image sourceBinding="incidentSeverity@defaultBean@servletRequest"
                    shortDescBinding= "incidentSeverityDesc@defaultBean@servletRequest" />
         <uix:spacer width="10"/>
         <uix:cellFormat wrappingDisabled="true">
          <uix:link textBinding="incidentCount@defaultBean@servletRequest"
                    destinationBinding="SWBPage@servletRequest" />
        </uix:cellFormat>
      </uix:rowLayout>

  <%-- Key SQL Profiles  --%>
      <uix:rowLayout renderedBinding="instanceVersion_gte11gR2@defaultBean@servletRequest">

        <uix:cellFormat hAlign="right">	     
          <uix:styledText styleClass="OraPromptText"
               textBinding="KEY_SQL_PROFILES@DBMsgBundle@servletRequest"/>
        </uix:cellFormat>
        <uix:spacer width="10"/>
        <uix:image sourceBinding="nothing@servletRequest" /> 
        <uix:spacer width="10"/>
        <uix:switcher childNameBinding="showAutoSqlTuneUrl@defaultBean@servletRequest">
        <uix:case name="true">
          <uix:switcher childNameBinding="hasKeyProfile@defaultBean@servletRequest">
          <uix:case name="true">
            <uix:switcher childNameBinding="autoImplEnable@defaultBean@servletRequest">
              <uix:case name="true">
            <oem:license>
               <uix:link 
                  textBinding="keyProfileCount@defaultBean@servletRequest"
                  destinationBinding="keySqlProfileUrl@servletRequest"  
                  shortDescBinding="AUTO_IMPL_TOOLTIP@DBMsgBundle@servletRequest" />
            </oem:license>
              </uix:case>
              <uix:case name="false">
            <oem:license>
               <uix:link 
                  textBinding="keyProfileCount@defaultBean@servletRequest"
                  destinationBinding="keySqlProfileUrl@servletRequest"  
                  shortDescBinding="KEY_PROFILES_TOOLTIP@DBMsgBundle@servletRequest" />
            </oem:license>
              </uix:case>
              </uix:switcher>
          </uix:case>
           <uix:case name="false">
             <uix:switcher childNameBinding="keyProfileEnable@defaultBean@servletRequest">
             <uix:case name="true">
               <oem:license>
                 <uix:link 
                   textBinding="keyProfileCount@defaultBean@servletRequest"
                   destinationBinding="keySqlProfileUrl@servletRequest"  
                   shortDescBinding="KEY_PROFILES_ENABLE_TOOLTIP@DBMsgBundle@servletRequest" />
                </oem:license>
               </uix:case>
               <uix:case name="false">
                 <oem:license>
                   <uix:link 
                      textBinding="keyProfileCount@defaultBean@servletRequest"
                      destinationBinding="keySqlProfileUrl@servletRequest"  
                      shortDescBinding="KEY_PROFILES_DISABLE_TOOLTIP@DBMsgBundle@servletRequest" />
                 </oem:license>
               </uix:case>
               </uix:switcher>
           </uix:case>
          </uix:switcher>
        </uix:case>
        <uix:case name="false">
          <uix:styledText styleClass="OraDataText"
            textBinding="unAvailableMsg@defaultBean@servletRequest" />
       </uix:case>
     </uix:switcher>
   </uix:rowLayout>
  <%-- Key SQL Profiles  --%>
 
      <uix:rowLayout renderedBinding="instanceVersion_gte11@defaultBean@servletRequest">
        <uix:spacer height="10"/>
      </uix:rowLayout>
 
      <uix:rowLayout renderedBinding="instanceVersion_gte11@defaultBean@servletRequest">
        <uix:cellFormat hAlign="center" columnSpan="5">   
          <uix:link textBinding="TITLE_DB_HEALTH_PAGE@DBHealthMsgBundle@servletRequest"
                    destinationBinding="DBHealthPage@servletRequest" />
        </uix:cellFormat>
      </uix:rowLayout>

 
       </uix:tableLayout>

     </uix:stackLayout>
     
     
        <uix:rowLayout renderedBinding="showNormal@defaultBean@servletRequest">             
        <uix:rowLayout renderedBinding="sqlNotConfigured@defaultBean@servletRequest">
          <uix:cellFormat hAlign="right">
              <uix:styledText styleClass="OraPromptText"
                textBinding="SQL_ACTIVITY_MON@DBMsgBundle@servletRequest" />
          </uix:cellFormat>
          <uix:spacer width="10" />
           <uix:styledText styleClass="OraDataText"
                textBinding="NOT_CONFIGURED@DBMsgBundle@servletRequest" />
          <uix:spacer width="10"/>
          <uix:button destinationBinding="configureLink@servletRequest"
            textBinding="CONFIGURE@DBMsgBundle@servletRequest"/>         
        </uix:rowLayout>             
      </uix:rowLayout>
     

	</uix:header>
</uix:cellFormat>  

<uix:cellFormat vAlign="top" width="35%" >
 <uix:header textBinding="SPACE_SUMMARY@DBMsgBundle@servletRequest"
    renderedBinding="showNormal@defaultBean@servletRequest">
    <uix:stackLayout>
      
      <%@ include file="/database/instance/sitemap/stgInclude.jspf" %>

    </uix:stackLayout>
  </uix:header>
  
</uix:cellFormat>   

<uix:cellFormat vAlign="top" width="30%" >
    <!--  Begin High Availability -->
    <uix:header textBinding="HIGHAVAIL@DBMsgBundle@servletRequest"
                  renderedBinding="showHA@defaultBean@servletRequest">
    <uix:stackLayout>
      <uix:tableLayout>

           <%-- Always show HA Console link --%>
           <uix:rowLayout>
             <uix:cellFormat hAlign="right" wrappingDisabled="true">
               <uix:styledText styleClass="OraPromptText"
                                textBinding="HA_CONSOLE_SM@DBMsgBundle@servletRequest" />
             </uix:cellFormat>
                                                                                
             <uix:spacer width="10"/>
             <uix:image sourceBinding="nothing@servletRequest"/>
             <uix:spacer width="10"/>
                                                                                
             <uix:cellFormat wrappingDisabled="true" hAlign="left">
               <db:link destination="/console/database/haConsole?event=doLoad"
                         copyParams="target,type"
                         textBinding="HA_DETAILS@DBMsgBundle@servletRequest" />
             </uix:cellFormat>
           </uix:rowLayout>

           <!--  Oracle Restart -->
           <uix:rowLayout renderedBinding="notRacInstance@defaultBean@servletRequest">
             <uix:cellFormat hAlign="right">
               <uix:styledText styleClass="OraPromptText"
                     textBinding="ORACLE_RESTART@DBMsgBundle@servletRequest"/>
             </uix:cellFormat>

             <uix:spacer width="10"/>

             <uix:image sourceBinding="nothing@servletRequest"/>

             <uix:spacer width="10"/>

             <uix:cellFormat wrappingDisabled="true" hAlign="left">
<uix:switcher childNameBinding="databaseRegistered@defaultBean@servletRequest" defaultCase="N/A">
<uix:case name="N/A">
<uix:styledText styleClass="OraPromptText" textBinding="N_A@DBMsgBundle@servletRequest"/>
</uix:case>
<uix:case name="YES">
<uix:styledText styleClass="OraPromptText" textBinding="DB_REPORT_ENABLED@DBMsgBundle@servletRequest"/>
</uix:case>
<uix:case name="NO">
<uix:link destinationBinding="registerLink@servletRequest" textBinding="DB_REPORT_DISABLED@DBMsgBundle@servletRequest" shortDescBinding="ORACLE_RESTART_TIP@DBMsgBundle@servletRequest"/>
</uix:case>
</uix:switcher>
             </uix:cellFormat>
           </uix:rowLayout>

           <!--  Data Guard Role -->
           <uix:rowLayout renderedBinding="showDG@defaultBean@servletRequest">
             <uix:cellFormat hAlign="right">
               <uix:styledText styleClass="OraPromptText"
                     textBinding="DATAGUARD@DBMsgBundle@servletRequest"/>
             </uix:cellFormat>

             <uix:spacer width="10"/>
              <uix:switcher childNameBinding="showDGStatus@defaultBean@servletRequest">
                <uix:case name="true">
                  <uix:image sourceBinding="dgStatusFlag@servletRequest"/>
                </uix:case>
                <uix:case name="false">
                 <uix:image sourceBinding="nothing@servletRequest"/>
                </uix:case>
              </uix:switcher>
             <uix:spacer width="10"/>

             <uix:cellFormat wrappingDisabled="true" hAlign="left">
                <db:link destination="/console/database/dataguard"
                         copyParams="target,type"
                         textBinding="DGRole@defaultBean@servletRequest" />
             </uix:cellFormat>
           </uix:rowLayout>

           <!--  Data Guard Primary DB Name  -->
           <uix:rowLayout renderedBinding="showPrmy@defaultBean@servletRequest">
             <uix:cellFormat hAlign="right">
               <uix:styledText styleClass="OraPromptText"
                     textBinding="DG_PRIMARY_DB@DBMsgBundle@servletRequest"/>
             </uix:cellFormat>

             <uix:spacer width="10"/>
             <uix:image sourceBinding="nothing@servletRequest"/>
             <uix:spacer width="10"/>

             <uix:cellFormat wrappingDisabled="true" hAlign="left">
              <uix:styledText styleClass="OraDataText"
                  textBinding="prmyEMName@defaultBean@servletRequest" />
             </uix:cellFormat>
           </uix:rowLayout>

           <!-- Instance Recovery Time -->
           <uix:rowLayout renderedBinding="showMTTR@defaultBean@servletRequest">
             <uix:cellFormat hAlign="right">
               <uix:styledText styleClass="OraPromptText"
                    textBinding="MTTR@DBMsgBundle@servletRequest"/>
             </uix:cellFormat>       

             <uix:spacer width="10"/>
             <uix:image sourceBinding="nothing@servletRequest"/>
             <uix:spacer width="10"/>

             <uix:cellFormat wrappingDisabled="true" hAlign="left">
               <db:link destination="/console/database/instance/recovery"
                       copyParams="target,type"
                       textBinding="MTTR@defaultBean@servletRequest"/>
             </uix:cellFormat>
           </uix:rowLayout>

           <!-- Last Backup -->
           <uix:rowLayout renderedBinding="showBackup@defaultBean@servletRequest">
             <uix:cellFormat hAlign="right">
              <uix:styledText styleClass="OraPromptText"
                  textBinding="backupMsg@defaultBean@servletRequest" />
             </uix:cellFormat>        

             <uix:spacer width="10"/>
              <uix:switcher childNameBinding="showBackupStatus@defaultBean@servletRequest">
                <uix:case name="true">
                  <uix:image sourceBinding="backupStatusFlag@servletRequest"/>
                </uix:case>
                <uix:case name="false">
                 <uix:image sourceBinding="nothing@servletRequest"/>
                </uix:case>
              </uix:switcher>
             <uix:spacer width="10"/>

             <uix:cellFormat wrappingDisabled="true" hAlign="left">

                <uix:switcher childNameBinding="showBackupTimeAsLink@defaultBean@servletRequest">
                  <uix:case name="true">
                     <db:link textBinding="backupTime@defaultBean@servletRequest"
                            destinationBinding="backupTimeLink@defaultBean@servletRequest"
                            copyParams="target,type"/>
                  </uix:case>
                  <uix:case name="false">
                        <uix:styledText styleClass="OraDataText"
                            textBinding="backupTime@defaultBean@servletRequest" />
                  </uix:case>
                </uix:switcher> 
             </uix:cellFormat>        
           </uix:rowLayout>
                                       
           <%-- Usable Flash Recovery Area --%>
           <uix:rowLayout renderedBinding="showReusableRecoveryArea@defaultBean@servletRequest">
             <uix:cellFormat hAlign="right" wrappingDisabled="true">
               <uix:styledText styleClass="OraPromptText"
                               textBinding="REUSABLE_RECOVERY_AREA@DBMsgBundle@servletRequest" />
             </uix:cellFormat>
                                                                                
             <uix:spacer width="10"/>
             <uix:image sourceBinding="nothing@servletRequest"/>
             <uix:spacer width="10"/>
                                                                                
             <uix:cellFormat wrappingDisabled="true" hAlign="left">
               <db:link destination="/console/database/instance/recovery?setFocus=FRA"
                         copyParams="target,type"
                         textBinding="reusableRecoveryArea@defaultBean@servletRequest" />
             </uix:cellFormat>
           </uix:rowLayout>

           <%-- Archive Area Used --%>
          <uix:switcher childNameBinding="showArchiveArea@defaultBean@servletRequest">
            <uix:case name="true">
            <uix:switcher childNameBinding="showMultiArchs@defaultBean@servletRequest">
              <uix:case name="false">
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                      <uix:styledText styleClass="OraPromptText"
                        textBinding="ARCHIVE_AREA_USED@DBMsgBundle@servletRequest" />
                  </uix:cellFormat>
    
                  <uix:spacer width="10"/>
                  <uix:image shortDescBinding="SEVERITY@DBMsgBundle@servletRequest"
                             sourceBinding="archUsageFlag@servletRequest"/>
                  <uix:spacer width="10"/>
    
                  <uix:switcher childNameBinding="archUsageIsStr@defaultBean@servletRequest">
                    <uix:case name="true">
                      <uix:styledText styleClass="OraDataText"
                        textBinding="archUsage@defaultBean@servletRequest" />
                    </uix:case>
                    <uix:case name="false">
    
                      <uix:link textBinding="archUsage@defaultBean@servletRequest"
                                destinationBinding="archUsageLink@servletRequest" />
                    </uix:case>
                  </uix:switcher>
                </uix:rowLayout>                            
              </uix:case>
              <uix:case name="true">
                <uix:rowLayout renderedBinding="showArchiveArea@defaultBean@servletRequest">
                  <uix:cellFormat hAlign="right">
                      <uix:styledText styleClass="OraPromptText"
                        textBinding="PROBLEM_ARCHIVE_AREAS@DBMsgBundle@servletRequest" />
                  </uix:cellFormat>
                  <uix:spacer width="10"/>
                  <uix:image shortDescBinding="SEVERITY@DBMsgBundle@servletRequest" 
                             sourceBinding="archUsageFlag@servletRequest" />
                  <uix:spacer width="10"/>
                  <uix:switcher childNameBinding="badArchCountIsStr@defaultBean@servletRequest">
                    <uix:case name="true">
                      <uix:styledText styleClass="OraDataText"
                        textBinding="badArchCount@defaultBean@servletRequest" />
                    </uix:case>
                    <uix:case name="false">
                      <uix:link textBinding="badArchCount@defaultBean@servletRequest"
                                destinationBinding="archUsageLink@servletRequest" />
                    </uix:case>
                  </uix:switcher>
                </uix:rowLayout>
              </uix:case>
            </uix:switcher>
            </uix:case>
          </uix:switcher>

           <%-- Flashback Logging --%>
           <uix:switcher childNameBinding="instanceVersion_gte10@defaultBean@servletRequest">
             <uix:case name="true">
               <uix:rowLayout renderedBinding="showFlashbackLogging@defaultBean@servletRequest">
                 <uix:cellFormat hAlign="right" wrappingDisabled="true">
                   <uix:styledText styleClass="OraPromptText"
                                   textBinding="FLASHBACK_LOGGING@DBMsgBundle@servletRequest" />
                 </uix:cellFormat>
                                                                                
                 <uix:spacer width="10"/>
                 <uix:image sourceBinding="nothing@servletRequest"/>
                 <uix:spacer width="10"/>
                                                                                
                 <uix:cellFormat wrappingDisabled="true" hAlign="left">
                   <db:link destinationBinding="flashbackLoggingLink@defaultBean@servletRequest"
                             copyParams="target,type"
                             textBinding="flashbackLogging@defaultBean@servletRequest" />
                 </uix:cellFormat>
               </uix:rowLayout>
             </uix:case>
           </uix:switcher>
           
           <%-- Flashback Time --%>
           <uix:rowLayout renderedBinding="showFlashbackTime@defaultBean@servletRequest">
             <uix:cellFormat hAlign="right" wrappingDisabled="true">
               <uix:styledText styleClass="OraPromptText"
                               textBinding="FLASHBACK_TIME@DBMsgBundle@servletRequest" />
             </uix:cellFormat>
                                                                                
             <uix:spacer width="10"/>
             <uix:image sourceBinding="nothing@servletRequest"/>
             <uix:spacer width="10"/>
                                                                                
             <uix:cellFormat wrappingDisabled="true" hAlign="left">
               <db:link destination="/console/database/instance/recovery?setFocus=FRA"
                         copyParams="target,type"
                         textBinding="flashbackTime@defaultBean@servletRequest" />
             </uix:cellFormat>
           </uix:rowLayout>


	  <%@ include file="/database/dist/streams/streamsHomeInclude.jspf" %>

      </uix:tableLayout>
    </uix:stackLayout>
   </uix:header>
   <!--  End High Availability -->
</uix:cellFormat>



	<%-- advice should be below general section - moved this here based on new UI rec .......................--%>




	<%--................... End recomm. settings .....................--%>

</uix:rowLayout>
