<%-- ================   SQL Statements page  =================

   MODIFIED    (MM/DD/YY)
      nachen    04/06/07 - XbranchMerge nachen_bug-5601098 from st_emdbsa_11.1
      ezeng     09/10/07 - 
      nachen    03/27/07 - fix prev/next bug
      nachen    01/24/07 - add status icon
      nachen    01/14/07 - XbranchMerge nachen_bug-5675267 from main
      nachen    12/14/06 - fix ADA
      yfeng     10/04/06 - add comparison name in parameter
      yfeng     10/03/06 - 
      nachen    07/26/06 - 
      yfeng     06/19/06 - 
      hxlin     05/08/06 - Initial draft
--%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <%@ include file="msgBundle.jspf" %>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <db:form name="SQLStmts" 
               destination="/console/database/instance/SPIAReport"
               copyParams="target,type,SPIATaskName,SPIATaskOwner,SPIATaskDescription,SPIAComparisonName,min,max,bucketId,SQLStmtType"> 
        <uix:pageLayout titleBinding="header@SPIAReportBean@servletRequest">

          <%@ include file="/database/global.jspf" %>

	  <%@ include file="infoAndError.jspf" %>

	  <%@ include file="resultTopHeader.jspf" %>

          <%-- Projected Workload Elapsed Time Chart--%>
	  <uix:rowLayout renderedBinding="showProjectedWorkloadPerformanceChart@SPIAReportBean@servletRequest">
	    <%@ include file="projectedWorkloadPerformanceChart.jspf" %>
	    <%@ include file="projectedWorkloadPerformanceSummary.jspf" %>
	  </uix:rowLayout>
          <%-- SQL Statement Count Chart --%>
          <uix:rowLayout renderedBinding="showSQLStatementCountChart@SPIAReportBean@servletRequest">
            <%@ include file="SQLStmtCountChart.jspf" %>
          </uix:rowLayout>
          <%-- Projected Workload Elapsed Time Distribution Chart--%>
          <uix:rowLayout renderedBinding="showProjectedWorkloadPerformanceDistributionChart@SPIAReportBean@servletRequest">
            <%@ include file="projectedWorkloadPerformanceDistributionChart.jspf" %>
          </uix:rowLayout>
          <%-- SQL Statement Count Chart --%>
          <uix:rowLayout renderedBinding="showSingleExecSQLStmtCountDistributionChart@SPIAReportBean@servletRequest">
            <%@ include file="singleExecSQLStmtCountDistributionChart.jspf" %>
          </uix:rowLayout>


	  <uix:header textBinding="SQLStmtHeader@SPIAReportBean@servletRequest">
	  <uix:switcher childNameBinding="showBucketInfo@SPIAReportBean@servletRequest">
            <uix:case name="true">
              <uix:labeledFieldLayout fieldWidth="65%" labelWidth="35%">
                 <uix:messagePrompt promptBinding="BUCKET_LABEL@SPIAMsg" />
                 <uix:styledText styleClass="OraDataText"
                                 textBinding="selectedBucketId@SPIAReportBean@servletRequest"/>
                 <uix:messagePrompt promptBinding="bucketRangeLabel@SPIAReportBean@servletRequest" />
                 <uix:styledText styleClass="OraDataText"
                                 textBinding="selectedBucketRange@SPIAReportBean@servletRequest"/>
                 <uix:messagePrompt promptBinding="TRIAL_RUN_NAME@SPIAMsg" />
                 <uix:styledText styleClass="OraDataText"
                                 textBinding="selectedTrialName@SPIAReportBean@servletRequest"/>
              </uix:labeledFieldLayout>
            </uix:case>
          </uix:switcher>
            <uix:table width="100%" 
                       summaryBinding="SQLStmtHeader@SPIAReportBean@servletRequest"
                       name="sqlStmt"
                       id="sqlStmt"
                       valueBinding="SQLStmtValue@SPIAReportBean@servletRequest"
                       minValueBinding="SQLStmtMinValue@SPIAReportBean@servletRequest"
 		       maxValueBinding="SQLStmtMaxValue@SPIAReportBean@servletRequest"
                       formSubmitted="true" blockSizeBinding="SQLStmtBlockSize@SPIAReportBean@servletRequest"
                       alternateTextBinding="NO_SQL_STMT@SPIAMsg"
                       tableDataBinding="SQLStmtData@SPIAReportBean@servletRequest">
              <uix:column>
                <uix:columnHeader>
                  <uix:styledText text=" "/>
                </uix:columnHeader>
		<uix:image sourceBinding="status" />
              </uix:column>
              <uix:column>
                <uix:columnHeader>
                  <uix:styledText textBinding="SQL_ID@DBMsg"/>
                </uix:columnHeader>
		<uix:link textBinding="sqlID" 
                      destinationBinding="sqlURL"/>
              </uix:column>
              <uix:column rendered="false">
                <uix:columnHeader>
                  <uix:styledText textBinding="EXECUTIONS@SPIAMsg"/>
                </uix:columnHeader>
                <uix:styledText textBinding="executions" />
                <uix:columnFormat columnDataFormat="numberFormat" />
              </uix:column>
              <uix:column>
                <uix:columnHeader>
                  <uix:styledText textBinding="NET_IMPACT_ON_WORKLOAD_PCT@SPIAMsg"/>
                </uix:columnHeader>
                <uix:styledText textBinding="netImpactOnWorkloadPct" />
                <uix:columnFormat columnDataFormat="numberFormat" />
              </uix:column>
              <uix:columnGroup>
                <uix:columnHeader>
                  <uix:text textBinding="comparisonMetricWithUnit@SPIAReportBean@servletRequest"/>
                </uix:columnHeader>
                <uix:column>
                  <uix:columnHeader>
                    <uix:text textBinding="trial1Label@SPIAReportBean@servletRequest"/>
                  </uix:columnHeader>
                  <uix:styledText textBinding="valueBefore"/>
                  <uix:columnFormat columnDataFormat="numberFormat" />
                </uix:column>
                <uix:column>
                  <uix:columnHeader>
                    <uix:text textBinding="trial2Label@SPIAReportBean@servletRequest"/>
                  </uix:columnHeader>
                  <uix:styledText textBinding="valueAfter"/>
                  <uix:columnFormat columnDataFormat="numberFormat" />
                </uix:column>
              </uix:columnGroup>
              <uix:column>
                <uix:columnHeader>
                  <uix:styledText textBinding="NET_IMPACT_ON_SQL_PCT@SPIAMsg"/>
                </uix:columnHeader>
                <uix:styledText textBinding="netImpactOnSQLPct" />
                <uix:columnFormat columnDataFormat="numberFormat" />
              </uix:column>
              <uix:column renderedBinding="showPlanChangedCol@SPIAReportBean@servletRequest">
                <uix:columnHeader>
                  <uix:styledText textBinding="PLAN_CHANGED@SPIAMsg"/>
                </uix:columnHeader>
                <uix:styledText textBinding="planChanged" />
                <uix:columnFormat columnDataFormat="textFormat" />
              </uix:column>
<%--
	      <%@ include file="commonSQLStmtCols.jspf" %>
	      <uix:switcher childNameBinding="showPlanChangedCol@SPIAReportBean@servletRequest">
		<uix:case name="true">
	      	  <%@ include file="planChangedCol.jspf" %>
		</uix:case>
	      </uix:switcher>
--%>
            </uix:table>
	  </uix:header>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
