<%-- ================   checklist page  =================

   MODIFIED    (MM/DD/YY)
      ezeng     05/08/07 - 
      yfeng     12/06/06 - Fix ADA issues
      yfeng     11/17/06 - Leave 10 pixels between Refresh button and View Data
                           label
      yfeng     11/16/06 - Add job confirmation information
      yfeng     11/08/06 - Add auto refresh choice
      yfeng     09/13/06 - Remove text of notes
      yfeng     09/12/06 - Add a button to view the result after completion
      nachen    08/07/06 - 
      yfeng     06/19/06 - 
      hxlin     05/08/06 - Initial draft
--%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <%@ include file="msgBundle.jspf" %>

  <uix:switcher childNameBinding="refreshChoice@SPIAAnalysisBean@servletRequest">
    <uix:case name="RT_15">
      <uix:rawText>
        <meta http-equiv="Refresh"
              content="15; URL=<%=request.getAttribute("refreshDest")%>">
      </uix:rawText>       
    </uix:case>
  </uix:switcher>
                
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <db:form name="SPIAChecklist" 
               destination="/console/database/instance/SPIAChecklist"
               copyParams="target,type,SPIATaskName,SPIATaskOwner">
        <uix:pageLayout titleBinding="header@SPIAAnalysisBean@servletRequest">

          <%@ include file="/database/global.jspf" %>
          <%@ include file="/sdk/page/pageMsgBox.jspf" %>
	  <%@ include file="infoAndError.jspf" %>

          <uix:tableLayout width="100%">
            <uix:rowLayout hAlign="right">
              <uix:cellFormat hAlign="right" >
                <uix:flowLayout>

                 <uix:styledText styleClass="OraTipText" 
                   textBinding="PAGE_REFRESHED_TIME@SDKBundle@servletRequest"/>
                 <uix:spacer width="5" />  
                 <uix:styledText styleClass="OraTipLabel" 
                   textBinding="refreshTime@servletRequest"/>
                 <uix:spacer width="10" />
                 <uix:button textBinding="REFRESH@SDKBundle@servletRequest"
                   destinationBinding="refreshDest@servletRequest" 
                   shortDescBinding="REFRESH@SDKBundle@servletRequest"/>
 
                  <uix:spacer width="10" />          
                  <uix:messagePrompt promptBinding="VIEW_DATA_LABEL@DBMsg" 
                                     labeledNodeId="refreshChoice"/> 
                                   
                    <uix:spacer width="5" />
                    <uix:choice id="refreshChoice" name="refreshChoice"
                               onChange="submitForm('SPIAChecklist', true, {'event':'changeViewData'})"
                               selectedValueBinding="refreshChoice@SPIAAnalysisBean@servletRequest"                                
                               shortDescBinding="VIEW_DATA_LABEL@dbMsg">
                               <uix:contents childDataBinding="viewDataList@SPIAAnalysisBean@servletRequest">
                                  <uix:option textBinding="stext"
                                              valueBinding="sval"/>
                   </uix:contents>
                  </uix:choice>   
              
                </uix:flowLayout>
              </uix:cellFormat>   

            </uix:rowLayout>
          </uix:tableLayout>

	  <uix:spacer height="5"/>

          <uix:styledText styleClass="OraInstructionText"
                          textBinding="CHECKLIST_TEXT@SPIAMsg"/>

          <uix:spacer height="5"/>

          <uix:styledText styleClass="OraInstructionText"
                          textBinding="CHECKLIST_NOTE@SPIAMsg"/>

          <uix:spacer height="5"/>

          <uix:tableLayout width="100%">
            <uix:rowLayout>
              <oem:table name="steps" beanKey="SPIAAnalysisBean"
                         summaryBinding="header@SPIAAnalysisBean@servletRequest"
                         showAll="yes"
                         formSubmitted="true"
                         dataSourceProp="stepTableUIDataSource" width="100%"/>
            </uix:rowLayout>
          </uix:tableLayout>

          <uix:spacer height="5"/>

          <uix:tip>
            <uix:styledText textBinding="ICON_TIP_TEXT@SPIAMsg"/>
            <uix:link textBinding="ICON_KEY@SPIAMsg" 
                      destinationBinding="iconURL@servletRequest"/>
          </uix:tip> 
  
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

