<%-- ================   Collect SQL Performance Before Change page  =================

   MODIFIED    (MM/DD/YY)
      nachen    08/07/06 - 
      yfeng     06/19/06 - 
      hxlin     05/08/06 - Initial draft
--%>

<%@ include file="/sdk/oemTop.jspf" %>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <%@ include file="msgBundle.jspf" %>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <db:form name="collectPerfBeforeChange" 
               destination="/console/database/instance/SPIAChecklist"
               copyParams="target,type,SPIATaskName,SPIATaskOwner">
        <uix:pageLayout titleBinding="COLLECT_PERF_BEFORE_CHANGE@SPIAMsg">

          <%@ include file="/database/global.jspf" %>

	  <%@ include file="infoAndError.jspf" %>

          <uix:styledText styleClass="OraInstructionText"
                          labeledNodeId="spia_collect_perf_before_change_sts"
                          textBinding="collectPerfBeforeChangeSTSText@SPIAAnalysisBean@servletRequest"/>

          <uix:spacer height="10"/>

          <uix:labeledFieldLayout fieldWidth="25%" labelWidth="25%" columns="2" width="100%">
            <uix:messagePrompt promptBinding="NAME@DBMsg" />
            <uix:styledText styleClass="OraDataText" 
                            textBinding="selectedName@sqlsetBean@servletRequest" />
            <uix:messagePrompt promptBinding="DESCRIPTION@DBMsg" />
            <uix:styledText styleClass="OraDataText" 
                            textBinding="selectedDescription@sqlsetBean@servletRequest" />
            <uix:messagePrompt promptBinding="OWNER@DBMsg" />
            <uix:styledText styleClass="OraDataText" 
                            textBinding="selectedOwner@sqlsetBean@servletRequest" />
            <uix:messagePrompt promptBinding="CREATED@DBMsg" />
            <uix:styledText styleClass="OraDataText" 
                            textBinding="selectedCreationTime@sqlsetBean@servletRequest" />
            <uix:messagePrompt promptBinding="NUMBER_OF_STATEMENTS@SPIAMsg" />
            <uix:styledText styleClass="OraDataText" 
                            textBinding="selectedSQLCount@sqlsetBean@servletRequest" />
            <uix:messagePrompt promptBinding="LAST_MODIFIED@DBMsg" />
            <uix:styledText styleClass="OraDataText" 
                            textBinding="selectedLastModifiedTime@sqlsetBean@servletRequest" />
          </uix:labeledFieldLayout>

          <uix:spacer height="10"/>

          <uix:styledText styleClass="OraInstructionText"
                          labeledNodeId="spia_collect_perf_before_change_new_trial"
                          textBinding="COLLECT_PERF_BEFORE_CHANGE_NEW_TRIAL_TXT@SPIAMsg"/>

          <uix:spacer height="5"/>

          <uix:submitButton textBinding="MAKE_NEW_TRIAL_RUN@SPIAMsg" 
			    name="event" value="createBeforeTrial"/>

          <uix:spacer height="10"/>

          <uix:styledText styleClass="OraInstructionText"
                          labeledNodeId="spia_collect_perf_before_change_reuse_trial"
                          textBinding="COLLECT_PERF_BEFORE_CHANGE_REUSE_TRIAL_TXT@SPIAMsg"/>

          <oem:table name="trials" beanKey="SPIAAnalysisBean"
                     summaryBinding="TRIAL_RUNS@SPIAMsg"
                     showAll="yes"
                     formSubmitted="true"
                     dataSourceProp="trialTableUIDataSource" width="100%"
                     blockSize="25" partialRenderMode="self">
            <uix:tableSelection>
              <oem:singleSelection selectedIndex="0"
                                   shortDescBinding="SELECT@DBMsg">
                <uix:submitButton textBinding="SELECT@DBMsg"
                                  name="event" value="selectBeforeTrial"/>
              </oem:singleSelection>
            </uix:tableSelection>
          </oem:table>

          <uix:contentFooter>
            <uix:pageButtonBar>
              <uix:button textBinding="CANCEL@DBMsg"                              
                          destinationBinding="cancelURL@servletRequest"/>
            </uix:pageButtonBar>
          </uix:contentFooter>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

