<%-- ================   Compare SQL Replay page  =================

   MODIFIED    (MM/DD/YY)
      yfeng     12/06/06 - Fix ADA issues
      yfeng     11/21/06 - Move the comparison metric down
      nachen    10/06/06 - 
      yfeng     09/18/06 - Fix the message bundle for SELECT
      yfeng     09/12/06 - Remove Comparison Name
      yfeng     09/11/06 - Define different event for refresh to distinquish it
                           from Checklist page
      yfeng     09/07/06 - Add one more parameter pName to distinquish pages
                           for refresh
      yfeng     08/28/06 - Initial draft copied from compare.jsp
--%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <%@ include file="msgBundle.jspf" %>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <db:form name="compare" 
               destination="/console/database/instance/SPIAChecklist"
               copyParams="target,type,SPIATaskName,SPIATaskOwner,pageName">
        <uix:formValue name="pageName" 
                       value="/database/instance/spia/compareSqlReplay"/>
                     
          <uix:pageLayout titleBinding="compareSqlReplayTitle@servletRequest">

          <%@ include file="/database/global.jspf" %>
          <%@ include file="/sdk/page/pageMsgBox.jspf" %>
	  <%@ include file="infoAndError.jspf" %>

    <uix:tableLayout width="100%">
      <uix:rowLayout hAlign="right">
        <uix:cellFormat>
          <uix:tableLayout width="100%">
            <uix:rowLayout hAlign="right">
              <uix:cellFormat>
                <uix:rowLayout>
                    <uix:styledText styleClass="OraTipText" 
                      textBinding="PAGE_REFRESHED_TIME@SDKBundle@servletRequest"/>
                    <uix:spacer width="5" />  
                    <uix:styledText styleClass="OraTipLabel" 
                      textBinding="refreshTime@servletRequest"/>
                    <uix:spacer width="10" />
                    <uix:submitButton textBinding="REFRESH@SDKBundle@servletRequest" 
                                      name="event" value="refreshCompareSQLReplay"/>
                </uix:rowLayout>
              </uix:cellFormat>
            </uix:rowLayout>
          </uix:tableLayout>
        </uix:cellFormat>
      </uix:rowLayout>
    </uix:tableLayout>
    
	  <uix:spacer height="5"/>
    
          <uix:labeledFieldLayout fieldWidth="25%" labelWidth="25%" columns="2" width="100%">
            <uix:messagePrompt promptBinding="STS_NAME@DBMsg" />
            <uix:styledText styleClass="OraDataText" 
                            textBinding="name@sqlsetBean@servletRequest" />
            <uix:messagePrompt promptBinding="STS_DESCRIPTION@SPIAMsg" />
            <uix:styledText styleClass="OraDataText" 
                            textBinding="description@sqlsetBean@servletRequest" />
            <uix:messagePrompt promptBinding="STS_OWNER@SPIAMsg" />
            <uix:styledText styleClass="OraDataText" 
                            textBinding="owner@sqlsetBean@servletRequest" />
            <uix:messagePrompt promptBinding="NUMBER_OF_STATEMENTS_IN_STS@SPIAMsg" />
            <uix:styledText styleClass="OraDataText" 
                            textBinding="selectedSQLCount@sqlsetBean@servletRequest" />
            <%--
	    <oem:choice name="comparisonMetric"
                        optionsBinding="comparisonMetricOptions@SPIAAnalysisBean@servletRequest"/>
          </uix:labeledFieldLayout>
          --%>
    </uix:labeledFieldLayout>
    
    	  <uix:spacer height="5"/>
        

     
     <%--
    </uix:labeledFieldLayout>
          <uix:labeledFieldLayout fieldWidth="50%" labelWidth="50%" columns="1" width="50%">
      <uix:messagePrompt promptBinding="TRIAL_RUN_NAME@SPIAMsg" required="yes"/>
	    <uix:textInput name="trialName" columns="50"/>
      
      <uix:messagePrompt promptBinding="COMPARISON_METRIC@SPIAMsg" required="yes"/>
      <uix:choice id="selectedComparisonMetric" 
                name="selectedComparisonMetric"
                selectedValueBinding="selectedComparisonMetric@SPIAAnalysisBean@servletRequest"                                
                shortDescBinding="COMPARISON_METRIC@SPIAMsg">
        <uix:contents childDataBinding="comparisonMetricOptions@SPIAAnalysisBean@servletRequest">
          <uix:option textBinding="stext"
                      valueBinding="sval"/>
        </uix:contents>
      </uix:choice>   
    </uix:labeledFieldLayout>
    --%>
    
    <uix:header textBinding="TRIAL_RUNS_TO_BE_ANALYZED@SPIAMsg">
    
          <uix:styledText styleClass="OraInstructionText"
                          textBinding="COMPARE_SQL_REPLAY_DESC@SPIAMsg"/>


          
          <uix:tableLayout width="100%">
            <uix:rowLayout>
              <uix:spacer height="6"/>
            </uix:rowLayout>
            <uix:rowLayout hAlign="left">
              <uix:cellFormat>
                <uix:rowLayout>
                  <uix:submitButton textBinding="CREATE_SQL_REPLAY@SPIAMsg"
                                    name="event" value="createSqlReplay"/>
                </uix:rowLayout>
              </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout>
              <uix:spacer height="6"/>
            </uix:rowLayout>
            <uix:rowLayout>

	    <oem:table name="sqlReplayUIDataSource" 
                 id="sqlReplayUIDataSource"
                 beanKey="SPIAAnalysisBean"
                 summaryBinding="TRIAL_RUNS_TO_BE_ANALYZED@SPIAMsg"
                 alternateTextBinding="NO_STATEMENTS_ALT@DBMsg"
                 width="100%"
                 blockSize="25"
                 formSubmitted="true"
                 dataSourceProp="sqlReplayUIDataSource"
                 partialRenderMode="self">

        <uix:tableSelection>
          <uix:multipleSelection
                  selectedBinding="selected"
                  shortDescBinding="SELECT@DBMsg"
                  selectionBinding="selection@sqlReplayUIDataSource@SPIAAnalysisBean@servletRequest"
                  >
          </uix:multipleSelection>
        </uix:tableSelection>
      </oem:table>
            </uix:rowLayout>
          </uix:tableLayout>
          
	  </uix:header>

          <uix:header textBinding="SELECT_COMPARISON_METRIC_HDR@SPIAMsg">
<%--
            <uix:styledText styleClass="OraInstructionText"
                            labeledNodeId="spia_select_sts"
                            textBinding="SELECT_COMPARISON_METRIC_DESC@SPIAMsg"/>
--%>
                <uix:rowLayout>
          <uix:spacer height="6"/>
                          </uix:rowLayout>
      <uix:labeledFieldLayout labelWidth="0" fieldWidth="100%" columns="1">
      <%--
        <uix:cellFormat wrappingDisabled="true" hAlign="right">
          <uix:messagePrompt labeledNodeId="comparisonNameLabel"
                             promptBinding="COMPARISON_NAME@SPIAMsg"
                             required="yes"  />
        </uix:cellFormat>
           <uix:textInput name="comparisonName" id="comparisonName"
            textBinding="comparisonName@SPIAAnalysisBean@servletRequest" />
          --%>
        <uix:cellFormat wrappingDisabled="true" hAlign="left">
          <uix:messagePrompt labeledNodeId="selectedComparisonMetric" 
                             promptBinding="COMPARISON_METRIC@SPIAMsg" />
        </uix:cellFormat>
        <uix:choice id="selectedComparisonMetric" 
                  name="selectedComparisonMetric"
                  selectedValueBinding="selectedComparisonMetric@SPIAAnalysisBean@servletRequest"                                
                  shortDescBinding="COMPARISON_METRIC@SPIAMsg">
          <uix:contents childDataBinding="comparisonMetricOptions@SPIAAnalysisBean@servletRequest">
            <uix:option textBinding="stext"
                        valueBinding="sval"/>
          </uix:contents>
        </uix:choice>   
     </uix:labeledFieldLayout>
     
	  </uix:header>
          
          
          <uix:contentFooter>
            <uix:pageButtonBar>
              <uix:button textBinding="CANCEL@DBMsg"                              
                          destinationBinding="cancelURL@servletRequest"/>
              <uix:submitButton textBinding="OK@DBMsg" 
                          name="event" value="doCompareSQLReplay"/>
            </uix:pageButtonBar>
          </uix:contentFooter>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

