<%-- ================   Create SQL Replay page  =================

   MODIFIED    (MM/DD/YY)
      ezeng     12/10/08 - XbranchMerge ezeng_bug-7572808 from
                           st_emdbgc_10.2.0.1.0
      ezeng     05/08/07 - 
      yfeng     04/03/07 - fix bug 5945053 (4) - show error under checkbox when
                           not checked
      yfeng     03/07/07 - Fix ADA issues
      yfeng     12/13/06 - Hook with Edit page
      yfeng     01/11/07 - XbranchMerge yfeng_bug-5750954 from st_emdbsa_11.1
      yfeng     12/06/06 - Fix ADA issues
      yfeng     11/21/06 - Make description textbox and add schedule
      nachen    10/06/06 - 
      yfeng     09/05/06 - Create a new SQL Replay for Compare SQL Replays
      yfeng     09/05/06 - Initial draft
--%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<db:script src="/database/LOV.js"/>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <%@ include file="msgBundle.jspf" %>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <db:form name="createNewSqlReplay" 
               destinationBinding="destController@servletRequest"
               copyParams="target,type,SPIATaskName,SPIATaskOwner,beforeChange">

        <uix:pageLayout titleBinding="REPLAY_STS@SPIAMsg">

          <%@ include file="/database/global.jspf" %>

	  <%@ include file="infoAndError.jspf" %>

          <uix:contentFooter>
            <uix:pageButtonBar>
              <uix:button textBinding="CANCEL@DBMsg"
                  shortDescBinding="CANCEL@DBMsg"
                        destinationBinding="cancelURL@servletRequest"/>
              <uix:submitButton 
                textBinding="SUBMIT@SQLMsg"
                shortDescBinding="SUBMIT@SQLMsg"
                name="event" value="doCreateSqlReplay"/>
            </uix:pageButtonBar>
          </uix:contentFooter>
          
          <uix:tableLayout width="100%">

            <uix:rowLayout hAlign="right">
              <uix:pageButtonBar>
                <uix:button textBinding="CANCEL@DBMsg"
                  shortDescBinding="CANCEL@DBMsg"
                  destinationBinding="cancelURL@servletRequest"/>
                <uix:submitButton
                  textBinding="SUBMIT@SQLMsg"
                  shortDescBinding="SUBMIT@SQLMsg"
	          name="event" value="doCreateSqlReplay"/>
              </uix:pageButtonBar>
            </uix:rowLayout>

            <uix:rowLayout>
              <uix:spacer height="3"/>
            </uix:rowLayout>

            <uix:rowLayout>

              <uix:borderLayout>
                <uix:right>
                  <uix:contentContainer textBinding="CREATE_TRIAL_DESC_TITLE@SPIAMsg" 
                                        width="400">

                    <uix:stackLayout>
                        <uix:styledText styleClass="OraInstructionText"
                            textBinding="CREATE_TRIAL_DESC_LIST_1@SPIAMsg"/>

                        <uix:spacer height="10"/>

                          <uix:styledText styleClass="OraInstructionText"
                            textBinding="CREATE_TRIAL_DESC_LIST_2@SPIAMsg"/>

                        <uix:spacer height="10"/>

                        <uix:styledText styleClass="OraInstructionText"
                            textBinding="CREATE_TRIAL_DESC_LIST_5@SPIAMsg"/>

                        <uix:bulletedList>
                          <uix:styledText styleClass="OraInstructionText"
                            textBinding="CREATE_TRIAL_DESC_LIST_6@SPIAMsg"/>

                        <uix:styledText styleClass="OraInstructionText"
                            textBinding="CREATE_TRIAL_DESC_LIST_7@SPIAMsg"/>

                          <uix:styledText styleClass="OraInstructionText"
                            textBinding="CREATE_TRIAL_DESC_LIST_8@SPIAMsg"
                            renderedBinding="showRemoteMsg@SPIAAnalysisBean@servletRequest"/>

                        <uix:styledText styleClass="OraInstructionText"
                            textBinding="CREATE_TRIAL_DESC_LIST_9@SPIAMsg"
                            renderedBinding="showBuildFromSTSMsg@SPIAAnalysisBean@servletRequest"/>
                        </uix:bulletedList>

                        <uix:spacer height="10"/>

                        <uix:styledText styleClass="OraInstructionTextStrong"
                            textBinding="CREATE_TRIAL_DESC_NOTE@SPIAMsg"/>

                        <uix:spacer height="5"/>

                      <uix:stackLayout>
                        <uix:flowLayout>
                          <uix:checkBox name="trialEnvironmentDone"
                                        id="trialEnvironmentDone"
                                        checkedBinding="trialEnvironmentDone@SPIAAnalysisBean@servletRequest"/>                 
                          <uix:styledText labeledNodeId="trialEnvironmentDone"
                                          styleClass="OraInstructionText"
                                          textBinding="TRIAL_ENVIRONMENT_ESTABLISHED@SPIAMsg"/>
                        </uix:flowLayout>
                        <uix:messageText messageType="error" messageBinding="trialEnvironmentDone@errors@servletRequest" />
                      </uix:stackLayout>
                    </uix:stackLayout>

                  </uix:contentContainer>
                </uix:right>

          <uix:stackLayout>

          <uix:styledText styleClass="OraInstructionText"
                          textBinding="CREATE_TRIAL_INST@SPIAMsg"/>

          <uix:tableLayout cellSpacing="5">
            <uix:rowLayout>
              <uix:cellFormat wrappingDisabled="true" hAlign="right">
                <uix:messagePrompt promptBinding="REPLAY_TASK@SPIAMsg" />
              </uix:cellFormat>
              <uix:styledText styleClass="OraDataText" 
                              textBinding="fullTaskNameForDisplay@SPIAAnalysisBean@servletRequest" />
            </uix:rowLayout>
            <uix:rowLayout>
              <uix:cellFormat wrappingDisabled="true" hAlign="right">
                <uix:messagePrompt promptBinding="SQL_TUNING_SET@SPIAMsg" />
              </uix:cellFormat>
              <uix:styledText styleClass="OraDataText" 
                              textBinding="fullStsName@SPIAAnalysisBean@servletRequest" />
            </uix:rowLayout>
            <uix:rowLayout>
              <uix:cellFormat wrappingDisabled="true" hAlign="right">
                <uix:messagePrompt labeledNodeId="executionName" 
                                   promptBinding="TRIAL_RUN_NAME@SPIAMsg" 
                                   required="yes"/>
              </uix:cellFormat>
    	      <uix:textInput name="executionName" 
                             id="executionName"
                             textBinding="executionName@SPIAAnalysisBean@servletRequest"
                             columns="50"/>
            </uix:rowLayout>
            <uix:rowLayout>
              <uix:cellFormat wrappingDisabled="true" hAlign="right">
                
              </uix:cellFormat>
                <uix:messageText messageType="error" messageBinding="executionName@errors@servletRequest" />
            </uix:rowLayout>      
            <uix:rowLayout>
              <uix:cellFormat wrappingDisabled="true" hAlign="right">
                <uix:messagePrompt labeledNodeId="executionDesc" 
                                   promptBinding="TRIAL_RUN_DESCRIPTION@SPIAMsg" 
                                   required="true"/>
              </uix:cellFormat>
              <uix:textInput name="executionDesc" 
                             id="executionDesc" 
                             textBinding="executionDesc@SPIAAnalysisBean@servletRequest"
                             columns="60" rows="2"/>
            </uix:rowLayout>
            <uix:rowLayout>
              <uix:cellFormat wrappingDisabled="true" hAlign="right">
                <uix:messagePrompt labeledNodeId="creationMethodSelected"
                                   promptBinding="METHOD@SPIAMsg" />
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:choice id="creationMethodSelected"
                            name="creationMethodSelected"
                            selectedValueBinding="creationMethodSelected@SPIAAnalysisBean@servletRequest"
                            shortDescBinding="METHOD@SPIAMsg"
                            onChange="submitForm('createNewSqlReplay', false, {'event':'changeCreationMethodSelection'})">
                  <uix:contents childDataBinding="creationMethodList@SPIAAnalysisBean@servletRequest">
                    <uix:option textBinding="stext"
                                valueBinding="sval"/>
                  </uix:contents>
                </uix:choice>
              </uix:cellFormat>
            </uix:rowLayout>
            <%-- Per-SQL time limit --%>
            <uix:rowLayout renderedBinding="showTimeLimit@SPIAAnalysisBean@servletRequest">
              <uix:cellFormat wrappingDisabled="true" hAlign="right">
                    <uix:messagePrompt labeledNodeId="perSqlTimeLimitSelected" 
                               promptBinding="PER_SQL_TIME_LIMIT@SPIAMsg"/>
              </uix:cellFormat>
              <uix:cellFormat>
                    <uix:rowLayout>
                    <uix:choice id="perSqlTimeLimitSelected" 
                                name="perSqlTimeLimitSelected"
                                selectedValueBinding="perSqlTimeLimitSelected@SPIAAnalysisBean@servletRequest"                                
                                shortDescBinding="PER_SQL_TIME_LIMIT@SPIAMsg"
                                onChange="submitForm('createNewSqlReplay', false, {'event':'changeSqlTimeLimitSelection'})">
                      <uix:contents childDataBinding="perSqlTimeLimitList@SPIAAnalysisBean@servletRequest">
                        <uix:option textBinding="stext"
                                    valueBinding="sval"/>
                      </uix:contents>
                    </uix:choice>
                    <uix:switcher childNameBinding="perSqlTimeLimitSelected@SPIAAnalysisBean@servletRequest">
                      <uix:case name="CUSTOMIZE">
                        <uix:flowLayout>
                        <uix:textInput name="timeLimitPerSQL" 
                                       columns="10"
                                       shortDescBinding="PER_SQL_TIME_LIMIT@SPIAMsg"
                                       textBinding="timeLimitPerSQL@SPIAAnalysisBean@servletRequest"/>
                        <uix:choice id="timeLimitPerSQLUnit"
                                    name="timeLimitPerSQLUnit"
                                    selectedValueBinding="timeLimitPerSQLUnit@SPIAAnalysisBean@servletRequest"
                                    shortDescBinding="timeLimitPerSQLUnit@SPIAAnalysisBean@servletRequest">
                          <uix:contents childDataBinding="timeLimitPerSQLUnitList@SPIAAnalysisBean@servletRequest">
                            <uix:option textBinding="stext"
                                        valueBinding="sval"/>
                          </uix:contents>
                        </uix:choice>
                        </uix:flowLayout>
                      </uix:case>
                    </uix:switcher>
                    </uix:rowLayout>             
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout renderedBinding="showTimeLimit@SPIAAnalysisBean@servletRequest">
                    <uix:cellFormat wrappingDisabled="true" hAlign="right">
                      <uix:spacer width="6"/>
                    </uix:cellFormat>
                    <uix:tip>
                       <uix:styledText styleClass="OraTipText" 
                                       textBinding="PER_SQL_TIME_LIMIT_TIP@SPIAMsg"/>
                    </uix:tip>
                  </uix:rowLayout>
                  <uix:rowLayout renderedBinding="showDbLink@SPIAAnalysisBean@servletRequest">
                    <uix:cellFormat hAlign="right">
                    <uix:messagePrompt labeledNodeId="dbLink"
                            styleClass="OraPromptText"
                            promptBinding ="DB_LINK@SPIAMsg"
                            required="yes"/>
                    </uix:cellFormat>
                    <uix:cellFormat>
                    <uix:rowLayout>
                    <uix:messageLovField name="dbLink"
                                         searchDescBinding="DB_LINK@SPIAMsg"
                                         id="dbLink"
                                         columns="28"
                                         textBinding="dbLink@SPIAAnalysisBean@servletRequest"
                                         onClick="preserveCase();startLov('dbLink', 'ListDBLinks');return false;"/>
                    <uix:spacer width="3"/> 
                    <uix:submitButton shortDescBinding="DB_LINK_CREATE@SPIAMsg"
                                      textBinding="DB_LINK_CREATE@SPIAMsg"
                                      name="event"
                                      value="createDBLink"/>
                    </uix:rowLayout>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout renderedBinding="showDbLink@SPIAAnalysisBean@servletRequest">
                    <uix:cellFormat wrappingDisabled="true" hAlign="right">
                      <uix:spacer width="6"/>
                    </uix:cellFormat>
                    <uix:tip>
                       <uix:styledText styleClass="OraTipText"
                                       textBinding="DB_LINK_TIP@SPIAMsg"/>
                    </uix:tip>
                  </uix:rowLayout>
          </uix:tableLayout>

          <uix:spacer height="10"/>

          <%@ include file="schedule.jspf" %>

          </uix:stackLayout>
          </uix:borderLayout>
          
            </uix:rowLayout>
          </uix:tableLayout>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

