<%@ include file="/sdk/oemTop.jspf" %>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <%@ include file="msgBundle.jspf" %>

  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="DELETE_ANALYSIS@SPIAMsg"/>
    </uix:metaContainer>

    <uix:body>

      <db:form name="deleteAnalysisForm" 
               destination="/console/database/instance/SPIASummary"
               copyParams="target,type">
        <uix:pageLayout>
          <%@ include file="/database/globalPopup.jspf" %>

          <uix:spacer height="20"/>
          <uix:header iconBinding="confirmationIcon@servletRequest" 
                      textBinding="CONFIRMATION@DBMsg">
            <uix:styledText styleClass="OraDataText"
                            textBinding="deleteAnalysisMsg@servletRequest"/>
          </uix:header>

          <uix:contentFooter>
            <uix:pageButtonBar>
              <uix:button textBinding="CANCEL@DBMsg"                              
                          destinationBinding="cancelURL@servletRequest"/>
              <uix:submitButton textBinding="DELETE@DBMsg" 
                          name="event" value="doDelete"/>
            </uix:pageButtonBar>
          </uix:contentFooter>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

