<%-- ================   Compare SQL Replay page  =================

   MODIFIED    (MM/DD/YY)
      ezeng     01/11/08 - 
      yfeng     04/25/07 - XbranchMerge yfeng_bug-5985420 from st_emdbsa_11.1
      yfeng     04/17/07 - XbranchMerge yfeng_bug-5960217 from st_emdbsa_11.1
      yfeng     03/14/07 - XbranchMerge yfeng_bug-5906169 from st_emdbsa_11.1
      yfeng     04/18/07 - Fix bug 6000178 - partial rendering problem
      yfeng     04/12/07 - Fix bug 5973085 - add link to show the latest report
      yfeng     03/07/07 - Fix ADA issues
      nachen    02/23/07 - 
      yfeng     01/22/07 - Implement JB's proposal
      yfeng     01/22/07 - Use NO_REPLAY_VERSIONS_ALT
      yfeng     11/21/06 - Move the comparison metric down
      nachen    10/06/06 - 
      yfeng     09/18/06 - Fix the message bundle for SELECT
      yfeng     09/12/06 - Remove Comparison Name
      yfeng     09/11/06 - Define different event for refresh to distinquish it
                           from Checklist page
      yfeng     09/07/06 - Add one more parameter pName to distinquish pages
                           for refresh
      yfeng     08/28/06 - Initial draft copied from compare.jsp
--%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <%@ include file="msgBundle.jspf" %>

  <uix:document>

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="replayTaskHomeTitle@servletRequest"/>
    </uix:metaContainer>
    
    <uix:body>
      <db:form name="edit" method="post"
               destinationBinding="destController@servletRequest"
               copyParams="target,type,SPIATaskName,SPIATaskOwner">
                     
          <uix:pageLayout titleBinding="replayTaskHomeTitle@servletRequest">

          <%@ include file="/database/global.jspf" %>
          <%@ include file="/sdk/page/pageMsgBox.jspf" %>
	  <%@ include file="infoAndError.jspf" %>

    <uix:tableLayout width="100%">
      <uix:rowLayout hAlign="right">
        <uix:cellFormat>
          <uix:tableLayout width="100%">
            <uix:rowLayout hAlign="right">
              <uix:cellFormat hAlign="left" 
                              renderedBinding="isLatestReportAvailable@SPIAAnalysisBean@servletRequest">
                <uix:link textBinding="VIEW_LATEST_REPORT@SPIAMsg"
                        longDescBinding="VIEW_LATEST_REPORT@SPIAMsg"
                        destinationBinding="latestReportUrl@SPIAAnalysisBean@servletRequest" />
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:rowLayout>
                    <uix:styledText styleClass="OraTipText" 
                      textBinding="PAGE_REFRESHED_TIME@SDKBundle@servletRequest"/>
                    <uix:spacer width="5" />  
                    <uix:styledText styleClass="OraTipLabel" 
                      textBinding="refreshTime@servletRequest"/>
                    <uix:spacer width="10" />
                    <uix:submitButton textBinding="REFRESH@SDKBundle@servletRequest" 
                                      name="event" value="refresh"/>
                </uix:rowLayout>
              </uix:cellFormat>
            </uix:rowLayout>
          </uix:tableLayout>
        </uix:cellFormat>
      </uix:rowLayout>
    </uix:tableLayout>

        <uix:spacer height="5"/>
        
          <uix:styledText styleClass="OraInstructionText"
                          textBinding="REPLAY_TASK_HOME_TEXT@SPIAMsg"/>
                          
      <uix:hideShowHeader textBinding="SQL_TUNING_SET@SPIAMsg"
                          disclosedBinding="hideSts@SPIAAnalysisBean@servletRequest"
                          formSubmitted="true"
                          id="hideShowSts"
                          partialRenderMode="self">

                          
          <uix:labeledFieldLayout fieldWidth="25%" labelWidth="25%" columns="2" width="100%">
            <uix:messagePrompt promptBinding="NAME@DBMsg" />
            <uix:styledText styleClass="OraDataText" 
                            textBinding="name@sqlsetBean@servletRequest" />
            <uix:messagePrompt promptBinding="DESCRIPTION@SPIAMsg" />
            <uix:styledText styleClass="OraDataText" 
                            textBinding="description@sqlsetBean@servletRequest" />
            <uix:messagePrompt promptBinding="OWNER@DBMsg" />
            <uix:styledText styleClass="OraDataText" 
                            textBinding="owner@sqlsetBean@servletRequest" />
            <uix:messagePrompt promptBinding="NUMBER_OF_STATEMENTS@SPIAMsg" />
            <uix:styledText styleClass="OraDataText" 
                            textBinding="selectedSQLCount@sqlsetBean@servletRequest" />
    </uix:labeledFieldLayout>
    </uix:hideShowHeader>   
 
    <uix:spacer height="10"/>
    
      <uix:hideShowHeader textBinding="REPLAY_TRIALS@SPIAMsg"
                          disclosedBinding="hideTrial@SPIAAnalysisBean@servletRequest"
                          formSubmitted="true"
                          id="hideShowTrial"
                          partialRenderMode="self">

          <uix:styledText styleClass="OraInstructionText"
                          textBinding="REPLAY_TRIAL_TEXT@SPIAMsg"/>

          <uix:tableLayout width="100%">
            <uix:rowLayout>
              <uix:spacer height="6"/>
            </uix:rowLayout>
            <uix:rowLayout hAlign="right">
              <uix:cellFormat>
                <uix:rowLayout>
                  <uix:submitButton textBinding="CREATE_SQL_REPLAY@SPIAMsg"
                                    name="event" value="createReplayVersion"
                                    renderedBinding="enableCreations@SPIAAnalysisBean@servletRequest"/>
                </uix:rowLayout>
              </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout>
              <uix:spacer height="6"/>
            </uix:rowLayout>
            <uix:rowLayout>

	    <oem:table name="sqlReplayUIDataSource" 
                 id="sqlReplayUIDataSource"
                 beanKey="SPIAAnalysisBean"
                 summaryBinding="TRIAL_RUNS_TO_BE_ANALYZED@SPIAMsg"
                 alternateTextBinding="NO_REPLAY_VERSIONS_ALT@SPIAMsg"
                 width="100%"
                 blockSize="10"
                 showAll="yes"
                 formSubmitted="true"
                 dataSourceProp="sqlReplayUIDataSource">
      </oem:table>
            </uix:rowLayout>
          </uix:tableLayout>
      </uix:hideShowHeader>   

    <uix:spacer height="10"/>

            <uix:hideShowHeader textBinding="TRIAL_COMPARISONS@SPIAMsg"
                                disclosedBinding="hideComparison@SPIAAnalysisBean@servletRequest"
                                formSubmitted="true"
                                id="hideShowComparison"
                                partialRenderMode="self">

          <uix:styledText styleClass="OraInstructionText"
                          textBinding="TRIAL_COMPARISONS_TEXT@SPIAMsg"/>
                          
          <uix:tableLayout width="100%">
            <uix:rowLayout hAlign="right">
              <uix:cellFormat>
                <uix:rowLayout>
                  <uix:submitButton textBinding="RUN_TRIAL_COMPARISON@SPIAMsg"
                                    name="event" value="compareTrials"
                                    renderedBinding="enableCreations@SPIAAnalysisBean@servletRequest"/>
                </uix:rowLayout>
              </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout>
              <uix:spacer height="6"/>
            </uix:rowLayout>
                            <uix:rowLayout>
	    <oem:table name="reportTableUIDataSource" 
                 id="reportTableUIDataSource"
                 beanKey="SPIAAnalysisBean"
                 summaryBinding="TRIAL_RUNS_TO_BE_ANALYZED@SPIAMsg"
                 alternateTextBinding="NO_REPORTS_ALT@SPIAMsg"
                 width="100%"
                 blockSize="10"
                 showAll="yes"
                 formSubmitted="true"
                 dataSourceProp="reportTableUIDataSource">

              </oem:table>
            </uix:rowLayout>
            </uix:tableLayout>
     
           </uix:hideShowHeader>
 
          <%--
          <uix:contentFooter>
            <uix:pageButtonBar>
              <uix:button textBinding="CANCEL@DBMsg"                              
                          destinationBinding="cancelURL@servletRequest"/>
              <uix:submitButton textBinding="OK@DBMsg" 
                          name="event" value="doCompareSQLReplay"/>
            </uix:pageButtonBar>
          </uix:contentFooter>
--%>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

