<%-- ================   Errors page  =================

   MODIFIED    (MM/DD/YY)
      yfeng     10/04/06 - add comparison name in parameter
      nachen    07/26/06 - 
      yfeng     06/19/06 - 
      hxlin     05/08/06 - Initial draft
--%>

<%@ include file="/sdk/oemTop.jspf" %>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <%@ include file="msgBundle.jspf" %>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <db:form name="errors" 
               destination="/console/database/instance/SPIAReport"
               copyParams="target,type,SPIATaskName,SPIATaskOwner,SPIATaskDescrption,SPIAComparisonName">
        <uix:pageLayout titleBinding="header@SPIAReportBean@servletRequest">

          <%@ include file="/database/global.jspf" %>

	  <%@ include file="infoAndError.jspf" %>

	  <%@ include file="resultTopHeader.jspf" %>

	  <uix:header textBinding="ERRORS@SPIAMsg">
	    <uix:styledText styleClass="OraInstructionText"
                          labeledNodeId="spia_errors"
                          textBinding="ERRORS_TXT@SPIAMsg"/>
	    <oem:table name="errors" beanKey="SPIAReportBean"
                       summaryBinding="ERRORS@SPIAMsg"
                       showAll="yes"
                       formSubmitted="true" blockSize="25"
                       dataSourceProp="errorTableUIDataSource" width="100%"
                       partialRenderMode="self"/>
	  </uix:header>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
