<%-- ================   Make New Trial Run page  =================

   MODIFIED    (MM/DD/YY)
      nachen    08/07/06 - 
      yfeng     06/19/06 - 
      hxlin     05/08/06 - Initial draft
--%>

<%@ include file="/sdk/oemTop.jspf" %>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="DBMsg" 
              class="oracle.sysman.db.rsc.inst.DBMsg"/>
  <uix:bundle name="SPIAMsg"
              class="oracle.sysman.db.rsc.inst.SPIAMsg"/>
  <uix:bundle name="ScheduleMsg"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="SQLMsg"
              class="oracle.sysman.db.rsc.inst.SQLMsg"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <db:form name="collectPerfBeforeChangeNewTrial" 
               destination="/console/database/instance/SPIAChecklist"
               copyParams="target,type,SPIATaskName">
        <uix:pageLayout titleBinding="COLLECT_PERF_BEFORE_CHANGE_MAKE_NEW_TRIAL_RUN@SPIAMsg">

          <%@ include file="/database/global.jspf" %>

          <oem:messageBox messageType="error" 
                          errorTableBinding="errors@servletRequest"
                          titleTextKey="titleText" 
                          mainTextKey="mainText"/>
          <oem:messageBox messageType="info" 
                          errorTableBinding="info@servletRequest"
                          titleTextKey="titleText" 
                          mainTextKey="mainText"/>  

          <uix:styledText styleClass="OraInstructionText"
                          labeledNodeId="spia_collect_perf_before_change_new_trial"
                          textBinding="COLLECT_PERF_BEFORE_CHANGE_MAKE_NEW_TRIAL_RUN_TXT@SPIAMsg"/>

          <uix:spacer height="10"/>

          <uix:labeledFieldLayout fieldWidth="75%" labelWidth="25%" width="100%">
            <uix:messagePrompt promptBinding="STS_NAME@DBMsg" />
            <uix:styledText styleClass="OraDataText" 
                            textBinding="selectedName@sqlsetBean@servletRequest" />
            <uix:messagePrompt promptBinding="STS_OWNER@SPIAMsg" />
            <uix:styledText styleClass="OraDataText" 
                            textBinding="selectedOwner@sqlsetBean@servletRequest" />
            <uix:messagePrompt promptBinding="NUMBER_OF_STATEMENTS_IN_STS@SPIAMsg" />
            <uix:styledText styleClass="OraDataText" 
                            textBinding="selectedSQLCount@sqlsetBean@servletRequest" />
            <uix:messagePrompt promptBinding="TRIAL_RUN_NAME@SPIAMsg" required="yes"/>
	    <uix:textInput name="trialName" columns="50"/>
            <uix:messagePrompt promptBinding="TRIAL_RUN_DESCRIPTION@SPIAMsg" required="true"/>
            <uix:textInput name="trialDescription" columns="120"/>
          </uix:labeledFieldLayout>

          <uix:spacer height="10"/>

	  <uix:header textBinding="XP_OPTIONS@DBMsg">
	    <uix:stackLayout>
	      <uix:styledText styleClass="OraInstructionText"
                              labeledNodeId="spia_collect_perf_before_change_new_trial_text"
                              textBinding="COLLECT_PERF_BEFORE_CHANGE_MAKE_NEW_TRIAL_RUN_OPTION_TXT@SPIAMsg"/>
	      <uix:spacer height="5"/>
	      <uix:tableLayout>
	    	<uix:rowLayout>
		  <uix:cellFormat hAlign="right">
                    <uix:messagePrompt promptBinding="EST_TIME_WO_EXEC_STATS@SPIAMsg" />
		  </uix:cellFormat>
		  <uix:cellFormat>
		    <uix:spacer width="5"/>
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left">
                    <uix:styledText styleClass="OraDataText" 
                                    textBinding="estimatedTimeWithoutExecStats@SPIAAnalysisBean@servletRequest" />
                  </uix:cellFormat>
		</uix:rowLayout>
            	<uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:messagePrompt promptBinding="EST_TIME_W_EXEC_STATS@SPIAMsg" />
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:spacer width="5"/>
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left">
                    <uix:styledText styleClass="OraDataText" 
                                    textBinding="estimatedTimeWithExecStats@SPIAAnalysisBean@servletRequest" />
                  </uix:cellFormat>
	    	</uix:rowLayout>
	      </uix:tableLayout>
              <uix:spacer height="5"/>
	      <uix:checkBox name="collectExecStats" 
                            checkedBinding="collectExecStats@SPIAAnalysisBean@servletRequest"
                            textBinding="COLLECT_EXEC_STATS@SPIAMsg"/>
	    </uix:stackLayout>
	  </uix:header>
<%--
	  <uix:dataScope>
--%>
	  <uix:header textBinding="OPT_SCHEDULE@SQLMsg">
	    <uix:tableLayout cellSpacing="5">
	      <uix:cellFormat hAlign="right">
		<uix:messagePrompt promptBinding="TIME_ZONE@ScheduleMsg"/>
	      </uix:cellFormat>
	      <uix:cellFormat>
		<oem:choice name="startTimeZoneSB"
     			    optionsBinding="timeZonesSB@scheduleBean@servletRequest"
     			    selectedValueBinding="startTimeZoneSB@scheduleBean@servletRequest"/>
	      </uix:cellFormat>
	    </uix:tableLayout>
	    <uix:tableLayout cellSpacing="5">
	      <uix:rowLayout>
		<uix:radioButton name="scheduleTypeSB"
     				 value="now"
     				 selectedValueBinding="scheduleTypeSB@scheduleBean@servletRequest"
     				 textBinding="IMMEDIATELY@ScheduleMsg"
     				 styleClass="OraInstructionText"/>
	      </uix:rowLayout>
	      <uix:rowLayout>
		<uix:radioButton name="scheduleTypeSB"
     				 value="later"
     				 selectedValueBinding="scheduleTypeSB@scheduleBean@servletRequest"
     				 textBinding="LATER@ScheduleMsg"
     				 styleClass="OraInstructionText"/>
	      </uix:rowLayout>
	      <uix:rowLayout>
		<uix:cellFormat  hAlign="right">
		  <uix:messagePrompt promptBinding="DATE@ScheduleMsg"/>
		</uix:cellFormat>
		<uix:messageDateField name="startDateSB"
     				      valueBinding="startDateSB@scheduleBean@pageContext"
     				      tipBinding="dateTip@scheduleBean@servletRequest"
     				      columns="24">
		  <uix:onSubmitValidater>
		    <uix:date dateStyle="medium"/>
		  </uix:onSubmitValidater>
		</uix:messageDateField>
	      </uix:rowLayout>
	      <uix:rowLayout hAlign="right">
		<uix:messagePrompt promptBinding="TIME@ScheduleMsg"/>
		<uix:flowLayout>
		  <oem:choice name="startHourSB"
     			      optionsBinding="hoursSB@scheduleBean@servletRequest"
     			      selectedValueBinding="startHourSB@scheduleBean@servletRequest"/>
		  <oem:choice name="startMinuteSB"
     			      optionsBinding="minutesSB@scheduleBean@servletRequest"
     			      selectedValueBinding="startMinuteSB@scheduleBean@servletRequest"/>
		  <oem:choice name="startSecondSB"
     			      renderedBinding="showSeconds@scheduleBean@servletRequest"
     			      optionsBinding="secondsSB@scheduleBean@servletRequest"
     			      selectedValueBinding="startSecondSB@scheduleBean@servletRequest"/>
		  <oem:radioButton name="startAmPmSB"
     				   value="AM_VALUE"
     				   selectedValueBinding="startAmPmSB@scheduleBean@servletRequest"
     				   textBinding="AM_LABEL@ScheduleMsg"
     				   styleClass="OraInstructionText"/>
		  <oem:radioButton name="startAmPmSB"
     				   value="PM_VALUE"
     				   selectedValueBinding="startAmPmSB@scheduleBean@servletRequest"
     				   textBinding="PM_LABEL@ScheduleMsg"
     				   styleClass="OraInstructionText"/>
		</uix:flowLayout>
	      </uix:rowLayout>
	    </uix:tableLayout>
	  </uix:header>
<%--
	  </uix:dataScope>
--%>
          <uix:contentFooter>
            <uix:pageButtonBar>
              <uix:button textBinding="CANCEL@DBMsg"                              
                          destinationBinding="cancelURL@servletRequest"/>
              <uix:submitButton textBinding="OK@DBMsg" 
                          name="event" value="doCreateTrial"/>
            </uix:pageButtonBar>
          </uix:contentFooter>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

