<%-- ================   Overall Report page  =================

   MODIFIED    (MM/DD/YY)
      ezeng     12/10/08 - XbranchMerge ezeng_bug-7572808 from
                           st_emdbgc_10.2.0.1.0
      manaraya  06/19/07 - XbranchMerge manaraya_bug-6074599 from
                           st_emdbsa_11.1
      nachen    05/04/07 - XbranchMerge nachen_bug-6001544 from st_emdbsa_11.1
      ezeng     09/10/07 - 
      manaraya  05/28/07 - Bug 6014038
      nachen    04/23/07 - add top 10 sqls
      yfeng     02/22/07 - add tuning task link
      nachen    01/23/07 - change layout
      nachen    01/14/07 - XbranchMerge nachen_bug-5675267 from main
      nachen    12/14/06 - fix ADA
      yfeng     10/04/06 - add comparison name in parameter
      yfeng     09/29/06 - change bar colors
      nachen    07/26/06 - 
      yfeng     06/19/06 - 
      hxlin     05/08/06 - Initial draft
--%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <%@ include file="msgBundle.jspf" %>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <db:form name="overallReport" 
               destination="/console/database/instance/SPIAReport"
               copyParams="target,type,SPIATaskName,SPIATaskOwner,SPIATaskDescription,SPIAComparisonName"> 
        <uix:pageLayout titleBinding="header@SPIAReportBean@servletRequest">

          <%@ include file="/database/global.jspf" %>

	  <%@ include file="infoAndError.jspf" %>

	  <%@ include file="resultTopHeader.jspf" %>

          <uix:header textBinding="GLOBAL_STATISTICS@SPIAMsg">
	    <uix:tableLayout>
	      <uix:rowLayout>
                <uix:rowLayout>
 
                  <%-- Projected Workload Performance --%>
		  <uix:cellFormat vAlign="top">
	            <uix:tableLayout>
	      	      <uix:rowLayout>
		        <%@ include file="projectedWorkloadPerformanceChart.jspf" %>
	              </uix:rowLayout>
                      <uix:rowLayout hAlign="center">
		        <%@ include file="projectedWorkloadPerformanceSummary.jspf" %>
	              </uix:rowLayout>
	    	    </uix:tableLayout>
		  </uix:cellFormat>

            	  <%-- SQL Statement Count --%>
		  <uix:cellFormat vAlign="top">
		    <%@ include file="SQLStmtCountChart.jspf" %>
		  </uix:cellFormat>

		  <%-- Recommendation --%>
		  <uix:cellFormat vAlign="top" renderedBinding="showTuningBtn@SPIAReportBean@servletRequest">
		    <uix:header textBinding="RECOMMENDATIONS@DBMsg">
		    <uix:tableLayout width="100%">
		    	<uix:rowLayout renderedBinding="showBaselineBtn@SPIAReportBean@servletRequest">
			<uix:cellFormat columnSpan="2">
		        <uix:styledText styleClass="OraInstructionText"
                          textBinding="REPORT_RECOMMEND@SPIAMsg"/>
			</uix:cellFormat>
		    	</uix:rowLayout>
		    	<uix:rowLayout>
			<uix:cellFormat width="5%">
			<uix:styledText styleClass="OraInstructionText" text=""/>
			</uix:cellFormat>
			<uix:cellFormat>
		    <uix:tableLayout width="80%">
		      <uix:stackLayout>
                        <uix:stackLayout renderedBinding="showBaselineBtn@SPIAReportBean@servletRequest">
		        <uix:spacer height="10"/>
		        <uix:styledText styleClass="OraInstructionText"
                          textBinding="BASELINE_INSTR@SPIAMsg"/>
		        <uix:spacer height="5"/>
		        <uix:submitButton
			textBinding="CREATE_BASELINE@SPIAMsg"
                                    name="event" value="createPlanBaseline"/>
                        </uix:stackLayout>
                      <uix:switcher childNameBinding="hasTuningTask@SPIAReportBean@servletRequest">
                      <uix:case name="true">
                        <uix:flowLayout>
                           <uix:messagePrompt promptBinding="SQLTUNE_REPORT@SPIAMsg"/>
			   <uix:spacer width="15" height="15"/>
                           <uix:link destinationBinding="tuningTaskURL@SPIAReportBean@servletRequest"
                                textBinding="fullTuningTaskNameForDisplay@SPIAReportBean@servletRequest"/>                
                        </uix:flowLayout>
                      </uix:case>
                      <uix:default>
		      <uix:stackLayout>
		        <uix:spacer height="15"/>
		        <uix:styledText styleClass="OraInstructionText"
                          textBinding="TUNING_ADVISOR_INSTR@SPIAMsg"/>
		        <uix:spacer height="5"/>
		        <uix:submitButton textBinding="RUN_SQL_TUNING_ADVISOR@SPIAMsg"
                                    name="event" value="scheduleTuningTask"/>
		      </uix:stackLayout>
                      </uix:default>
                      </uix:switcher>
		      </uix:stackLayout>
		      </uix:tableLayout>
		      </uix:cellFormat>
		      </uix:rowLayout>
		      </uix:tableLayout>
		    </uix:header>
		  </uix:cellFormat>
	        </uix:rowLayout>
              </uix:rowLayout>

	    </uix:tableLayout>
	  </uix:header>
          <uix:header textBinding="TOP_SQLS@SPIAMsg">
            <uix:table width="100%" 
                       summaryBinding="TOP_SQLS@SPIAMsg"
                       name="sqlStmt"
                       id="sqlStmt"
                       valueBinding="SQLStmtValue@SPIAReportBean@servletRequest"
                       minValueBinding="SQLStmtMinValue@SPIAReportBean@servletRequest"
 		       maxValueBinding="SQLStmtMaxValue@SPIAReportBean@servletRequest"
                       formSubmitted="true" blockSizeBinding="SQLStmtBlockSize@SPIAReportBean@servletRequest"
                       alternateTextBinding="NO_SQL_STMT@SPIAMsg"
                       tableDataBinding="SQLStmtData@SPIAReportBean@servletRequest">
              <uix:column>
                <uix:columnHeader>
                  <uix:styledText text=" "/>
                </uix:columnHeader>
		<uix:image sourceBinding="status" />
              </uix:column>
              <uix:column>
                <uix:columnHeader>
                  <uix:styledText textBinding="SQL_ID@DBMsg"/>
                </uix:columnHeader>
		<uix:link textBinding="sqlID" 
                      destinationBinding="sqlURL"/>
              </uix:column>
              <uix:column rendered="false">
                <uix:columnHeader>
                  <uix:styledText textBinding="EXECUTIONS@SPIAMsg"/>
                </uix:columnHeader>
                <uix:styledText textBinding="executions" />
                <uix:columnFormat columnDataFormat="numberFormat" />
              </uix:column>
              <uix:column>
                <uix:columnHeader>
                  <uix:styledText textBinding="NET_IMPACT_ON_WORKLOAD_PCT@SPIAMsg"/>
                </uix:columnHeader>
                <uix:styledText textBinding="netImpactOnWorkloadPct" />
                <uix:columnFormat columnDataFormat="numberFormat" />
              </uix:column>
              <uix:columnGroup>
                <uix:columnHeader>
                  <uix:text textBinding="comparisonMetricWithUnit@SPIAReportBean@servletRequest"/>
                </uix:columnHeader>
                <uix:column>
                  <uix:columnHeader>
                    <uix:text textBinding="trial1Label@SPIAReportBean@servletRequest"/>
                  </uix:columnHeader>
                  <uix:styledText textBinding="valueBefore"/>
                  <uix:columnFormat columnDataFormat="numberFormat" />
                </uix:column>
                <uix:column>
                  <uix:columnHeader>
                    <uix:text textBinding="trial2Label@SPIAReportBean@servletRequest"/>
                  </uix:columnHeader>
                  <uix:styledText textBinding="valueAfter"/>
                  <uix:columnFormat columnDataFormat="numberFormat" />
                </uix:column>
              </uix:columnGroup>
              <uix:column>
                <uix:columnHeader>
                  <uix:styledText textBinding="NET_IMPACT_ON_SQL_PCT@SPIAMsg"/>
                </uix:columnHeader>
                <uix:styledText textBinding="netImpactOnSQLPct" />
                <uix:columnFormat columnDataFormat="numberFormat" />
              </uix:column>
              <uix:column renderedBinding="showPlanChangedCol@SPIAReportBean@servletRequest">
                <uix:columnHeader>
                  <uix:styledText textBinding="PLAN_CHANGED@SPIAMsg"/>
                </uix:columnHeader>
                <uix:styledText textBinding="planChanged" />
                <uix:columnFormat columnDataFormat="textFormat" />
              </uix:column>
<%--
	      <%@ include file="commonSQLStmtCols.jspf" %>
	      <uix:switcher childNameBinding="showPlanChangedCol@SPIAReportBean@servletRequest">
		<uix:case name="true">
	      	  <%@ include file="planChangedCol.jspf" %>
		</uix:case>
	      </uix:switcher>
--%>
            </uix:table>
          </uix:header>     
<%--
            <uix:labeledFieldLayout fieldWidth="25%" labelWidth="25%" columns="2" width="100%">
              <uix:messagePrompt promptBinding="STATUS@DBMsg" />
              <uix:styledText styleClass="OraDataText" 
                              textBinding="status@SPIAReportBean@servletRequest" />
              <uix:messagePrompt promptBinding="START_TIME@SQLMsg" />
              <uix:styledText styleClass="OraDataText" 
                              textBinding="startTime@SPIAReportBean@servletRequest" />
              <uix:messagePrompt promptBinding="COMPARISON_METRIC@SPIAMsg" />
              <uix:styledText styleClass="OraDataText" 
                              textBinding="comparisonMetric@SPIAReportBean@servletRequest" />
              <uix:messagePrompt promptBinding="END_TIME@SQLMsg" />
              <uix:styledText styleClass="OraDataText" 
                              textBinding="endTime@SPIAReportBean@servletRequest" />
              <uix:messagePrompt promptBinding="NUMBER_OF_STATEMENTS@SPIAMsg" />
              <uix:styledText styleClass="OraDataText" 
                              textBinding="SQLStmtCount@SPIAReportBean@servletRequest" />
              <uix:messagePrompt promptBinding="TIME_LIMIT@SPIAMsg" />
              <uix:styledText styleClass="OraDataText" 
                              textBinding="timeLimit@SPIAReportBean@servletRequest" />
            </uix:labeledFieldLayout>
	    <uix:header textBinding="TRIAL_RUN_COMPARISON@SPIAMsg">
	      <oem:table name="analyzedTrials" beanKey="SPIAReportBean"
                         summaryBinding="TRIAL_RUN_COMPARISON@SPIAMsg"
                         showAll="yes"
                         formSubmitted="true"
                         dataSourceProp="analyzedTrialTableUIDataSource" width="100%"
                         partialRenderMode="self"/>
	    </uix:header>
--%>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

