<%-- ================   Parameter Change page  =================

   MODIFIED    (MM/DD/YY)
      manaraya  08/14/08 - Fix paramater change
      manaraya  07/21/08 - 
      ezeng     03/11/08 - 
      ezeng     01/11/08 - 
      yfeng     04/10/07 - XbranchMerge yfeng_bug-5945053 from st_emdbsa_11.1
      yfeng     03/14/07 - XbranchMerge yfeng_bug-5906169 from st_emdbsa_11.1
      yfeng     04/05/07 - Add validation errors
      yfeng     03/07/07 - Fix ADA issues
      nachen    02/23/07 - 
      yfeng     01/23/07 - Created
--%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>
<db:script src="/database/LOV.js"/>

<script>
  function lovCallBack(data) {
    f1 = callBackLovField();
    f2 = 'selectedParamValue';

    if ((i=data.indexOf('.')) >= 0)
    {
      document.forms[0][f1].value = data.substring(0,i);
      if ((j=data.substring(i+1, data.length).lastIndexOf('.')) >= 0)
      {
          document.forms[0][f2].value =data.substring(i+1, i+j+1);
      }
      if (data.substring(j+1, data.length) != ' ')
      {
        document.forms[0]['paramType'].value = data.substring(j+1, data.length);
      }
      else
        document.forms[0]['paramType'].value = '';
    }
    submitForm('form', false, {'event':'changeParam'});
  }
</script>


<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <%@ include file="msgBundle.jspf" %>
  
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="SQL_REPLAY_PARAMETER_CHANGE@SPIAMsg"/>
    </uix:metaContainer>

    <uix:body>

      <db:form
        name="form"
        destinationBinding="destController@servletRequest"
        method="post"
        copyParams="target,type">
        <uix:formValue name="pageName" 
                       value="/database/instance/spia/parameterChange"/>

        <uix:formValue name="paramType" value=""/>
        <uix:formValue name="selectedParamValue" value=""/>

        <uix:pageLayout titleBinding="SQL_REPLAY_PARAMETER_CHANGE@SPIAMsg">
          <%@ include file="/database/global.jspf" %>
	  <%@ include file="infoAndError.jspf" %>

          <uix:contentFooter>
            <uix:pageButtonBar>
              <uix:button textBinding="CANCEL@DBMsg"
                shortDescBinding="CANCEL@DBMsg"
                destinationBinding="cancelURL@servletRequest"/>
              <uix:submitButton formName="form" 
                textBinding="SUBMIT@SQLMsg"
                shortDescBinding="SUBMIT@SQLMsg"
                name="event" value="submit"/>
            </uix:pageButtonBar>
          </uix:contentFooter>
          
          <uix:tableLayout width="100%">

            <uix:rowLayout hAlign="right">
              <uix:pageButtonBar>
                <uix:button textBinding="CANCEL@DBMsg"
                  shortDescBinding="CANCEL@DBObjectBundle@servletRequest"
                  destinationBinding="cancelURL@servletRequest"/>
                <uix:submitButton formName="form" 
                  textBinding="SUBMIT@SQLMsg"
                  shortDescBinding="SUBMIT@SQLMsg"
                  name="event" value="submit"/>
              </uix:pageButtonBar>
            </uix:rowLayout>

            <uix:rowLayout>
              <uix:spacer height="3"/>
            </uix:rowLayout>

            <uix:rowLayout>

              <uix:borderLayout>
                <uix:right>
                  <uix:contentContainer textBinding="PARAMETER_CHANGE_DESCRIPTION_TITLE@SPIAMsg" 
                                        width="480">

                    <uix:stackLayout>
                        <uix:styledText styleClass="OraInstructionText"
                            textBinding="PARAMETER_CHANGE_DESCRIPTION_PARAGRAPH_1@SPIAMsg"/>

                        <uix:bulletedList>
                          <uix:styledText styleClass="OraInstructionText"
                            textBinding="PARAMETER_CHANGE_DESCRIPTION_LIST_1@SPIAMsg"/>
                          <uix:styledText styleClass="OraInstructionText"
                            textBinding="PARAMETER_CHANGE_DESCRIPTION_LIST_2@SPIAMsg"/>
                          <uix:styledText styleClass="OraInstructionText"
                            textBinding="PARAMETER_CHANGE_DESCRIPTION_LIST_3@SPIAMsg"/>
                        </uix:bulletedList>

                        <uix:spacer height="10"/>

                        <uix:styledText styleClass="OraInstructionText"
                            textBinding="CREATE_TRIAL_DESC_LIST_5@SPIAMsg"/>

                        <uix:bulletedList>
                          <uix:styledText styleClass="OraInstructionText"
                            textBinding="CREATE_TRIAL_DESC_LIST_6@SPIAMsg"/>

                          <uix:styledText styleClass="OraInstructionText"
                            textBinding="CREATE_TRIAL_DESC_LIST_7@SPIAMsg"/>
                        </uix:bulletedList>
                    </uix:stackLayout>

                  </uix:contentContainer>
                </uix:right>
                
                
                <uix:stackLayout>
                <uix:header textBinding="TASK_INFORMATION@SPIAMsg">
                  <uix:tableLayout cellSpacing="5">
                    <uix:rowLayout>
                      <uix:cellFormat wrappingDisabled="true" hAlign="right">
                        <uix:messagePrompt labeledNodeId="taskName"
                                           promptBinding="ANALYSIS_NAME@SPIAMsg"
                                           required="yes"  />
                    </uix:cellFormat>
                    <uix:textInput name="taskName" id="taskName"
                         columns="40"
                         textBinding="taskName@parameterChangeBean@servletRequest"
                         required="yes" />
                    </uix:rowLayout>
                    <uix:rowLayout>
                      <uix:cellFormat wrappingDisabled="true" hAlign="right">
                      </uix:cellFormat >
                      <uix:cellFormat hAlign="left">
                        <uix:messageText messageType="error" messageBinding="taskName@errors@servletRequest" />
                      </uix:cellFormat >
                    </uix:rowLayout>
                    
       
                    <%-- SQL Tuning Set  --%>
                    <uix:rowLayout>
                    <uix:cellFormat hAlign="right"> 
                    <uix:messagePrompt labeledNodeId="fullStsName"
                            styleClass="OraPromptText" 
                            promptBinding ="SQL_TUNING_SET@SQLMsg"
                            required="yes"/>
                    </uix:cellFormat>

                    <uix:messageLovField 
                                         name="fullStsName" 
                                         searchDescBinding="SQL_TUNING_SET@SQLMsg"
                                         id="fullStsName" 
                                         columns="40"
                                         textBinding="fullStsName@parameterChangeBean@servletRequest" 
                                         onClick="startLov('fullStsName', 'ListSTS');return false;"/>

                    </uix:rowLayout>   
                    <uix:rowLayout>
                      <uix:cellFormat wrappingDisabled="true" hAlign="right">
                      </uix:cellFormat >
                      <uix:cellFormat hAlign="left">
                        <uix:messageText messageType="error" messageBinding="fullStsName@errors@servletRequest" />
                      </uix:cellFormat >
                    </uix:rowLayout>
                    
                         <uix:rowLayout>  
                    <uix:cellFormat wrappingDisabled="true" hAlign="right">
                    <uix:messagePrompt labeledNodeId="taskDescription" 
                               promptBinding="DESCRIPTION@DBMsg" />
                    </uix:cellFormat>
                    <uix:textInput name="taskDescription" id="taskDescription"
                            columns="40"
                            textBinding="taskDescription@parameterChangeBean@servletRequest"  />
                    </uix:rowLayout> 
                   
            <uix:rowLayout>
              <uix:cellFormat wrappingDisabled="true" hAlign="right">
                <uix:messagePrompt labeledNodeId="creationMethodSelected"
                                   promptBinding="METHOD@SPIAMsg" />
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:choice id="creationMethodSelected"
                            name="creationMethodSelected"
                            selectedValueBinding="creationMethodSelected@parameterChangeBean@servletRequest"
                            shortDescBinding="METHOD@SPIAMsg"
                            onChange="submitForm('form', false, {'event':'changeCreationMethodSelection'})">
                  <uix:contents childDataBinding="creationMethodList@parameterChangeBean@servletRequest">
                    <uix:option textBinding="stext"
                                valueBinding="sval"/>
                  </uix:contents>
                </uix:choice>
              </uix:cellFormat>
            </uix:rowLayout> 
                    
                  <%-- Per-SQL time limit --%>
                  <uix:rowLayout renderedBinding="showTimeLimit@parameterChangeBean@servletRequest">
                    <uix:cellFormat wrappingDisabled="true" hAlign="right">
                    <uix:messagePrompt labeledNodeId="perSqlTimeLimitSelected" 
                               promptBinding="PER_SQL_TIME_LIMIT@SPIAMsg" />
                    </uix:cellFormat>
                    <uix:cellFormat>
                    <uix:rowLayout>
                    <uix:choice id="perSqlTimeLimitSelected" 
                                name="perSqlTimeLimitSelected"
                                selectedValueBinding="perSqlTimeLimitSelected@parameterChangeBean@servletRequest"                                
                                shortDescBinding="PER_SQL_TIME_LIMIT@SPIAMsg"
                                onChange="submitForm('form', false, {'event':'changeSqlTimeLimitSelection'})">
                      <uix:contents childDataBinding="perSqlTimeLimitList@parameterChangeBean@servletRequest">
                        <uix:option textBinding="stext"
                                    valueBinding="sval"/>
                      </uix:contents>
                    </uix:choice>
                    <uix:switcher childNameBinding="perSqlTimeLimitSelected@parameterChangeBean@servletRequest">
                      <uix:case name="CUSTOMIZE">
                        <uix:flowLayout>
                        <uix:textInput name="timeLimitPerSQL" 
                                       columns="10"
                                       id="timeLimitPerSQL"
                                       textBinding="timeLimitPerSQL@parameterChangeBean@servletRequest"/>
                        <uix:choice id="timeLimitPerSQLUnit"
                                    name="timeLimitPerSQLUnit"
                                    selectedValueBinding="timeLimitPerSQLUnit@parameterChangeBean@servletRequest"
                                    shortDescBinding="timeLimitPerSQLUnit@parameterChangeBean@servletRequest">
                          <uix:contents childDataBinding="timeLimitPerSQLUnitList@parameterChangeBean@servletRequest">
                            <uix:option textBinding="stext"
                                        valueBinding="sval"/>
                          </uix:contents>
                        </uix:choice>
                        </uix:flowLayout>
                      </uix:case>
                    </uix:switcher>
                    </uix:rowLayout>
                    </uix:cellFormat>
                  </uix:rowLayout>

                  <uix:rowLayout renderedBinding="showTimeLimit@parameterChangeBean@servletRequest">
                    <uix:cellFormat wrappingDisabled="true" hAlign="right">
                      <uix:spacer width="6"/>
                    </uix:cellFormat>
                    <uix:tip>
                       <uix:styledText styleClass="OraTipText" 
                                       textBinding="PER_SQL_TIME_LIMIT_TIP@SPIAMsg"/>
                    </uix:tip>
                  </uix:rowLayout>
                  </uix:tableLayout>
                </uix:header>
                
                <%-- Parameter Change Section --%>
                <uix:header textBinding="PARAMETER_CHANGE@SPIAMsg">


                  <uix:tableLayout cellSpacing="5">

                  <uix:rowLayout>
                    <uix:cellFormat wrappingDisabled="true" hAlign="right">
                    <uix:messagePrompt labeledNodeId="parameterName" 
                                       promptBinding="PARAMETER_NAME@SPIAMsg" 
                                       required="yes" />
                    </uix:cellFormat>
                    <uix:messageLovField name="parameterName" id="parameterName"
                            searchDescBinding="PARAMETER_NAME@SPIAMsg"
                            columns="40"
                            textBinding="parameterName@parameterChangeBean@servletRequest"  
                            onClick="useCallBack();preserveCase();startLov('parameterName', 'ListInitParams'); return false;"/>
                  </uix:rowLayout>   
                    <uix:rowLayout>
                      <uix:cellFormat wrappingDisabled="true" hAlign="right">
                      </uix:cellFormat >
                      <uix:cellFormat hAlign="left">
                        <uix:messageText messageType="error" messageBinding="parameterName@errors@servletRequest" />
                      </uix:cellFormat >
                    </uix:rowLayout>
                    
                  <uix:rowLayout>
                    <uix:cellFormat wrappingDisabled="true" hAlign="right">
                    <uix:messagePrompt labeledNodeId="baseValue" 
                                       promptBinding="BASE_VALUE@SPIAMsg" 
                                       required="yes"/>
                    </uix:cellFormat>
		    <uix:include nodeBinding="baseDisplayNode@parameterChangeBean@servletRequest" />
                  </uix:rowLayout> 
                    <uix:rowLayout>
                      <uix:cellFormat wrappingDisabled="true" hAlign="right">
                      </uix:cellFormat >
                      <uix:cellFormat hAlign="left">
                        <uix:messageText messageType="error" messageBinding="baseValue@errors@servletRequest" />
                      </uix:cellFormat >
                    </uix:rowLayout>
                    
                  <uix:rowLayout>
                    <uix:cellFormat wrappingDisabled="true" hAlign="right">
                    <uix:messagePrompt labeledNodeId="changedValue" 
                                       promptBinding="CHANGED_VALUE@SPIAMsg" 
                                       required="yes" />
                    </uix:cellFormat>
		    <uix:include nodeBinding="changedDisplayNode@parameterChangeBean@servletRequest" />
                  </uix:rowLayout> 
                    <uix:rowLayout>
                      <uix:cellFormat wrappingDisabled="true" hAlign="right">
                      </uix:cellFormat >
                      <uix:cellFormat hAlign="left">
                        <uix:messageText messageType="error" messageBinding="changedValue@errors@servletRequest" />
                      </uix:cellFormat >
                    </uix:rowLayout>
                    
                  </uix:tableLayout>
                </uix:header>
                
                <%-- Evaluation --%>
                <uix:header textBinding="EVALUATION@SPIAMsg">
                
                <uix:rowLayout>
                  <uix:spacer height="6" />
                </uix:rowLayout>
                <uix:rowLayout hAlign="left">
                <uix:flowLayout>

                  <uix:messagePrompt promptBinding="COMPARISON_METRIC@SPIAMsg" />
                  <uix:choice id="selectedComparisonMetric" 
                            name="selectedComparisonMetric"
                            selectedValueBinding="selectedComparisonMetric@parameterChangeBean@servletRequest"                                
                            shortDescBinding="COMPARISON_METRIC@SPIAMsg">
                    <uix:contents childDataBinding="comparisonMetricOptions@parameterChangeBean@servletRequest">
                      <uix:option textBinding="stext"
                                  valueBinding="sval"/>
                    </uix:contents>
                  </uix:choice>  
                </uix:flowLayout>
              </uix:rowLayout>
                </uix:header>
                
          <%@ include file="schedule.jspf" %>
          
                </uix:stackLayout>
              </uix:borderLayout>

            </uix:rowLayout>
          </uix:tableLayout>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
