<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>
<db:script src="/database/LOV.js"/>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <%@ include file="msgBundle.jspf" %>
  
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="SAGE_SIMULATION@SPIAMsg"/>
    </uix:metaContainer>

    <uix:body>

      <db:form
        name="form"
        destinationBinding="destController@servletRequest"
        method="post"
        copyParams="target,type">
        <uix:formValue name="pageName" 
                       value="/database/instance/spia/sage"/>

        <uix:pageLayout titleBinding="SAGE_SIMULATION@SPIAMsg">
          <%@ include file="/database/global.jspf" %>
	  <%@ include file="infoAndError.jspf" %>

          <uix:contentFooter>
            <uix:pageButtonBar>
              <uix:button textBinding="CANCEL@DBMsg"
                shortDescBinding="CANCEL@DBMsg"
                destinationBinding="cancelURL@servletRequest"/>
              <uix:submitButton formName="form" 
                textBinding="SUBMIT@SQLMsg"
                shortDescBinding="SUBMIT@SQLMsg"
                name="event" value="submit"/>
            </uix:pageButtonBar>
          </uix:contentFooter>

          <uix:tableLayout width="100%">

            <uix:rowLayout hAlign="right">
              <uix:pageButtonBar>
                <uix:button textBinding="CANCEL@DBMsg"
                  shortDescBinding="CANCEL@DBObjectBundle@servletRequest"
                  destinationBinding="cancelURL@servletRequest"/>
                <uix:submitButton formName="form" 
                  textBinding="SUBMIT@SQLMsg"
                  shortDescBinding="SUBMIT@SQLMsg"
                  name="event" value="submit"/>
              </uix:pageButtonBar>
            </uix:rowLayout>

            <uix:rowLayout>
              <uix:spacer height="3"/>
            </uix:rowLayout>

            <uix:rowLayout>

              <uix:borderLayout>
                <uix:right>
                  <uix:contentContainer textBinding="SAGE_DESCRIPTION_TITLE@SPIAMsg"
                                        width="480">

                    <uix:stackLayout>
                        <uix:styledText styleClass="OraInstructionText"
                            textBinding="SAGE_DESCRIPTION_PARAGRAPH@SPIAMsg"/>

                        <uix:bulletedList>
                          <uix:styledText styleClass="OraInstructionText"
                            textBinding="SAGE_DESCRIPTION_LIST_1@SPIAMsg"/>
                          <uix:styledText styleClass="OraInstructionText"
                            textBinding="SAGE_DESCRIPTION_LIST_2@SPIAMsg"/>
                          <uix:styledText styleClass="OraInstructionText"
                            textBinding="SAGE_DESCRIPTION_LIST_3@SPIAMsg"/>
                        </uix:bulletedList>

                    </uix:stackLayout>

                  </uix:contentContainer>

                </uix:right>
                
                
                <uix:stackLayout>
                <uix:header textBinding="TASK_INFORMATION@SPIAMsg">
                  <uix:tableLayout cellSpacing="5">
                    <uix:rowLayout>
                      <uix:cellFormat wrappingDisabled="true" hAlign="right">
                        <uix:messagePrompt labeledNodeId="taskName"
                                           promptBinding="ANALYSIS_NAME@SPIAMsg"
                                           required="yes"  />
                    </uix:cellFormat>
                    <uix:textInput name="taskName" id="taskName"
                         columns="40"
                         textBinding="taskName@sageBean@servletRequest"
                         required="yes" />
                    </uix:rowLayout>
                    <uix:rowLayout>
                      <uix:cellFormat wrappingDisabled="true" hAlign="right">
                      </uix:cellFormat >
                      <uix:cellFormat hAlign="left">
                        <uix:messageText messageType="error" messageBinding="taskName@errors@servletRequest" />
                      </uix:cellFormat >
                    </uix:rowLayout>
       
                    <%-- SQL Tuning Set  --%>
                    <uix:rowLayout>
                    <uix:cellFormat hAlign="right"> 
                    <uix:messagePrompt labeledNodeId="fullStsName"
                            styleClass="OraPromptText" 
                            promptBinding ="SQL_TUNING_SET@SQLMsg"
                            required="yes"/>
                    </uix:cellFormat>

                    <uix:messageLovField 
                                         name="fullStsName" 
                                         searchDescBinding="SQL_TUNING_SET@SQLMsg"
                                         id="fullStsName" 
                                         columns="40"
                                         textBinding="fullStsName@sageBean@servletRequest" 
                                         onClick="startLov('fullStsName', 'ListSTS');return false;"/>

                    </uix:rowLayout>   
                <uix:rowLayout>
                  <uix:cellFormat wrappingDisabled="true" hAlign="right">
                  </uix:cellFormat >
                  <uix:cellFormat hAlign="left">
                    <uix:messageText messageType="error" messageBinding="fullStsName@errors@servletRequest" />
                  </uix:cellFormat >
                </uix:rowLayout> 
            
                         <uix:rowLayout>  
                    <uix:cellFormat wrappingDisabled="true" hAlign="right">
                    <uix:messagePrompt labeledNodeId="taskDescription" 
                               promptBinding="DESCRIPTION@DBMsg" />
                    </uix:cellFormat>
                    <uix:textInput name="taskDescription" id="taskDescription"
                            columns="40"
                            textBinding="taskDescription@sageBean@servletRequest"  />
                    </uix:rowLayout> 
                    
            <uix:rowLayout>
              <uix:cellFormat wrappingDisabled="true" hAlign="right">
                <uix:messagePrompt promptBinding="METHOD@SPIAMsg" />
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:styledText styleClass="OraDataText"
                                textBinding="EXECUTE_ANY@SPIAMsg"/>
              </uix:cellFormat>
            </uix:rowLayout>

                  <%-- Per-SQL time limit --%>
                  <uix:rowLayout renderedBinding="showTimeLimit@sageBean@servletRequest">
                    <uix:cellFormat wrappingDisabled="true" hAlign="right">
                    <uix:messagePrompt labeledNodeId="perSqlTimeLimitSelected" 
                               promptBinding="PER_SQL_TIME_LIMIT@SPIAMsg" />
                    </uix:cellFormat>
                    <uix:cellFormat>
                    <uix:rowLayout>
                    <uix:choice id="perSqlTimeLimitSelected" 
                                name="perSqlTimeLimitSelected"
                                selectedValueBinding="perSqlTimeLimitSelected@sageBean@servletRequest"                                
                                shortDescBinding="PER_SQL_TIME_LIMIT@SPIAMsg"
                                onChange="submitForm('form', false, {'event':'changeSqlTimeLimitSelection'})">
                      <uix:contents childDataBinding="perSqlTimeLimitList@sageBean@servletRequest">
                        <uix:option textBinding="stext"
                                    valueBinding="sval"/>
                      </uix:contents>
                    </uix:choice>
                    <uix:switcher childNameBinding="perSqlTimeLimitSelected@sageBean@servletRequest">
                      <uix:case name="CUSTOMIZE">
                        <uix:flowLayout>
                        <uix:textInput name="timeLimitPerSQL" 
                                       columns="10"
                                       id="timeLimitPerSQL"
                                       textBinding="timeLimitPerSQL@sageBean@servletRequest"/>
                        <uix:choice id="timeLimitPerSQLUnit"
                                    name="timeLimitPerSQLUnit"
                                    selectedValueBinding="timeLimitPerSQLUnit@sageBean@servletRequest"
                                    shortDescBinding="timeLimitPerSQLUnit@sageBean@servletRequest">
                          <uix:contents childDataBinding="timeLimitPerSQLUnitList@sageBean@servletRequest">
                            <uix:option textBinding="stext"
                                        valueBinding="sval"/>
                          </uix:contents>
                        </uix:choice>
                        </uix:flowLayout>
                      </uix:case>
                    </uix:switcher>
                    </uix:rowLayout>
                    </uix:cellFormat>
                  </uix:rowLayout>

                  <uix:rowLayout renderedBinding="showTimeLimit@sageBean@servletRequest">
                    <uix:cellFormat wrappingDisabled="true" hAlign="right">
                      <uix:spacer width="6"/>
                    </uix:cellFormat>
                    <uix:tip>
                       <uix:styledText styleClass="OraTipText" 
                                       textBinding="PER_SQL_TIME_LIMIT_TIP@SPIAMsg"/>
                    </uix:tip>
                  </uix:rowLayout>
                  </uix:tableLayout>
                </uix:header>
               
                <%-- Evaluation --%>
                <uix:header textBinding="EVALUATION@SPIAMsg">
                
                <uix:rowLayout>
                  <uix:spacer height="6" />
                </uix:rowLayout>
                <uix:rowLayout hAlign="left">
                <uix:flowLayout>

                  <uix:messagePrompt promptBinding="COMPARISON_METRIC@SPIAMsg" />
                  <uix:spacer width="8" />
                  <uix:styledText styleClass="OraDataText"
                                  textBinding="IO_INTERCONNECT@SPIAMsg"/>
                </uix:flowLayout>
              </uix:rowLayout>
                </uix:header>
                
          <%@ include file="schedule.jspf" %>
          
                </uix:stackLayout>
              </uix:borderLayout>

            </uix:rowLayout>
          </uix:tableLayout>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
