<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <%@ include file="msgBundle.jspf" %>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <db:form name="SQLStmts" 
               destination="/console/database/instance/SPIAReport"
               copyParams="target,type,SPIATaskName,SPIATaskOwner,SPIATaskDescription,SPIAComparisonName,min,max,bucketId,SQLStmtType"> 
        <uix:pageLayout titleBinding="header@SPIAReportBean@servletRequest">

          <%@ include file="/database/global.jspf" %>

      <uix:header textBinding="CREATE_BASELINE@SPIAMsg">
	  <uix:spacer height="15"/>
          <uix:styledText styleClass="OraInstructionText" textBinding="CREATE_BASELINE_INSTR@SPIAMsg"/>
      <uix:header textBinding="SQLStmtHeader@SPIAReportBean@servletRequest">
	  <uix:spacer height="15"/>
	  <uix:switcher childNameBinding="showBucketInfo@SPIAReportBean@servletRequest">
            <uix:case name="true">
              <uix:labeledFieldLayout fieldWidth="65%" labelWidth="35%">
                 <uix:messagePrompt promptBinding="BUCKET_LABEL@SPIAMsg" />
                 <uix:styledText styleClass="OraDataText"
                                 textBinding="selectedBucketId@SPIAReportBean@servletRequest"/>
                 <uix:messagePrompt promptBinding="bucketRangeLabel@SPIAReportBean@servletRequest" />
                 <uix:styledText styleClass="OraDataText"
                                 textBinding="selectedBucketRange@SPIAReportBean@servletRequest"/>
                 <uix:messagePrompt promptBinding="TRIAL_RUN_NAME@SPIAMsg" />
                 <uix:styledText styleClass="OraDataText"
                                 textBinding="selectedTrialName@SPIAReportBean@servletRequest"/>
              </uix:labeledFieldLayout>
            </uix:case>
          </uix:switcher>
            <uix:table width="100%" 
                       summaryBinding="SQLStmtHeader@SPIAReportBean@servletRequest"
                       name="sqlStmt"
                       id="sqlStmt"
                       valueBinding="SQLStmtValue@SPIAReportBean@servletRequest"
                       minValueBinding="SQLStmtMinValue@SPIAReportBean@servletRequest"
 		       maxValueBinding="SQLStmtMaxValue@SPIAReportBean@servletRequest"
                       formSubmitted="true" blockSizeBinding="SQLStmtBlockSize@SPIAReportBean@servletRequest"
                       alternateTextBinding="NO_SQL_STMT@SPIAMsg"
                       tableDataBinding="SQLStmtData@SPIAReportBean@servletRequest">
              <uix:column>
                <uix:columnHeader>
                  <uix:styledText text=" "/>
                </uix:columnHeader>
		<uix:image sourceBinding="status" />
              </uix:column>
              <uix:column>
                <uix:columnHeader>
                  <uix:styledText textBinding="SQL_ID@DBMsg"/>
                </uix:columnHeader>
		<uix:link textBinding="sqlID" 
                      destinationBinding="sqlURL"/>
              </uix:column>
              <uix:column rendered="false">
                <uix:columnHeader>
                  <uix:styledText textBinding="EXECUTIONS@SPIAMsg"/>
                </uix:columnHeader>
                <uix:styledText textBinding="executions" />
                <uix:columnFormat columnDataFormat="numberFormat" />
              </uix:column>
              <uix:column>
                <uix:columnHeader>
                  <uix:styledText textBinding="NET_IMPACT_ON_WORKLOAD_PCT@SPIAMsg"/>
                </uix:columnHeader>
                <uix:styledText textBinding="netImpactOnWorkloadPct" />
                <uix:columnFormat columnDataFormat="numberFormat" />
              </uix:column>
              <uix:columnGroup>
                <uix:columnHeader>
                  <uix:text textBinding="comparisonMetric@SPIAReportBean@servletRequest"/>
                </uix:columnHeader>
                <uix:column>
                  <uix:columnHeader>
                    <uix:text textBinding="trial1Name@SPIAReportBean@servletRequest"/>
                  </uix:columnHeader>
                  <uix:styledText textBinding="valueBefore"/>
                  <uix:columnFormat columnDataFormat="numberFormat" />
                </uix:column>
                <uix:column>
                  <uix:columnHeader>
                    <uix:text textBinding="trial2Name@SPIAReportBean@servletRequest"/>
                  </uix:columnHeader>
                  <uix:styledText textBinding="valueAfter"/>
                  <uix:columnFormat columnDataFormat="numberFormat" />
                </uix:column>
              </uix:columnGroup>
              <uix:column>
                <uix:columnHeader>
                  <uix:styledText textBinding="NET_IMPACT_ON_SQL_PCT@SPIAMsg"/>
                </uix:columnHeader>
                <uix:styledText textBinding="netImpactOnSQLPct" />
                <uix:columnFormat columnDataFormat="numberFormat" />
              </uix:column>
              <uix:columnGroup>
                <uix:columnHeader>
                  <uix:text textBinding="WORKLOAD_PCT@SPIAMsg"/>
                </uix:columnHeader>
                <uix:column>
                  <uix:columnHeader>
                    <uix:text textBinding="trial1Name@SPIAReportBean@servletRequest"/>
                  </uix:columnHeader>
                  <uix:styledText textBinding="workloadPctBefore"/>
                  <uix:columnFormat columnDataFormat="numberFormat" />
                </uix:column>
                <uix:column>
                  <uix:columnHeader>
                    <uix:text textBinding="trial2Name@SPIAReportBean@servletRequest"/>
                  </uix:columnHeader>
                  <uix:styledText textBinding="workloadPctAfter"/>
                  <uix:columnFormat columnDataFormat="numberFormat" />
                </uix:column>
              </uix:columnGroup>
              <uix:column renderedBinding="showPlanChangedCol@SPIAReportBean@servletRequest">
                <uix:columnHeader>
                  <uix:styledText textBinding="PLAN_CHANGED@SPIAMsg"/>
                </uix:columnHeader>
                <uix:styledText textBinding="planChanged" />
                <uix:columnFormat columnDataFormat="textFormat" />
              </uix:column>
            </uix:table>
	  </uix:header>
	  </uix:header>
	   <%@ include file="/database/instance/simpleSchedule.jspf" %>
        <uix:pageButtons>
          <uix:pageButtonBar>
            <uix:submitButton textBinding="CANCEL@DBMsg"
                              name="event"
                              value="cancel"/>
            <uix:submitButton textBinding="OK@DBMsg"
                              name="event"
                              value="ok"/>
         </uix:pageButtonBar>
        </uix:pageButtons>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

