<%-- ================   Select STS page  =================

   MODIFIED    (MM/DD/YY)
      ezeng     05/08/07 - 
      yfeng     04/05/07 - Add validation errors under the components that
                           caused the errors
      yfeng     03/21/07 - Change the parameter name from description to
                           taskDescription
      yfeng     02/07/07 - implement JB's proposal
      yfeng     12/06/06 - Fix ADA issues
      yfeng     11/17/06 - Remove related link
      yfeng     11/09/06 - Suport action to create STS
      yfeng     09/13/06 - Remove extra text
      nachen    08/07/06 - 
      yfeng     07/22/06 - Use new bean for STS collection 
      yfeng     06/19/06 - 
      hxlin     05/08/06 - Initial draft
--%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<db:script src="/database/LOV.js"/>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <%@ include file="msgBundle.jspf" %>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <db:form name="selectSTS" 
               destination="/console/database/instance/SPIAChecklist"
               copyParams="target,type">
        <uix:pageLayout titleBinding="CREATE_NEW_ANALYSIS@SPIAMsg">

          <%@ include file="/database/global.jspf" %>

	  <%@ include file="infoAndError.jspf" %>

          <uix:styledText styleClass="OraInstructionText"
                          textBinding="CREATE_TASK_DESC@SPIAMsg"/>

          <uix:spacer height="5"/>

	  <uix:tableLayout width="100%" cellSpacing="5">
	    <uix:rowLayout>
	      <uix:cellFormat hAlign="right">
          <uix:messagePrompt labeledNodeId="taskName"
                             promptBinding="NAME@DBMsg"
                             required="yes"  />
	      </uix:cellFormat>
              <uix:cellFormat hAlign="left">
                <uix:textInput name="taskName" id="taskName"
                               textBinding="taskName@SPIAAnalysisBean@servletRequest"/>
	      </uix:cellFormat>
	    </uix:rowLayout>
            <uix:rowLayout>
              <uix:cellFormat wrappingDisabled="true" hAlign="right">
              </uix:cellFormat >
              <uix:cellFormat hAlign="left">
                <uix:messageText messageType="error" messageBinding="taskName@errors@servletRequest" />
              </uix:cellFormat >
            </uix:rowLayout> 
            <uix:rowLayout>
              <uix:cellFormat hAlign="right">
                <uix:styledText styleClass="OraPromptText" 
                                textBinding="OWNER@DBMsg"/>
              </uix:cellFormat>
              <uix:cellFormat hAlign="left">
                <uix:styledText styleClass="OraDataText" 
                                textBinding="taskOwner@SPIAAnalysisBean@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout>
              <uix:cellFormat hAlign="right">
                <uix:styledText styleClass="OraPromptText" 
                                labeledNodeId="taskDescription"
                                textBinding="DESCRIPTION@DBMsg"/>
              </uix:cellFormat>
              <uix:cellFormat hAlign="left">
                <uix:textInput name="taskDescription" 
                               id="taskDescription"
                               textBinding="taskDescription@SPIAAnalysisBean@servletRequest"
                               columns="120"/>
                <uix:tip>
                <uix:styledText textBinding="CREATE_TASK_TIP@SPIAMsg"/>
                </uix:tip>
              </uix:cellFormat>
            </uix:rowLayout>
	  </uix:tableLayout>

          <uix:header textBinding="SQL_TUNING_SET@SPIAMsg">
          <uix:styledText styleClass="OraInstructionText"
                          textBinding="STS_DESC@SPIAMsg"/>

	  <uix:tableLayout width="100%" cellSpacing="5">
	    <uix:rowLayout>
	      <uix:cellFormat hAlign="right">
                <uix:messagePrompt labeledNodeId="fullStsName"
                             promptBinding="NAME@DBMsg"
                             required="yes"  />
	      </uix:cellFormat>
              <uix:cellFormat hAlign="left">
              <uix:lovField 
               name="fullStsName" 
               searchDescBinding="SQL_TUNING_SET@SQLMsg"
               id="fullStsName" 
               columns="40"
               textBinding="fullStsName@SPIAAnalysisBean@servletRequest" 
               onClick="startLov('fullStsName', 'ListSTS');return false;" />
          <uix:tip>
            <uix:flowLayout>
              <uix:styledText textBinding="STS_TIP@SPIAMsg"/>
              <uix:link textBinding="CREATE_STS_LINK@SPIAMsg"
                        destinationBinding="createSTSURL@servletRequest"/>
            </uix:flowLayout>
          </uix:tip>
	      </uix:cellFormat>
	    </uix:rowLayout>
            <uix:rowLayout>
              <uix:cellFormat wrappingDisabled="true" hAlign="right">
              </uix:cellFormat >
              <uix:cellFormat hAlign="left">
                <uix:messageText messageType="error" messageBinding="fullStsName@errors@servletRequest" />
              </uix:cellFormat >
            </uix:rowLayout> 
	  </uix:tableLayout>

          </uix:header>
      
          <uix:contentFooter>
            <uix:pageButtonBar>
              <uix:button textBinding="CANCEL@DBMsg"
                          shortDescBinding="CANCEL@DBMsg"
                          destinationBinding="cancelURL@servletRequest"/>
              <uix:submitButton textBinding="CREATE@DBMsg"
                                shortDescBinding="CREATE@DBMsg" 
                          name="event" value="doSelectSTS"/>
            </uix:pageButtonBar>
          </uix:contentFooter>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

