<%-- ================   SQL Details page  =================

   MODIFIED    (MM/DD/YY)
      ezeng     02/25/09 - sql formatter
      ezeng     12/10/08 - XbranchMerge ezeng_bug-7572808 from
                           st_emdbgc_10.2.0.1.0
      ezeng     01/15/08 - 
      nachen    04/16/07 - XbranchMerge nachen_bug-5894081 from st_emdbsa_11.1
      nachen    04/06/07 - XbranchMerge nachen_bug-5601098 from st_emdbsa_11.1
      ezeng     09/10/07 - 
      nachen    01/24/07 - rename tuning button
      nachen    01/14/07 - XbranchMerge nachen_bug-5675267 from main
      nachen    12/14/06 - fix ADA
      yfeng     10/04/06 - add comparison name in parameter
      nachen    07/26/06 - 
      yfeng     06/19/06 - 
      hxlin     04/25/06 - Initial draft
--%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="dbMsg"
              class="oracle.sysman.db.rsc.inst.DBMsg"/>
  <uix:bundle name="sqlMsg"
              class="oracle.sysman.db.rsc.inst.SQLMsg"/>
  <uix:bundle name="SPIAMsg"
              class="oracle.sysman.db.rsc.inst.SPIAMsg"/>

  <%@ include file="msgBundle.jspf" %>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <db:form name="SPIASQLDetail"  
               destination="/console/database/instance/SPIASqlDetail"
               copyParams="target,type,sql_id,objectId,SPIATaskName,SPIATaskOwner,SPIATaskDescription,SPIAComparisonName,state,_root,node,min,max,bucketId">
        <uix:formValue name="event" />
        <uix:formValue name="iconIndex" value=""/>

        <uix:pageLayout titleBinding="header@SPIAReportBean@servletRequest">
          <%@ include file="/database/global.jspf" %>

	  <%@ include file="infoAndError.jspf" %>

	  <%@ include file="resultTopHeader.jspf" %>

          <uix:header textBinding="header@SPIASQLDetailBean@servletRequest">
          <%-- General info --%>
          <uix:tableLayout width="60%">
            <uix:rowLayout>
              <uix:cellFormat wrappingDisabled="true" hAlign="right">
                <uix:styledText styleClass="OraPromptText"
                                textBinding="PARSING_SCHEMA@sqlMsg"/>
	      </uix:cellFormat>
              <uix:cellFormat>
                <uix:spacer width="5"/>
              </uix:cellFormat>
              <uix:cellFormat hAlign="left">
                <uix:styledText styleClass="OraDataText"
                                textBinding="parsingSchema@SPIASQLDetailBean@servletRequest"/>
              </uix:cellFormat>


              <uix:cellFormat wrappingDisabled="true" hAlign="right">
                <uix:styledText styleClass="OraPromptText"
                                textBinding="EXEC_FREQUENCY@SPIAMsg"/>
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:spacer width="5"/>
              </uix:cellFormat>
              <uix:cellFormat hAlign="left">
                <uix:styledText styleClass="OraDataText"
                                textBinding="execFrequency@SPIASQLDetailBean@servletRequest"/>
              </uix:cellFormat>

	    </uix:rowLayout>
	  </uix:tableLayout>

          <%-- SQL Text --%>
          <uix:switcher childNameBinding="showTextIcon@SPIASQLDetailBean@servletRequest">
            <uix:case name="true">
            <uix:stackLayout>
            <uix:rowLayout>
              <uix:hideShowHeader textBinding="HDR_SQL_TEXT@dbMsg"
                    disclosedBinding="disclosedIcon@SPIASQLDetailBean@servletRequest" 
                    formSubmitted="true" id="hideShowSql" />
              <uix:spacer width="15"/>
              <uix:image source="/em/images/database/sql/file_html.gif"
                         id="processIcon"
                         shortDescBinding="FORMAT_SQL_IN_HTML@sqlMsg"
                         destinationBinding="formatSqlURL@servletRequest"/>
            </uix:rowLayout>
                <db:sqlDisplay sqlListBinding="sqlList@SPIASQLDetailBean@servletRequest"/>
            </uix:stackLayout>
            </uix:case>
            <uix:case name="false"> 
              <uix:stackLayout>
              <uix:rowLayout>
                <uix:header textBinding="HDR_SQL_TEXT@dbMsg"/>
                <uix:spacer width="15"/>
                <uix:image source="/em/images/database/sql/file_html.gif"
                         id="processIcon"
                         shortDescBinding="FORMAT_SQL_IN_HTML@sqlMsg"
                         destinationBinding="formatSqlURL@servletRequest"/>
              </uix:rowLayout>
                <db:sqlDisplay sqlListBinding="sqlList@SPIASQLDetailBean@servletRequest"/>
              </uix:stackLayout>
            </uix:case>         
          </uix:switcher> 

          <%-- Single Execution Statistics --%>
          <uix:header textBinding="SINGLE_EXEC_STATS@SPIAMsg">
            <uix:table width="100%"
                       summaryBinding="SINGLE_EXEC_STATS@SPIAMsg"
                       name="singleExecStats"
                       tableDataBinding="singleExecStatsData@SPIASQLDetailBean@servletRequest">
	      <uix:column>
		<uix:columnHeader>
		  <uix:styledText text=" "/>
		</uix:columnHeader>
                <uix:switcher childNameBinding="showImage">
                  <uix:case name="true">
                    <uix:image sourceBinding="status" />
                  </uix:case>
                </uix:switcher>
 	      </uix:column>
	      <uix:column>
		<uix:columnHeader>
		  <uix:styledText textBinding="EXEC_STAT_NAME@SPIAMsg"/>
		</uix:columnHeader>
                <uix:styledText textBinding="name" />
 	      </uix:column>
              <uix:column>
                <uix:columnHeader>
                  <uix:styledText textBinding="NET_IMPACT_ON_WORKLOAD_PCT@SPIAMsg"/>
                </uix:columnHeader>
                <uix:styledText textBinding="netImpactOnWorkloadPct" />
                <uix:columnFormat columnDataFormat="numberFormat" />
              </uix:column>
	      <uix:columnGroup>
                <uix:columnHeader>
                  <uix:text textBinding="EXEC_STAT@SPIAMsg"/>
                </uix:columnHeader>
                <uix:column>
                  <uix:columnHeader>
                    <uix:text textBinding="trial1Label@SPIAReportBean@servletRequest"/>
                  </uix:columnHeader>
                  <uix:styledText textBinding="valueBefore"/>
                  <uix:columnFormat columnDataFormat="numberFormat" />
                </uix:column>
                <uix:column>
                  <uix:columnHeader>
                    <uix:text textBinding="trial2Label@SPIAReportBean@servletRequest"/>
                  </uix:columnHeader>
                  <uix:styledText textBinding="valueAfter"/>
                  <uix:columnFormat columnDataFormat="numberFormat" />
                </uix:column>
              </uix:columnGroup>
              <uix:column>
                <uix:columnHeader>
                  <uix:styledText textBinding="NET_IMPACT_ON_SQL_PCT@SPIAMsg"/>
                </uix:columnHeader>
                <uix:styledText textBinding="netImpactOnSQLPct" />
                <uix:columnFormat columnDataFormat="numberFormat" />
              </uix:column>
            </uix:table>
            
            <uix:spacer height="5"/>

            <uix:tip>
              <uix:styledText textBinding="NA_TIP_TEXT@SPIAMsg"/>
            </uix:tip>
          </uix:header>       

          <uix:header textBinding="NOTES@SPIAMsg" renderedBinding="showNotes@SPIASQLDetailBean@servletRequest">
          <uix:tableLayout width="100%">
            <uix:rowLayout>
              <uix:cellFormat>
                <uix:spacer width="5"/>
              </uix:cellFormat>
              <uix:cellFormat>
              <uix:header textBinding="trial1Label@SPIAReportBean@servletRequest" renderedBinding="showBeforeNotes@SPIASQLDetailBean@servletRequest">
                <uix:messagePrompt promptBinding="beforeNotes@SPIASQLDetailBean@servletRequest"/>
              </uix:header>
              <uix:header textBinding="trial2Label@SPIAReportBean@servletRequest" renderedBinding="showAfterNotes@SPIASQLDetailBean@servletRequest">
                <uix:messagePrompt promptBinding="afterNotes@SPIASQLDetailBean@servletRequest"/>
              </uix:header>
              </uix:cellFormat>
            </uix:rowLayout>
          </uix:tableLayout>
          </uix:header>

          <%-- Plan Change Analysis --%>
              <uix:header textBinding="PROBLEM_FINDINGS@SPIAMsg" renderedBinding="showProblemFindings@SPIASQLDetailBean@servletRequest">
                <uix:messagePrompt promptBinding="problemFindings@SPIASQLDetailBean@servletRequest"/>
              </uix:header>						
              <uix:header textBinding="SYMPTOM_FINDINGS@SPIAMsg" renderedBinding="showSymptomFindings@SPIASQLDetailBean@servletRequest">
                <uix:messagePrompt promptBinding="symptomFindings@SPIASQLDetailBean@servletRequest"/>
              </uix:header>
              <uix:header textBinding="ERROR_FINDINGS@SPIAMsg" renderedBinding="showErrorFindings@SPIASQLDetailBean@servletRequest">
                <uix:messagePrompt promptBinding="errorFindings@SPIASQLDetailBean@servletRequest"/>
              </uix:header>
              <uix:hideShowHeader textBinding="INFORMATION_FINDINGS@SPIAMsg" 
               disclosedBinding="showInformationFinding@SPIASQLDetailBean@servletRequest" formSubmitted="true" id="hideShowInformationFinding"
               renderedBinding="showInformationFindings@SPIASQLDetailBean@servletRequest">
                <uix:messagePrompt promptBinding="informationFindings@SPIASQLDetailBean@servletRequest"/>
              </uix:hideShowHeader>

          <%-- Plan Comparison --%>          
          <uix:header textBinding="PLAN_COMPARISON@SPIAMsg">
          <uix:tableLayout width="100%">
            <uix:rowLayout>
              <uix:cellFormat>
                <uix:spacer width="5"/>
              </uix:cellFormat>
              <uix:cellFormat>
          <uix:header textBinding="trial1Name@SPIAReportBean@servletRequest">
            <uix:labeledFieldLayout labelWidth="10%">
                  <uix:styledText styleClass="OraPromptText"
                                  textBinding="PLAN_HASH_VALUE@dbMsg"/>
                  <uix:styledText styleClass="OraDataText"
                                  textBinding="planHashValueBefore@SPIASQLDetailBean@servletRequest"/>
            </uix:labeledFieldLayout>
            <uix:rawText textBinding="topFrameText@servletRequest"/>
          </uix:header>
          <uix:header textBinding="trial2Name@SPIAReportBean@servletRequest">
            <uix:labeledFieldLayout labelWidth="10%">
                  <uix:messagePrompt 
                                  promptBinding="PLAN_HASH_VALUE@dbMsg"/>
                  <uix:styledText styleClass="OraDataText"
                                  textBinding="planHashValueAfter@SPIASQLDetailBean@servletRequest"/>
            </uix:labeledFieldLayout>
            <uix:rawText textBinding="bottomFrameText@servletRequest"/>
          </uix:header>
              </uix:cellFormat>
            </uix:rowLayout>
          </uix:tableLayout>
          </uix:header>

        </uix:header>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

