<%-- ================   summary page  =================

   MODIFIED    (MM/DD/YY)
      manaraya  02/05/09 - Bug 7707441
      ezeng     08/26/08 - Exadata simulation
      ezeng     06/02/08 - new upgrade page
      yfeng     03/29/07 - XbranchMerge yfeng_bug-5926134 from st_emdbsa_11.1
      yfeng     03/14/07 - XbranchMerge yfeng_bug-5906169 from st_emdbsa_11.1
      yfeng     03/26/07 - Remove Edit button
      yfeng     01/20/07 - Add link for parameter change page
      yfeng     12/21/06 - Put the tip beneath the table
      yfeng     12/16/06 - Change the name of the Analyze button
      yfeng     01/11/07 - XbranchMerge yfeng_bug-5750954 from st_emdbsa_11.1
      yfeng     12/06/06 - Fix ADA issues
      yfeng     08/28/06 - Add Compare SQL Replay button
      yfeng     08/28/06 - 
      nachen    08/07/06 - 
      yfeng     07/31/06 - Remove Compare Trials button
      yfeng     06/20/06 - Change the table name to analyses 
      hxlin     05/08/06 - Initial draft
--%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
<uix:bundle name="SDKMsg"
	    class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
<uix:bundle name="dbMsg"
	    class="oracle.sysman.db.rsc.inst.DBMsg"/>
  <oem:setURLEncoder id="renderingContext"/>

  <%@ include file="msgBundle.jspf" %>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <db:form name="SPIASummary" 
               destination="/console/database/instance/SPIASummary"
               copyParams="target,type">
        <uix:pageLayout titleBinding="SPIA@SPIAMsg">

          <%@ include file="/database/global.jspf" %>
          <%@ include file="/sdk/page/pageMsgBox.jspf" %>
	  <%@ include file="infoAndError.jspf" %>
    <uix:switcher childNameBinding="refreshChoice@servletRequest">
      <uix:case name="RT_15">
        <uix:rawText>
          <meta http-equiv="Refresh" content='15;<%=request.getAttribute("refreshDest")%>' >
        </uix:rawText>
      </uix:case>
    </uix:switcher>

<%-- REFRESH --%>
<uix:tableLayout width="100%" cellSpacing="2">
<uix:rowLayout hAlign="right">
  <uix:cellFormat>
    <uix:rowLayout>
                <%@ include file="../refreshTime.jspf" %>
    <%--
      <uix:styledText styleClass="OraTipText"
           textBinding="PAGE_REFRESHED_TIME@SDKMsg"/>
      <uix:spacer width="5"/>
      <uix:styledText styleClass="OraTipLabel"
           textBinding="lastUpdatedTime@defaultBean@servletRequest"/>
	   --%>
      <uix:spacer width="10"/>
      <uix:styledText styleClass="OraTipText"   textBinding="VIEW_DATA_LABEL@dbMsg"/>
      <uix:spacer width="5"/>
            <uix:choice name="refreshChoice" id="view_choice" onChange="submitForm('SPIASummary', true, {'event':'changeRefreshChoice'})" selectedValueBinding="refreshChoice@servletRequest">
              <uix:option textBinding="REAL_TIME_AUTO_15_SEC@dbMsg"
                        value="RT_15"/>
              <uix:option textBinding="REAL_TIME_MANUAL@dbMsg"
                        value="RT_MAN" />
            </uix:choice>
    <%--
      <uix:spacer width="10"/>
      <uix:button textBinding="REFRESH@SDKMsg"
            destinationBinding="refreshDest@servletRequest" />
	   --%>
    </uix:rowLayout>
  </uix:cellFormat>
</uix:rowLayout>
</uix:tableLayout>

	  <uix:spacer height="5"/>

          <uix:styledText styleClass="OraInstructionText"
                          textBinding="SQL_REPLAY_TASK_HOME_TEXT@SPIAMsg"/>

            <uix:header textBinding="REPLAY_TASK_WORKFLOW@SPIAMsg">
              <uix:styledText styleClass="OraInstructionText"
                              textBinding="REPLAY_TASK_WORKFLOW_TEXT@SPIAMsg"/>
              <uix:tableLayout width="100%" cellSpacing="2">
             
                <%-- Upgrade links --%>
                <uix:rowLayout renderedBinding="showUpgrade@servletRequest">
                  <uix:cellFormat hAlign="left" width="20%" >
                    <uix:link textBinding="UPGRADE_LOWER@SPIAMsg"
                              destinationBinding="upgradeLowerURL@servletRequest" />
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left" width="80%" >
                    <uix:styledText styleClass="OraInstructionText"
                                    textBinding="UPGRADE_LOWER_INTRO@SPIAMsg"/>
                  </uix:cellFormat>
                </uix:rowLayout>

                <uix:rowLayout renderedBinding="showUpgrade@servletRequest">
                  <uix:cellFormat hAlign="left" width="20%" >
                    <uix:link textBinding="UPGRADE_HIGHER@SPIAMsg"
                              destinationBinding="upgradeHigherURL@servletRequest" />
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left" width="80%" >
                    <uix:styledText styleClass="OraInstructionText"
                                    textBinding="UPGRADE_HIGHER_INTRO@SPIAMsg"/>
                  </uix:cellFormat>
                </uix:rowLayout>

                <%-- Parameter Change link --%>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="left" width="20%" >
                    <uix:link textBinding="SQL_REPLAY_PARAMETER_CHANGE@SPIAMsg"
                              destinationBinding="parameterChangeURL@servletRequest" />
              </uix:cellFormat>
                  <uix:cellFormat hAlign="left" width="80%" >
                    <uix:styledText styleClass="OraInstructionText"
                                    textBinding="SQL_REPLAY_PARAMETER_CHANGE_INTRO@SPIAMsg"/>
                  </uix:cellFormat>
                </uix:rowLayout>
               
                <%-- SAGE Simulation link --%>
                <uix:rowLayout renderedBinding="showSage@servletRequest">
                  <uix:cellFormat hAlign="left" width="20%" >
                    <uix:link textBinding="SAGE_SIMULATION@SPIAMsg"
                              destinationBinding="sageURL@servletRequest" />
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left" width="80%" >
                    <uix:styledText styleClass="OraInstructionText"
                                    textBinding="SAGE_SIMULATION_INTRO@SPIAMsg"/>
                  </uix:cellFormat>
                </uix:rowLayout>
 
                <%-- Guided Replay Task --%>
            <uix:rowLayout>
                  <uix:cellFormat hAlign="left" width="20%" >
                    <uix:link textBinding="GUIDED_REPLAY_TASK@SPIAMsg"
                              destinationBinding="guidedURL@servletRequest" />
                    </uix:cellFormat>
                  <uix:cellFormat hAlign="left" width="80%" >
                    <uix:styledText styleClass="OraInstructionText"
                                    textBinding="GUIDED_REPLAY_TASK_INTRO@SPIAMsg"/>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:header>                      

        <uix:header textBinding="SQL_REPLAY_TASKS@SPIAMsg">
          <uix:spacer height="2"/>
          <uix:tableLayout width="100%">
            <uix:rowLayout>
              <oem:table name="summaryTableUIDataSource" 
                         beanKey="SPIASummaryBean"
                         summaryBinding="SPIA@SPIAMsg"
                         showAll="yes"
                         formSubmitted="true"
                         dataSourceProp="summaryTableUIDataSource" width="100%"
                         alternateTextBinding="NO_SPIA@SPIAMsg"
                         blockSize="25" partialRenderMode="self">
                <uix:tableSelection>
                  <oem:singleSelection selectedIndexBinding="selectedIndex@SPIASummaryBean@servletRequest"
                                       shortDescBinding="SELECT@DBMsg">
                    <uix:pageButtonBar>
                    <uix:submitButton textBinding="DELETE@DBMsg"
                                      name="event" value="delete"/>
                    <uix:submitButton textBinding="VIEW_LATEST_REPORT@SPIAMsg"
                                      name="event" value="viewReport"/>
                    </uix:pageButtonBar>
                  </oem:singleSelection>
                </uix:tableSelection>
              </oem:table>
            </uix:rowLayout>
          </uix:tableLayout>
          
                    <uix:spacer height="5"/>

    	  <uix:tip>
            <uix:styledText textBinding="ICON_TIP_TEXT@SPIAMsg"/>
            <uix:link textBinding="ICON_KEY@SPIAMsg" 
		      destinationBinding="iconURL@servletRequest"/>  
    	  </uix:tip>    
            </uix:header> 

            <uix:rowLayout>
              <uix:spacer height="20"/>
            </uix:rowLayout>

            <uix:header textBinding="RELATED_LINKS@DBMsg">
              <uix:tableLayout width="100%" cellSpacing="2">
                <uix:rowLayout>
                  <uix:stackLayout>
                    <uix:link textBinding="SQL_TUNING_SETS@DBMsg"
                              destinationBinding="sqlTuningSetsLink@servletRequest"/>
                  </uix:stackLayout>
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:header>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

