<%-- ================   Trial Comparison page  =================

   MODIFIED    (MM/DD/YY)
      nachen    02/23/07 - 
      yfeng     01/23/07 - Created
--%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>
<db:script src="/database/LOV.js"/>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <%@ include file="msgBundle.jspf" %>
  
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="RUN_TRIAL_COMPARISON@SPIAMsg"/>
    </uix:metaContainer>

    <uix:body>

      <db:form
        name="form"
        destinationBinding="destController@servletRequest"
        copyParams="target,type,SPIATaskName,SPIATaskOwner">

        <uix:pageLayout titleBinding="RUN_TRIAL_COMPARISON@SPIAMsg">
          <%@ include file="/database/global.jspf" %>
	  <%@ include file="infoAndError.jspf" %>

          <uix:contentFooter>
            <uix:pageButtonBar>
                <uix:submitButton
                  textBinding="CANCEL@DBMsg"
                  shortDescBinding="CANCEL@DBMsg"
                  name="event" value="cancelTrialsComparison"/>
              <uix:submitButton
                textBinding="SUBMIT@SQLMsg"
                shortDescBinding="SUBMIT@SQLMsg"
                name="event" value="runCompareTrials"/>
            </uix:pageButtonBar>
          </uix:contentFooter>
          
          <uix:tableLayout width="100%">

            <uix:rowLayout hAlign="right">
              <uix:pageButtonBar>
                <uix:submitButton
                  textBinding="CANCEL@DBMsg"
                  shortDescBinding="CANCEL@DBMsg"
                  name="event" value="cancelTrialsComparison"/>
                <uix:submitButton
                  textBinding="SUBMIT@SQLMsg"
                  shortDescBinding="SUBMIT@SQLMsg"
                  name="event" value="runCompareTrials"/>
              </uix:pageButtonBar>
            </uix:rowLayout>

            <uix:rowLayout>
              <uix:spacer height="3"/>
            </uix:rowLayout>

            <uix:rowLayout>                
              <uix:borderLayout>
                <uix:right>
                  <uix:contentContainer textBinding="TRIAL_COMPARISON_DESC_TITLE@SPIAMsg" 
                                        width="360">

                    <uix:stackLayout>
                        <uix:styledText styleClass="OraInstructionText"
                            textBinding="TRIAL_COMPARISON_DESC_1@SPIAMsg"/>

                        <uix:spacer height="10"/>

                          <uix:styledText styleClass="OraInstructionText"
                            textBinding="TRIAL_COMPARISON_DESC_2@SPIAMsg"/>

                        <uix:spacer height="10"/>

                          <uix:styledText styleClass="OraInstructionText"
                            textBinding="TRIAL_COMPARISON_DESC_3@SPIAMsg"/>

                    </uix:stackLayout>

                  </uix:contentContainer>
                </uix:right>

              <uix:stackLayout>
                <uix:tableLayout cellSpacing="5">
                  
                  <%-- Task Name --%>
                  <uix:rowLayout>
                    <uix:cellFormat wrappingDisabled="true" hAlign="right">
                      <uix:messagePrompt promptBinding="ANALYSIS_NAME@SPIAMsg"/>
                    </uix:cellFormat>
                      <uix:styledText styleClass="OraDataText" 
                          textBinding="fullTaskNameForDisplay@trialsComparisonBean@servletRequest" />
                  </uix:rowLayout>
                    
       
                  <%-- SQL Tuning Set  --%>
                  <uix:rowLayout>
                    <uix:cellFormat wrappingDisabled="true" hAlign="right">
                        <uix:messagePrompt promptBinding="SQL_TUNING_SET@SQLMsg"/>
                    </uix:cellFormat>
                    <uix:styledText styleClass="OraDataText" 
                        textBinding="fullStsName@trialsComparisonBean@servletRequest" />
                  </uix:rowLayout>
                    
                  <uix:rowLayout>  
                    <uix:spacer height="6"/>
                  </uix:rowLayout>
                  
                  <%-- Trial 1 Information --%>
                  <%-- Trial 1 Name --%>
                  <uix:rowLayout>
                    <uix:cellFormat wrappingDisabled="true" hAlign="right">
                      <uix:messagePrompt promptBinding="TRIAL_1_NAME@SPIAMsg" />
                    </uix:cellFormat>
                    <oem:choice name="trial1Name" 
                                id="trial1Name"
                                shortDescBinding="TRIAL_1_NAME@SPIAMsg"
                                optionsBinding="trialNameList@trialsComparisonBean@servletRequest" 
                                onChange="submitForm(\'form\', true, {\'event\':\'changeTrialName\'});return false;"
                                selectedValueBinding="trial1Name@trialsComparisonBean@servletRequest" />
                  </uix:rowLayout>
                  <%-- Trial 1 Description --%>
                  <uix:rowLayout>
                    <uix:cellFormat wrappingDisabled="true" hAlign="right">
                      <uix:messagePrompt promptBinding="DESCRIPTION@DBMsg" />
                    </uix:cellFormat>
                    <uix:styledText styleClass="OraDataText" 
                                    textBinding="trial1Description@trialsComparisonBean@servletRequest" />  
                  </uix:rowLayout>
                  
                  <%-- Trial 1 SQL Executed--%>
                  <uix:rowLayout>
                    <uix:cellFormat wrappingDisabled="true" hAlign="right">
                      <uix:messagePrompt promptBinding="SQL_EXECUTED@SPIAMsg" />
                    </uix:cellFormat>
                    <uix:styledText styleClass="OraDataText" 
                                    textBinding="trial1CollectExecStats@trialsComparisonBean@servletRequest" />  
                  </uix:rowLayout>
                  
                  <uix:rowLayout>  
                    <uix:spacer height="6"/>
                  </uix:rowLayout>
                         
                         
                  <%-- Trial 2 information --%>
                  <%-- Trial 2 Name --%>
                  <uix:rowLayout>
                    <uix:cellFormat wrappingDisabled="true" hAlign="right">
                      <uix:messagePrompt promptBinding="TRIAL_2_NAME@SPIAMsg" />
                    </uix:cellFormat>
                    <oem:choice name="trial2Name" 
                                id="trial2Name"
                                shortDescBinding="TRIAL_2_NAME@SPIAMsg"
                                optionsBinding="trialNameList@trialsComparisonBean@servletRequest" 
                                onChange="submitForm(\'form\', true, {\'event\':\'changeTrialName\'});return false;"
                                selectedValueBinding="trial2Name@trialsComparisonBean@servletRequest" />
                  </uix:rowLayout>
                  <%-- Trial 2 Description --%>
                  <uix:rowLayout>
                    <uix:cellFormat wrappingDisabled="true" hAlign="right">
                      <uix:messagePrompt promptBinding="DESCRIPTION@DBMsg" />
                    </uix:cellFormat>
                    <uix:styledText styleClass="OraDataText" 
                                    textBinding="trial2Description@trialsComparisonBean@servletRequest" />  
                  </uix:rowLayout>
                  
                  <%-- Trial 2 SQL Executed --%>
                  <uix:rowLayout>
                    <uix:cellFormat wrappingDisabled="true" hAlign="right">
                      <uix:messagePrompt promptBinding="SQL_EXECUTED@SPIAMsg" />
                    </uix:cellFormat>
                    <uix:styledText styleClass="OraDataText" 
                                    textBinding="trial2CollectExecStats@trialsComparisonBean@servletRequest" />  
                  </uix:rowLayout>
                  
                  <uix:rowLayout>  
                    <uix:spacer height="6"/>
                  </uix:rowLayout>
                  
                  <%-- Comparison Metrics --%>
                  <uix:rowLayout>
                    <uix:cellFormat wrappingDisabled="true" hAlign="right">
                      <uix:messagePrompt promptBinding="COMPARISON_METRIC@SPIAMsg" />
                    </uix:cellFormat>
                    <uix:choice id="selectedComparisonMetric" 
                            name="selectedComparisonMetric"
                            selectedValueBinding="selectedComparisonMetric@trialsComparisonBean@servletRequest"                                
                            shortDescBinding="COMPARISON_METRIC@SPIAMsg">
                      <uix:contents childDataBinding="comparisonMetricOptions@trialsComparisonBean@servletRequest">
                        <uix:option textBinding="stext"
                                    valueBinding="sval"/>
                      </uix:contents>
                    </uix:choice>  
                  </uix:rowLayout>
                </uix:tableLayout>

                
          <%@ include file="schedule.jspf" %>
          
                </uix:stackLayout>
          </uix:borderLayout>


            </uix:rowLayout>
          </uix:tableLayout>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
